/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo.srv;

import java.io.File;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.adempiere.base.IDictionaryService;
import org.adempiere.pipo2.PackIn;
import org.adempiere.pipo2.Zipper;
import org.compiere.model.MAttachment;
import org.compiere.model.MSysConfig;
import org.compiere.model.X_AD_Package_Imp_Proc;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.osgi.framework.BundleContext;

public class PipoDictionaryService
implements IDictionaryService {
    private static final CLogger logger = CLogger.getCLogger((String)PipoDictionaryService.class.getName());
    X_AD_Package_Imp_Proc adPackageImp = null;

    public void merge(BundleContext context, File packageFile) throws Exception {
        if (packageFile == null || !packageFile.exists()) {
            logger.info("No PackIn Model found");
            return;
        }
        if (!packageFile.canRead()) {
            logger.severe("Cannot read file " + packageFile.getName());
            return;
        }
        String symbolicName = "org.adempiere.pipo";
        if (context != null) {
            symbolicName = context.getBundle().getSymbolicName();
        }
        String trxName = null;
        PackIn packIn = null;
        try {
            try {
                int dotPos;
                trxName = Trx.createTrxName((String)"PipoDS");
                Trx.get((String)trxName, (boolean)true).setDisplayName(String.valueOf(this.getClass().getName()) + "_merge");
                packIn = new PackIn();
                if ("org.adempiere.pipo".equals(symbolicName) && !packageFile.getName().startsWith("2Pack")) {
                    packIn.setPackageName(packageFile.getName());
                } else {
                    packIn.setPackageName(symbolicName);
                }
                if (Env.getCtx().getProperty("#AD_Client_ID") == null) {
                    Env.getCtx().put("#AD_Client_ID", (Object)0);
                }
                String packageVersion = null;
                String fileName = packageFile.getName();
                int versionSeparatorPos = fileName.lastIndexOf("2Pack_");
                if (versionSeparatorPos > 0 && (dotPos = fileName.lastIndexOf(".")) > 0 && dotPos > versionSeparatorPos) {
                    String version;
                    int extraInfoIndex = fileName.indexOf("_", versionSeparatorPos + 6);
                    if (extraInfoIndex > 0) {
                        dotPos = extraInfoIndex;
                    }
                    if ((version = fileName.substring(versionSeparatorPos + "2Pack_".length(), dotPos)).split("[.]").length == 3) {
                        packageVersion = version;
                    }
                }
                if (packageVersion == null && context != null) {
                    packageVersion = (String)context.getBundle().getHeaders().get("Bundle-Version");
                }
                packIn.setPackageVersion(packageVersion);
                packIn.setUpdateDictionary(false);
                packIn.getNotifier().setFileName(packageFile.getName());
                packIn.getNotifier().setPluginName(String.valueOf(symbolicName) + " v" + packageVersion);
                this.adPackageImp = new X_AD_Package_Imp_Proc(Env.getCtx(), 0, null);
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("zipFilepath->" + packageFile);
                }
                String parentDir = Zipper.getParentDir(packageFile);
                File targetDir = new File(System.getProperty("java.io.tmpdir"));
                Zipper.unpackFile(packageFile, targetDir);
                String dict_file = targetDir + File.separator + parentDir + File.separator + "dict" + File.separator + "PackOut.xml";
                packIn.setPackageDirectory(targetDir + File.separator + parentDir);
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("dict file->" + dict_file);
                }
                this.adPackageImp.setName(packIn.getPackageName());
                this.adPackageImp.setAD_Package_Source_Type("File");
                packIn.setAD_Package_Imp_Proc(this.adPackageImp);
                String msg = packIn.importXML(dict_file, Env.getCtx(), trxName);
                this.adPackageImp.setDateProcessed(new Timestamp(System.currentTimeMillis()));
                this.adPackageImp.setP_Msg(msg);
                Trx.get((String)trxName, (boolean)false).commit(true);
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("commit " + trxName);
                }
            }
            catch (Exception e) {
                Trx.get((String)trxName, (boolean)false).rollback();
                this.adPackageImp.setP_Msg(e.getLocalizedMessage());
                packIn.getNotifier().addFailureLine(e.getLocalizedMessage());
                packIn.setSuccess(false);
                logger.log(Level.SEVERE, "importXML:", (Throwable)e);
                throw e;
            }
        }
        finally {
            try {
                Trx.get((String)trxName, (boolean)false).close();
            }
            catch (Exception attachment) {}
            if (this.adPackageImp != null) {
                this.adPackageImp.save();
            }
            if (this.adPackageImp != null && packIn != null && (MSysConfig.getBooleanValue((String)"ATTACH_EMBEDDED_2PACK", (boolean)true) || !packIn.isSuccess())) {
                MAttachment attachment = new MAttachment(this.adPackageImp.getCtx(), 50008, this.adPackageImp.getAD_Package_Imp_Proc_ID(), null);
                attachment.addEntry(packageFile);
                attachment.save();
            }
            packIn.getNotifier().notifyRecipient();
        }
    }

    public X_AD_Package_Imp_Proc getAD_Package_Imp_Proc() {
        return this.adPackageImp;
    }
}

