/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.Writer;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.DeferredValue;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.sys.ComponentRedraws;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.sys.HtmlPageRenders;

public class Script
extends AbstractComponent {
    private String _src;
    private String _charset;
    private String _content;
    private String _packages;
    private boolean _defer;

    public Script() {
    }

    public Script(String content) {
        this.setContent(content);
    }

    public String getType() {
        return "text/javascript";
    }

    public void setType(String type) {
    }

    public String getCharset() {
        return this._charset;
    }

    public void setCharset(String charset) {
        if (charset != null && charset.length() == 0) {
            charset = null;
        }
        if (!Objects.equals((Object)this._charset, (Object)charset)) {
            this._charset = charset;
            this.smartUpdate("charset", this._charset);
        }
    }

    public String getSrc() {
        return this._src;
    }

    public void setSrc(String src) {
        if (src != null && src.length() == 0) {
            src = null;
        }
        if (!Objects.equals((Object)this._src, (Object)src)) {
            this._src = src;
            this.smartUpdate("src", new EncodedSrcURL());
        }
    }

    public boolean isDefer() {
        return this._defer;
    }

    public void setDefer(boolean defer) {
        this._defer = defer;
    }

    public String getContent() {
        return this._content;
    }

    public void setContent(String content) {
        if (content != null && content.length() == 0) {
            content = null;
        }
        if (!Objects.equals((Object)this._content, (Object)content)) {
            this._content = content;
            this.smartUpdate("content", this.getContent());
        }
    }

    public String getPackages() {
        return this._packages;
    }

    public void setPackages(String packages) {
        if (packages != null && packages.length() == 0) {
            packages = null;
        }
        if (!Objects.equals((Object)this._packages, (Object)packages)) {
            this._packages = packages;
            this.smartUpdate("packages", this._packages);
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        String cnt = this.getContent();
        if (cnt != null) {
            if (this._defer) {
                renderer.renderDirectly("content", (Object)("function(){\n" + cnt + "\n}"));
            } else {
                Writer out = ComponentRedraws.getScriptBuffer();
                out.write(cnt.replaceAll("</(?i)(?=script>)", "<\\\\/"));
                out.write(10);
            }
        }
        if (this._src != null) {
            HtmlPageRenders.RenderContext rc;
            HtmlPageRenders.RenderContext renderContext = rc = this._defer ? null : HtmlPageRenders.getRenderContext(null);
            if (rc != null && rc.perm != null) {
                Writer cwout = rc.perm;
                cwout.write("\n<script id=\"");
                cwout.write(this.getUuid());
                cwout.write("\" type=\"text/javascript\" src=\"");
                cwout.write(this.getEncodedSrcURL());
                cwout.write(34);
                if (this._charset != null) {
                    cwout.write(" charset=\"");
                    cwout.write(this._charset);
                    cwout.write(34);
                }
                cwout.write(">\n</script>\n");
            } else {
                this.render(renderer, "src", this.getEncodedSrcURL());
            }
        }
        this.render(renderer, "charset", this._charset);
        this.render(renderer, "packages", this._packages);
    }

    protected boolean isChildable() {
        return false;
    }

    private String getEncodedSrcURL() {
        if (this._src == null) {
            return null;
        }
        Desktop dt = this.getDesktop();
        return dt != null ? dt.getExecution().encodeURL(this._src) : null;
    }

    private class EncodedSrcURL
    implements DeferredValue {
        private EncodedSrcURL() {
        }

        public Object getValue() {
            return Script.this.getEncodedSrcURL();
        }
    }
}

