/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.util.HashMap;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.sys.PropertyAccess;
import org.zkoss.zul.impl.NumberInputElement;
import org.zkoss.zul.mesg.MZul;

public class Longbox
extends NumberInputElement {
    private static HashMap<String, PropertyAccess> _properties = new HashMap(1);

    public Longbox() {
        this.setCols(11);
    }

    public Longbox(long value) throws WrongValueException {
        this();
        this.setValue(new Long(value));
    }

    public Longbox(int value) throws WrongValueException {
        this();
        this.setValue(new Long(value));
    }

    public Long getValue() throws WrongValueException {
        return (Long)this.getTargetValue();
    }

    public long longValue() throws WrongValueException {
        Object val = this.getTargetValue();
        return val != null ? (Long)val : 0L;
    }

    public long intValue() throws WrongValueException {
        Object val = this.getTargetValue();
        return val != null ? (long)((Long)val).intValue() : 0L;
    }

    public void setValue(Long value) throws WrongValueException {
        this.validate(value);
        this.setRawValue(value);
    }

    public String getZclass() {
        return this._zclass == null ? "z-longbox" : this._zclass;
    }

    @Override
    protected Object marshall(Object value) {
        return value != null ? ((Long)value).toString() : value;
    }

    @Override
    protected Object unmarshall(Object value) {
        return value != null ? new Long((String)value) : value;
    }

    @Override
    protected Object coerceFromString(String value) throws WrongValueException {
        Object[] vals = this.toNumberOnly(value);
        String val = (String)vals[0];
        if (val == null || val.length() == 0) {
            return null;
        }
        try {
            long v;
            int divscale;
            int n = divscale = vals[1] != null ? (Integer)vals[1] : 0;
            for (v = Long.parseLong(val); v != 0L && --divscale >= 0; v /= 10L) {
            }
            return new Long(v);
        }
        catch (NumberFormatException ex) {
            throw this.showCustomError(new WrongValueException((Component)this, MZul.NUMBER_REQUIRED, (Object)value));
        }
    }

    @Override
    protected String coerceToString(Object value) {
        return value != null && this.getFormat() == null ? value.toString() : this.formatNumber(value, null);
    }

    @Override
    public PropertyAccess getPropertyAccess(String prop) {
        PropertyAccess pa = _properties.get(prop);
        if (pa != null) {
            return pa;
        }
        return super.getPropertyAccess(prop);
    }

    static {
        _properties.put("value", (PropertyAccess)new PropertyAccess<Long>(){

            public void setValue(Component cmp, Long value) {
                ((Longbox)cmp).setValue(value);
            }

            public Class<Long> getType() {
                return Long.class;
            }

            public Long getValue(Component cmp) {
                return ((Longbox)cmp).getValue();
            }
        });
    }
}

