/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.webui.panel.action;

import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import jpiere.plugin.webui.adwindow.JPiereAbstractADWindowContent;
import jpiere.plugin.webui.adwindow.JPiereIADTabbox;
import jpiere.plugin.webui.adwindow.JPiereIADTabpanel;
import org.adempiere.base.IGridTabImporter;
import org.adempiere.base.equinox.EquinoxExtensionLocator;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.webui.AdempiereWebUI;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Column;
import org.adempiere.webui.component.Columns;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.editor.WTableDirEditor;
import org.adempiere.webui.util.ReaderInputStream;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.Dialog;
import org.compiere.model.GridTab;
import org.compiere.model.Lookup;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MLookupInfo;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.util.media.AMedia;
import org.zkoss.util.media.Media;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.UploadEvent;
import org.zkoss.zul.Filedownload;
import org.zkoss.zul.Space;
import org.zkoss.zul.Vbox;
import org.zkoss.zul.Vlayout;

public class JPiereFileImportAction
implements EventListener<Event> {
    private JPiereAbstractADWindowContent panel;
    private Map<String, IGridTabImporter> importerMap = null;
    private Map<String, String> extensionMap = null;
    private Window winImportFile = null;
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private Listbox cboType = new Listbox();
    private Button bFile = new Button();
    private Listbox fCharset = new Listbox();
    private WTableDirEditor fImportMode;
    private InputStream m_file_istream = null;

    public JPiereFileImportAction(JPiereAbstractADWindowContent panel) {
        this.panel = panel;
    }

    public void fileImport() {
        Charset[] charsets = Ini.getAvailableCharsets();
        int i = 0;
        while (i < charsets.length) {
            this.fCharset.appendItem(charsets[i].displayName(), (Object)charsets[i]);
            ++i;
        }
        Charset charset = Ini.getCharset();
        int i2 = 0;
        while (i2 < this.fCharset.getItemCount()) {
            ListItem listitem = this.fCharset.getItemAtIndex(i2);
            Charset compare = (Charset)listitem.getValue();
            if (charset == compare) {
                this.fCharset.setSelectedIndex(i2);
                Executions.getCurrent().getDesktop().getWebApp().getConfiguration().setUploadCharset(compare.name());
                break;
            }
            ++i2;
        }
        this.fCharset.addEventListener("onSelect", (EventListener)this);
        MLookupInfo lookupInfo = MLookupFactory.getLookup_List((Language)Env.getLanguage((Properties)Env.getCtx()), (int)200098);
        MLookup lookup = new MLookup(lookupInfo, 0);
        this.fImportMode = new WTableDirEditor("ImportMode", true, false, true, (Lookup)lookup);
        this.importerMap = new HashMap<String, IGridTabImporter>();
        this.extensionMap = new HashMap<String, String>();
        List importerList = EquinoxExtensionLocator.instance().list(IGridTabImporter.class).getExtensions();
        for (IGridTabImporter iGridTabImporter : importerList) {
            String extension = iGridTabImporter.getFileExtension();
            if (this.extensionMap.containsKey(extension)) continue;
            this.extensionMap.put(extension, iGridTabImporter.getFileExtensionLabel());
            this.importerMap.put(extension, iGridTabImporter);
        }
        if (this.winImportFile == null) {
            this.winImportFile = new Window();
            this.winImportFile.setTitle(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"FileImport")) + ": " + this.panel.getActiveGridTab().getName());
            ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this.winImportFile, (int)450);
            this.winImportFile.setClosable(true);
            this.winImportFile.setBorder("normal");
            this.winImportFile.setStyle("position:absolute");
            this.winImportFile.setWidgetAttribute("instanceName", "importAction");
            this.winImportFile.setSclass("popup-dialog");
            this.cboType.setMold("select");
            this.cboType.getItems().clear();
            for (Map.Entry entry : this.extensionMap.entrySet()) {
                this.cboType.appendItem(String.valueOf((String)entry.getKey()) + " - " + (String)entry.getValue(), (String)entry.getKey());
            }
            this.cboType.setSelectedIndex(0);
            Vbox vbox = new Vbox();
            ZKUpdateUtil.setWidth((HtmlBasedComponent)vbox, (String)"100%");
            this.winImportFile.appendChild((Component)vbox);
            Vlayout vlayout = new Vlayout();
            vlayout.setSclass("dialog-content");
            vbox.appendChild((Component)vlayout);
            Grid grid = GridFactory.newGridLayout();
            vlayout.appendChild((Component)grid);
            Columns columns = new Columns();
            Column column = new Column();
            ZKUpdateUtil.setHflex((HtmlBasedComponent)column, (String)"min");
            columns.appendChild((Component)column);
            column = new Column();
            ZKUpdateUtil.setHflex((HtmlBasedComponent)column, (String)"1");
            columns.appendChild((Component)column);
            grid.appendChild((Component)columns);
            Rows rows = new Rows();
            grid.appendChild((Component)rows);
            Row row = new Row();
            rows.appendChild((Component)row);
            row.appendChild((Component)new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"FilesOfType", (boolean)true)));
            row.appendChild((Component)this.cboType);
            ZKUpdateUtil.setHflex((HtmlBasedComponent)this.cboType, (String)"1");
            row = new Row();
            rows.appendChild((Component)row);
            row.appendChild((Component)new Label(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"Charset", (boolean)true)) + ": "));
            this.fCharset.setMold("select");
            this.fCharset.setRows(0);
            this.fCharset.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"Charset", (boolean)false));
            row.appendChild((Component)this.fCharset);
            ZKUpdateUtil.setHflex((HtmlBasedComponent)this.fCharset, (String)"1");
            row = new Row();
            rows.appendChild((Component)row);
            row.appendChild((Component)new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"import.mode", (boolean)true)));
            row.appendChild((Component)this.fImportMode.getComponent());
            row = new Row();
            rows.appendChild((Component)row);
            row.appendChild((Component)new Space());
            this.bFile.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"FileImportFile"));
            this.bFile.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"FileImportFileInfo"));
            this.bFile.setUpload(AdempiereWebUI.getUploadSetting());
            LayoutUtils.addSclass((String)"txt-btn", (HtmlBasedComponent)this.bFile);
            this.bFile.addEventListener("onUpload", (EventListener)this);
            row.appendChild((Component)this.bFile);
            LayoutUtils.addSclass((String)"dialog-footer", (HtmlBasedComponent)this.confirmPanel);
            vbox.appendChild((Component)this.confirmPanel);
            this.confirmPanel.addActionListener((EventListener)this);
            this.winImportFile.addEventListener("onCancel", e -> this.onCancel());
        }
        this.panel.getComponent().getParent().appendChild((Component)this.winImportFile);
        this.panel.showBusyMask(this.winImportFile);
        LayoutUtils.openOverlappedWindow((Component)this.panel.getComponent(), (org.zkoss.zul.Window)this.winImportFile, (String)"middle_center");
        this.winImportFile.addEventListener("onWindowClose", (EventListener)this);
        this.winImportFile.focus();
    }

    public void onEvent(Event event) throws Exception {
        if (event instanceof UploadEvent) {
            UploadEvent ue = (UploadEvent)event;
            this.processUploadMedia(ue.getMedia());
        } else if (event.getTarget().getId().equals("Cancel")) {
            this.onCancel();
        } else if (event.getTarget() == this.fCharset) {
            ListItem listitem;
            if (this.m_file_istream != null) {
                this.m_file_istream.close();
                this.m_file_istream = null;
            }
            if ((listitem = this.fCharset.getSelectedItem()) == null) {
                return;
            }
            Charset charset = (Charset)listitem.getValue();
            Executions.getCurrent().getDesktop().getWebApp().getConfiguration().setUploadCharset(charset.name());
            this.bFile.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"FileImportFile"));
        } else if (event.getTarget().getId().equals("Ok")) {
            if (this.m_file_istream == null || this.fCharset.getSelectedItem() == null || Util.isEmpty((String)((String)this.fImportMode.getValue()))) {
                return;
            }
            this.importFile();
        } else if (event.getName().equals("onWindowClose")) {
            this.panel.hideBusyMask();
        }
    }

    private void onCancel() {
        this.winImportFile.onClose();
    }

    private void processUploadMedia(Media media) {
        if (media == null) {
            return;
        }
        if (media.isBinary()) {
            this.m_file_istream = media.getStreamData();
        } else {
            ListItem listitem = this.fCharset.getSelectedItem();
            if (listitem == null) {
                this.m_file_istream = new ReaderInputStream(media.getReaderData());
            } else {
                Charset charset = (Charset)listitem.getValue();
                this.m_file_istream = new ReaderInputStream(media.getReaderData(), charset.name());
            }
        }
        this.bFile.setLabel(media.getName());
    }

    private void importFile() {
        try {
            String tableName;
            ListItem li = this.cboType.getSelectedItem();
            if (li == null || li.getValue() == null) {
                Dialog.error((int)0, (String)"FileInvalidExtension");
                return;
            }
            String ext = li.getValue().toString();
            IGridTabImporter importer = this.importerMap.get(ext);
            if (importer == null) {
                Dialog.error((int)0, (String)"FileInvalidExtension");
                return;
            }
            JPiereIADTabbox adTab = this.panel.getADTab();
            int selected = adTab.getSelectedIndex();
            int tabLevel = this.panel.getActiveGridTab().getTabLevel();
            HashSet<String> tables = new HashSet<String>();
            ArrayList<GridTab> childs = new ArrayList<GridTab>();
            List includedList = this.panel.getActiveGridTab().getIncludedTabs();
            for (GridTab included : includedList) {
                tableName = included.getTableName();
                if (tables.contains(tableName)) continue;
                tables.add(tableName);
                childs.add(included);
            }
            int i = selected + 1;
            while (i < adTab.getTabCount()) {
                JPiereIADTabpanel adTabPanel = adTab.getADTabpanel(i);
                if (!adTabPanel.getGridTab().isSortTab()) {
                    if (adTabPanel.getGridTab().getTabLevel() <= tabLevel) break;
                    tableName = adTabPanel.getGridTab().getTableName();
                    if (!tables.contains(tableName)) {
                        tables.add(tableName);
                        childs.add(adTabPanel.getGridTab());
                    }
                }
                ++i;
            }
            ListItem listitem = this.fCharset.getSelectedItem();
            Charset charset = null;
            if (listitem == null) {
                return;
            }
            try {
                charset = (Charset)listitem.getValue();
                String iMode = (String)this.fImportMode.getValue();
                File outFile = importer.fileImport(this.panel.getActiveGridTab(), childs, this.m_file_istream, charset, iMode);
                this.winImportFile.onClose();
                this.winImportFile = null;
                AMedia media = null;
                media = new AMedia(importer.getSuggestedFileName(this.panel.getActiveGridTab()), null, importer.getContentType(), outFile, true);
                Filedownload.save((Media)media);
            }
            catch (Exception e) {
                throw new AdempiereException((Throwable)e);
            }
        }
        finally {
            if (this.winImportFile != null) {
                this.winImportFile.onClose();
            }
        }
    }
}

