/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.webui.panel;

import java.util.ArrayList;
import java.util.List;
import jpiere.plugin.webui.adwindow.JPiereAbstractADWindowContent;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ZkCssHelper;
import org.compiere.model.MLabel;
import org.compiere.model.MLabelAssignment;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Div;
import org.zkoss.zul.Groupbox;

public class JPiereLabelsPanel
extends Div
implements EventListener<Event> {
    private static final long serialVersionUID = 2232899183255702050L;
    private JPiereAbstractADWindowContent abstractADWindowContent;
    private int AD_Table_ID;
    private int Record_ID;

    public JPiereLabelsPanel(JPiereAbstractADWindowContent abstractADWindowContent, int AD_Table_ID, int Record_ID) {
        this.abstractADWindowContent = abstractADWindowContent;
        this.AD_Table_ID = AD_Table_ID;
        this.Record_ID = Record_ID;
        this.setStyle("padding:0px 5px;");
        this.addEventListener("onPostSelectLabelitem", this);
        this.update();
    }

    public int getAD_Table_ID() {
        return this.AD_Table_ID;
    }

    public int getRecord_ID() {
        return this.Record_ID;
    }

    public void onEvent(Event event) throws Exception {
        if (event.getName().equals("onPostSelectLabelitem")) {
            this.update();
        }
    }

    private void update() {
        ArrayList children = new ArrayList(this.getChildren());
        for (Component child : children) {
            this.removeChild(child);
        }
        List assignmentsList = new Query(Env.getCtx(), "AD_LabelAssignment", "AD_Table_ID=? AND Record_ID=?", null).setParameters(new Object[]{this.AD_Table_ID, this.Record_ID}).setOrderBy("Created").list();
        for (MLabelAssignment assignment : assignmentsList) {
            Div d = new Div();
            ZkCssHelper.appendStyle((HtmlBasedComponent)d, (String)"float: left;");
            LabelPill gb = new LabelPill(assignment);
            d.appendChild((Component)gb);
            this.appendChild((Component)d);
        }
        this.abstractADWindowContent.getToolbar().setPressed("Label", this.abstractADWindowContent.getActiveGridTab().hasLabel());
    }

    private class LabelPill
    extends Groupbox {
        private static final long serialVersionUID = -2248242199670448950L;

        public LabelPill(final MLabelAssignment assignment) {
            this.setContentStyle("border: none; padding: 0px 4px 6px 4px;");
            MLabel label = new MLabel(assignment.getCtx(), assignment.getAD_Label_ID(), assignment.get_TrxName());
            Label name = new Label(label.getName());
            ZkCssHelper.appendStyle((HtmlBasedComponent)name, (String)label.buildStyle());
            this.appendChild((Component)name);
            Label closeButton = new Label("x");
            ZkCssHelper.appendStyle((HtmlBasedComponent)closeButton, (String)"cursor: pointer; margin:3px; font-size: 10px; font-weight: bold; color: #909090; vertical-align: super;");
            this.appendChild((Component)closeButton);
            closeButton.addEventListener("onClick", (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    if ("onClick".equals(event.getName())) {
                        assignment.deleteEx(true);
                        JPiereLabelsPanel.this.update();
                    }
                }
            });
        }
    }
}

