/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.webui.desktop;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import jpiere.plugin.webui.window.factory.IFormWindowZoomFactory;
import org.adempiere.base.Service;
import org.adempiere.base.event.EventManager;
import org.adempiere.model.MBroadcastMessage;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.adwindow.ADWindow;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.apps.BusyDialog;
import org.adempiere.webui.apps.ProcessDialog;
import org.adempiere.webui.apps.WReport;
import org.adempiere.webui.component.DesktopTabpanel;
import org.adempiere.webui.component.Tab;
import org.adempiere.webui.component.Tabbox;
import org.adempiere.webui.component.Tabpanel;
import org.adempiere.webui.component.ToolBar;
import org.adempiere.webui.component.ToolBarButton;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.desktop.DashboardController;
import org.adempiere.webui.desktop.IDesktop;
import org.adempiere.webui.desktop.TabbedDesktop;
import org.adempiere.webui.event.DrillEvent;
import org.adempiere.webui.event.MenuListener;
import org.adempiere.webui.event.ZKBroadCastManager;
import org.adempiere.webui.event.ZoomEvent;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.panel.BroadcastMessageWindow;
import org.adempiere.webui.panel.HeaderPanel;
import org.adempiere.webui.panel.HelpController;
import org.adempiere.webui.panel.TimeoutPanel;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.UserPreference;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.Dialog;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MPreference;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.MTreeFavorite;
import org.compiere.model.MWindow;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.util.WebUtil;
import org.idempiere.broadcast.BroadCastMsg;
import org.idempiere.broadcast.BroadcastMsgUtil;
import org.idempiere.broadcast.IBroadcastMsgPopup;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.EventQueue;
import org.zkoss.zk.ui.event.EventQueues;
import org.zkoss.zk.ui.event.OpenEvent;
import org.zkoss.zk.ui.event.SwipeEvent;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zk.ui.util.DesktopCleanup;
import org.zkoss.zul.Anchorchildren;
import org.zkoss.zul.Anchorlayout;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.East;
import org.zkoss.zul.Image;
import org.zkoss.zul.LayoutRegion;
import org.zkoss.zul.Popup;
import org.zkoss.zul.West;
import org.zkoss.zul.Window;

public class JPiereFormWindowZoomDesktop
extends TabbedDesktop
implements MenuListener,
Serializable,
EventListener<org.zkoss.zk.ui.event.Event>,
EventHandler,
DesktopCleanup {
    private static final String POPUP_OPEN_ATTR = "popup.open";
    private static final String HOME_TAB_RENDER_ATTR = "homeTab.render";
    private static final long serialVersionUID = 7189914859100400758L;
    private static final String IMAGES_UPARROW_PNG = "images/collapse-header.png";
    private static final String IMAGES_DOWNARROW_PNG = "images/expand-header.png";
    private static final String IMAGES_CONTEXT_HELP_PNG = "images/Help16.png";
    private static final String IMAGES_THREELINE_MENU_PNG = "images/threelines.png";
    private static final CLogger logger = CLogger.getCLogger(JPiereFormWindowZoomDesktop.class);
    private Borderlayout layout;
    private int noCount;
    private Tabpanel homeTab;
    private DashboardController dashboardController;
    private DashboardController sideController;
    private HeaderPanel pnlHead;
    private Desktop m_desktop;
    private HelpController helpController;
    private ToolBarButton max;
    private ToolBarButton contextHelp;
    private ToolBarButton showHeader;
    private Component headerContainer;
    private Window headerPopup;
    private Image logo;
    private boolean mobile;
    private Popup eastPopup;
    private Popup westPopup;
    private ToolBarButton westBtn;
    private GridTab gridTab;
    private boolean isQuickInfoOpen;
    private boolean isDisplayEastContents;
    private static final String autoHideMenuScript = "try{var w=zk.Widget.$('#{0}');var t=zk.Widget.$('#{1}');var e=new Object;e.target=t;w._docClick(e);}catch(error){}";
    HashMap<Integer, Integer> formWindowToFormMap;
    HashMap<Integer, String> WindowTabTitleMap;

    public JPiereFormWindowZoomDesktop() {
        block9: {
            this.m_desktop = null;
            this.isQuickInfoOpen = true;
            this.isDisplayEastContents = MSysConfig.getBooleanValue((String)"JP_DISPLAY_EAST_CONTENTS", (boolean)false, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            this.formWindowToFormMap = new HashMap();
            this.WindowTabTitleMap = new HashMap();
            this.dashboardController = new DashboardController();
            this.sideController = new DashboardController();
            this.helpController = new HelpController();
            this.m_desktop = AEnv.getDesktop();
            this.m_desktop.addListener((Object)this);
            this.bindEventManager();
            try {
                ZKBroadCastManager.getBroadCastMgr();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            EventQueue queue = EventQueues.lookup((String)"ActivitiesEventQueue", (boolean)true);
            queue.subscribe((EventListener)this);
            if (MTable.getTable_ID((String)"JP_FormWindowZoom") == 0) {
                return;
            }
            String sql = "SELECT AD_Window_ID, JP_ZoomWindow_ID FROM JP_FormWindowZoom WHERE IsActive='Y'";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        this.formWindowToFormMap.put(rs.getInt(1), rs.getInt(2));
                    }
                }
                catch (Exception exception) {
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
    }

    protected Component doCreatePart(Component parent) {
        boolean headerCollapsed;
        boolean helpCollapsed;
        PageDefinition pagedef = Executions.getCurrent().getPageDefinition(ThemeManager.getThemeResource((String)"zul/desktop/desktop.zul"));
        Component page = Executions.createComponents((PageDefinition)pagedef, (Component)parent, null);
        this.layout = (Borderlayout)page.getFellow("layout");
        this.headerContainer = page.getFellow("northBody");
        this.pnlHead = (HeaderPanel)this.headerContainer.getFellow("header");
        this.layout.addEventListener("onZoom", (EventListener)this);
        this.layout.addEventListener("onDrillDown", (EventListener)this);
        West w = this.layout.getWest();
        w.addEventListener("onOpen", (EventListener)new EventListener<org.zkoss.zk.ui.event.Event>(){

            public void onEvent(org.zkoss.zk.ui.event.Event event) throws Exception {
                OpenEvent oe = (OpenEvent)event;
                JPiereFormWindowZoomDesktop.this.updateMenuCollapsedPreference(!oe.isOpen());
            }
        });
        w.addEventListener("onSwipe", (EventListener)new EventListener<SwipeEvent>(){

            public void onEvent(SwipeEvent event) throws Exception {
                West w;
                if ("left".equals(event.getSwipeDirection()) && (w = (West)event.getTarget()).isOpen()) {
                    w.setOpen(false);
                    LayoutUtils.addSclass((String)"slide", (HtmlBasedComponent)w);
                    JPiereFormWindowZoomDesktop.this.updateMenuCollapsedPreference(true);
                }
            }
        });
        w.addEventListener("onSize", (EventListener)new EventListener<org.zkoss.zk.ui.event.Event>(){

            public void onEvent(org.zkoss.zk.ui.event.Event event) throws Exception {
                West west = (West)event.getTarget();
                JPiereFormWindowZoomDesktop.this.updateSideControllerWidthPreference(west.getWidth());
            }
        });
        UserPreference pref = SessionManager.getSessionApplication().getUserPreference();
        boolean menuCollapsed = pref.isPropertyBool("MenuCollapsed");
        w.setOpen(!menuCollapsed);
        if (!w.isOpen()) {
            LayoutUtils.addSclass((String)"slide", (HtmlBasedComponent)w);
        }
        this.mobile = ClientInfo.isMobile();
        w.setCollapsible(true);
        LayoutUtils.addSlideSclass((LayoutRegion)w);
        if (this.mobile) {
            w.setOpen(false);
        }
        East e = this.layout.getEast();
        e.addEventListener("onOpen", (EventListener)new EventListener<org.zkoss.zk.ui.event.Event>(){

            public void onEvent(org.zkoss.zk.ui.event.Event event) throws Exception {
                OpenEvent oe = (OpenEvent)event;
                JPiereFormWindowZoomDesktop.this.isQuickInfoOpen = oe.isOpen();
                JPiereFormWindowZoomDesktop.this.updateHelpCollapsedPreference(!oe.isOpen());
                Tabbox comp = JPiereFormWindowZoomDesktop.this.windowContainer.getComponent();
                if (comp != null) {
                    JPiereFormWindowZoomDesktop.this.contextHelp.setVisible(!oe.isOpen());
                    if (!oe.isOpen()) {
                        JPiereFormWindowZoomDesktop.this.layout.getEast().setVisible(false);
                    }
                }
            }
        });
        e.addEventListener("onSwipe", (EventListener)new EventListener<SwipeEvent>(){

            public void onEvent(SwipeEvent event) throws Exception {
                East e;
                if ("right".equals(event.getSwipeDirection()) && (e = (East)event.getTarget()).isOpen()) {
                    e.setOpen(false);
                    LayoutUtils.addSclass((String)"slide", (HtmlBasedComponent)e);
                    JPiereFormWindowZoomDesktop.this.updateHelpCollapsedPreference(true);
                }
            }
        });
        e.addEventListener("onSize", (EventListener)new EventListener<org.zkoss.zk.ui.event.Event>(){

            public void onEvent(org.zkoss.zk.ui.event.Event event) throws Exception {
                East east = (East)event.getTarget();
                JPiereFormWindowZoomDesktop.this.updateHelpWidthPreference(east.getWidth());
            }
        });
        String westWidth = this.getWestWidthPreference();
        String eastWidth = this.getEastWidthPreference();
        if (westWidth != null || eastWidth != null) {
            if (westWidth != null && eastWidth != null) {
                ClientInfo browserInfo = this.getClientInfo();
                int browserWidth = browserInfo.desktopWidth;
                int wWidth = Integer.valueOf(westWidth.replace("px", ""));
                int eWidth = Integer.valueOf(eastWidth.replace("px", ""));
                if (eWidth + wWidth <= browserWidth) {
                    ZKUpdateUtil.setWidth((HtmlBasedComponent)w, (String)westWidth);
                    ZKUpdateUtil.setWidth((HtmlBasedComponent)e, (String)eastWidth);
                }
            } else if (westWidth != null) {
                ZKUpdateUtil.setWidth((HtmlBasedComponent)w, (String)westWidth);
            } else if (eastWidth != null) {
                ZKUpdateUtil.setWidth((HtmlBasedComponent)e, (String)eastWidth);
            }
        }
        e.setVisible(!(helpCollapsed = pref.isPropertyBool("HelpCollapsed")));
        this.helpController.render((Component)e, (IDesktop)this);
        if (this.mobile) {
            e.setVisible(false);
            e.setOpen(false);
            Component content = e.getFirstChild();
            this.eastPopup = new Popup();
            ToolBarButton btn = new ToolBarButton();
            btn.setIconSclass("z-icon-remove");
            btn.addEventListener("onClick", evt -> {
                this.eastPopup.close();
                this.isQuickInfoOpen = false;
            });
            this.eastPopup.appendChild((Component)btn);
            btn.setStyle("position: absolute; top: 20px; right: 0px; padding: 2px 0px;");
            this.eastPopup.setStyle("padding-top: 20px;");
            this.eastPopup.appendChild(content);
            this.eastPopup.setPage(this.getComponent().getPage());
            this.eastPopup.setHeight("100%");
            this.helpController.setupFieldTooltip();
            this.eastPopup.addEventListener("onOpen", oe -> {
                this.isQuickInfoOpen = oe.isOpen();
            });
            this.westPopup = new Popup();
            this.westPopup.setStyle("padding-top: 10px;");
            this.westPopup.setPage(this.getComponent().getPage());
            this.westPopup.setHeight("100%");
            this.westPopup.addEventListener("onOpen", oe -> {
                if (oe.isOpen()) {
                    this.westPopup.setAttribute(POPUP_OPEN_ATTR, (Object)Boolean.TRUE);
                } else {
                    this.westPopup.removeAttribute(POPUP_OPEN_ATTR);
                }
            });
        }
        Center windowArea = this.layout.getCenter();
        this.windowContainer.createPart((Object)windowArea);
        this.homeTab = new Tabpanel();
        this.windowContainer.addWindow((Component)this.homeTab, Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Home")), false, null);
        this.homeTab.getLinkedTab().setSclass("desktop-hometab");
        ((Tab)this.homeTab.getLinkedTab()).setDisableDraggDrop(true);
        this.homeTab.setSclass("desktop-home-tabpanel");
        BusyDialog busyDialog = new BusyDialog();
        busyDialog.setShadow(false);
        this.homeTab.appendChild((Component)busyDialog);
        this.registerWindow(this.homeTab);
        BroadcastMessageWindow messageWindow = new BroadcastMessageWindow(this.pnlHead);
        BroadcastMsgUtil.showPendingMessage((int)Env.getAD_User_ID((Properties)Env.getCtx()), (IBroadcastMsgPopup)messageWindow);
        if (!this.layout.getDesktop().isServerPushEnabled()) {
            this.layout.getDesktop().enableServerPush(true);
        }
        Executions.schedule((Desktop)this.layout.getDesktop(), event -> {
            this.renderHomeTab();
            this.automaticOpen(Env.getCtx());
        }, (org.zkoss.zk.ui.event.Event)new org.zkoss.zk.ui.event.Event("onRenderHomeTab"));
        ToolBar toolbar = this.windowContainer.getToobar();
        if (!this.mobile) {
            this.showHeader = new ToolBarButton(){

                public void onPageDetached(Page page) {
                    super.onPageDetached(page);
                    if (JPiereFormWindowZoomDesktop.this.headerPopup != null) {
                        JPiereFormWindowZoomDesktop.this.headerPopup.setPage(null);
                    }
                }
            };
            toolbar.appendChild((Component)this.showHeader);
            if (ThemeManager.isUseFontIconForImage()) {
                this.showHeader.setIconSclass("z-icon-ThreeLineMenu");
            } else {
                this.showHeader.setImage(ThemeManager.getThemeResource((String)IMAGES_THREELINE_MENU_PNG));
            }
            this.showHeader.addEventListener("onClick", (EventListener)this);
            this.showHeader.setSclass("window-container-toolbar-btn");
            this.showHeader.setVisible(false);
            this.max = new ToolBarButton();
            toolbar.appendChild((Component)this.max);
            if (ThemeManager.isUseFontIconForImage()) {
                this.max.setIconSclass("z-icon-Collapsing");
            } else {
                this.max.setImage(ThemeManager.getThemeResource((String)IMAGES_UPARROW_PNG));
            }
            this.max.addEventListener("onClick", (EventListener)this);
            this.max.setSclass("window-container-toolbar-btn");
        }
        this.contextHelp = new ToolBarButton();
        if (this.isDisplayEastContents) {
            toolbar.appendChild((Component)this.contextHelp);
            if (ThemeManager.isUseFontIconForImage()) {
                this.contextHelp.setIconSclass("z-icon-Help");
            } else {
                this.contextHelp.setImage(ThemeManager.getThemeResource((String)IMAGES_CONTEXT_HELP_PNG));
            }
            this.contextHelp.addEventListener("onClick", (EventListener)this);
            this.contextHelp.setSclass("window-container-toolbar-btn context-help-btn");
            this.contextHelp.setTooltiptext(Util.cleanAmp((String)Msg.getElement((Properties)Env.getCtx(), (String)"AD_CtxHelp_ID")));
            this.contextHelp.setVisible(!e.isVisible());
            this.isQuickInfoOpen = e.isVisible();
        }
        if (!this.mobile && (headerCollapsed = pref.isPropertyBool("HeaderCollapsed"))) {
            this.collapseHeader();
        }
        if (this.mobile) {
            this.westBtn = new ToolBarButton();
            if (ThemeManager.isUseFontIconForImage()) {
                this.westBtn.setIconSclass("z-icon-ThreeLineMenu");
            } else {
                this.westBtn.setImage(ThemeManager.getThemeResource((String)IMAGES_THREELINE_MENU_PNG));
            }
            this.westBtn.addEventListener("onClick", (EventListener)this);
            this.westBtn.setSclass("window-container-toolbar-btn");
            this.westBtn.setStyle("cursor: pointer; padding: 0px; margin: 0px;");
        }
        return this.layout;
    }

    private String getWestWidthPreference() {
        String width = Env.getPreference((Properties)Env.getCtx(), (int)0, (String)"SideController.Width", (boolean)false);
        if (!Util.isEmpty((String)width)) {
            ClientInfo browserInfo = this.getClientInfo();
            int browserWidth = browserInfo.desktopWidth;
            int prefWidth = Integer.valueOf(width.replace("px", ""));
            if (prefWidth <= browserWidth) {
                return width;
            }
        }
        return null;
    }

    protected void updateSideControllerWidthPreference(String width) {
        if (width != null) {
            Query query = new Query(Env.getCtx(), MTable.get((Properties)Env.getCtx(), (int)195), " Attribute=? AND AD_User_ID=? AND AD_Process_ID IS NULL AND PreferenceFor = 'W'", null);
            int userId = Env.getAD_User_ID((Properties)Env.getCtx());
            MPreference preference = (MPreference)query.setOnlyActiveRecords(true).setApplyAccessFilter(true).setClient_ID().setParameters(new Object[]{"SideController.Width", userId}).first();
            if (preference == null || preference.getAD_Preference_ID() <= 0) {
                preference = new MPreference(Env.getCtx(), 0, null);
                preference.setAD_User_ID(userId);
                preference.setAttribute("SideController.Width");
            }
            preference.setValue(width);
            preference.saveEx();
        }
    }

    private String getEastWidthPreference() {
        String width = Env.getPreference((Properties)Env.getCtx(), (int)0, (String)"HelpController.Width", (boolean)false);
        if (!Util.isEmpty((String)width)) {
            ClientInfo browserInfo = this.getClientInfo();
            int browserWidth = browserInfo.desktopWidth;
            int prefWidth = Integer.valueOf(width.replace("px", ""));
            if (prefWidth <= browserWidth) {
                return width;
            }
        }
        return null;
    }

    protected void updateHelpWidthPreference(String width) {
        if (width != null) {
            Query query = new Query(Env.getCtx(), MTable.get((Properties)Env.getCtx(), (int)195), " Attribute=? AND AD_User_ID=? AND AD_Process_ID IS NULL AND PreferenceFor = 'W'", null);
            int userId = Env.getAD_User_ID((Properties)Env.getCtx());
            MPreference preference = (MPreference)query.setOnlyActiveRecords(true).setApplyAccessFilter(true).setClient_ID().setParameters(new Object[]{"HelpController.Width", userId}).first();
            if (preference == null || preference.getAD_Preference_ID() <= 0) {
                preference = new MPreference(Env.getCtx(), 0, null);
                preference.setAD_User_ID(userId);
                preference.setAttribute("HelpController.Width");
            }
            preference.setValue(width);
            preference.saveEx();
        }
    }

    private void updateMenuCollapsedPreference(boolean collapsed) {
        UserPreference pref = SessionManager.getSessionApplication().getUserPreference();
        pref.setProperty("MenuCollapsed", collapsed);
        pref.savePreference();
    }

    private void updateHelpCollapsedPreference(boolean collapsed) {
        UserPreference pref = SessionManager.getSessionApplication().getUserPreference();
        pref.setProperty("HelpCollapsed", collapsed);
        pref.savePreference();
    }

    private void updateHeaderCollapsedPreference(boolean collapsed) {
        UserPreference pref = SessionManager.getSessionApplication().getUserPreference();
        pref.setProperty("HeaderCollapsed", collapsed);
        pref.savePreference();
    }

    public void renderHomeTab() {
        this.homeTab.getChildren().clear();
        this.dashboardController.render((Component)this.homeTab, (IDesktop)this, true);
        this.homeTab.setAttribute(HOME_TAB_RENDER_ATTR, (Object)Boolean.TRUE);
        West w = this.layout.getWest();
        West side = null;
        if (this.mobile) {
            this.westPopup.getChildren().clear();
            side = this.westPopup;
            w.setVisible(false);
            if (this.westBtn.getParent() == null) {
                Component menuSearchPanel = this.pnlHead.getFellow("menuLookup");
                menuSearchPanel.getParent().insertBefore((Component)this.westBtn, menuSearchPanel);
            }
            this.setSidePopupWidth(this.westPopup);
            this.setSidePopupWidth(this.eastPopup);
        } else {
            w.getChildren().clear();
            side = w;
        }
        this.sideController.render((Component)side, (IDesktop)this, false);
        if (this.mobile) {
            ToolBarButton btn = new ToolBarButton();
            btn.setIconSclass("z-icon-remove");
            btn.addEventListener("onClick", evt -> {
                this.westPopup.close();
                this.westPopup.removeAttribute(POPUP_OPEN_ATTR);
            });
            this.westPopup.appendChild((Component)btn);
            btn.setStyle("position: absolute; top: 10px; right: 0px; padding: 2px 0px;");
        }
        this.logo = this.pnlHead.getLogo();
        if (this.mobile && this.logo != null) {
            Anchorchildren ac = new Anchorchildren();
            ac.appendChild((Component)this.logo);
            ac.setStyle("padding: 4px;");
            Anchorlayout layout = (Anchorlayout)side.getFirstChild();
            layout.insertBefore((Component)ac, layout.getFirstChild());
        }
        if (this.mobile) {
            this.pnlHead.invalidate();
        }
        this.homeTab.invalidate();
    }

    protected void setSidePopupWidth(Popup popup) {
        if (ClientInfo.minWidth((int)1200)) {
            popup.setWidth("30%");
        } else if (ClientInfo.minWidth((int)1000)) {
            popup.setWidth("40%");
        } else if (ClientInfo.minWidth((int)700)) {
            popup.setWidth("50%");
        } else if (ClientInfo.minWidth((int)500)) {
            popup.setWidth("60%");
        } else if (ClientInfo.minWidth((int)400)) {
            popup.setWidth("70%");
        } else {
            popup.setWidth("80%");
        }
    }

    public void onEvent(org.zkoss.zk.ui.event.Event event) {
        Component comp = event.getTarget();
        String eventName = event.getName();
        if (eventName.equals("onClick")) {
            int menuId;
            ToolBarButton btn;
            if (comp == this.max) {
                if (this.layout.getNorth().isVisible()) {
                    this.collapseHeader();
                } else {
                    this.restoreHeader();
                }
            } else if (comp == this.showHeader) {
                this.showHeader.setPressed(true);
                if (this.pnlHead.getParent() != this.headerPopup) {
                    this.headerPopup.appendChild((Component)this.pnlHead);
                }
                LayoutUtils.openPopupWindow((Component)this.showHeader, (org.zkoss.zul.Window)this.headerPopup, (String)"after_start");
            } else if (comp == this.contextHelp) {
                if (this.isDisplayEastContents) {
                    if (this.mobile && this.eastPopup != null) {
                        this.eastPopup.open((Component)this.layout.getCenter(), "overlap_end");
                        this.isQuickInfoOpen = true;
                        this.updateHelpQuickInfo(this.gridTab);
                    } else {
                        this.layout.getEast().setVisible(true);
                        this.layout.getEast().setOpen(true);
                        LayoutUtils.removeSclass((String)"slide", (HtmlBasedComponent)this.layout.getEast());
                        this.contextHelp.setVisible(false);
                        this.updateHelpCollapsedPreference(false);
                        this.isQuickInfoOpen = true;
                        this.updateHelpQuickInfo(this.gridTab);
                    }
                }
            } else if (comp == this.westBtn) {
                this.westPopup.open((Component)this.layout.getNorth(), "overlap_start");
                this.westPopup.setAttribute(POPUP_OPEN_ATTR, (Object)Boolean.TRUE);
            } else if (comp instanceof ToolBarButton && (btn = (ToolBarButton)comp).getAttribute("AD_Menu_ID") != null && (menuId = ((Integer)btn.getAttribute("AD_Menu_ID")).intValue()) > 0) {
                this.onMenuSelected(menuId);
            }
        } else if (eventName.equals("onActivitiesChanged")) {
            Integer count = (Integer)event.getData();
            boolean change = false;
            if (count != null && count != this.noCount) {
                this.noCount = count;
                change = true;
            }
            if (change) {
                this.updateUI();
            }
        } else if (event instanceof ZoomEvent) {
            Clients.clearBusy();
            ZoomEvent ze = (ZoomEvent)event;
            if (ze.getData() != null && ze.getData() instanceof MQuery) {
                AEnv.zoom((MQuery)((MQuery)ze.getData()));
            }
        } else if (event instanceof DrillEvent) {
            Clients.clearBusy();
            DrillEvent de = (DrillEvent)event;
            if (de.getData() != null && de.getData() instanceof MQuery) {
                MQuery query = (MQuery)de.getData();
                this.executeDrill(query);
            }
        }
    }

    protected void restoreHeader() {
        this.layout.getNorth().setVisible(true);
        if (ThemeManager.isUseFontIconForImage()) {
            this.max.setIconSclass("z-icon-Collapsing");
        } else {
            this.max.setImage(ThemeManager.getThemeResource((String)IMAGES_UPARROW_PNG));
        }
        this.showHeader.setVisible(false);
        this.pnlHead.detach();
        this.headerContainer.appendChild((Component)this.pnlHead);
        Clients.resize((Component)this.pnlHead);
        this.updateHeaderCollapsedPreference(false);
    }

    protected void collapseHeader() {
        this.layout.getNorth().setVisible(false);
        if (ThemeManager.isUseFontIconForImage()) {
            this.max.setIconSclass("z-icon-Expanding");
        } else {
            this.max.setImage(ThemeManager.getThemeResource((String)IMAGES_DOWNARROW_PNG));
        }
        this.showHeader.setVisible(true);
        this.pnlHead.detach();
        if (this.headerPopup == null) {
            this.headerPopup = new Window();
            this.headerPopup.setSclass("desktop-header-popup");
            ZKUpdateUtil.setVflex((HtmlBasedComponent)this.headerPopup, (String)"true");
            this.headerPopup.setVisible(false);
            this.headerPopup.addEventListener("onOpen", (EventListener)new EventListener<OpenEvent>(){

                public void onEvent(OpenEvent event) throws Exception {
                    if (!event.isOpen() && JPiereFormWindowZoomDesktop.this.showHeader.isPressed()) {
                        JPiereFormWindowZoomDesktop.this.showHeader.setPressed(false);
                    }
                }
            });
        }
        this.headerPopup.appendChild((Component)this.pnlHead);
        this.updateHeaderCollapsedPreference(true);
    }

    private void executeDrill(MQuery query) {
        int AD_Table_ID = MTable.getTable_ID((String)query.getTableName());
        if (!MRole.getDefault().isCanReport(AD_Table_ID)) {
            Dialog.error((int)0, (String)"AccessCannotReport", (String)query.getTableName());
            return;
        }
        if (AD_Table_ID != 0) {
            new WReport(AD_Table_ID, query);
        }
    }

    public void setPage(Page page) {
        if (this.page != page) {
            this.layout.setPage(page);
            this.page = page;
            if (this.dashboardController != null) {
                this.dashboardController.onSetPage(page, this.layout.getDesktop());
            }
            if (this.sideController != null) {
                this.sideController.onSetPage(page, this.layout.getDesktop());
            }
        }
    }

    public Component getComponent() {
        return this.layout;
    }

    public void logout() {
        this.unbindEventManager();
        if (this.dashboardController != null) {
            this.dashboardController.onLogOut();
            this.dashboardController = null;
        }
        if (this.sideController != null) {
            this.sideController.onLogOut();
            this.sideController = null;
        }
        if (this.layout != null) {
            this.layout.detach();
        }
        this.layout = null;
        this.pnlHead = null;
        this.max = null;
        this.m_desktop = null;
    }

    public void updateUI() {
    }

    private void autoHideMenu() {
        if (this.mobile) {
            if (this.westPopup.getAttribute(POPUP_OPEN_ATTR) != null) {
                this.westPopup.close();
                this.westPopup.removeAttribute(POPUP_OPEN_ATTR);
            }
            this.pnlHead.closeSearchPopup();
        } else if (this.layout.getWest().isCollapsible() && !this.layout.getWest().isOpen()) {
            String id = this.layout.getWest().getUuid();
            Tab tab = this.windowContainer.getSelectedTab();
            if (tab != null) {
                String tabId = tab.getUuid();
                String script = autoHideMenuScript.replace("{0}", id);
                script = script.replace("{1}", tabId);
                AuScript aus = new AuScript((Component)this.layout.getWest(), script);
                Clients.response((String)"autoHideWest", (AuResponse)aus);
            }
        }
    }

    protected void preOpenNewTab() {
        this.autoHideMenu();
    }

    public void bindEventManager() {
        EventManager.getInstance().register("idempiere/broadcastMsg", (EventHandler)this);
    }

    public void unbindEventManager() {
        EventManager.getInstance().unregister((EventHandler)this);
    }

    public void handleEvent(Event event) {
        String eventName = event.getTopic();
        if (eventName.equals("idempiere/broadcastMsg")) {
            EventListener<org.zkoss.zk.ui.event.Event> listner = new EventListener<org.zkoss.zk.ui.event.Event>(){

                public void onEvent(org.zkoss.zk.ui.event.Event event) throws Exception {
                    BroadCastMsg msg = (BroadCastMsg)event.getData();
                    switch (msg.getEventId()) {
                        case 2: {
                            MBroadcastMessage mbMessage = MBroadcastMessage.get((Properties)Env.getCtx(), (int)msg.getIntData());
                            String currSession = Integer.toString(Env.getContextAsInt((Properties)Env.getCtx(), (String)"AD_Session_ID"));
                            if (!currSession.equals(msg.getTarget())) break;
                            BroadcastMessageWindow testMessageWindow = new BroadcastMessageWindow(JPiereFormWindowZoomDesktop.this.pnlHead);
                            testMessageWindow.appendMessage(mbMessage, true);
                            testMessageWindow = null;
                            break;
                        }
                        case 1: {
                            MBroadcastMessage mbMessage = MBroadcastMessage.get((Properties)Env.getCtx(), (int)msg.getIntData());
                            if (!mbMessage.isValidUserforMessage()) break;
                            BroadcastMessageWindow messageWindow = new BroadcastMessageWindow(JPiereFormWindowZoomDesktop.this.pnlHead);
                            messageWindow.appendMessage(mbMessage, false);
                            break;
                        }
                        case 3: {
                            String currSession = Integer.toString(Env.getContextAsInt((Properties)Env.getCtx(), (String)"AD_Session_ID"));
                            if (!currSession.equalsIgnoreCase(msg.getTarget())) break;
                            new TimeoutPanel(JPiereFormWindowZoomDesktop.this.pnlHead, msg.getIntData());
                            break;
                        }
                        case 4: {
                            String currSession = WebUtil.getServerName();
                            if (!currSession.equalsIgnoreCase(msg.getTarget())) break;
                            new TimeoutPanel(JPiereFormWindowZoomDesktop.this.pnlHead, msg.getIntData());
                        }
                    }
                }
            };
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Executions.schedule((Desktop)this.m_desktop, (EventListener)listner, (org.zkoss.zk.ui.event.Event)new org.zkoss.zk.ui.event.Event("OnBroadcast", null, event.getProperty("event.data")));
        }
    }

    public void cleanup(Desktop desktop) throws Exception {
        this.unbindEventManager();
    }

    public void updateHelpContext(String ctxType, int recordId) {
        if (this.isDisplayEastContents) {
            if (recordId == 200000 && "F".equals(ctxType)) {
                return;
            }
            Clients.response((AuResponse)new AuScript("zWatch.fire('onFieldTooltip', this);"));
            this.helpController.renderCtxHelp(ctxType, recordId);
            GridTab gridTab = null;
            Component window = this.getActiveWindow();
            ADWindow adwindow = ADWindow.findADWindow((Component)window);
            if (adwindow != null) {
                gridTab = adwindow.getADWindowContent().getActiveGridTab();
            }
            this.updateHelpQuickInfo(gridTab);
        }
    }

    public void updateHelpTooltip(GridField gridField) {
        if (this.isDisplayEastContents) {
            this.helpController.renderToolTip(gridField);
        }
    }

    public void updateHelpTooltip(String hdr, String desc, String help, String otherContent) {
        if (this.isDisplayEastContents) {
            this.helpController.renderToolTip(hdr, desc, help, otherContent);
        }
    }

    public void updateHelpQuickInfo(GridTab gridTab) {
        if (this.isDisplayEastContents) {
            this.gridTab = gridTab;
            if (this.isQuickInfoOpen) {
                this.helpController.renderQuickInfo(gridTab);
            }
        }
    }

    public ProcessDialog openProcessDialog(int processId, boolean soTrx) {
        ProcessDialog pd = super.openProcessDialog(processId, soTrx);
        this.updateHelpContext("P", processId);
        return pd;
    }

    public ADForm openForm(int formId) {
        ADForm form = super.openForm(formId);
        this.updateHelpContext("F", formId);
        return form;
    }

    public void openInfo(int infoId) {
        super.openInfo(infoId);
        this.updateHelpContext("I", infoId);
    }

    public void openWorkflow(int workflow_ID) {
        super.openWorkflow(workflow_ID);
        this.updateHelpContext("W", workflow_ID);
    }

    public void openTask(int taskId) {
        super.openTask(taskId);
        this.updateHelpContext("K", taskId);
    }

    public boolean isPendingWindow() {
        List windows = this.getWindows();
        if (windows != null) {
            int idx = 0;
            while (idx < windows.size()) {
                Object ad = windows.get(idx);
                if (ad != null && ad instanceof ADWindow && ((ADWindow)ad).getADWindowContent() != null && ((ADWindow)ad).getADWindowContent().isPendingChanges()) {
                    return true;
                }
                ++idx;
            }
        }
        return false;
    }

    public void onMenuSelected(int menuId) {
        super.onMenuSelected(menuId);
        if (this.showHeader != null && this.showHeader.isVisible()) {
            String script = "var w=zk.Widget.$('#" + this.layout.getUuid() + "'); " + "zWatch.fire('onFloatUp', w);";
            Clients.response((AuResponse)new AuScript(script));
        }
    }

    int getMenuID() {
        int AD_Role_ID = Env.getAD_Role_ID((Properties)Env.getCtx());
        int AD_Tree_ID = DB.getSQLValue(null, (String)"SELECT COALESCE(r.AD_Tree_Menu_ID, ci.AD_Tree_Menu_ID)FROM AD_ClientInfo ci INNER JOIN AD_Role r ON (ci.AD_Client_ID=r.AD_Client_ID) WHERE AD_Role_ID=?", (int)AD_Role_ID);
        if (AD_Tree_ID <= 0) {
            AD_Tree_ID = 10;
        }
        return AD_Tree_ID;
    }

    private void automaticOpen(Properties ctx) {
        if (this.isActionURL()) {
            return;
        }
        StringBuilder sql = new StringBuilder("SELECT m.Action, COALESCE(m.AD_Window_ID, m.AD_Process_ID, m.AD_Form_ID, m.AD_Workflow_ID, m.AD_Task_ID, m.AD_InfoWindow_ID), m.AD_Menu_ID ").append(" FROM AD_Tree_Favorite_Node tfn ").append(" INNER JOIN AD_Menu m ON (tfn.AD_Menu_ID = m.AD_Menu_ID) ").append(" WHERE tfn.AD_Tree_Favorite_ID = ").append(MTreeFavorite.getFavoriteTreeID((int)Env.getAD_User_ID((Properties)Env.getCtx()))).append(" AND tfn.IsActive = 'Y' AND tfn.LoginOpenSeqNo >= 0 ").append(" ORDER BY tfn.LoginOpenSeqNo ");
        List rows = DB.getSQLArrayObjectsEx(null, (String)sql.toString(), (Object[])new Object[0]);
        if (rows != null && rows.size() > 0) {
            for (List row : rows) {
                Boolean access;
                String action = (String)row.get(0);
                int recordID = ((BigDecimal)row.get(1)).intValue();
                int menuID = ((BigDecimal)row.get(2)).intValue();
                if (action.equals("X")) {
                    access = MRole.getDefault().getFormAccess(recordID);
                    if (access == null || !access.booleanValue()) continue;
                    SessionManager.getAppDesktop().openForm(recordID);
                    continue;
                }
                if (action.equals("I")) {
                    access = MRole.getDefault().getInfoAccess(recordID);
                    if (access == null || !access.booleanValue()) continue;
                    SessionManager.getAppDesktop().openInfo(recordID);
                    continue;
                }
                if (action.equals("P") || action.equals("R")) {
                    access = MRole.getDefault().getProcessAccess(recordID);
                    if (access == null || !access.booleanValue()) continue;
                    SessionManager.getAppDesktop().openProcessDialog(recordID, DB.getSQLValueStringEx(null, (String)"SELECT IsSOTrx FROM AD_Menu WHERE AD_Menu_ID = ?", (Object[])new Object[]{menuID}).equals("Y"));
                    continue;
                }
                if (action.equals("T")) {
                    access = MRole.getDefault().getTaskAccess(recordID);
                    if (access == null || !access.booleanValue()) continue;
                    SessionManager.getAppDesktop().openTask(recordID);
                    continue;
                }
                if (action.equals("W")) {
                    access = MRole.getDefault().getWindowAccess(recordID);
                    if (access == null || !access.booleanValue()) continue;
                    SessionManager.getAppDesktop().openWindow(recordID, null);
                    continue;
                }
                if (!action.equals("F") || (access = MRole.getDefault().getWorkflowAccess(recordID)) == null || !access.booleanValue()) continue;
                SessionManager.getAppDesktop().openWorkflow(recordID);
            }
        }
    }

    public void setClientInfo(ClientInfo clientInfo) {
        super.setClientInfo(clientInfo);
        if (clientInfo.tablet && this.homeTab != null && this.homeTab.getAttribute(HOME_TAB_RENDER_ATTR) != null) {
            this.dashboardController.updateLayout(clientInfo);
            this.updateSideLayout();
        }
    }

    private void updateSideLayout() {
        if (this.westPopup != null && this.westPopup.getChildren().size() > 1) {
            this.setSidePopupWidth(this.westPopup);
        }
        if (this.eastPopup != null && this.eastPopup.getChildren().size() > 1) {
            this.setSidePopupWidth(this.eastPopup);
        }
    }

    private boolean isActionURL() {
        String[] strs;
        ConcurrentHashMap parameters = new ConcurrentHashMap(Executions.getCurrent().getParameterMap());
        String action = "";
        if (parameters != null && (strs = (String[])parameters.get("Action")) != null && strs.length == 1 && strs[0] != null) {
            action = strs[0];
        }
        return !Util.isEmpty((String)action);
    }

    public void showZoomWindow(int AD_Window_ID, MQuery query) {
        if (this.formWindowToFormMap.size() > 0 && this.formWindowToFormMap.containsKey(AD_Window_ID)) {
            int Zoom_Window_ID = this.formWindowToFormMap.get(AD_Window_ID);
            List factories = Service.locator().list(IFormWindowZoomFactory.class).getServices();
            if (factories != null) {
                for (IFormWindowZoomFactory factory : factories) {
                    ADForm form = factory.newFormInstance(Zoom_Window_ID, query);
                    if (form == null || Window.Mode.EMBEDDED != form.getWindowMode()) continue;
                    DesktopTabpanel tabPanel = new DesktopTabpanel();
                    form.setParent((Component)tabPanel);
                    form.setTitle(null);
                    this.preOpenNewTab();
                    if (!this.WindowTabTitleMap.containsKey(AD_Window_ID)) {
                        this.WindowTabTitleMap.put(AD_Window_ID, MWindow.get((Properties)Env.getCtx(), (int)AD_Window_ID).get_Translation("Name"));
                    }
                    this.windowContainer.addWindow((Component)tabPanel, this.WindowTabTitleMap.get(AD_Window_ID), true, null);
                    form.focus();
                    return;
                }
            }
        }
        super.showZoomWindow(AD_Window_ID, query);
    }
}

