/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.webui.apps;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import jpiere.plugin.webui.panel.JPiereLabelsPanel;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListHead;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.MLabel;
import org.compiere.model.MLabelAssignment;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListModelList;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listheader;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.ListitemRenderer;
import org.zkoss.zul.ListitemRendererExt;
import org.zkoss.zul.Vlayout;

public class JPiereLabelsSearchController
implements EventListener<Event> {
    public static final String ON_POST_SELECT_LABELITEM_EVENT = "onPostSelectLabelitem";
    private static final String ON_SEARCH_ECHO = "onSearchEcho";
    private static final String ON_LOAD_MORE = "onLoadMore";
    private Component parent;
    private org.adempiere.webui.component.Listbox listbox;
    private ListModelList<LabelItem> model;
    private Vlayout layout;
    private JPiereLabelsPanel labelsPanel;

    public JPiereLabelsSearchController(JPiereLabelsPanel labelsPanel) {
        this.labelsPanel = labelsPanel;
    }

    public void create(Component parent) {
        this.parent = parent;
        this.layout = new Vlayout();
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.layout, (String)"100%");
        parent.appendChild((Component)this.layout);
        this.listbox = new org.adempiere.webui.component.Listbox();
        this.listbox.setItemRenderer((ListitemRenderer)new LabelItemRenderer());
        this.listbox.setStyle("border: none");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.listbox, (String)"100%");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.listbox, (String)"true");
        this.layout.appendChild((Component)this.listbox);
        this.listbox.addEventListener("onSelect", (EventListener)this);
        this.listbox.addEventListener(ON_POST_SELECT_LABELITEM_EVENT, (EventListener)this);
        ListHead listhead = new ListHead();
        this.listbox.appendChild((Component)listhead);
        Listheader listheader = new Listheader();
        listhead.appendChild((Component)listheader);
        listheader = new Listheader();
        listheader.setAlign("center");
        listheader.setValign("middle");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)listheader, (String)"30px");
        listhead.appendChild((Component)listheader);
        this.layout.addEventListener(ON_SEARCH_ECHO, (EventListener)this);
        this.layout.addEventListener(ON_LOAD_MORE, (EventListener)this);
    }

    public void onEvent(Event event) throws Exception {
        if (event.getName().equals(ON_SEARCH_ECHO)) {
            this.onSearchEcho((String)event.getData());
        } else if ("onClick".equals(event.getName()) && event.getTarget() instanceof ListItem) {
            ListItem item = (ListItem)event.getTarget();
            LabelItem labelItem = (LabelItem)item.getValue();
            this.onSelect(labelItem);
        }
    }

    public void search(String value) {
        this.listbox.setModel(null);
        Events.echoEvent((String)ON_SEARCH_ECHO, (Component)this.layout, (String)value);
    }

    public void onSearchEcho(String value) {
        ListModelList newModel = null;
        if (Util.isEmpty((String)value)) {
            newModel = this.model;
        } else {
            LabelItem i;
            newModel = new ListModelList();
            boolean found = false;
            int currentIndex = 0;
            int foundIndex = 0;
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT ");
            sql.append("   AD_Label.AD_Label_ID, ");
            sql.append("   AD_Label.Name, ");
            sql.append("   COUNT(AD_LabelAssignment.AD_LabelAssignment_ID), ");
            sql.append("   CASE ");
            sql.append("     WHEN AD_Label.AD_LabelCategory_ID > 0 AND AD_LabelCategory.IsCanBeUsedInAllTables = 'N' ");
            sql.append("       AND AD_LabelCategoryTable.AD_Table_ID <> ").append(this.labelsPanel.getAD_Table_ID()).append(" THEN 'N' ");
            sql.append("     ELSE 'Y' ");
            sql.append("   END AS IsAllowed ");
            sql.append(" FROM AD_Label ");
            sql.append(" LEFT JOIN AD_LabelAssignment ON AD_LabelAssignment.AD_Label_ID = AD_Label.AD_Label_ID ");
            sql.append(" LEFT JOIN AD_LabelCategory ON AD_LabelCategory.AD_LabelCategory_ID = AD_LabelCategory.AD_LabelCategory_ID ");
            sql.append(" LEFT JOIN AD_LabelCategoryTable ON AD_LabelCategoryTable.AD_LabelCategory_ID = AD_LabelCategory.AD_LabelCategory_ID ");
            sql.append(" WHERE AD_Label.AD_Client_ID = ? AND LOWER(AD_Label.Name) LIKE LOWER(?) ");
            sql.append(" GROUP BY AD_Label.AD_Label_ID, AD_Label.Name, ");
            sql.append("   CASE ");
            sql.append("     WHEN AD_Label.AD_LabelCategory_ID > 0 AND AD_LabelCategory.IsCanBeUsedInAllTables = 'N' ");
            sql.append("       AND AD_LabelCategoryTable.AD_Table_ID <> ").append(this.labelsPanel.getAD_Table_ID()).append(" THEN 'N' ");
            sql.append("     ELSE 'Y' ");
            sql.append("   END ");
            sql.append(" ORDER BY COUNT(AD_LabelAssignment.AD_LabelAssignment_ID) DESC");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), null);
                    pstmt.setInt(1, Env.getAD_Client_ID((Properties)Env.getCtx()));
                    pstmt.setString(2, "%" + value + "%");
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        i = new LabelItem(rs.getInt(1), rs.getString(2), rs.getInt(3), rs.getBoolean(4));
                        newModel.add((Object)i);
                        if (rs.getString(2).toUpperCase().equals(value.toUpperCase())) {
                            found = true;
                            foundIndex = currentIndex;
                        }
                        ++currentIndex;
                    }
                }
                catch (SQLException e) {
                    throw new AdempiereException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            if (!found) {
                i = new LabelItem(0, value, 0, true);
                newModel.add((Object)i);
            }
            this.listbox.setModel((ListModel)newModel);
            this.listbox.setSelectedIndex(foundIndex);
        }
    }

    public void onSelect(LabelItem item) {
        if (item == null || !item.isAllowed()) {
            return;
        }
        MLabel label = null;
        if (item.getC_Label_ID() > 0) {
            label = new MLabel(Env.getCtx(), item.getC_Label_ID(), null);
        } else {
            label = MLabel.getByName((Properties)Env.getCtx(), (String)item.getLabel(), null);
            if (label == null) {
                label = new MLabel(Env.getCtx(), 0, null);
            }
        }
        if (label.get_ID() <= 0) {
            label.setAD_Org_ID(0);
            label.setName(item.getLabel());
            label.saveEx();
        }
        if (!MLabelAssignment.hasLabelAssignment((int)label.get_ID(), (int)this.labelsPanel.getAD_Table_ID(), (int)this.labelsPanel.getRecord_ID())) {
            MLabelAssignment assign = new MLabelAssignment(Env.getCtx(), 0, null);
            assign.setAD_Org_ID(label.getAD_Org_ID());
            assign.setAD_Label_ID(label.get_ID());
            assign.setAD_Table_ID(this.labelsPanel.getAD_Table_ID());
            assign.setRecord_ID(this.labelsPanel.getRecord_ID());
            assign.saveEx();
        }
        Events.echoEvent((String)ON_POST_SELECT_LABELITEM_EVENT, (Component)this.labelsPanel, (Object)item);
        Events.echoEvent((String)ON_POST_SELECT_LABELITEM_EVENT, (Component)this.parent.getParent().getParent(), (Object)item);
    }

    public LabelItem getSelectedItem() {
        ListItem selected = this.listbox.getSelectedItem();
        if (selected == null) {
            return null;
        }
        return (LabelItem)selected.getValue();
    }

    public LabelItem selectPrior() {
        int i = this.listbox.getSelectedIndex();
        if (i > 0) {
            this.listbox.setSelectedIndex(i - 1);
            ListItem selected = this.listbox.getSelectedItem();
            if (selected == null) {
                return null;
            }
            Clients.scrollIntoView((Component)selected);
            LabelItem item = (LabelItem)selected.getValue();
            return item;
        }
        return null;
    }

    public LabelItem selectNext() {
        int i = this.listbox.getSelectedIndex();
        if (i < 0 && this.listbox.getItemCount() > 0) {
            this.listbox.setSelectedIndex(0);
            ListItem selected = this.listbox.getSelectedItem();
            if (selected == null) {
                return null;
            }
            LabelItem item = (LabelItem)selected.getValue();
            return item;
        }
        if (i + 1 < this.listbox.getItemCount()) {
            this.listbox.setSelectedIndex(i + 1);
            ListItem selected = this.listbox.getSelectedItem();
            if (selected == null) {
                return null;
            }
            LabelItem item = (LabelItem)selected.getValue();
            if (item == null) {
                return null;
            }
            Clients.scrollIntoView((Component)selected);
            return item;
        }
        return null;
    }

    public class LabelItem {
        private String label;
        private int C_Label_ID;
        private int countUsed;
        private boolean isAllowed;

        public LabelItem(int C_Label_ID, String label, int countUsed, boolean isAllowed) {
            this.label = label;
            this.C_Label_ID = C_Label_ID;
            this.countUsed = countUsed;
            this.isAllowed = isAllowed;
        }

        public String getLabel() {
            return this.label;
        }

        public int getC_Label_ID() {
            return this.C_Label_ID;
        }

        public int getCountUsed() {
            return this.countUsed;
        }

        public boolean isAllowed() {
            return this.isAllowed;
        }
    }

    private class LabelItemRenderer
    implements ListitemRenderer<LabelItem>,
    ListitemRendererExt {
        private LabelItemRenderer() {
        }

        public Listitem newListitem(Listbox listbox) {
            return new ListItem();
        }

        public Listcell newListcell(Listitem item) {
            return new Listcell(item.getLabel());
        }

        public int getControls() {
            return 1;
        }

        public void render(Listitem item, LabelItem data, int index) throws Exception {
            Label labelName = new Label(data.getLabel());
            labelName.setStyle("color: " + MLabel.calculateHexColor((String)data.getLabel()));
            Listcell cell = new Listcell();
            cell.appendChild((Component)labelName);
            if (data.getC_Label_ID() > 0) {
                Label labelCountUsed = new Label("(" + data.getCountUsed() + ")");
                labelCountUsed.setStyle("color: #909090; margin-left: 4px;");
                cell.appendChild((Component)labelCountUsed);
            }
            if (!data.isAllowed()) {
                item.setDisabled(true);
            }
            item.appendChild((Component)cell);
            item.setValue((Object)data);
            item.addEventListener("onClick", (EventListener)JPiereLabelsSearchController.this);
            Listcell cell2 = new Listcell();
            if (data.getC_Label_ID() <= 0) {
                if (ThemeManager.isUseFontIconForImage()) {
                    cell2.setIconSclass("z-icon-New");
                } else {
                    cell2.setImage(ThemeManager.getThemeResource((String)"images/New16.png"));
                }
            } else if (!data.isAllowed()) {
                if (ThemeManager.isUseFontIconForImage()) {
                    cell2.setIconSclass("z-icon-NotAllowed");
                } else {
                    cell2.setImage(ThemeManager.getThemeResource((String)"images/Cancel16.png"));
                }
            }
            item.appendChild((Component)cell2);
        }
    }
}

