/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.webui.apps;

import java.util.Properties;
import jpiere.plugin.webui.apps.JPiereLabelsSearchController;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.component.Bandbox;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.InputEvent;
import org.zkoss.zk.ui.event.KeyEvent;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Bandpopup;
import org.zkoss.zul.Div;

public class JPiereLabelsSearch
extends Div
implements EventListener<Event> {
    private static final long serialVersionUID = -8793878697269469837L;
    private static final String ON_ENTER_KEY = "onEnterKey";
    private static final String ON_CREATE_ECHO = "onCreateEcho";
    private static final String ON_SEARCH = "onSearch";
    private Bandbox bandbox;
    private JPiereLabelsSearchController controller;

    public JPiereLabelsSearch(JPiereLabelsSearchController controller) {
        this.controller = controller;
        this.init();
    }

    private void init() {
        this.bandbox = new Bandbox();
        this.appendChild((Component)this.bandbox);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.bandbox, (String)"100%");
        this.bandbox.setAutodrop(true);
        this.bandbox.setId("labelsSearchBox");
        this.bandbox.addEventListener("onChanging", (EventListener)this);
        this.bandbox.addEventListener("onChange", (EventListener)this);
        this.bandbox.setCtrlKeys("#up#down");
        this.bandbox.addEventListener("onCtrlKey", (EventListener)this);
        this.bandbox.setPlaceholder(Msg.getMsg((Properties)Env.getCtx(), (String)"TypeToSearchOrCreate"));
        Bandpopup popup = new Bandpopup();
        ZKUpdateUtil.setWindowHeightX((HtmlBasedComponent)popup, (int)100);
        ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)popup, (int)176);
        this.bandbox.appendChild((Component)popup);
        this.controller.create((Component)popup);
        this.addEventListener(ON_SEARCH, this);
        this.addEventListener(ON_CREATE_ECHO, this);
        this.addEventListener("onPostSelectLabelitem", this);
        this.bandbox.addEventListener(ON_ENTER_KEY, (EventListener)this);
    }

    public void onEvent(Event event) throws Exception {
        if ("onChanging".equals(event.getName())) {
            InputEvent inputEvent = (InputEvent)event;
            String value = inputEvent.getValue();
            this.bandbox.setAttribute("last.onchanging", (Object)value);
            Events.postEvent((String)ON_SEARCH, (Component)this, (Object)value);
        } else if ("onChange".equals(event.getName())) {
            this.bandbox.removeAttribute("last.onchanging");
        } else if ("onCtrlKey".equals(event.getName())) {
            JPiereLabelsSearchController.LabelItem selected;
            KeyEvent ke = (KeyEvent)event;
            if (ke.getKeyCode() == 38) {
                JPiereLabelsSearchController.LabelItem selected2;
                if (this.bandbox.getFirstChild().isVisible() && (selected2 = this.controller.selectPrior()) != null) {
                    this.bandbox.setText(selected2.getLabel());
                }
            } else if (ke.getKeyCode() == 40 && this.bandbox.getFirstChild().isVisible() && (selected = this.controller.selectNext()) != null) {
                this.bandbox.setText(selected.getLabel());
            }
        } else if (event.getName().equals(ON_SEARCH)) {
            String value = (String)event.getData();
            this.controller.search(value);
            this.bandbox.focus();
        } else if (event.getName().equals(ON_CREATE_ECHO)) {
            StringBuilder script = new StringBuilder("jq('#").append(this.bandbox.getUuid()).append("').bind('keydown', function(e) {var code=e.keyCode||e.which;if(code==13){").append("var widget=zk.Widget.$(this);").append("var event=new zk.Event(widget,'").append(ON_ENTER_KEY).append("',{},{toServer:true});").append("zAu.send(event);").append("}});");
            Clients.evalJavaScript((String)script.toString());
        } else if (event.getName().equals(ON_ENTER_KEY)) {
            if (event.getTarget() instanceof Bandbox) {
                this.controller.onSelect(this.controller.getSelectedItem());
            }
        } else if (event.getName().equals("onSelect")) {
            String value = (String)this.bandbox.getAttribute("last.onchanging");
            if (value == null) {
                value = this.bandbox.getValue();
            }
            Events.postEvent((String)ON_SEARCH, (Component)this, (Object)value);
        }
        if (event.getName().equals("onPostSelectLabelitem")) {
            this.closePopup();
            this.bandbox.focus();
            this.bandbox.setText(null);
            this.bandbox.setValue(null);
        }
    }

    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        Events.echoEvent((String)ON_CREATE_ECHO, (Component)this, null);
    }

    public void closePopup() {
        if (this.bandbox != null) {
            this.bandbox.close();
        }
    }

    public void onClientInfo() {
        ZKUpdateUtil.setWindowHeightX((HtmlBasedComponent)this.bandbox.getDropdown(), (int)(ClientInfo.get().desktopHeight - 50));
    }
}

