/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.webui.adwindow;

import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import jpiere.plugin.webui.adwindow.JPiereAbstractADWindowContent;
import jpiere.plugin.webui.adwindow.JPiereGridView;
import org.adempiere.util.GridRowCtx;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.adwindow.ADWindow;
import org.adempiere.webui.adwindow.ADWindowContent;
import org.adempiere.webui.adwindow.GridTableListModel;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.EditorBox;
import org.adempiere.webui.component.NumberBox;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.component.Urlbox;
import org.adempiere.webui.editor.IEditorConfiguration;
import org.adempiere.webui.editor.WButtonEditor;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WEditorPopupMenu;
import org.adempiere.webui.editor.WImageEditor;
import org.adempiere.webui.editor.WebEditorFactory;
import org.adempiere.webui.event.ActionEvent;
import org.adempiere.webui.event.ActionListener;
import org.adempiere.webui.event.ContextMenuListener;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.panel.HelpController;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.GridTabDataBinder;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MStyle;
import org.compiere.model.MSysConfig;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Evaluatee;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.util.Callback;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Cell;
import org.zkoss.zul.Columns;
import org.zkoss.zul.Grid;
import org.zkoss.zul.Html;
import org.zkoss.zul.Label;
import org.zkoss.zul.Paging;
import org.zkoss.zul.RendererCtrl;
import org.zkoss.zul.Row;
import org.zkoss.zul.RowRenderer;
import org.zkoss.zul.RowRendererExt;
import org.zkoss.zul.Vbox;
import org.zkoss.zul.impl.XulElement;

public class JPiereGridTabRowRenderer
implements RowRenderer<Object[]>,
RowRendererExt,
RendererCtrl,
EventListener<Event> {
    protected static final String COLUMN_NAME_ATTR = "columnName";
    private static final String DISPLAY_COMPONENT_ATTR = "display.component";
    private static final String GRID_VIEW_ON_SELECT_ROW_ATTR = "gridView.onSelectRow";
    public static final String GRID_ROW_INDEX_ATTR = "grid.row.index";
    private static final String CELL_DIV_STYLE = "height: 100%; cursor: pointer; ";
    private static final String CELL_DIV_STYLE_ALIGN_CENTER = "height: 100%; cursor: pointer; text-align:center; ";
    private static final String CELL_DIV_STYLE_ALIGN_RIGHT = "height: 100%; cursor: pointer; text-align:right; ";
    private static final String CELL_BORDER_STYLE_DEFAULT = "border: dotted 1px #dddddd;";
    private static final String CELL_BORDER_STYLE_NONE = "border: none;";
    private static final String ROW_STYLE = "border: solid 1px #dddddd; cursor:pointer";
    private static final int MAX_TEXT_LENGTH_DEFAULT = 60;
    private GridTab gridTab;
    private int windowNo;
    private GridTabDataBinder dataBinder;
    private Map<GridField, WEditor> editors = new LinkedHashMap<GridField, WEditor>();
    private Map<GridField, WEditor> readOnlyEditors = new LinkedHashMap<GridField, WEditor>();
    private Paging paging;
    private RowListener rowListener;
    private Grid grid = null;
    private JPiereGridView gridPanel = null;
    private Row currentRow;
    private Object[] currentValues;
    private boolean editing = false;
    private int currentRowIndex = -1;
    private JPiereAbstractADWindowContent m_windowPanel;
    private ActionListener buttonListener;
    private boolean isGridViewCustomized = false;
    private WEditor defaultFocusField = null;
    private static final IEditorConfiguration readOnlyEditorConfiguration = new IEditorConfiguration(){

        public Boolean getReadonly() {
            return Boolean.TRUE;
        }

        public Boolean getMandatory() {
            return Boolean.FALSE;
        }
    };

    public JPiereGridTabRowRenderer(GridTab gridTab, int windowNo) {
        this.gridTab = gridTab;
        this.windowNo = windowNo;
        this.dataBinder = new GridTabDataBinder(gridTab);
    }

    private WEditor getEditorCell(GridField gridField) {
        WEditor editor = this.editors.get(gridField);
        if (editor != null) {
            this.prepareFieldEditor(gridField, editor);
            editor.addValueChangeListener((ValueChangeListener)this.dataBinder);
            gridField.removePropertyChangeListener((PropertyChangeListener)editor);
            gridField.addPropertyChangeListener((PropertyChangeListener)editor);
            editor.setValue(gridField.getValue());
        }
        return editor;
    }

    private void prepareFieldEditor(GridField gridField, WEditor editor) {
        if (editor instanceof WButtonEditor) {
            if (this.buttonListener != null) {
                ((WButtonEditor)editor).addActionListener(this.buttonListener);
            } else {
                Object window = SessionManager.getAppDesktop().findWindow(this.windowNo);
                if (window != null && window instanceof ADWindow) {
                    ADWindowContent windowPanel = ((ADWindow)window).getADWindowContent();
                    ((WButtonEditor)editor).addActionListener((ActionListener)windowPanel);
                }
            }
        }
        if (editor.getComponent() instanceof HtmlBasedComponent) {
            editor.fillHorizontal();
        }
    }

    public int getColumnIndex(GridField field) {
        GridField[] fields = this.gridPanel.getFields();
        int i = 0;
        while (i < fields.length) {
            if (fields[i] == field) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private Component createReadonlyCheckbox(Object value) {
        Checkbox checkBox = new Checkbox();
        if (value != null && "true".equalsIgnoreCase(value.toString())) {
            checkBox.setChecked(true);
        } else {
            checkBox.setChecked(false);
        }
        checkBox.setDisabled(true);
        return checkBox;
    }

    private Component createInvisibleComponent() {
        Textbox textBox = new Textbox();
        textBox.setDisabled(true);
        textBox.setVisible(false);
        return textBox;
    }

    protected String getDisplayTextWithEditorCheck(Object value, GridField gridField, int rowIndex) {
        WEditor readOnlyEditor = this.readOnlyEditors.get(gridField);
        if (readOnlyEditor == null && (readOnlyEditor = WebEditorFactory.getEditor((GridField)gridField, (boolean)true, (IEditorConfiguration)readOnlyEditorConfiguration)) != null) {
            this.readOnlyEditors.put(gridField, readOnlyEditor);
        }
        return this.getDisplayText(value, gridField, rowIndex);
    }

    public String getDisplayText(Object value, GridField gridField, int rowIndex) {
        return this.getDisplayText(value, gridField, rowIndex, false);
    }

    private String getDisplayText(Object value, GridField gridField, int rowIndex, boolean isForceGetValue) {
        if (value == null) {
            return "";
        }
        GridRowCtx gridRowCtx = new GridRowCtx(Env.getCtx(), this.gridTab, rowIndex);
        if (rowIndex >= 0 && !isForceGetValue && !gridField.isDisplayed((Properties)gridRowCtx, true)) {
            return "";
        }
        if (gridField.isEncryptedField()) {
            return "********";
        }
        if (this.readOnlyEditors.get(gridField) != null) {
            WEditor editor = this.readOnlyEditors.get(gridField);
            return editor.getDisplayTextForGridView(gridRowCtx, value);
        }
        return value.toString();
    }

    private Component getDisplayComponent(int rowIndex, Object value, GridField gridField, boolean isForceGetValue) {
        Component component;
        if (gridField.getDisplayType() == 20) {
            component = this.createReadonlyCheckbox(value);
        } else if (gridField.isHeading()) {
            component = this.createInvisibleComponent();
        } else if (gridField.getDisplayType() == 28) {
            GridRowCtx gridRowCtx = new GridRowCtx(Env.getCtx(), this.gridTab, rowIndex);
            WButtonEditor editor = new WButtonEditor(gridField, rowIndex);
            editor.setValue(this.gridTab.getValue(rowIndex, gridField.getColumnName()));
            editor.setReadWrite(gridField.isEditable((Properties)gridRowCtx, true, true));
            editor.getComponent().setAttribute(GRID_ROW_INDEX_ATTR, (Object)rowIndex);
            editor.addActionListener(this.buttonListener);
            component = editor.getComponent();
        } else {
            String text = this.getDisplayText(value, gridField, rowIndex, isForceGetValue);
            WEditor editor = this.getEditorCell(gridField);
            if (editor.getDisplayComponent() == null) {
                Label label = new Label();
                this.setLabelText(text, label);
                component = label;
            } else {
                component = editor.getDisplayComponent();
                if (component instanceof Html) {
                    ((Html)component).setContent(text);
                } else {
                    throw new UnsupportedOperationException("Only implemented for Html component.");
                }
            }
        }
        this.applyFieldStyle(gridField, rowIndex, (HtmlBasedComponent)component);
        return component;
    }

    private void applyFieldStyle(GridField gridField, int rowIndex, HtmlBasedComponent component) {
        int AD_Style_ID = gridField.getAD_FieldStyle_ID();
        if (AD_Style_ID <= 0) {
            return;
        }
        GridRowCtx gridRowCtx = new GridRowCtx(Env.getCtx(), this.gridTab, rowIndex);
        MStyle style = MStyle.get((Properties)Env.getCtx(), (int)AD_Style_ID);
        this.setComponentStyle(component, style.buildStyle(ThemeManager.getTheme(), (Evaluatee)gridRowCtx));
    }

    protected void setComponentStyle(HtmlBasedComponent component, String style) {
        if (style != null && style.startsWith("@sclass=")) {
            String sclass = style.substring("@sclass=".length());
            if (component instanceof EditorBox) {
                ((EditorBox)component).getTextbox().setSclass(sclass);
            } else {
                component.setSclass(sclass);
            }
        } else if (style != null && style.startsWith("@zclass=")) {
            String zclass = style.substring("@zclass=".length());
            if (component instanceof EditorBox) {
                ((EditorBox)component).getTextbox().setZclass(zclass);
            } else {
                component.setZclass(zclass);
            }
        } else if (component instanceof EditorBox) {
            ((EditorBox)component).getTextbox().setStyle(style);
        } else {
            component.setStyle(style);
        }
    }

    private void setLabelText(String text, Label label) {
        String display = text;
        int MAX_TEXT_LENGTH = MSysConfig.getIntValue((String)"MAX_TEXT_LENGTH_ON_GRID_VIEW", (int)60, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
        if (text != null && text.length() > MAX_TEXT_LENGTH) {
            display = String.valueOf(text.substring(0, MAX_TEXT_LENGTH - 3)) + "...";
        }
        label.setValue(display);
        if (text != null && text.length() > MAX_TEXT_LENGTH) {
            label.setTooltiptext(text);
        }
    }

    public List<WEditor> getEditors() {
        ArrayList<WEditor> editorList = new ArrayList<WEditor>();
        if (!this.editors.isEmpty()) {
            editorList.addAll(this.editors.values());
        }
        return editorList;
    }

    public void setPaging(Paging paging) {
        this.paging = paging;
    }

    public void stopEditing(boolean updateCellLabel) {
        if (!this.editing) {
            return;
        }
        this.editing = false;
        for (Map.Entry<GridField, WEditor> entry : this.editors.entrySet()) {
            Component component;
            if (entry.getValue().getComponent().getParent() == null) continue;
            Component child = entry.getValue().getComponent();
            Cell div = null;
            while (div == null && child != null) {
                Component parent = child.getParent();
                if (parent instanceof Cell && parent.getParent().getParent() instanceof Row) {
                    div = (Cell)parent;
                    continue;
                }
                child = parent;
            }
            Component component2 = component = div != null ? (Component)div.getAttribute(DISPLAY_COMPONENT_ATTR) : null;
            if (updateCellLabel) {
                if (component instanceof Label) {
                    Label label = (Label)component;
                    label.getChildren().clear();
                    String text = this.getDisplayText(entry.getValue().getValue(), entry.getValue().getGridField(), -1);
                    this.setLabelText(text, label);
                } else if (component instanceof Checkbox) {
                    Checkbox checkBox = (Checkbox)component;
                    Object value = entry.getValue().getValue();
                    if (value != null && "true".equalsIgnoreCase(value.toString())) {
                        checkBox.setChecked(true);
                    } else {
                        checkBox.setChecked(false);
                    }
                } else if (component instanceof Html) {
                    ((Html)component).setContent(this.getDisplayText(entry.getValue().getValue(), entry.getValue().getGridField(), -1));
                }
            }
            entry.getValue().getComponent().detach();
            entry.getKey().removePropertyChangeListener((PropertyChangeListener)entry.getValue());
            entry.getValue().removeValuechangeListener((ValueChangeListener)this.dataBinder);
            if (component.getParent() == null || component.getParent() != div) {
                div.appendChild(component);
                continue;
            }
            if (component.isVisible()) continue;
            component.setVisible(true);
        }
        GridTableListModel model = (GridTableListModel)this.grid.getModel();
        model.setEditing(false);
    }

    public void render(Row row, Object[] data, int index) throws Exception {
        Object isActiveValue;
        int columnCount = 0;
        GridField[] gridPanelFields = null;
        GridField[] gridTabFields = null;
        this.isGridViewCustomized = false;
        if (this.gridPanel != null) {
            if (!this.gridPanel.isVisible()) {
                return;
            }
            gridPanelFields = this.gridPanel.getFields();
            columnCount = gridPanelFields.length;
            gridTabFields = this.gridTab.getFields();
            boolean bl = this.isGridViewCustomized = gridTabFields.length != gridPanelFields.length;
        }
        if (this.grid == null) {
            this.grid = (Grid)row.getParent().getParent();
        }
        if (this.rowListener == null) {
            this.rowListener = new RowListener((Grid)row.getParent().getParent());
        }
        if (!this.isGridViewCustomized) {
            int i = 0;
            while (i < gridTabFields.length) {
                if (gridPanelFields[i].getAD_Field_ID() != gridTabFields[i].getAD_Field_ID()) {
                    this.isGridViewCustomized = true;
                    break;
                }
                ++i;
            }
        }
        if (!this.isGridViewCustomized) {
            this.currentValues = data;
        } else {
            ArrayList<Object> dataList = new ArrayList<Object>();
            GridField[] gridFieldArray = gridPanelFields;
            int n = gridPanelFields.length;
            int n2 = 0;
            while (n2 < n) {
                GridField gridField = gridFieldArray[n2];
                int i = 0;
                while (i < gridTabFields.length) {
                    if (gridField.getAD_Field_ID() == gridTabFields[i].getAD_Field_ID()) {
                        dataList.add(data[i]);
                        break;
                    }
                    ++i;
                }
                ++n2;
            }
            this.currentValues = dataList.toArray(new Object[0]);
        }
        Columns columns = this.grid.getColumns();
        int rowIndex = index;
        if (this.paging != null && this.paging.getPageSize() > 0) {
            rowIndex = this.paging.getActivePage() * this.paging.getPageSize() + rowIndex;
        }
        Cell cell = new Cell();
        cell.setWidth("28px");
        cell.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"Select"));
        Checkbox selection = new Checkbox();
        selection.setAttribute(GRID_ROW_INDEX_ATTR, (Object)rowIndex);
        selection.setChecked(this.gridTab.isSelected(rowIndex));
        cell.setStyle("background-color: transparent !important;");
        selection.addEventListener("onCheck", (EventListener)this);
        if (!selection.isChecked() && this.gridPanel.selectAll.isChecked()) {
            this.gridPanel.selectAll.setChecked(false);
        }
        cell.appendChild((Component)selection);
        row.appendChild((Component)cell);
        if (this.isShowCurrentRowIndicatorColumn()) {
            cell = new Cell();
            cell.setWidth("18px");
            cell.addEventListener("onClick", (EventListener)this);
            cell.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"EditRecord")));
            if (ThemeManager.isUseFontIconForImage()) {
                Label indicatorLabel = new Label();
                cell.appendChild((Component)indicatorLabel);
                Cell finalCell = cell;
                indicatorLabel.addEventListener("onClick", evt -> Events.postEvent((String)"onClick", (Component)finalCell, (Object)indicatorLabel.getSclass()));
            }
            cell.setValign("middle");
            row.appendChild((Component)cell);
        }
        Boolean isActive = null;
        int colIndex = -1;
        Vbox vbox = null;
        int auxheadSize = this.gridPanel.getAuxheadSize();
        int sameLineColumnCounter = 0;
        int i = 0;
        while (i < columnCount) {
            WEditor editor;
            if (this.editors.get(gridPanelFields[i]) == null && (editor = WebEditorFactory.getEditor((GridField)gridPanelFields[i], (boolean)true)) != null) {
                WEditor readOnlyEditor;
                this.editors.put(gridPanelFields[i], editor);
                if (editor instanceof WButtonEditor) {
                    ((WButtonEditor)editor).addActionListener(this.buttonListener);
                }
                if ((readOnlyEditor = WebEditorFactory.getEditor((GridField)gridPanelFields[i], (boolean)true, (IEditorConfiguration)readOnlyEditorConfiguration)) != null) {
                    this.readOnlyEditors.put(gridPanelFields[i], readOnlyEditor);
                }
                if (editor.getComponent() instanceof AbstractComponent) {
                    editor.getComponent().setWidgetOverride("fieldHeader", HelpController.escapeJavascriptContent((String)gridPanelFields[i].getHeader()));
                    editor.getComponent().setWidgetOverride("fieldDescription", HelpController.escapeJavascriptContent((String)gridPanelFields[i].getDescription()));
                    editor.getComponent().setWidgetOverride("fieldHelp", HelpController.escapeJavascriptContent((String)gridPanelFields[i].getHelp()));
                    editor.getComponent().setWidgetListener("onFocus", "zWatch.fire('onFieldTooltip', this, null, this.fieldHeader(), this.fieldDescription(), this.fieldHelp());");
                    ((AbstractComponent)editor.getComponent()).addCallback("afterPageDetached", (Callback & Serializable)t -> ((AbstractComponent)t).setWidgetListener("onFocus", null));
                }
                if (this.defaultFocusField == null && gridPanelFields[i].isDefaultFocus()) {
                    this.defaultFocusField = editor;
                }
            }
            if ("IsActive".equals(gridPanelFields[i].getColumnName())) {
                isActive = Boolean.FALSE;
                if (this.currentValues[i] != null && "true".equalsIgnoreCase(this.currentValues[i].toString())) {
                    isActive = Boolean.TRUE;
                }
            }
            if (!(!this.isGridViewCustomized && gridPanelFields[i].isDisplayedGrid() || gridPanelFields[i].isToolbarOnlyButton())) {
                ++colIndex;
                Cell div = new Cell();
                String divStyle = "height: 100%; cursor: pointer; border: dotted 1px #dddddd;";
                Component component = this.getDisplayComponent(rowIndex, this.currentValues[i], gridPanelFields[i], this.isGridViewCustomized);
                div.appendChild(component);
                div.setAttribute(DISPLAY_COMPONENT_ATTR, (Object)component);
                if (20 == gridPanelFields[i].getDisplayType() || 32 == gridPanelFields[i].getDisplayType()) {
                    divStyle = "height: 100%; cursor: pointer; text-align:center; border: none;";
                } else if (DisplayType.isNumeric((int)gridPanelFields[i].getDisplayType())) {
                    divStyle = "height: 100%; cursor: pointer; text-align:right; border: dotted 1px #dddddd;";
                } else if (28 == gridPanelFields[i].getDisplayType()) {
                    divStyle = "height: 100%; cursor: pointer; border: none;";
                }
                GridRowCtx ctx = new GridRowCtx(Env.getCtx(), this.gridTab, rowIndex);
                component.setVisible(gridPanelFields[i].isDisplayed((Properties)ctx, true));
                div.setStyle(divStyle);
                ZKUpdateUtil.setWidth((HtmlBasedComponent)div, (String)"100%");
                div.setHeight("28px");
                div.setAttribute(COLUMN_NAME_ATTR, (Object)gridPanelFields[i].getColumnName());
                div.addEventListener("onClick", (EventListener)this.rowListener);
                if (!gridPanelFields[i].isSameLine() || sameLineColumnCounter == 0) {
                    vbox = new Vbox();
                    vbox.setWidth("100%");
                    vbox.addEventListener("onClick", (EventListener)this.rowListener);
                    vbox.appendChild((Component)div);
                    row.appendChild((Component)vbox);
                    sameLineColumnCounter = 1;
                } else if (sameLineColumnCounter <= auxheadSize) {
                    vbox.appendChild((Component)div);
                    row.appendChild((Component)vbox);
                    ++sameLineColumnCounter;
                } else {
                    vbox = new Vbox();
                    vbox.setWidth("100%");
                    vbox.addEventListener("onClick", (EventListener)this.rowListener);
                    vbox.appendChild((Component)div);
                    row.appendChild((Component)vbox);
                    sameLineColumnCounter = 1;
                }
            }
            ++i;
        }
        if (rowIndex == this.gridTab.getCurrentRow()) {
            this.setCurrentRow(row);
        }
        row.setStyle(ROW_STYLE);
        row.addEventListener("onClick", (EventListener)this.rowListener);
        row.addEventListener("onOK", (EventListener)this.rowListener);
        row.setTooltiptext(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"Row")) + " " + (rowIndex + 1));
        if (isActive == null && (isActiveValue = this.gridTab.getValue(rowIndex, "IsActive")) != null) {
            isActive = "true".equalsIgnoreCase(isActiveValue.toString()) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (isActive != null && !isActive.booleanValue()) {
            LayoutUtils.addSclass((String)"grid-inactive-row", (HtmlBasedComponent)row);
        }
        if (this.gridTab.isNew() && rowIndex == this.grid.getRows().getChildren().size() - 1) {
            this.grid.invalidate();
        }
        if (MSysConfig.getBooleanValue((String)"ZK_GRID_VIEW_USE_DEFER_RENDERING", (boolean)false, (int)Env.getAD_Client_ID((Properties)Env.getCtx()))) {
            row.setRenderdefer(1);
        }
    }

    public void setCurrentRow(Row row) {
        Cell cell;
        if (this.currentRow != null && this.currentRow.getParent() != null && this.currentRow != row && this.isShowCurrentRowIndicatorColumn() && (cell = (Cell)this.currentRow.getChildren().get(1)) != null) {
            cell.setStyle("background-color: transparent");
            cell.setSclass("row-indicator");
            if (cell.getFirstChild() != null) {
                ((Label)cell.getFirstChild()).setSclass("");
            }
        }
        this.currentRow = row;
        cell = (Cell)this.currentRow.getChildren().get(1);
        if (cell != null && this.isShowCurrentRowIndicatorColumn()) {
            if (ThemeManager.isUseFontIconForImage()) {
                Label indicatorLabel = (Label)cell.getFirstChild();
                indicatorLabel.setSclass("row-indicator-selected z-icon-Edit");
            } else {
                cell.setSclass("row-indicator-selected");
            }
        }
        this.currentRowIndex = this.gridTab.getCurrentRow();
        if (this.currentRowIndex == this.gridTab.getCurrentRow()) {
            if (this.editing) {
                this.stopEditing(false);
                this.editCurrentRow();
            }
        } else {
            this.currentRowIndex = this.gridTab.getCurrentRow();
            if (this.editing) {
                this.stopEditing(false);
            }
        }
        String script = "jq('#" + row.getUuid() + "').addClass('highlight').siblings().removeClass('highlight')";
        Boolean isActive = null;
        Object isActiveValue = this.gridTab.getValue(this.currentRowIndex, "IsActive");
        if (isActiveValue != null) {
            isActive = "true".equalsIgnoreCase(isActiveValue.toString()) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (isActive != null && !isActive.booleanValue()) {
            script = "jq('#" + row.getUuid() + "').addClass('grid-inactive-row').siblings().removeClass('highlight')";
        }
        Clients.response((AuResponse)new AuScript(script));
    }

    public Row getCurrentRow() {
        return this.currentRow;
    }

    public int getCurrentRowIndex() {
        return this.currentRowIndex;
    }

    public void editCurrentRow() {
        if (ClientInfo.isMobile() && !MSysConfig.getBooleanValue((String)"ZK_GRID_MOBILE_EDITABLE", (boolean)false)) {
            return;
        }
        if (this.currentRow != null && this.currentRow.getParent() != null && this.currentRow.isVisible() && this.grid != null && this.grid.isVisible() && this.grid.getParent() != null && this.grid.getParent().isVisible()) {
            GridField[] gridPanelFields = this.gridPanel.getFields();
            int columnCount = gridPanelFields.length;
            int colIndex = 1;
            int auxheadSize = this.gridPanel.getAuxheadSize();
            int sameLineColumnCounter = 0;
            int cellCounter = 0;
            int i = 0;
            while (i < columnCount) {
                if (gridPanelFields[i].isDisplayedGrid() && !gridPanelFields[i].isToolbarButton()) {
                    ++colIndex;
                    if (!gridPanelFields[i].isSameLine() || sameLineColumnCounter == 0) {
                        sameLineColumnCounter = 1;
                        cellCounter = 0;
                    } else if (sameLineColumnCounter <= auxheadSize) {
                        ++sameLineColumnCounter;
                        ++cellCounter;
                        --colIndex;
                    } else {
                        sameLineColumnCounter = 1;
                        cellCounter = 0;
                    }
                    if (this.editors.get(gridPanelFields[i]) == null) {
                        this.editors.put(gridPanelFields[i], WebEditorFactory.getEditor((GridField)gridPanelFields[i], (boolean)true));
                    }
                    Vbox vbox = (Vbox)this.currentRow.getChildren().get(colIndex);
                    Cell div = (Cell)vbox.getChildren().get(cellCounter);
                    WEditor editor = this.getEditorCell(gridPanelFields[i]);
                    if (div.getChildren().isEmpty() || !(div.getChildren().get(0) instanceof Button)) {
                        div.getChildren().clear();
                    } else if (!div.getChildren().isEmpty()) {
                        ((Component)div.getChildren().get(0)).setVisible(false);
                    }
                    div.appendChild(editor.getComponent());
                    WEditorPopupMenu popupMenu = editor.getPopupMenu();
                    if (popupMenu != null) {
                        popupMenu.addMenuListener((ContextMenuListener)editor);
                        div.appendChild((Component)popupMenu);
                        popupMenu.addContextElement((XulElement)editor.getComponent());
                    }
                    editor.setReadWrite(gridPanelFields[i].isEditableGrid(true));
                }
                ++i;
            }
            this.editing = true;
            GridTableListModel model = (GridTableListModel)this.grid.getModel();
            model.setEditing(true);
        }
    }

    public int getControls() {
        return 1;
    }

    public Component newCell(Row row) {
        return null;
    }

    public Row newRow(Grid grid) {
        return null;
    }

    public void doCatch(Throwable ex) throws Throwable {
    }

    public void doFinally() {
    }

    public void doTry() {
    }

    public void focusToFirstEditor() {
        if (this.currentRow != null && this.currentRow.getParent() != null) {
            WEditor toFocus = null;
            WEditor firstEditor = null;
            if (this.defaultFocusField != null && this.defaultFocusField.isVisible() && this.defaultFocusField.isReadWrite() && this.defaultFocusField.getComponent().getParent() != null && !(this.defaultFocusField instanceof WImageEditor)) {
                toFocus = this.defaultFocusField;
            } else {
                for (WEditor editor : this.getEditors()) {
                    if (!editor.isVisible() || editor.getComponent().getParent() == null) continue;
                    if (editor.isReadWrite()) {
                        toFocus = editor;
                        break;
                    }
                    if (firstEditor != null) continue;
                    firstEditor = editor;
                }
            }
            if (toFocus != null) {
                this.focusToEditor(toFocus);
            } else if (firstEditor != null) {
                this.focusToEditor(firstEditor);
            }
        }
    }

    protected void focusToEditor(WEditor toFocus) {
        Component c = toFocus.getComponent();
        if (c instanceof EditorBox) {
            c = ((EditorBox)c).getTextbox();
        } else if (c instanceof NumberBox) {
            c = ((NumberBox)c).getDecimalbox();
        } else if (c instanceof Urlbox) {
            c = ((Urlbox)c).getTextbox();
        }
        ((HtmlBasedComponent)c).focus();
    }

    public void focusToNextEditor(WEditor ref) {
        boolean found = false;
        for (WEditor editor : this.getEditors()) {
            if (editor == ref) {
                found = true;
                continue;
            }
            if (!found || !editor.isVisible() || !editor.isReadWrite()) continue;
            this.focusToEditor(editor);
            break;
        }
    }

    public void setGridPanel(JPiereGridView gridPanel) {
        this.gridPanel = gridPanel;
    }

    public boolean isEditing() {
        return this.editing;
    }

    public void setADWindowPanel(JPiereAbstractADWindowContent windowPanel) {
        if (this.m_windowPanel == windowPanel) {
            return;
        }
        this.m_windowPanel = windowPanel;
        this.buttonListener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                WButtonEditor editor = (WButtonEditor)event.getSource();
                Integer rowIndex = (Integer)editor.getComponent().getAttribute(JPiereGridTabRowRenderer.GRID_ROW_INDEX_ATTR);
                if (rowIndex != null) {
                    int newRowIndex = JPiereGridTabRowRenderer.this.gridTab.navigate(rowIndex.intValue());
                    if (newRowIndex == rowIndex) {
                        JPiereGridTabRowRenderer.this.m_windowPanel.actionPerformed(event);
                    }
                } else {
                    JPiereGridTabRowRenderer.this.m_windowPanel.actionPerformed(event);
                }
            }
        };
    }

    public void onEvent(Event event) throws Exception {
        if (event.getTarget() instanceof Cell) {
            Cell cell = (Cell)event.getTarget();
            if (cell.getSclass() != null && cell.getSclass().indexOf("row-indicator-selected") >= 0) {
                Events.sendEvent((Component)this.gridPanel, (Event)new Event("onEdit", (Component)this.gridPanel));
            } else if (event.getData() != null && event.getData().toString().indexOf("row-indicator-selected") >= 0) {
                Events.sendEvent((Component)this.gridPanel, (Event)new Event("onEdit", (Component)this.gridPanel));
            } else {
                Events.sendEvent((Component)event.getTarget().getParent(), (Event)event);
            }
        } else if (event.getTarget() instanceof Checkbox) {
            Executions.getCurrent().setAttribute(GRID_VIEW_ON_SELECT_ROW_ATTR, (Object)Boolean.TRUE);
            Checkbox checkBox = (Checkbox)event.getTarget();
            Events.sendEvent((Component)this.gridPanel, (Event)new Event("onSelectRow", (Component)this.gridPanel, (Object)checkBox));
        }
    }

    private boolean isShowCurrentRowIndicatorColumn() {
        return this.gridPanel != null && this.gridPanel.isShowCurrentRowIndicatorColumn();
    }

    static class RowListener
    implements EventListener<Event> {
        private Grid _grid;

        public RowListener(Grid grid) {
            this._grid = grid;
        }

        public void onEvent(Event event) throws Exception {
            if ("onClick".equals(event.getName())) {
                if (Executions.getCurrent().getAttribute(JPiereGridTabRowRenderer.GRID_VIEW_ON_SELECT_ROW_ATTR) != null) {
                    return;
                }
                Event evt = new Event("onClick", (Component)this._grid, (Object)event.getTarget());
                Events.sendEvent((Component)this._grid, (Event)evt);
                evt.stopPropagation();
            } else if ("onDoubleClick".equals(event.getName())) {
                Event evt = new Event("onDoubleClick", (Component)this._grid, (Object)this._grid);
                Events.sendEvent((Component)this._grid, (Event)evt);
            } else if ("onOK".equals(event.getName())) {
                Event evt = new Event("onOK", (Component)this._grid, (Object)this._grid);
                Events.sendEvent((Component)this._grid, (Event)evt);
            }
        }
    }
}

