/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.webui.adwindow;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import jpiere.plugin.webui.adwindow.JPiereADWindow;
import jpiere.plugin.webui.adwindow.JPiereAbstractADWindowContent;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.adwindow.BreadCrumbLink;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Menupopup;
import org.adempiere.webui.component.ToolBar;
import org.adempiere.webui.component.ToolBarButton;
import org.adempiere.webui.component.ZkCssHelper;
import org.adempiere.webui.event.ToolbarListener;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.window.WRecordInfo;
import org.compiere.model.DataStatusEvent;
import org.compiere.model.GridTab;
import org.compiere.model.MRole;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.KeyEvent;
import org.zkoss.zk.ui.util.Callback;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Div;
import org.zkoss.zul.Hlayout;
import org.zkoss.zul.Menuitem;

public class JPiereBreadCrumb
extends Div
implements EventListener<Event> {
    private static final String ON_MOUSE_OVER_ECHO_EVENT = "onMouseOverEcho";
    private static final String ON_MOUSE_OUT_ECHO_EVENT = "onMouseOutEcho";
    private static final long serialVersionUID = 929253935475618911L;
    private static final String BTNPREFIX = "Btn";
    private Hlayout layout;
    private ToolBarButton btnFirst;
    private ToolBarButton btnPrevious;
    private ToolBarButton btnNext;
    private ToolBarButton btnLast;
    private ToolBarButton btnRecordInfo;
    private LinkedHashMap<String, String> links;
    private int windowNo;
    private HashMap<String, ToolBarButton> buttons = new HashMap();
    private DataStatusEvent m_dse;
    private String m_text;
    private ToolbarListener toolbarListener;
    private Hlayout toolbarContainer;
    protected Menupopup linkPopup;
    private GridTab m_gridTab;
    private JPiereAbstractADWindowContent windowContent;

    public JPiereBreadCrumb(JPiereAbstractADWindowContent windowContent, int windowNo) {
        this.windowContent = windowContent;
        this.windowNo = windowNo;
        this.layout = new Hlayout();
        this.layout.setValign("middle");
        this.appendChild((Component)this.layout);
        this.layout.setSclass("adwindow-breadcrumb-paths");
        this.setVisible(false);
        this.setSclass("adwindow-breadcrumb");
        this.toolbarContainer = new Hlayout();
        this.toolbarContainer.setSclass("adwindow-breadcrumb-toolbar");
        this.appendChild((Component)this.toolbarContainer);
        ToolBar toolbar = new ToolBar();
        this.toolbarContainer.appendChild((Component)toolbar);
        this.btnFirst = this.createButton("First", "First", "First");
        this.btnFirst.setTooltiptext(String.valueOf(this.btnFirst.getTooltiptext()) + "    Alt+Home");
        toolbar.appendChild((Component)this.btnFirst);
        this.btnPrevious = this.createButton("Previous", "Previous", "Previous");
        this.btnPrevious.setTooltiptext(String.valueOf(this.btnPrevious.getTooltiptext()) + "    Alt+Left");
        toolbar.appendChild((Component)this.btnPrevious);
        this.btnRecordInfo = new ToolBarButton();
        this.btnRecordInfo.setLabel("");
        this.btnRecordInfo.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Who")));
        this.btnRecordInfo.addEventListener("onClick", (EventListener)this);
        this.btnRecordInfo.setSclass("breadcrumb-record-info link");
        this.btnRecordInfo.setId("recordInfo");
        toolbar.appendChild((Component)this.btnRecordInfo);
        this.btnNext = this.createButton("Next", "Next", "Next");
        this.btnNext.setTooltiptext(String.valueOf(this.btnNext.getTooltiptext()) + "    Alt+Right");
        toolbar.appendChild((Component)this.btnNext);
        this.btnLast = this.createButton("Last", "Last", "Last");
        this.btnLast.setTooltiptext(String.valueOf(this.btnLast.getTooltiptext()) + "    Alt+End");
        toolbar.appendChild((Component)this.btnLast);
        this.setWidgetAttribute("instanceName", "breadcrumb");
        this.addEventListener(ON_MOUSE_OUT_ECHO_EVENT, this);
    }

    public void setToolbarListener(ToolbarListener listener) {
        this.toolbarListener = listener;
    }

    public void addPath(String label, String id, boolean clickable) {
        if (clickable) {
            BreadCrumbLink a = new BreadCrumbLink();
            a.setLabel(label);
            a.setId("breadcrumb-" + id + "-" + label);
            a.setPathId(id);
            a.addEventListener("onClick", (EventListener)this);
            if (this.layout.getChildren().size() > 0) {
                Label symbol = new Label();
                symbol.setValue(" > ");
                this.layout.appendChild((Component)symbol);
            }
            this.layout.appendChild((Component)a);
        } else {
            Label pathLabel = new Label();
            pathLabel.setId("breadcrumb-" + id + "-" + label);
            pathLabel.setValue(label);
            if (this.layout.getChildren().size() > 0) {
                Label symbol = new Label();
                symbol.setValue(" > ");
                this.layout.appendChild((Component)symbol);
            }
            pathLabel.setStyle("font-weight: bold");
            this.layout.appendChild((Component)pathLabel);
        }
    }

    public List<BreadCrumbLink> getParentLinks() {
        ArrayList<BreadCrumbLink> parents = new ArrayList<BreadCrumbLink>();
        for (Component component : this.layout.getChildren()) {
            if (!(component instanceof BreadCrumbLink)) continue;
            parents.add((BreadCrumbLink)component);
        }
        return parents;
    }

    public void addLinks(LinkedHashMap<String, String> links) {
        this.links = links;
        final Label pathLabel = (Label)this.layout.getChildren().get(this.layout.getChildren().size() - 1);
        pathLabel.setStyle("cursor: pointer; font-weight: bold; padding-right: 10px;");
        EventListener<Event> listener = new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                if (JPiereBreadCrumb.this.linkPopup != null && JPiereBreadCrumb.this.linkPopup.getPage() != null && JPiereBreadCrumb.this.linkPopup.isVisible()) {
                    if (event.getName().equals("onMouseOut")) {
                        JPiereBreadCrumb.this.linkPopup.setAttribute(JPiereBreadCrumb.ON_MOUSE_OUT_ECHO_EVENT, (Object)Boolean.TRUE);
                        StringBuilder script = new StringBuilder("setTimeout(function(){let w=zk('#").append(JPiereBreadCrumb.this.getUuid()).append("').$();").append("let e=new zk.Event(w, '").append(JPiereBreadCrumb.ON_MOUSE_OUT_ECHO_EVENT).append("', null, {toServer:true});").append("zAu.send(e);},500)");
                        AuScript response = new AuScript(script.toString());
                        Clients.response((AuResponse)response);
                    }
                    return;
                }
                if (event.getName().equals("onClick")) {
                    if (JPiereBreadCrumb.this.linkPopup != null && JPiereBreadCrumb.this.linkPopup.getPage() != null) {
                        JPiereBreadCrumb.this.linkPopup.detach();
                    }
                    JPiereBreadCrumb.this.linkPopup = new Menupopup();
                    this.showLinksMenu(pathLabel);
                } else if (event.getName().equals("onMouseOver")) {
                    if (JPiereBreadCrumb.this.linkPopup == null || !JPiereBreadCrumb.this.linkPopup.isVisible()) {
                        if (JPiereBreadCrumb.this.linkPopup != null && JPiereBreadCrumb.this.linkPopup.getPage() != null) {
                            JPiereBreadCrumb.this.linkPopup.detach();
                        }
                        JPiereBreadCrumb.this.linkPopup = new Menupopup();
                        StringBuilder script = new StringBuilder("setTimeout(function(){let w=zk('#").append(event.getTarget().getUuid()).append("').$();").append("let e=new zk.Event(w, '").append(JPiereBreadCrumb.ON_MOUSE_OVER_ECHO_EVENT).append("', null, {toServer:true});").append("zAu.send(e);},500)");
                        AuScript response = new AuScript(script.toString());
                        Clients.response((AuResponse)response);
                    }
                } else if (event.getName().equals("onMouseOut")) {
                    if (JPiereBreadCrumb.this.linkPopup != null && JPiereBreadCrumb.this.linkPopup.getPage() == null) {
                        JPiereBreadCrumb.this.linkPopup = null;
                    }
                } else if (event.getName().equals(JPiereBreadCrumb.ON_MOUSE_OVER_ECHO_EVENT) && JPiereBreadCrumb.this.linkPopup != null && JPiereBreadCrumb.this.linkPopup.getPage() == null) {
                    this.showLinksMenu(pathLabel);
                }
            }

            private void showLinksMenu(Label pathLabel2) {
                for (Map.Entry<String, String> entry : JPiereBreadCrumb.this.links.entrySet()) {
                    Menuitem item = new Menuitem();
                    item.setLabel(entry.getValue());
                    item.setValue(entry.getKey());
                    item.addEventListener("onClick", (EventListener)JPiereBreadCrumb.this);
                    JPiereBreadCrumb.this.linkPopup.appendChild((Component)item);
                }
                StringBuilder script = new StringBuilder("setTimeout(function(){let w=zk('#").append(JPiereBreadCrumb.this.getUuid()).append("').$();").append("let e=new zk.Event(w, '").append(JPiereBreadCrumb.ON_MOUSE_OUT_ECHO_EVENT).append("', null, {toServer:true});").append("zAu.send(e);},500)");
                final AuScript response = new AuScript(script.toString());
                JPiereBreadCrumb.this.linkPopup.addEventListener("onMouseOut", (EventListener)new EventListener<Event>(){

                    public void onEvent(Event event) throws Exception {
                        if ((this).JPiereBreadCrumb.this.linkPopup != null) {
                            (this).JPiereBreadCrumb.this.linkPopup.setAttribute(JPiereBreadCrumb.ON_MOUSE_OUT_ECHO_EVENT, (Object)Boolean.TRUE);
                            Clients.response((AuResponse)response);
                        }
                    }
                });
                JPiereBreadCrumb.this.linkPopup.addEventListener("onMouseOver", (EventListener)new EventListener<Event>(){

                    public void onEvent(Event event) throws Exception {
                        if ((this).JPiereBreadCrumb.this.linkPopup != null && (this).JPiereBreadCrumb.this.linkPopup.isVisible()) {
                            (this).JPiereBreadCrumb.this.linkPopup.removeAttribute(JPiereBreadCrumb.ON_MOUSE_OUT_ECHO_EVENT);
                        }
                    }
                });
                JPiereBreadCrumb.this.linkPopup.setPage(pathLabel2.getPage());
                JPiereBreadCrumb.this.linkPopup.open((Component)pathLabel2, "after_start");
            }
        };
        pathLabel.addEventListener("onClick", (EventListener)listener);
        pathLabel.addEventListener("onMouseOver", (EventListener)listener);
        pathLabel.addEventListener("onMouseOut", (EventListener)listener);
        pathLabel.addEventListener(ON_MOUSE_OVER_ECHO_EVENT, (EventListener)listener);
        if (ThemeManager.isUseFontIconForImage()) {
            pathLabel.setSclass("adwindow-breadcrumb-menu");
        } else {
            String imageUrl = Executions.getCurrent().encodeURL(ThemeManager.getThemeResource((String)"images/downarrow.png"));
            ZkCssHelper.appendStyle((HtmlBasedComponent)pathLabel, (String)("background: transparent url('" + imageUrl + "') no-repeat right center"));
        }
    }

    public void onEvent(Event event) throws Exception {
        if (event.getTarget() == this.btnRecordInfo) {
            if (this.m_dse == null || this.m_dse.CreatedBy == null || !MRole.getDefault().isShowPreference()) {
                return;
            }
            String title = String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"Who")) + this.m_text;
            WRecordInfo winfo = new WRecordInfo(title, this.m_dse, this.m_gridTab);
            winfo.addCallback("afterPageDetached", (Callback & Serializable)t -> {
                JPiereADWindow adwindow = JPiereADWindow.findADWindow((Component)this);
                if (adwindow != null) {
                    adwindow.getJPiereADWindowContent().focusToLastFocusEditor();
                }
            });
        } else if (event.getTarget() == this.btnFirst) {
            if (this.toolbarListener != null) {
                this.toolbarListener.onFirst();
            }
        } else if (event.getTarget() == this.btnPrevious) {
            if (this.toolbarListener != null) {
                this.toolbarListener.onPrevious();
            }
        } else if (event.getTarget() == this.btnNext) {
            if (this.toolbarListener != null) {
                this.toolbarListener.onNext();
            }
        } else if (event.getTarget() == this.btnLast) {
            if (this.toolbarListener != null) {
                this.toolbarListener.onLast();
            }
        } else if (event.getName().equals(ON_MOUSE_OUT_ECHO_EVENT)) {
            if (this.linkPopup != null && this.linkPopup.getPage() != null && this.linkPopup.isVisible() && this.linkPopup.getAttribute(ON_MOUSE_OUT_ECHO_EVENT) != null) {
                this.linkPopup.detach();
                this.linkPopup = null;
            }
        } else if (event.getName().equals("onCtrlKey")) {
            if (!LayoutUtils.isReallyVisible((Component)this)) {
                return;
            }
            if (this.windowContent != null && this.windowContent.getOpenQuickFormTabs().size() > 0) {
                return;
            }
            if (this.windowContent != null && this.windowContent.isBlock()) {
                return;
            }
            KeyEvent keyEvent = (KeyEvent)event;
            if (keyEvent.isAltKey()) {
                if (keyEvent.getKeyCode() == 37) {
                    if (this.toolbarListener != null) {
                        this.toolbarListener.onPrevious();
                    }
                } else if (keyEvent.getKeyCode() == 39) {
                    if (this.toolbarListener != null) {
                        this.toolbarListener.onNext();
                    }
                } else if (keyEvent.getKeyCode() == 36) {
                    if (this.toolbarListener != null) {
                        this.toolbarListener.onFirst();
                    }
                } else if (keyEvent.getKeyCode() == 35 && this.toolbarListener != null) {
                    this.toolbarListener.onLast();
                }
            }
        } else {
            Events.sendEvent((Component)this, (Event)event);
        }
    }

    public void reset() {
        this.layout.getChildren().clear();
        this.links = null;
    }

    public void enableFirstNavigation(boolean enabled) {
        this.btnFirst.setDisabled(!enabled);
        this.btnPrevious.setDisabled(!enabled);
    }

    public void enableLastNavigation(boolean enabled) {
        this.btnLast.setDisabled(!enabled);
        this.btnNext.setDisabled(!enabled);
    }

    private ToolBarButton createButton(String name, String image, String tooltip) {
        ToolBarButton btn = new ToolBarButton("");
        btn.setName(BTNPREFIX + name);
        btn.setId(name);
        Executions.createComponents((String)ThemeManager.getPreference(), (Component)this, null);
        String size = Env.getContext((Properties)Env.getCtx(), (String)"#ZK_Toolbar_Button_Size");
        String suffix = "24.png";
        if (!Util.isEmpty((String)size)) {
            suffix = String.valueOf(size) + ".png";
        }
        if (ThemeManager.isUseFontIconForImage()) {
            btn.setIconSclass("z-icon-" + image + "Record");
        } else {
            btn.setImage(ThemeManager.getThemeResource((String)("images/" + image + suffix)));
        }
        btn.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)tooltip));
        btn.setSclass("breadcrumb-toolbar-button");
        this.buttons.put(name, btn);
        this.appendChild((Component)btn);
        btn.setTabindex(0);
        btn.addEventListener("onClick", (EventListener)this);
        btn.setDisabled(true);
        return btn;
    }

    public void setStatusDB(String text) {
        this.setStatusDB(text, null, null);
    }

    public void setStatusDB(String text, DataStatusEvent dse, GridTab gridTab) {
        if (text == null || text.length() == 0) {
            this.btnRecordInfo.setLabel("");
        } else {
            if (text.indexOf("-1/0") >= 0) {
                text = text.replace("-1/0", "0/0");
            }
            this.btnRecordInfo.setLabel(text);
        }
        this.m_text = text;
        this.m_dse = dse;
        if (this.m_dse != null) {
            this.enableFirstNavigation(this.m_dse.getCurrentRow() > 0);
            this.enableLastNavigation(this.m_dse.getTotalRows() > this.m_dse.getCurrentRow() + 1);
        }
        this.m_gridTab = gridTab;
    }

    public void onPageDetached(Page page) {
        super.onPageDetached(page);
        if (this.linkPopup != null) {
            this.linkPopup.detach();
        }
        try {
            SessionManager.getSessionApplication().getKeylistener().removeEventListener("onCtrlKey", (EventListener)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setNavigationToolbarVisibility(boolean visible) {
        this.toolbarContainer.setVisible(visible);
    }

    public boolean hasParentLink() {
        for (Component c : this.layout.getChildren()) {
            if (!(c instanceof BreadCrumbLink)) continue;
            return true;
        }
        return false;
    }

    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        if (newpage != null) {
            SessionManager.getSessionApplication().getKeylistener().addEventListener("onCtrlKey", (EventListener)this);
        }
    }

    public boolean isPreviousEnabled() {
        return !this.btnPrevious.isDisabled();
    }

    public boolean isNextEnabled() {
        return !this.btnNext.isDisabled();
    }

    public ToolBarButton getNextButton() {
        return this.btnNext;
    }

    public ToolBarButton getPreviousButton() {
        return this.btnPrevious;
    }

    public boolean isEmpty() {
        return this.layout == null || this.layout.getChildren().isEmpty();
    }
}

