/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.process;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.IArchiveStore;
import org.compiere.model.IAttachmentStore;
import org.compiere.model.IImageStore;
import org.compiere.model.MArchive;
import org.compiere.model.MAttachment;
import org.compiere.model.MAttachmentEntry;
import org.compiere.model.MClient;
import org.compiere.model.MClientInfo;
import org.compiere.model.MImage;
import org.compiere.model.MProcessPara;
import org.compiere.model.MStorageProvider;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CacheMgt;

@Process
public class MigrateStorageProvider
extends SvrProcess {
    private int p_AD_Client_ID = -1;
    private int p_Actual_StorageProvider_ID = 0;
    private int p_AD_StorageProvider_ID = -1;
    private boolean p_IsMigrateAttachment = false;
    private boolean p_IsMigrateArchive = false;
    private boolean p_IsMigrateImage = false;
    private boolean p_IsMigrateData = true;
    private int p_IDFrom = 0;
    private int p_IDTo = 0;
    private boolean p_DeleteOld = false;
    int cntAttachment = 0;
    int cntArchive = 0;
    int cntImage = 0;

    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        int n = processInfoParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessInfoParameter para = processInfoParameterArray[n2];
            String name = para.getParameterName();
            if ("AD_AllClients_V_ID".equals(name)) {
                if (para.getParameter() != null) {
                    this.p_AD_Client_ID = para.getParameterAsInt();
                }
            } else if ("Actual_StorageProvider_ID".equals(name)) {
                this.p_Actual_StorageProvider_ID = para.getParameterAsInt();
            } else if ("AD_StorageProvider_ID".equals(name)) {
                this.p_AD_StorageProvider_ID = para.getParameterAsInt();
            } else if ("IsMigrateAttachment".equals(name)) {
                this.p_IsMigrateAttachment = para.getParameterAsBoolean();
            } else if ("IsMigrateArchive".equals(name)) {
                this.p_IsMigrateArchive = para.getParameterAsBoolean();
            } else if ("IsMigrateImage".equals(name)) {
                this.p_IsMigrateImage = para.getParameterAsBoolean();
            } else if ("IsMigrateData".equals(name)) {
                this.p_IsMigrateData = para.getParameterAsBoolean();
            } else if ("Record_ID".equals(name)) {
                this.p_IDFrom = para.getParameterAsInt();
                this.p_IDTo = para.getParameter_ToAsInt();
            } else if ("DeleteOld".equals(name)) {
                this.p_DeleteOld = para.getParameterAsBoolean();
            } else {
                MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para);
            }
            ++n2;
        }
    }

    protected String doIt() throws Exception {
        int[] clientsToUpdate;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("AD_AllClients_V_ID" + this.p_AD_Client_ID + ", Actual_StorageProvider_ID=" + this.p_Actual_StorageProvider_ID + ", AD_StorageProvider_ID=" + this.p_AD_StorageProvider_ID + ", IsMigrateAttachment=" + this.p_IsMigrateAttachment + ", IsMigrateArchive=" + this.p_IsMigrateArchive + ", IsMigrateImage=" + this.p_IsMigrateImage + ", IsMigrateData=" + this.p_IsMigrateData + ", IDFrom=" + this.p_IDFrom + ", IDTo=" + this.p_IDTo + ", DeleteOld=" + this.p_DeleteOld);
        }
        if (!(this.p_IsMigrateAttachment || this.p_IsMigrateArchive || this.p_IsMigrateImage)) {
            return "Nothing to migrate, please select an option";
        }
        MStorageProvider newProvider = MStorageProvider.get((Properties)this.getCtx(), (int)this.p_AD_StorageProvider_ID);
        if (this.p_AD_Client_ID >= 0) {
            clientsToUpdate = new int[]{this.p_AD_Client_ID};
            this.p_Actual_StorageProvider_ID = 0;
        } else {
            StringBuilder whereClause = new StringBuilder();
            StringBuilder storageClause = new StringBuilder();
            if (this.p_Actual_StorageProvider_ID > 0) {
                storageClause.append("=").append(this.p_Actual_StorageProvider_ID);
            } else {
                storageClause.append(" IS NULL");
            }
            if (this.p_IsMigrateAttachment) {
                whereClause.append("AD_StorageProvider_ID").append((CharSequence)storageClause);
            }
            if (this.p_IsMigrateArchive) {
                if (whereClause.length() > 0) {
                    whereClause.append(" OR ");
                }
                whereClause.append("StorageArchive_ID").append((CharSequence)storageClause);
            }
            if (this.p_IsMigrateImage) {
                if (whereClause.length() > 0) {
                    whereClause.append(" OR ");
                }
                whereClause.append("StorageImage_ID").append((CharSequence)storageClause);
            }
            clientsToUpdate = new Query(this.getCtx(), "AD_ClientInfo", whereClause.toString(), this.get_TrxName()).setOrderBy("AD_Client_ID").getIDs();
        }
        int[] nArray = clientsToUpdate;
        int n = clientsToUpdate.length;
        int storageClause = 0;
        while (storageClause < n) {
            String msg;
            int clientid = nArray[storageClause];
            MClientInfo clientInfo = MClientInfo.getCopy((Properties)this.getCtx(), (int)clientid, null);
            MClient client = MClient.get((Properties)this.getCtx(), (int)clientid);
            if (this.p_IsMigrateAttachment && clientInfo.getAD_StorageProvider_ID() != this.p_AD_StorageProvider_ID) {
                clientInfo.setAD_StorageProvider_ID(this.p_AD_StorageProvider_ID);
                clientInfo.saveEx();
                msg = "Attachment provider set to " + newProvider.getName() + " on " + client.getName();
                this.addLog(msg);
            }
            if (this.p_IsMigrateArchive && clientInfo.getStorageArchive_ID() != this.p_AD_StorageProvider_ID) {
                clientInfo.setStorageArchive_ID(this.p_AD_StorageProvider_ID);
                clientInfo.saveEx();
                msg = "Archive provider set to " + newProvider.getName() + " on " + client.getName();
                this.addLog(msg);
            }
            if (this.p_IsMigrateImage && clientInfo.getStorageImage_ID() != this.p_AD_StorageProvider_ID) {
                clientInfo.setStorageImage_ID(this.p_AD_StorageProvider_ID);
                clientInfo.saveEx();
                msg = "Image provider set to " + newProvider.getName() + " on " + client.getName();
                this.addLog(msg);
            }
            ++storageClause;
        }
        this.commitEx();
        CacheMgt.get().reset("AD_ClientInfo");
        if (this.p_IsMigrateData) {
            int[] clientsToMigrate;
            if (this.p_AD_Client_ID >= 0) {
                clientsToMigrate = new int[]{this.p_AD_Client_ID};
            } else {
                String whereMigrate = "(AD_StorageProvider_ID=? OR StorageArchive_ID=? OR StorageImage_ID=?)";
                clientsToMigrate = new Query(this.getCtx(), "AD_ClientInfo", "(AD_StorageProvider_ID=? OR StorageArchive_ID=? OR StorageImage_ID=?)", this.get_TrxName()).setOrderBy("AD_Client_ID").setParameters(new Object[]{this.p_AD_StorageProvider_ID, this.p_AD_StorageProvider_ID, this.p_AD_StorageProvider_ID}).getIDs();
            }
            int idxClient = 0;
            int totalClients = clientsToMigrate.length;
            int[] nArray2 = clientsToMigrate;
            int n2 = clientsToMigrate.length;
            int n3 = 0;
            while (n3 < n2) {
                int clientid = nArray2[n3];
                ++idxClient;
                MClient client = MClient.get((Properties)this.getCtx(), (int)clientid);
                int odometer = 10;
                if (this.p_IsMigrateAttachment) {
                    this.migrateAttachments(newProvider, idxClient, totalClients, clientid, client, odometer);
                }
                if (this.p_IsMigrateArchive) {
                    this.migrateArchives(newProvider, idxClient, totalClients, clientid, client, odometer);
                }
                if (this.p_IsMigrateImage) {
                    this.migrateImages(newProvider, idxClient, totalClients, clientid, client, odometer);
                }
                ++n3;
            }
        }
        return "@Updated@ " + this.cntAttachment + " @AD_Attachment_ID@, " + this.cntArchive + " @AD_Archive_ID@, " + this.cntImage + " @AD_Image_ID@";
    }

    private void migrateAttachments(MStorageProvider newProvider, int idxClient, int totalClients, int clientid, MClient client, int odometer) throws SQLException {
        this.status(idxClient, totalClients, "Migrating attachments for " + client.getName());
        String where = "AD_Client_ID=? AND (?=0 OR AD_Attachment_ID>=?) AND (?=0 OR AD_Attachment_ID<=?) AND COALESCE(AD_StorageProvider_ID,0)!=?";
        int[] attachIds = new Query(this.getCtx(), "AD_Attachment", "AD_Client_ID=? AND (?=0 OR AD_Attachment_ID>=?) AND (?=0 OR AD_Attachment_ID<=?) AND COALESCE(AD_StorageProvider_ID,0)!=?", this.get_TrxName()).setParameters(new Object[]{clientid, this.p_IDFrom, this.p_IDFrom, this.p_IDTo, this.p_IDTo, this.p_AD_StorageProvider_ID}).setOrderBy("AD_Attachment_ID").getIDs();
        int cntRecords = attachIds.length;
        int idxAttach = 0;
        int[] nArray = attachIds;
        int n = attachIds.length;
        int n2 = 0;
        while (n2 < n) {
            int attachId = nArray[n2];
            if (++idxAttach % odometer == 0) {
                this.progress(idxClient, totalClients, idxAttach, cntRecords, "Migrating attachment ");
            }
            MAttachment attachment = new MAttachment(this.getCtx(), attachId, this.get_TrxName());
            int oldProviderId = attachment.getAD_StorageProvider_ID();
            MAttachmentEntry[] mAttachmentEntryArray = attachment.getEntries();
            int n3 = mAttachmentEntryArray.length;
            int n4 = 0;
            while (n4 < n3) {
                MAttachmentEntry entry = mAttachmentEntryArray[n4];
                entry.getData();
                ++n4;
            }
            attachment.setStorageProvider(newProvider);
            attachment.set_ValueNoCheck("Updated", (Object)new Timestamp(System.currentTimeMillis()));
            attachment.saveEx();
            ++this.cntAttachment;
            this.commitEx();
            if (this.p_DeleteOld) {
                MStorageProvider oldProvider = MStorageProvider.get((Properties)this.getCtx(), (int)oldProviderId);
                if (oldProviderId != 0 && !"DB".equals(oldProvider.getMethod())) {
                    IAttachmentStore oldStore = oldProvider.getAttachmentStore();
                    oldStore.delete(attachment, oldProvider);
                    this.commitEx();
                }
            }
            ++n2;
        }
        String msg = "Migrated " + cntRecords + " attachments on " + client.getName();
        this.addLog(msg);
    }

    private void migrateArchives(MStorageProvider newProvider, int idxClient, int totalClients, int clientid, MClient client, int odometer) throws SQLException {
        this.status(idxClient, totalClients, "Migrating archives for " + client.getName());
        String where = "AD_Client_ID=? AND (?=0 OR AD_Archive_ID>=?) AND (?=0 OR AD_Archive_ID<=?) AND COALESCE(AD_StorageProvider_ID,0)!=?";
        int[] archiveIds = new Query(this.getCtx(), "AD_Archive", "AD_Client_ID=? AND (?=0 OR AD_Archive_ID>=?) AND (?=0 OR AD_Archive_ID<=?) AND COALESCE(AD_StorageProvider_ID,0)!=?", this.get_TrxName()).setParameters(new Object[]{clientid, this.p_IDFrom, this.p_IDFrom, this.p_IDTo, this.p_IDTo, this.p_AD_StorageProvider_ID}).setOrderBy("AD_Archive_ID").getIDs();
        int cntRecords = archiveIds.length;
        int idxArchive = 0;
        int[] nArray = archiveIds;
        int n = archiveIds.length;
        int n2 = 0;
        while (n2 < n) {
            int archiveId = nArray[n2];
            if (++idxArchive % odometer == 0) {
                this.progress(idxClient, totalClients, idxArchive, cntRecords, "Migrating archive ");
            }
            MArchive archive = new MArchive(this.getCtx(), archiveId, this.get_TrxName());
            int oldProviderId = archive.getAD_StorageProvider_ID();
            byte[] data = archive.getBinaryData();
            archive.setStorageProvider(newProvider);
            archive.setBinaryData(data);
            archive.set_ValueNoCheck("Updated", (Object)new Timestamp(System.currentTimeMillis()));
            archive.saveEx();
            ++this.cntArchive;
            this.commitEx();
            if (this.p_DeleteOld) {
                MStorageProvider oldProvider = MStorageProvider.get((Properties)this.getCtx(), (int)oldProviderId);
                if (oldProviderId != 0 && !"DB".equals(oldProvider.getMethod())) {
                    IArchiveStore oldStore = oldProvider.getArchiveStore();
                    oldStore.deleteArchive(archive, oldProvider);
                    this.commitEx();
                }
            }
            ++n2;
        }
        String msg = "Migrated " + cntRecords + " archives on " + client.getName();
        this.addLog(msg);
    }

    private void migrateImages(MStorageProvider newProvider, int idxClient, int totalClients, int clientid, MClient client, int odometer) throws SQLException {
        this.status(idxClient, totalClients, "Migrating images for " + client.getName());
        String where = "AD_Client_ID=? AND (?=0 OR AD_Image_ID>=?) AND (?=0 OR AD_Image_ID<=?) AND COALESCE(AD_StorageProvider_ID,0)!=?";
        int[] imageIds = new Query(this.getCtx(), "AD_Image", "AD_Client_ID=? AND (?=0 OR AD_Image_ID>=?) AND (?=0 OR AD_Image_ID<=?) AND COALESCE(AD_StorageProvider_ID,0)!=?", this.get_TrxName()).setParameters(new Object[]{clientid, this.p_IDFrom, this.p_IDFrom, this.p_IDTo, this.p_IDTo, this.p_AD_StorageProvider_ID}).setOrderBy("AD_Image_ID").getIDs();
        int cntRecords = imageIds.length;
        int idxImage = 0;
        int[] nArray = imageIds;
        int n = imageIds.length;
        int n2 = 0;
        while (n2 < n) {
            int imageId = nArray[n2];
            if (++idxImage % odometer == 0) {
                this.progress(idxClient, totalClients, idxImage, cntRecords, "Migrating image ");
            }
            MImage image = new MImage(this.getCtx(), imageId, this.get_TrxName());
            int oldProviderId = image.getAD_StorageProvider_ID();
            byte[] data = image.getBinaryData();
            image.setStorageProvider(newProvider);
            image.setBinaryData(data);
            image.set_ValueNoCheck("Updated", (Object)new Timestamp(System.currentTimeMillis()));
            image.saveEx();
            this.commitEx();
            if (this.p_DeleteOld) {
                MStorageProvider oldProvider = MStorageProvider.get((Properties)this.getCtx(), (int)oldProviderId);
                if (oldProviderId != 0 && !"DB".equals(oldProvider.getMethod())) {
                    IImageStore oldStore = oldProvider.getImageStore();
                    oldStore.delete(image, oldProvider);
                    this.commitEx();
                }
            }
            ++n2;
        }
        String msg = "Migrated " + cntRecords + " images on " + client.getName();
        this.addLog(msg);
    }

    private void progress(int idxClient, int totalClients, int idxRecord, int cntRecords, String msg) {
        if (this.processUI != null) {
            this.processUI.statusUpdate("Tenant " + idxClient + "/" + totalClients + " - " + msg + " " + idxRecord + "/" + cntRecords + " = " + idxRecord * 100 / cntRecords + "%");
        }
    }

    private void status(int idxClient, int totalClients, String msg) {
        if (this.processUI != null) {
            this.processUI.statusUpdate("Tenant " + idxClient + "/" + totalClients + " - " + msg);
        }
    }
}

