/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.process;

import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MProcessPara;
import org.compiere.model.MRole;
import org.compiere.model.MUserRoles;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;

@Process
public class MaintainSupportRoles
extends SvrProcess {
    private String p_IsActive;
    private static final String ACTION_ACTIVATE = "Y";
    private static final String ACTION_DEACTIVATE = "N";
    private static final String ACTION_DELETE = "D";

    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        int n = processInfoParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessInfoParameter para = processInfoParameterArray[n2];
            String name = para.getParameterName();
            if ("IsActive".equals(name)) {
                this.p_IsActive = para.getParameterAsString();
            } else {
                MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para);
            }
            ++n2;
        }
    }

    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("IsActive=" + this.p_IsActive);
        }
        List rows = DB.getSQLArrayObjectsEx((String)this.get_TrxName(), (String)"SELECT ViewID FROM T_Selection WHERE AD_PInstance_ID=?", (Object[])new Object[]{this.getAD_PInstance_ID()});
        int cnt = 0;
        if (rows != null) {
            for (List row : rows) {
                Object viewID = row.get(0);
                if (viewID == null || !(viewID instanceof String)) continue;
                String[] ids = ((String)viewID).split("\\|");
                int userID = Integer.valueOf(ids[0]);
                int roleID = Integer.valueOf(ids[1]);
                MUserRoles ur = (MUserRoles)new Query(this.getCtx(), "AD_User_Roles", "AD_User_ID=? AND AD_Role_ID=?", this.get_TrxName()).setParameters(new Object[]{userID, roleID}).first();
                if (ACTION_ACTIVATE.equals(this.p_IsActive)) {
                    if (ur != null) {
                        if (ur.isActive()) continue;
                        ur.setIsActive(true);
                        ur.saveEx();
                        ++cnt;
                        continue;
                    }
                    ur = new MUserRoles(this.getCtx(), userID, roleID, this.get_TrxName());
                    MRole role = MRole.get((Properties)this.getCtx(), (int)roleID);
                    ur.set_ValueNoCheck("AD_Client_ID", (Object)role.getAD_Client_ID());
                    ur.set_ValueNoCheck("AD_Org_ID", (Object)0);
                    ur.saveEx();
                    ++cnt;
                    continue;
                }
                if (ACTION_DEACTIVATE.equals(this.p_IsActive)) {
                    if (ur == null || !ur.isActive()) continue;
                    ur.setIsActive(false);
                    ur.saveEx();
                    ++cnt;
                    continue;
                }
                if (!ACTION_DELETE.equals(this.p_IsActive) || ur == null) continue;
                ur.deleteEx(true);
                ++cnt;
            }
        }
        return String.valueOf(cnt) + " @Processed@";
    }
}

