/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MPeriod;
import org.compiere.model.MProcessPara;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

@Process
public class InvoiceCreateCreditMemo
extends SvrProcess {
    private int p_C_DocType_ID = 0;
    private Timestamp p_DateInvoiced = null;
    private Timestamp p_DateAcct = null;
    private String p_DocAction = null;
    private boolean p_IsCreateAllocation = false;
    private MInvoice invoice = null;

    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        int n = processInfoParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            ProcessInfoParameter para = processInfoParameterArray[n2];
            switch (name = para.getParameterName()) {
                case "C_DocType_ID": {
                    this.p_C_DocType_ID = para.getParameterAsInt();
                    break;
                }
                case "DateInvoiced": {
                    this.p_DateInvoiced = para.getParameterAsTimestamp();
                    break;
                }
                case "DateAcct": {
                    this.p_DateAcct = para.getParameterAsTimestamp();
                    break;
                }
                case "DocAction": {
                    this.p_DocAction = para.getParameterAsString();
                    break;
                }
                case "IsCreateAllocation": {
                    this.p_IsCreateAllocation = para.getParameterAsBoolean();
                    break;
                }
                default: {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para);
                }
            }
            ++n2;
        }
        this.invoice = new MInvoice(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
    }

    protected String doIt() throws Exception {
        MAllocationHdr[] allocs;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("C_Invoice_ID" + this.invoice.getC_Invoice_ID() + ", C_DocType_ID=" + this.p_C_DocType_ID + ", DateInvoiced=" + this.p_DateInvoiced + ", DateAcct=" + this.p_DateAcct + ", DocAction=" + this.p_DocAction);
        }
        if (this.p_IsCreateAllocation && (allocs = MAllocationHdr.getOfInvoice((Properties)this.getCtx(), (int)this.invoice.getC_Invoice_ID(), (String)this.get_TrxName())).length > 0) {
            throw new AdempiereException(Msg.getMsg((Properties)this.getCtx(), (String)"InvoiceHasAllocations"));
        }
        if (this.invoice.isCreditMemo()) {
            throw new AdempiereException(Msg.getMsg((Properties)this.getCtx(), (String)"CannotCreateCreditMemoFromCreditMemo"));
        }
        int id = DB.getSQLValueEx((String)this.get_TrxName(), (String)"SELECT C_Invoice_ID FROM C_Invoice WHERE RelatedInvoice_ID = ?", (Object[])new Object[]{this.invoice.getC_Invoice_ID()});
        if (id > 0) {
            MInvoice actualCreditMemo = MInvoice.get((Properties)this.getCtx(), (int)id);
            MDocType dtc = MDocType.get((Properties)this.getCtx(), (int)actualCreditMemo.getC_DocTypeTarget_ID());
            this.addLog(0, null, null, String.valueOf(dtc.getName()) + " " + actualCreditMemo.getDocumentNo(), 318, actualCreditMemo.getC_Invoice_ID());
            throw new AdempiereException(Msg.getMsg((Properties)this.getCtx(), (String)"CreditMemoAlreadyExists"));
        }
        MInvoice creditMemo = this.credit();
        if (creditMemo != null) {
            MDocType dtc = MDocType.get((Properties)this.getCtx(), (int)creditMemo.getC_DocTypeTarget_ID());
            this.addLog(0, null, null, String.valueOf(dtc.getName()) + " " + creditMemo.getDocumentNo(), 318, creditMemo.getC_Invoice_ID());
        }
        return "@OK@";
    }

    private MInvoice credit() {
        MInvoiceLine[] rLines;
        Timestamp creditDate = this.p_DateAcct;
        Timestamp creditDateInvoiced = this.p_DateInvoiced;
        MPeriod.testPeriodOpen((Properties)this.getCtx(), (Timestamp)creditDate, (int)this.p_C_DocType_ID, (int)this.invoice.getAD_Org_ID());
        MInvoice creditMemo = null;
        creditMemo = MInvoice.copyFrom((MInvoice)this.invoice, (Timestamp)creditDateInvoiced, (Timestamp)creditDate, (int)this.p_C_DocType_ID, (boolean)this.invoice.isSOTrx(), (boolean)false, (String)this.get_TrxName(), (boolean)true);
        if (creditMemo == null) {
            throw new AdempiereException("Could not create Credit Memo");
        }
        MInvoiceLine[] oLines = this.invoice.getLines(false);
        if (oLines.length != (rLines = creditMemo.getLines(true)).length) {
            throw new AdempiereException("Credit Memo created with different number of lines than invoice");
        }
        int i = 0;
        while (i < rLines.length) {
            MInvoiceLine rLine = rLines[i];
            MInvoiceLine oLine = oLines[i];
            rLine.setQtyEntered(oLine.getQtyEntered());
            rLine.setQtyInvoiced(oLine.getQtyInvoiced());
            rLine.setLineNetAmt(oLine.getLineNetAmt());
            rLine.setTaxAmt(oLine.getTaxAmt());
            rLine.setLineTotalAmt(oLine.getLineTotalAmt());
            rLine.setPriceActual(oLine.getPriceActual());
            rLine.setPriceList(oLine.getPriceList());
            rLine.setPriceLimit(oLine.getPriceLimit());
            rLine.setPriceEntered(oLine.getPriceEntered());
            rLine.setC_UOM_ID(oLine.getC_UOM_ID());
            if (!rLine.save(this.get_TrxName())) {
                throw new AdempiereException("Could not create credit memo line");
            }
            ++i;
        }
        if ("B".equals(creditMemo.getPaymentRule())) {
            creditMemo.setPaymentRule("P");
        }
        creditMemo.setC_Order_ID(this.invoice.getC_Order_ID());
        StringBuilder msgadd = new StringBuilder("{->").append(this.invoice.getDocumentNo()).append(")");
        creditMemo.addDescription(msgadd.toString());
        creditMemo.setPOReference(this.invoice.getDocumentNo());
        creditMemo.setRelatedInvoice_ID(this.invoice.getC_Invoice_ID());
        creditMemo.saveEx(this.get_TrxName());
        if (this.p_DocAction != null) {
            if (!creditMemo.processIt(this.p_DocAction)) {
                throw new AdempiereException(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"FailedProcessingDocument")) + " - " + creditMemo.getProcessMsg());
            }
            if (this.p_IsCreateAllocation && "CO".equals(this.p_DocAction)) {
                StringBuilder msgall = new StringBuilder().append(Msg.translate((Properties)this.getCtx(), (String)"C_Invoice_ID")).append(": ").append(this.invoice.getDocumentNo()).append("/").append(creditMemo.getDocumentNo());
                MAllocationHdr alloc = new MAllocationHdr(this.getCtx(), false, creditDate, this.invoice.getC_Currency_ID(), msgall.toString(), this.get_TrxName());
                alloc.setAD_Org_ID(this.invoice.getAD_Org_ID());
                alloc.saveEx();
                BigDecimal gt = this.invoice.getGrandTotal(true);
                if (!this.invoice.isSOTrx()) {
                    gt = gt.negate();
                }
                MAllocationLine aLine = new MAllocationLine(alloc, gt, Env.ZERO, Env.ZERO, Env.ZERO);
                aLine.setC_Invoice_ID(this.invoice.getC_Invoice_ID());
                aLine.saveEx();
                MAllocationLine cLine = new MAllocationLine(alloc, gt.negate(), Env.ZERO, Env.ZERO, Env.ZERO);
                cLine.setC_Invoice_ID(creditMemo.getC_Invoice_ID());
                cLine.saveEx();
                if (!alloc.processIt("CO")) {
                    throw new AdempiereException(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"FailedProcessingDocument")) + " - " + alloc.getProcessMsg());
                }
                alloc.saveEx();
            }
        }
        return creditMemo;
    }
}

