/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.process;

import java.util.Properties;
import org.adempiere.base.annotation.Process;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MColumn;
import org.compiere.model.MIndexColumn;
import org.compiere.model.MProcess;
import org.compiere.model.MProcessPara;
import org.compiere.model.MTable;
import org.compiere.model.MTableIndex;
import org.compiere.model.M_Element;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWFNodeNext;
import org.compiere.wf.MWorkflow;

@Process
public class CreateTable
extends SvrProcess {
    private String p_tableName = "";
    private String p_name = "";
    private String p_description = "";
    private String p_accessLevel = "";
    private String p_entityType = "";
    private boolean p_isCreateKeyColumn = false;
    private boolean p_isCreateWorkflow = false;
    private boolean p_isCreateTranslationTable = false;
    private boolean p_isCreateColValue = false;
    private boolean p_isCreateColName = false;
    private boolean p_isCreateColDescription = false;
    private boolean p_isCreateColHelp = false;
    private boolean p_isCreateColDocumentNo = false;
    private boolean p_isCreateColDocAction = false;
    private boolean p_isCreateColDocStatus = false;
    private boolean p_isCreateColProcessed = false;
    private boolean p_isCreateColProcessedOn = false;
    private boolean p_isCreateColProcessing = false;
    private boolean p_isCreateColC_DocTypeTarget_ID = false;
    private boolean p_isCreateColC_DocType_ID = false;
    private boolean p_isCreateColC_Currency_ID = false;
    private boolean p_isCreateColDateTrx = false;
    private boolean p_isCreateColDateAcct = false;
    private boolean p_isCreateColPosted = false;
    private boolean p_isCreateColIsApproved = false;
    private boolean p_isCreateColSalesRepID = false;
    private boolean p_isCreateColAD_User_ID = false;
    private int p_record_ID = 0;
    private static final int LENGTH_0 = 0;
    private static final int LENGTH_1 = 1;
    private static final int LENGTH_2 = 2;
    private static final int LENGTH_6 = 6;
    private static final int LENGTH_7 = 7;
    private static final int LENGTH_20 = 20;
    private static final int LENGTH_22 = 22;
    private static final int LENGTH_30 = 30;
    private static final int LENGTH_36 = 36;
    private static final int LENGTH_40 = 40;
    private static final int LENGTH_60 = 60;
    private static final int LENGTH_255 = 255;
    private static final int LENGTH_2000 = 2000;
    private static final int WF_TRANSITION_10 = 10;
    private static final int WF_TRANSITION_100 = 100;
    public static final String[] WORKFLOW_COLUMNS = new String[]{"DocAction", "DocStatus", "Processed", "ProcessedOn", "Processing"};

    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        int n = processInfoParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            ProcessInfoParameter para = processInfoParameterArray[n2];
            switch (name = para.getParameterName()) {
                case "TableName": {
                    this.p_tableName = para.getParameterAsString();
                    break;
                }
                case "Name": {
                    this.p_name = para.getParameterAsString();
                    break;
                }
                case "Description": {
                    this.p_description = para.getParameterAsString();
                    break;
                }
                case "AccessLevel": {
                    this.p_accessLevel = para.getParameterAsString();
                    break;
                }
                case "EntityType": {
                    this.p_entityType = para.getParameterAsString();
                    break;
                }
                case "IsCreateKeyColumn": {
                    this.p_isCreateKeyColumn = para.getParameterAsBoolean();
                    break;
                }
                case "IsCreateWorkflow": {
                    this.p_isCreateWorkflow = para.getParameterAsBoolean();
                    break;
                }
                case "IsCreateTranslationTable": {
                    this.p_isCreateTranslationTable = para.getParameterAsBoolean();
                    break;
                }
                case "IsCreateColValue": {
                    this.p_isCreateColValue = para.getParameterAsBoolean();
                    break;
                }
                case "IsCreateColName": {
                    this.p_isCreateColName = para.getParameterAsBoolean();
                    break;
                }
                case "IsCreateColDescription": {
                    this.p_isCreateColDescription = para.getParameterAsBoolean();
                    break;
                }
                case "IsCreateColHelp": {
                    this.p_isCreateColHelp = para.getParameterAsBoolean();
                    break;
                }
                case "IsCreateColDocumentNo": {
                    this.p_isCreateColDocumentNo = para.getParameterAsBoolean();
                    break;
                }
                case "IsCreateColDocAction": {
                    this.p_isCreateColDocAction = para.getParameterAsBoolean();
                    break;
                }
                case "IsCreateColDocStatus": {
                    this.p_isCreateColDocStatus = para.getParameterAsBoolean();
                    break;
                }
                case "IsCreateColProcessed": {
                    this.p_isCreateColProcessed = para.getParameterAsBoolean();
                    break;
                }
                case "IsCreateColProcessedOn": {
                    this.p_isCreateColProcessedOn = para.getParameterAsBoolean();
                    break;
                }
                case "IsCreateColProcessing": {
                    this.p_isCreateColProcessing = para.getParameterAsBoolean();
                    break;
                }
                case "IsCreateColC_DocTypeTarget_ID": {
                    this.p_isCreateColC_DocTypeTarget_ID = para.getParameterAsBoolean();
                    break;
                }
                case "IsCreateColC_DocType_ID": {
                    this.p_isCreateColC_DocType_ID = para.getParameterAsBoolean();
                    break;
                }
                case "IsCreateColC_Currency_ID": {
                    this.p_isCreateColC_Currency_ID = para.getParameterAsBoolean();
                    break;
                }
                case "IsCreateColDateTrx": {
                    this.p_isCreateColDateTrx = para.getParameterAsBoolean();
                    break;
                }
                case "IsCreateColDateAcct": {
                    this.p_isCreateColDateAcct = para.getParameterAsBoolean();
                    break;
                }
                case "IsCreateColPosted": {
                    this.p_isCreateColPosted = para.getParameterAsBoolean();
                    break;
                }
                case "IsCreateColIsApproved": {
                    this.p_isCreateColIsApproved = para.getParameterAsBoolean();
                    break;
                }
                case "IsCreateColSalesRep_ID": {
                    this.p_isCreateColSalesRepID = para.getParameterAsBoolean();
                    break;
                }
                case "IsCreateColAD_User_ID": {
                    this.p_isCreateColAD_User_ID = para.getParameterAsBoolean();
                    break;
                }
                default: {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para);
                }
            }
            ++n2;
        }
        this.p_record_ID = this.getRecord_ID();
    }

    protected String doIt() {
        M_Element elementUU;
        if (!this.p_isCreateKeyColumn && this.p_isCreateTranslationTable) {
            return "@Error@ Main table must have a key column if you want to handle translations";
        }
        if (Util.isEmpty((String)this.p_name)) {
            this.p_name = this.p_tableName;
        }
        MTable table = this.createTable(false);
        M_Element elementID = null;
        if (this.p_isCreateKeyColumn) {
            elementID = M_Element.get((Properties)this.getCtx(), (String)(String.valueOf(this.p_tableName) + "_ID"));
            if (elementID == null) {
                elementID = new M_Element(this.getCtx(), String.valueOf(this.p_tableName) + "_ID", this.p_entityType, this.get_TrxName());
                elementID.setName(this.p_name);
                elementID.setPrintName(this.p_name);
                elementID.setDescription(this.p_description);
                elementID.saveEx();
            }
            this.createColumn(table, elementID.getColumnName());
        }
        if ((elementUU = M_Element.get((Properties)this.getCtx(), (String)(String.valueOf(this.p_tableName) + "_UU"))) == null) {
            elementUU = new M_Element(this.getCtx(), String.valueOf(this.p_tableName) + "_UU", this.p_entityType, this.get_TrxName());
            elementUU.saveEx();
        }
        this.createColumn(table, elementUU.getColumnName());
        if (this.p_isCreateColValue) {
            this.createColumn(table, "Value");
        }
        if (this.p_isCreateColName) {
            this.createColumn(table, "Name");
        }
        if (this.p_isCreateColDescription) {
            this.createColumn(table, "Description");
        }
        if (this.p_isCreateColHelp) {
            this.createColumn(table, "Help");
        }
        if (this.p_isCreateColDateTrx) {
            this.createColumn(table, "DateTrx");
        }
        if (this.p_isCreateColDateAcct) {
            this.createColumn(table, "DateAcct");
        }
        if (this.p_isCreateColC_DocTypeTarget_ID) {
            this.createColumn(table, "C_DocTypeTarget_ID");
        }
        if (this.p_isCreateColC_DocType_ID) {
            this.createColumn(table, "C_DocType_ID");
        }
        if (this.p_isCreateColDocumentNo) {
            this.createColumn(table, "DocumentNo");
        }
        if (this.p_isCreateColSalesRepID) {
            this.createColumn(table, "SalesRep_ID");
        }
        if (this.p_isCreateColAD_User_ID) {
            this.createColumn(table, "AD_User_ID");
        }
        if (this.p_isCreateColC_Currency_ID) {
            this.createColumn(table, "C_Currency_ID");
        }
        if (this.p_isCreateColIsApproved) {
            this.createColumn(table, "IsApproved");
        }
        if (this.p_isCreateColPosted) {
            this.createColumn(table, "Posted");
        }
        if (this.p_isCreateColDocAction || this.p_isCreateWorkflow) {
            this.createColumn(table, "DocAction");
        }
        if (this.p_isCreateColDocStatus || this.p_isCreateWorkflow) {
            this.createColumn(table, "DocStatus");
        }
        if (this.p_isCreateColProcessed || this.p_isCreateWorkflow) {
            this.createColumn(table, "Processed");
        }
        if (this.p_isCreateColProcessedOn || this.p_isCreateWorkflow) {
            this.createColumn(table, "ProcessedOn");
        }
        if (this.p_isCreateColProcessing || this.p_isCreateWorkflow) {
            this.createColumn(table, "Processing");
        }
        if (this.p_isCreateWorkflow) {
            MWorkflow wf = this.createWorkflow(table);
            MProcess process = (MProcess)new Query(this.getCtx(), "AD_Process", "AD_Workflow_ID=?", this.get_TrxName()).setParameters(new Object[]{wf.getAD_Workflow_ID()}).first();
            if (process == null) {
                process = new MProcess(this.getCtx(), 0, this.get_TrxName());
                process.setValue(String.valueOf(this.p_tableName) + " Process");
                process.setName("Process " + this.p_name);
                process.setEntityType(this.p_entityType);
                process.setAccessLevel(this.p_accessLevel);
                process.setAD_Workflow_ID(wf.getAD_Workflow_ID());
                process.saveEx();
            }
            MColumn colDocAction = this.getColumn(table, "DocAction");
            colDocAction.setAD_Process_ID(process.getAD_Process_ID());
            colDocAction.saveEx();
        }
        if (this.p_isCreateTranslationTable) {
            M_Element elementTrlUU;
            MTable tableTrl = this.createTable(true);
            int colElementID = 0;
            if (elementID != null) {
                colElementID = this.createColumn(tableTrl, elementID.getColumnName());
            }
            if ((elementTrlUU = M_Element.get((Properties)this.getCtx(), (String)(String.valueOf(tableTrl.getTableName()) + "_UU"))) == null) {
                elementTrlUU = new M_Element(this.getCtx(), String.valueOf(tableTrl.getTableName()) + "_UU", this.p_entityType, this.get_TrxName());
                elementTrlUU.saveEx();
            }
            this.createColumn(tableTrl, elementTrlUU.getColumnName());
            int colLanguageID = this.createColumn(tableTrl, "AD_Language");
            this.createColumn(tableTrl, "IsTranslated");
            MColumn[] mColumnArray = MTable.get((Properties)this.getCtx(), (String)this.p_tableName).getColumns(false);
            int n = mColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                MColumn column = mColumnArray[n2];
                if (column.isTranslated()) {
                    this.createColumn(tableTrl, column.getColumnName());
                }
                ++n2;
            }
            if (this.p_isCreateColName) {
                this.createColumn(tableTrl, "Name");
            }
            if (this.p_isCreateColDescription) {
                this.createColumn(tableTrl, "Description");
            }
            if (this.p_isCreateColHelp) {
                this.createColumn(tableTrl, "Help");
            }
            MTableIndex ti = new MTableIndex(tableTrl, String.valueOf(tableTrl.getTableName()) + "_pkey");
            ti.setIsCreateConstraint(true);
            ti.setIsUnique(true);
            ti.setIsKey(true);
            ti.saveEx();
            MIndexColumn ic = new MIndexColumn(ti, new MColumn(this.getCtx(), colLanguageID, this.get_TrxName()), 1);
            ic.saveEx();
            ic = new MIndexColumn(ti, new MColumn(this.getCtx(), colElementID, this.get_TrxName()), 2);
            ic.saveEx();
            this.addLog(Msg.getMsg((Properties)this.getCtx(), (String)"TrlCreatedSyncColumnValidateIndex"));
        }
        return "@ProcessOK@";
    }

    private MColumn getColumn(MTable table, String columnName) {
        return (MColumn)new Query(this.getCtx(), "AD_Column", "AD_Table_ID=? AND UPPER(ColumnName)=UPPER(?)", this.get_TrxName()).setParameters(new Object[]{table.getAD_Table_ID(), columnName}).first();
    }

    private void log(MTable table) {
        this.addLog(table.getAD_Table_ID(), null, null, table.getTableName(), 100, table.getAD_Table_ID());
    }

    private MTable createTable(boolean trl) {
        String tableName = String.valueOf(this.p_tableName) + (trl ? "_Trl" : "");
        MTable table = (MTable)new Query(this.getCtx(), "AD_Table", "UPPER(TableName)=UPPER(?)", this.get_TrxName()).setParameters(new Object[]{tableName}).first();
        if (table == null) {
            String name = String.valueOf(this.p_name) + (trl ? " Trl" : "");
            String description = null;
            if (!Util.isEmpty((String)this.p_description)) {
                description = String.valueOf(this.p_description) + (trl ? " Trl" : "");
            }
            table = new MTable(this.getCtx(), 0, this.get_TrxName());
            table.setTableName(tableName);
            table.setName(name);
            table.setDescription(description);
            table.setEntityType(this.p_entityType);
            table.setAccessLevel(this.p_accessLevel);
            table.setIsDeleteable(!trl);
            table.setIsChangeLog(true);
            table.saveEx();
            this.log(table);
        } else if (this.p_record_ID == 0 && !trl) {
            throw new AdempiereException("Table " + this.p_tableName + " already exists");
        }
        this.createColumn(table, "AD_Client_ID");
        this.createColumn(table, "AD_Org_ID");
        this.createColumn(table, "Created");
        this.createColumn(table, "CreatedBy");
        this.createColumn(table, "Updated");
        this.createColumn(table, "UpdatedBy");
        this.createColumn(table, "IsActive");
        return table;
    }

    private int createColumn(MTable table, String columnName) {
        MColumn columnThatExists = this.getColumn(table, columnName);
        if (columnThatExists != null) {
            if (this.p_isCreateTranslationTable && !columnThatExists.isTranslated() && !table.getTableName().toUpperCase().endsWith("_TRL") && (this.p_isCreateColName && columnName.equals("Name") || this.p_isCreateColHelp && columnName.equals("Help") || this.p_isCreateColDescription && columnName.equals("Description"))) {
                columnThatExists.setIsTranslated(true);
                columnThatExists.saveEx();
            }
            return -1;
        }
        MColumn column = new MColumn(table);
        M_Element element = M_Element.get((Properties)this.getCtx(), (String)columnName, (String)this.get_TrxName());
        column.setColumnName(element.getColumnName());
        column.setName(element.getName());
        column.setDescription(element.getDescription());
        column.setHelp(element.getHelp());
        column.setAD_Element_ID(element.getAD_Element_ID());
        if (columnName.equals("AD_Client_ID")) {
            column.setAD_Reference_ID(30);
            column.setDefaultValue("@#AD_Client_ID@");
            column.setIsMandatory(true);
            column.setIsUpdateable(false);
            column.setReadOnlyLogic("1=1");
        } else if (columnName.equals("AD_Org_ID")) {
            column.setAD_Reference_ID(19);
            column.setDefaultValue("@AD_Org_ID@");
            column.setIsMandatory(true);
            column.setIsUpdateable(false);
        } else if (columnName.equals("Created") || columnName.equals("Updated")) {
            column.setAD_Reference_ID(16);
            column.setIsMandatory(true);
            column.setIsUpdateable(false);
        } else if (columnName.equals("CreatedBy") || columnName.equals("UpdatedBy")) {
            column.setAD_Reference_ID(30);
            column.setAD_Reference_Value_ID(110);
            column.setIsMandatory(true);
            column.setIsUpdateable(false);
        } else if (columnName.equals("IsActive") || columnName.equals("IsTranslated") || columnName.equals("Processed") || columnName.equals("Processing") || columnName.equals("IsApproved")) {
            column.setAD_Reference_ID(20);
            column.setIsMandatory(true);
            column.setIsUpdateable(true);
            column.setFieldLength(1);
            column.setDefaultValue("N");
            if (columnName.equals("IsActive")) {
                column.setDefaultValue("Y");
            }
        } else if (columnName.equals("AD_Language")) {
            column.setAD_Reference_ID(18);
            column.setAD_Reference_Value_ID(106);
            column.setIsMandatory(true);
            column.setIsUpdateable(false);
            column.setFieldLength(6);
            column.setIsParent(true);
        } else if (columnName.equals("Value") || columnName.equals("Name") || columnName.equals("DocumentNo")) {
            column.setAD_Reference_ID(10);
            column.setIsUpdateable(true);
            column.setIsSelectionColumn(true);
            int length = 0;
            if (columnName.equals("Value")) {
                length = 40;
            } else if (columnName.equals("Name")) {
                length = 60;
                column.setIsMandatory(true);
                column.setIsIdentifier(true);
                if (this.p_isCreateTranslationTable && !table.getTableName().toUpperCase().endsWith("_TRL")) {
                    column.setIsTranslated(true);
                }
            } else if (columnName.equals("DocumentNo")) {
                length = 30;
            }
            column.setFieldLength(length);
        } else if (columnName.equals("Description") || columnName.equals("Help")) {
            column.setAD_Reference_ID(10);
            column.setIsUpdateable(true);
            int length = 0;
            if (columnName.equals("Description")) {
                length = 255;
            } else if (columnName.equals("Help")) {
                length = 2000;
            }
            column.setFieldLength(length);
            if (this.p_isCreateTranslationTable && !table.getTableName().toUpperCase().endsWith("_TRL")) {
                column.setIsTranslated(true);
            }
        } else if (columnName.equals("C_Currency_ID")) {
            column.setAD_Reference_ID(19);
            column.setIsMandatory(true);
            column.setIsUpdateable(true);
            column.setFieldLength(22);
            column.setDefaultValue("@C_Currency_ID@");
        } else if (columnName.equals("DateAcct") || columnName.equals("DateTrx")) {
            column.setAD_Reference_ID(15);
            column.setIsMandatory(true);
            column.setIsUpdateable(true);
            column.setFieldLength(7);
            column.setDefaultValue("@#Date@");
        } else if (columnName.equals("DocAction")) {
            column.setAD_Reference_ID(28);
            column.setAD_Reference_Value_ID(135);
            column.setIsMandatory(true);
            column.setIsUpdateable(true);
            column.setFieldLength(2);
            column.setDefaultValue("CO");
            column.setIsToolbarButton("N");
        } else if (columnName.equals("DocStatus")) {
            column.setAD_Reference_ID(17);
            column.setIsMandatory(true);
            column.setIsUpdateable(true);
            column.setFieldLength(2);
            column.setAD_Reference_Value_ID(131);
            column.setDefaultValue("DR");
        } else if (columnName.equals("ProcessedOn")) {
            column.setAD_Reference_ID(22);
            column.setFieldLength(20);
        } else if (columnName.equals("C_DocType_ID")) {
            column.setAD_Reference_ID(19);
            column.setIsMandatory(true);
            column.setIsUpdateable(true);
            column.setFieldLength(22);
        } else if (columnName.equals("C_DocTypeTarget_ID")) {
            column.setAD_Reference_ID(18);
            column.setAD_Reference_Value_ID(170);
            column.setIsMandatory(true);
            column.setIsUpdateable(true);
            column.setFieldLength(22);
        } else if (columnName.equals("Posted")) {
            column.setAD_Reference_ID(28);
            column.setIsMandatory(true);
            column.setIsUpdateable(true);
            column.setFieldLength(1);
            column.setAD_Reference_Value_ID(234);
            column.setDefaultValue("N");
            column.setIsToolbarButton("N");
        } else if (columnName.equals("AD_User_ID") || columnName.equals("SalesRep_ID")) {
            column.setAD_Reference_ID(30);
            column.setAD_Reference_Value_ID(110);
            column.setIsMandatory(true);
            column.setIsUpdateable(true);
            if (columnName.equals("SalesRep_ID")) {
                column.setAD_Reference_Value_ID(190);
            }
        } else if (element.getColumnName().equalsIgnoreCase(String.valueOf(table.getTableName()) + "_ID")) {
            column.setIsKey(true);
            column.setAD_Reference_ID(13);
            column.setIsMandatory(true);
            column.setFieldLength(22);
        } else if (element.getColumnName().equalsIgnoreCase(String.valueOf(table.getTableName()) + "_UU")) {
            column.setAD_Reference_ID(10);
            column.setFieldLength(36);
        } else if (element.getColumnName().equalsIgnoreCase(String.valueOf(table.getTableName().substring(0, table.getTableName().length() - 4)) + "_ID")) {
            column.setAD_Reference_ID(30);
            column.setIsParent(true);
            column.setIsMandatory(true);
            column.setFKConstraintType("C");
        }
        column.saveEx();
        return column.getAD_Column_ID();
    }

    private MWorkflow createWorkflow(MTable table) {
        MWorkflow wf = (MWorkflow)new Query(this.getCtx(), "AD_Workflow", "WorkflowType=? AND AD_Table_ID=?", this.get_TrxName()).setParameters(new Object[]{"P", table.getAD_Table_ID()}).first();
        if (wf != null) {
            return wf;
        }
        wf = new MWorkflow(this.getCtx(), 0, this.get_TrxName());
        wf.setValue("Process_" + this.p_tableName);
        wf.setName("Process_" + this.p_tableName);
        wf.setWorkflowType("P");
        wf.setAD_Table_ID(table.getAD_Table_ID());
        wf.setEntityType(this.p_entityType);
        wf.setAuthor("iDempiere");
        wf.saveEx();
        MWFNode docAuto = this.createWorkflowNode(wf, "DocAuto", "D", "--");
        MWFNode docComplete = this.createWorkflowNode(wf, "DocComplete", "D", "CO");
        MWFNode docPrepare = this.createWorkflowNode(wf, "DocPrepare", "D", "PR");
        MWFNode start = this.createWorkflowNode(wf, "Start", "Z", null);
        this.createWorkflowNodeNext(start, docPrepare.getAD_WF_Node_ID(), 10, "(Standard Approval)", true);
        this.createWorkflowNodeNext(start, docAuto.getAD_WF_Node_ID(), 100, "(Standard Transition)", false);
        this.createWorkflowNodeNext(docPrepare, docComplete.getAD_WF_Node_ID(), 100, "(Standard Transition)", false);
        wf.setAD_WF_Node_ID(start.getAD_WF_Node_ID());
        wf.saveEx();
        return wf;
    }

    private MWFNode createWorkflowNode(MWorkflow wf, String name, String action, String docAction) {
        MWFNode wfn = new MWFNode(wf, "(" + name + ")", "(" + name + ")");
        wfn.setDescription("(Standard Node)");
        wfn.setEntityType(this.p_entityType);
        wfn.setAction(action);
        wfn.setDocAction(docAction);
        wfn.saveEx();
        return wfn;
    }

    private void createWorkflowNodeNext(MWFNode wfn, int nodeNextID, int seq, String description, boolean isStdUserWF) {
        MWFNodeNext wfnn = new MWFNodeNext(wfn, nodeNextID);
        wfnn.setSeqNo(seq);
        wfnn.setDescription(description);
        wfnn.setIsStdUserWorkflow(isStdUserWF);
        wfnn.setEntityType(this.p_entityType);
        wfnn.saveEx();
    }
}

