/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.process;

import java.math.BigDecimal;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MArchive;
import org.compiere.model.MAttachment;
import org.compiere.model.MProcessPara;
import org.compiere.model.MTable;
import org.compiere.model.MTree_Base;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;

@Process
public class CleanOrphanCascade
extends SvrProcess {
    private boolean p_IsCleanChangeLog;

    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        int n = processInfoParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessInfoParameter para = processInfoParameterArray[n2];
            String name = para.getParameterName();
            if ("IsCleanChangeLog".equals(name)) {
                this.p_IsCleanChangeLog = para.getParameterAsBoolean();
            } else {
                MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para);
            }
            ++n2;
        }
    }

    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("");
        }
        ValueNamePair[] treeTables = new ValueNamePair[]{new ValueNamePair("AD_TreeBar", "AD_Menu"), new ValueNamePair("AD_TreeNodeBP", "C_BPartner"), new ValueNamePair("AD_TreeNodeCMC", "CM_Container"), new ValueNamePair("AD_TreeNodeCMM", "CM_Media"), new ValueNamePair("AD_TreeNodeCMS", "CM_CStage"), new ValueNamePair("AD_TreeNodeCMT", "CM_Template"), new ValueNamePair("AD_TreeNodeMM", "AD_Menu"), new ValueNamePair("AD_TreeNodePR", "M_Product"), new ValueNamePair("AD_TreeNodeU1", "C_ElementValue"), new ValueNamePair("AD_TreeNodeU2", "C_ElementValue"), new ValueNamePair("AD_TreeNodeU3", "C_ElementValue"), new ValueNamePair("AD_TreeNodeU4", "C_ElementValue")};
        ValueNamePair[] valueNamePairArray = treeTables;
        int n = treeTables.length;
        int n2 = 0;
        while (n2 < n) {
            ValueNamePair vnp = valueNamePairArray[n2];
            String treeTable = vnp.getValue();
            String foreignTable = vnp.getName();
            this.delTree(treeTable, foreignTable, "Node_ID", 0);
            if (!"AD_TreeBar".equalsIgnoreCase(treeTable)) {
                this.delTree(treeTable, foreignTable, "Parent_ID", 0);
            }
            ++n2;
        }
        List trees = new Query(this.getCtx(), "AD_Tree", null, this.get_TrxName()).list();
        String treeTable = "AD_TreeNode";
        for (MTree_Base tree : trees) {
            String foreignTable = tree.getSourceTableName(true);
            this.delTree(treeTable, foreignTable, "Parent_ID", tree.getAD_Tree_ID());
        }
        String whereTables = "    IsView = 'N' AND EXISTS (SELECT 1             FROM   AD_Column ct             WHERE  ct.IsActive='Y' AND ct.AD_Table_ID = AD_Table.AD_Table_ID                    AND ct.ColumnName = 'AD_Table_ID') AND EXISTS (SELECT 1             FROM   AD_Column cr             WHERE  cr.IsActive='Y' AND cr.AD_Table_ID = AD_Table.AD_Table_ID                    AND cr.ColumnName = 'Record_ID') AND EXISTS (SELECT 1             FROM   AD_Column ck             WHERE  ck.IsActive='Y' AND ck.AD_Table_ID = AD_Table.AD_Table_ID                    AND ck.ColumnName = AD_Table.TableName || '_ID')";
        if (!this.p_IsCleanChangeLog) {
            whereTables = String.valueOf(whereTables) + " AND TableName != 'AD_ChangeLog'";
        }
        List tables = new Query(this.getCtx(), "AD_Table", whereTables, this.get_TrxName()).setOnlyActiveRecords(true).setOrderBy("TableName").list();
        tables.add(MTable.get((Properties)this.getCtx(), (String)"AD_Package_UUID_Map"));
        for (MTable table : tables) {
            String tableName = table.getTableName();
            boolean isUUIDMap = "AD_Package_UUID_Map".equals(tableName);
            StringBuilder sqlRef = new StringBuilder();
            sqlRef.append("SELECT DISTINCT t.AD_Table_ID, ");
            sqlRef.append("                t.TableName ");
            sqlRef.append("FROM   ").append(tableName).append(" r ");
            sqlRef.append("       JOIN AD_Table t ON ( r.AD_Table_ID = t.AD_Table_ID ) ");
            sqlRef.append("ORDER  BY t.Tablename");
            List rowTables = DB.getSQLArrayObjectsEx((String)this.get_TrxName(), (String)sqlRef.toString(), (Object[])new Object[0]);
            if (rowTables == null) continue;
            for (List row : rowTables) {
                int refTableID = ((BigDecimal)row.get(0)).intValue();
                String refTableName = row.get(1).toString();
                MTable refTable = MTable.get((Properties)this.getCtx(), (int)refTableID);
                StringBuilder whereClause = new StringBuilder();
                whereClause.append("AD_Table_ID = ").append(refTableID);
                if (refTable.getKeyColumns().length != 1 && !isUUIDMap) {
                    this.log.warning("Wrong reference for table " + tableName + " -> " + refTableName);
                    whereClause.append(" AND Record_ID>0");
                } else {
                    String colRef = refTable.getKeyColumns()[0];
                    if (isUUIDMap) {
                        colRef = MTable.getUUIDColumnName((String)refTable.getTableName());
                    }
                    whereClause.append(" AND NOT EXISTS (SELECT ").append(colRef);
                    whereClause.append("                FROM   ").append(refTableName).append(" ");
                    whereClause.append("                WHERE  ").append(refTableName).append(".").append(colRef).append(" = ").append(tableName);
                    if (isUUIDMap) {
                        whereClause.append(".Target_UUID)");
                    } else {
                        whereClause.append(".Record_ID)");
                    }
                }
                int noDel = 0;
                if ("AD_Attachment".equals(tableName)) {
                    List attachments = new Query(this.getCtx(), tableName, whereClause.toString(), this.get_TrxName()).list();
                    for (MAttachment attachment : attachments) {
                        attachment.deleteEx(true, this.get_TrxName());
                        ++noDel;
                    }
                } else if ("AD_Archive".equals(tableName)) {
                    List archives = new Query(this.getCtx(), tableName, whereClause.toString(), this.get_TrxName()).list();
                    for (MArchive archive : archives) {
                        archive.deleteEx(true, this.get_TrxName());
                        ++noDel;
                    }
                } else {
                    StringBuilder sqlDelete = new StringBuilder();
                    sqlDelete.append("DELETE FROM ").append(tableName).append(" WHERE ").append((CharSequence)whereClause);
                    noDel = DB.executeUpdateEx((String)sqlDelete.toString(), (String)this.get_TrxName());
                }
                if (noDel <= 0) continue;
                this.addLog(Msg.parseTranslation((Properties)this.getCtx(), (String)(String.valueOf(noDel) + " " + tableName + " " + "@Deleted@ -> " + refTableName)));
            }
        }
        return "@OK@";
    }

    private void delTree(String treeTable, String foreignTable, String columnName, int treeId) {
        int noDel;
        StringBuilder sqlDelete = new StringBuilder().append("DELETE FROM ").append(treeTable).append(" WHERE ").append(columnName).append(">0 AND ").append(columnName).append(" NOT IN (SELECT ").append(foreignTable).append("_ID FROM ").append(foreignTable).append(")");
        if (treeId > 0) {
            sqlDelete.append(" AND AD_Tree_ID=").append(treeId);
        }
        if ((noDel = DB.executeUpdateEx((String)sqlDelete.toString(), (String)this.get_TrxName())) > 0) {
            this.addLog(Msg.parseTranslation((Properties)this.getCtx(), (String)(String.valueOf(noDel) + " " + treeTable + " " + "@Deleted@ -> " + foreignTable + (treeId > 0 ? " Tree=" + treeId : ""))));
        }
    }
}

