/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MProcessPara;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUser;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Util;

@Process
public class UserPassword
extends SvrProcess {
    private int p_AD_User_ID = -1;
    private String p_OldPassword = null;
    private String p_NewPassword = null;
    private String p_NewPasswordConfirm = null;
    private String p_NewEMail = null;
    private String p_NewEMailConfirm = null;
    private String p_NewEMailUser = null;
    private String p_NewEMailUserPW = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("AD_User_ID")) {
                    this.p_AD_User_ID = para[i].getParameterAsInt();
                } else if (name.equals("OldPassword")) {
                    this.p_OldPassword = (String)para[i].getParameter();
                } else if (name.equals("NewPassword")) {
                    this.p_NewPassword = (String)para[i].getParameter();
                } else if (name.equals("NewEMail")) {
                    this.p_NewEMail = (String)para[i].getParameter();
                } else if (name.equals("NewEMailUser")) {
                    this.p_NewEMailUser = (String)para[i].getParameter();
                } else if (name.equals("NewEMailUserPW")) {
                    this.p_NewEMailUserPW = (String)para[i].getParameter();
                } else if (name.equals("NewPasswordConfirm")) {
                    this.p_NewPasswordConfirm = (String)para[i].getParameter();
                } else if (name.equals("NewEMailConfirm")) {
                    this.p_NewEMailConfirm = (String)para[i].getParameter();
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("AD_User_ID=" + this.p_AD_User_ID + " from " + this.getAD_User_ID());
        }
        MUser user = new MUser(this.getCtx(), this.p_AD_User_ID, this.get_TrxName());
        MUser operator = MUser.get((Properties)this.getCtx(), (int)this.getAD_User_ID());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("User=" + user + ", Operator=" + operator);
        }
        boolean hash_password = MSysConfig.getBooleanValue((String)"USER_PASSWORD_HASH", (boolean)false);
        if (Util.isEmpty((String)this.p_OldPassword)) {
            if (this.p_AD_User_ID == 10 || this.p_AD_User_ID == 100 || !operator.isAdministrator()) {
                throw new IllegalArgumentException("@OldPasswordMandatory@");
            }
        } else if (hash_password ? !user.authenticateHash(this.p_OldPassword) : !this.p_OldPassword.equals(user.getPassword())) {
            throw new IllegalArgumentException("@OldPasswordNoMatch@");
        }
        if (!Util.isEmpty((String)this.p_NewPassword)) {
            if (Util.isEmpty((String)this.p_NewPasswordConfirm)) {
                throw new IllegalArgumentException("@NewPasswordConfirmMandatory@");
            }
            if (!this.p_NewPassword.equals(this.p_NewPasswordConfirm)) {
                throw new IllegalArgumentException("@PasswordNotMatch@");
            }
        }
        if (!Util.isEmpty((String)this.p_NewEMailUserPW)) {
            if (Util.isEmpty((String)this.p_NewEMailConfirm)) {
                throw new IllegalArgumentException("@NewEmailConfirmMandatory@");
            }
            if (!this.p_NewEMailUserPW.equals(this.p_NewEMailConfirm)) {
                throw new IllegalArgumentException("@NewEmailNotMatch@");
            }
        }
        if (!Util.isEmpty((String)this.p_NewPassword)) {
            user.set_ValueOfColumn("Password", (Object)this.p_NewPassword);
        }
        if (!Util.isEmpty((String)this.p_NewEMail)) {
            user.setEMail(this.p_NewEMail);
        }
        if (!Util.isEmpty((String)this.p_NewEMailUser)) {
            user.setEMailUser(this.p_NewEMailUser);
        }
        if (!Util.isEmpty((String)this.p_NewEMailUserPW)) {
            user.setEMailUserPW(this.p_NewEMailUserPW);
        }
        user.saveEx();
        return "OK";
    }
}

