/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MProcessPara;
import org.compiere.model.MRfQ;
import org.compiere.model.MRfQLine;
import org.compiere.model.MRfQLineQty;
import org.compiere.model.MRfQResponse;
import org.compiere.model.MRfQResponseLine;
import org.compiere.model.MRfQResponseLineQty;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Msg;

@Process
public class RfQResponseRank
extends SvrProcess {
    private int p_C_RfQ_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            if (para[i].getParameter() != null) {
                MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
            }
            ++i;
        }
        this.p_C_RfQ_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        String error;
        MRfQ rfq = new MRfQ(this.getCtx(), this.p_C_RfQ_ID, this.get_TrxName());
        if (rfq.get_ID() == 0) {
            throw new IllegalArgumentException("No RfQ found");
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(rfq.toString());
        }
        if ((error = rfq.checkQuoteTotalAmtOnly()) != null && error.length() > 0) {
            throw new Exception(error);
        }
        MRfQResponse[] responses = rfq.getResponses(true, true);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("doIt - #Responses=" + responses.length);
        }
        if (responses.length == 0) {
            throw new IllegalArgumentException("No completed RfQ Responses found");
        }
        if (responses.length == 1) {
            responses[0].setIsSelectedWinner(true);
            responses[0].saveEx();
            return Msg.getMsg((Properties)Env.getCtx(), (String)"OnlyOneRfQResponse");
        }
        if (rfq.isQuoteTotalAmtOnly()) {
            this.rankResponses(rfq, responses);
        } else {
            this.rankLines(rfq, responses);
        }
        StringBuilder msgreturn = new StringBuilder("# ").append(responses.length);
        return msgreturn.toString();
    }

    private void rankLines(MRfQ rfq, MRfQResponse[] responses) {
        MRfQLine[] rfqLines = rfq.getLines();
        if (rfqLines.length == 0) {
            throw new IllegalArgumentException("No RfQ Lines found");
        }
        int i = 0;
        while (i < rfqLines.length) {
            MRfQLine rfqLine = rfqLines[i];
            if (rfqLine.isActive()) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("rankLines - " + rfqLine);
                }
                MRfQLineQty[] rfqQtys = rfqLine.getQtys();
                int j = 0;
                while (j < rfqQtys.length) {
                    MRfQLineQty rfqQty = rfqQtys[j];
                    if (rfqQty.isActive() && rfqQty.isRfQQty()) {
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.fine("rankLines Qty - " + rfqQty);
                        }
                        MRfQResponseLineQty[] respQtys = rfqQty.getResponseQtys(false);
                        int kk = 0;
                        while (kk < respQtys.length) {
                            MRfQResponseLineQty respQty = respQtys[kk];
                            if (!respQty.isActive() || !respQty.isValidAmt()) {
                                respQty.setRanking(999);
                                respQty.saveEx();
                                if (this.log.isLoggable(Level.FINE)) {
                                    this.log.fine("  - ignored: " + respQty);
                                }
                            }
                            ++kk;
                        }
                        respQtys = rfqQty.getResponseQtys(false);
                        if (respQtys.length == 0) {
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.fine("  - No Qtys with valid Amounts");
                            }
                        } else {
                            Arrays.sort(respQtys, respQtys[0]);
                            int lastRank = 1;
                            BigDecimal lastAmt = Env.ZERO;
                            int rank = 0;
                            int k = 0;
                            while (k < respQtys.length) {
                                MRfQResponseLineQty qty = respQtys[k];
                                if (qty.isActive() && qty.getRanking() != 999) {
                                    BigDecimal netAmt = qty.getNetAmt();
                                    if (netAmt == null) {
                                        qty.setRanking(999);
                                        qty.saveEx();
                                        if (this.log.isLoggable(Level.FINE)) {
                                            this.log.fine("  - Rank 999: " + qty);
                                        }
                                    } else {
                                        if (lastAmt.compareTo(netAmt) != 0) {
                                            lastRank = rank + 1;
                                            lastAmt = qty.getNetAmt();
                                        }
                                        qty.setRanking(lastRank);
                                        if (this.log.isLoggable(Level.FINE)) {
                                            this.log.fine("  - Rank " + lastRank + ": " + qty);
                                        }
                                        qty.saveEx();
                                        if (rank == 0) {
                                            rfqQty.setBestResponseAmt(qty.getNetAmt());
                                            rfqQty.saveEx();
                                        }
                                        ++rank;
                                    }
                                }
                                ++k;
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        MRfQResponse winner = null;
        int ii = 0;
        while (ii < responses.length) {
            MRfQResponse response = responses[ii];
            if (response.isSelectedWinner()) {
                response.setIsSelectedWinner(false);
            }
            int ranking = 0;
            MRfQResponseLine[] respLines = response.getLines(false);
            int jj = 0;
            while (jj < respLines.length) {
                MRfQResponseLine respLine = respLines[jj];
                if (respLine.isActive()) {
                    if (respLine.isSelectedWinner()) {
                        respLine.setIsSelectedWinner(false);
                    }
                    MRfQResponseLineQty[] respQtys = respLine.getQtys(false);
                    int kk = 0;
                    while (kk < respQtys.length) {
                        MRfQResponseLineQty respQty = respQtys[kk];
                        if (respQty.isActive()) {
                            ranking += respQty.getRanking();
                            if (respQty.getRanking() == 1 && respQty.getRfQLineQty().isPurchaseQty()) {
                                respLine.setIsSelectedWinner(true);
                                break;
                            }
                        }
                        ++kk;
                    }
                    respLine.saveEx();
                }
                ++jj;
            }
            response.setRanking(ranking);
            response.saveEx();
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("- Response Ranking " + ranking + ": " + response);
            }
            if (!rfq.isQuoteSelectedLines()) {
                if (winner == null && ranking > 0) {
                    winner = response;
                }
                if (winner != null && response.getRanking() > 0 && response.getRanking() < winner.getRanking()) {
                    winner = response;
                }
            }
            ++ii;
        }
        if (winner != null) {
            winner.setIsSelectedWinner(true);
            winner.saveEx();
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("- Response Winner: " + winner);
            }
        }
    }

    private void rankResponses(MRfQ rfq, MRfQResponse[] responses) {
        int ranking = 1;
        int ii = 0;
        while (ii < responses.length) {
            MRfQResponse response = responses[ii];
            if (response.getPrice() != null && response.getPrice().compareTo(Env.ZERO) > 0) {
                if (response.isSelectedWinner() != (ranking == 1)) {
                    response.setIsSelectedWinner(ranking == 1);
                }
                response.setRanking(ranking);
                ++ranking;
            } else {
                response.setRanking(999);
                if (response.isSelectedWinner()) {
                    response.setIsSelectedWinner(false);
                }
            }
            response.saveEx();
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("rankResponse - " + response);
            }
            ++ii;
        }
    }
}

