/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.adempiere.base.annotation.Process;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MConversionType;
import org.compiere.model.MDocType;
import org.compiere.model.MGLCategory;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MJournal;
import org.compiere.model.MJournalLine;
import org.compiere.model.MOrg;
import org.compiere.model.MProcessPara;
import org.compiere.model.MRevenueRecognitionRun;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Util;

@Process
public class RevenueRecognition
extends SvrProcess {
    private Timestamp p_Date = null;
    private int p_C_DocType_ID = 0;
    private int p_C_RevenueRecognition_ID = 0;
    private int cntDocs = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_RevenueRecognition_ID")) {
                    this.p_C_RevenueRecognition_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("DateAcct")) {
                    this.p_Date = (Timestamp)para[i].getParameter();
                } else if (name.equals("C_DocType_ID")) {
                    this.p_C_DocType_ID = para[i].getParameterAsInt();
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
        if (this.p_Date == null) {
            this.p_Date = new Timestamp(System.currentTimeMillis());
        }
    }

    protected String doIt() throws Exception {
        MAcctSchema[] schemas;
        MAcctSchema[] mAcctSchemaArray = schemas = MAcctSchema.getClientAcctSchema((Properties)this.getCtx(), (int)this.getAD_Client_ID());
        int n = schemas.length;
        int n2 = 0;
        while (n2 < n) {
            MAcctSchema schema = mAcctSchemaArray[n2];
            this.createGLJournal(schema);
            ++n2;
        }
        return "@OK@ #" + this.cntDocs;
    }

    private void createGLJournal(MAcctSchema as) {
        MDocType docType = MDocType.get((Properties)this.getCtx(), (int)this.p_C_DocType_ID);
        MGLCategory cat = MGLCategory.get((Properties)this.getCtx(), (int)docType.getGL_Category_ID());
        MJournal journal = null;
        BigDecimal drTotal = Env.ZERO;
        BigDecimal crTotal = Env.ZERO;
        String where = "DateRecognized IS NOT NULL AND DateRecognized <= ? AND GL_Journal_ID IS NULL  AND (SELECT rp.C_AcctSchema_ID FROM C_RevenueRecognition_Plan rp WHERE rp.C_RevenueRecognition_Plan_ID=C_RevenueRecognition_Run.C_RevenueRecognition_Plan_ID) = ?  AND EXISTS (SELECT * \tFROM C_RevenueRecognition_Plan rp \tWHERE rp.C_RevenueRecognition_Plan_ID=C_RevenueRecognition_Run.C_RevenueRecognition_Plan_ID  AND rp.C_RevenueRecognition_ID = ? OR 0 = ?) ";
        Query query = new Query(this.getCtx(), "C_RevenueRecognition_Run", where, this.get_TrxName());
        query.setParameters(new Object[]{this.p_Date, as.getC_AcctSchema_ID(), this.p_C_RevenueRecognition_ID, this.p_C_RevenueRecognition_ID});
        query.setOrderBy("C_RevenueRecognition_Run_ID");
        List list = query.list();
        int lineNo = 1;
        for (MRevenueRecognitionRun run : list) {
            if (run.getRecognizedAmt().signum() == 0) continue;
            if (journal == null) {
                journal = new MJournal(this.getCtx(), 0, this.get_TrxName());
                journal.setDescription(this.getName());
                journal.setC_DocType_ID(this.p_C_DocType_ID);
                journal.setDateDoc(this.p_Date);
                journal.setDateAcct(this.p_Date);
                if (journal.getC_Period_ID() == 0) {
                    throw new AdempiereException("@PeriodNotFound@");
                }
                journal.setC_Currency_ID(as.getC_Currency_ID());
                journal.setC_AcctSchema_ID(as.getC_AcctSchema_ID());
                journal.setC_Currency_ID(as.getC_Currency_ID());
                journal.setC_ConversionType_ID(MConversionType.getDefault((int)this.getAD_Client_ID()));
                MOrg org = MOrg.get((Properties)this.getCtx(), (int)run.getAD_Org_ID());
                journal.setAD_Org_ID(run.getAD_Org_ID());
                journal.setDescription(String.valueOf(this.getName()) + " - " + org.getName());
                journal.setGL_Category_ID(cat.getGL_Category_ID());
                journal.saveEx();
                ++this.cntDocs;
                this.addBufferLog(journal.getGL_Journal_ID(), journal.getDateAcct(), null, String.valueOf(docType.getName()) + " " + journal.getDocumentNo(), 224, journal.getGL_Journal_ID());
            }
            MInvoiceLine il = (MInvoiceLine)run.getC_RevenueRecognition_Plan().getC_InvoiceLine();
            MInvoice inv = il.getParent();
            String description = String.valueOf(inv.getDocumentInfo()) + " (" + il.getLine() + ")";
            if (!Util.isEmpty((String)il.getDescription())) {
                description = String.valueOf(description) + " " + il.getDescription();
            }
            MJournalLine line = new MJournalLine(journal);
            line.setLine(lineNo++ * 10);
            line.setDescription(description);
            line.setC_ValidCombination_ID(run.getC_RevenueRecognition_Plan().getP_Revenue_Acct());
            BigDecimal amtReval = run.getRecognizedAmt();
            BigDecimal dr = amtReval.compareTo(Env.ZERO) > 0 ? amtReval : Env.ZERO;
            BigDecimal cr = amtReval.compareTo(Env.ZERO) < 0 ? amtReval.negate() : Env.ZERO;
            drTotal = drTotal.add(dr);
            crTotal = crTotal.add(cr);
            line.setAmtSourceDr(dr);
            line.setAmtAcctDr(dr);
            line.setAmtSourceCr(cr);
            line.setAmtAcctCr(cr);
            line.saveEx();
            MJournalLine drline = new MJournalLine(journal);
            drline.setLine(lineNo++ * 10);
            drline.setDescription(description);
            drline.setC_ValidCombination_ID(run.getC_RevenueRecognition_Plan().getUnEarnedRevenue_Acct());
            dr = amtReval.compareTo(Env.ZERO) < 0 ? amtReval.negate() : Env.ZERO;
            cr = amtReval.compareTo(Env.ZERO) > 0 ? amtReval : Env.ZERO;
            drTotal = drTotal.add(dr);
            crTotal = crTotal.add(cr);
            drline.setAmtSourceDr(dr);
            drline.setAmtAcctDr(dr);
            drline.setAmtSourceCr(cr);
            drline.setAmtAcctCr(cr);
            drline.saveEx();
            run.setGL_Journal_ID(journal.getGL_Journal_ID());
            run.saveEx();
        }
    }
}

