/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import org.adempiere.base.annotation.Process;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAttachment;
import org.compiere.model.MColumn;
import org.compiere.model.MProcessPara;
import org.compiere.model.MRequest;
import org.compiere.model.MRequestType;
import org.compiere.model.MUser;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.EmailSrv;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

@Process
public class RequestEMailProcessor
extends SvrProcess
implements EmailSrv.ProcessEmailHandle {
    protected String p_IMAPHost = null;
    protected int p_IMAPPort = 143;
    protected String p_IMAPUser = null;
    protected String p_IMAPPwd = null;
    protected String p_RequestFolder = null;
    protected String p_InboxFolder = null;
    protected Boolean p_NestInbox = true;
    protected String p_ErrorFolder = null;
    protected Boolean isSSL = null;
    protected int C_BPartner_ID = 0;
    protected int AD_User_ID = 0;
    protected int AD_Role_ID = 0;
    protected int SalesRep_ID = 0;
    protected int R_RequestType_ID = 0;
    protected String p_DefaultPriority = null;
    protected String p_DefaultConfidentiality = null;
    protected String p_HTMLAttachmentType = "H";
    protected int noProcessed = 0;
    protected int noRequest = 0;
    protected int noError = 0;
    protected Session m_session = null;
    protected Store m_store = null;
    protected static final int ERROR = 0;
    protected static final int REQUEST = 1;
    protected Folder errorFolder;
    protected Folder requestFolder;
    protected List<Folder> lsFolderProcess = new ArrayList<Folder>();

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("p_IMAPHost")) {
                    this.p_IMAPHost = (String)para[i].getParameter();
                } else if (name.equals("p_IMAPUser")) {
                    this.p_IMAPUser = (String)para[i].getParameter();
                } else if (name.equals("p_IMAPPwd")) {
                    this.p_IMAPPwd = (String)para[i].getParameter();
                } else if (name.equals("p_RequestFolder")) {
                    this.p_RequestFolder = (String)para[i].getParameter();
                } else if (name.equals("p_InboxFolder")) {
                    this.p_InboxFolder = (String)para[i].getParameter();
                } else if (name.equals("p_ErrorFolder")) {
                    this.p_ErrorFolder = (String)para[i].getParameter();
                } else if (name.equals("C_BPartner_ID")) {
                    this.C_BPartner_ID = para[i].getParameterAsInt();
                } else if (name.equals("AD_User_ID")) {
                    this.AD_User_ID = para[i].getParameterAsInt();
                } else if (name.equals("AD_Role_ID")) {
                    this.AD_Role_ID = para[i].getParameterAsInt();
                } else if (name.equals("SalesRep_ID")) {
                    this.SalesRep_ID = para[i].getParameterAsInt();
                } else if (name.equals("R_RequestType_ID")) {
                    this.R_RequestType_ID = para[i].getParameterAsInt();
                } else if (name.equals("p_DefaultPriority")) {
                    this.p_DefaultPriority = (String)para[i].getParameter();
                } else if (name.equals("p_DefaultConfidentiality")) {
                    this.p_DefaultConfidentiality = (String)para[i].getParameter();
                } else if (name.equals("p_NestInbox")) {
                    this.p_NestInbox = "Y".equalsIgnoreCase(para[i].getParameter().toString());
                } else if (name.equals("HTMLAttachmentType")) {
                    this.p_HTMLAttachmentType = para[i].getParameterAsString();
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
        if (this.p_HTMLAttachmentType == null) {
            this.p_HTMLAttachmentType = "H";
        }
    }

    protected String doIt() throws Exception {
        this.parseParameter();
        EmailSrv emailSrv = new EmailSrv(this.p_IMAPHost, this.p_IMAPUser, this.p_IMAPPwd, this.p_IMAPPort, this.isSSL);
        this.checkInputParameter(emailSrv);
        EmailSrv.readEmailFolder((EmailSrv)emailSrv, (String)this.p_InboxFolder, (Boolean)this.p_NestInbox, (EmailSrv.ProcessEmailHandle)this);
        StringBuilder msgreturn = new StringBuilder("processInBox - Total=").append(this.noProcessed).append(" - Requests=").append(this.noRequest).append(" - Errors=").append(this.noError);
        return msgreturn.toString();
    }

    protected void parseParameter() {
        int portStartIndex;
        int imapProtocolIndex = this.p_IMAPHost.lastIndexOf("://");
        if (imapProtocolIndex > 0) {
            String str_Protocol = this.p_IMAPHost.substring(0, imapProtocolIndex);
            if (str_Protocol.toLowerCase().equals("imaps")) {
                this.isSSL = true;
            } else if (str_Protocol.toLowerCase().equals("imap")) {
                this.isSSL = false;
            } else {
                this.log.warning("Unrecognized protocol - " + str_Protocol);
            }
            if (this.isSSL != null) {
                this.p_IMAPHost = this.p_IMAPHost.substring(imapProtocolIndex + 3, this.p_IMAPHost.length());
            }
        }
        if ((portStartIndex = this.p_IMAPHost.lastIndexOf(":")) > 0) {
            String strPort = this.p_IMAPHost.substring(portStartIndex + 1, this.p_IMAPHost.length());
            this.p_IMAPHost = this.p_IMAPHost.substring(0, portStartIndex);
            try {
                this.p_IMAPPort = Integer.parseInt(strPort);
            }
            catch (Exception ex) {
                throw new AdempiereException("Error format port : " + strPort);
            }
        } else if (this.p_IMAPHost.startsWith("imap.gmail.com")) {
            this.p_IMAPPort = 993;
        } else if (portStartIndex <= 0 && this.isSSL != null && this.isSSL.booleanValue()) {
            this.p_IMAPPort = 993;
        }
    }

    protected void checkInputParameter(EmailSrv emailSrv) throws MessagingException, Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("doIt - IMAPHost=" + this.p_IMAPHost + " IMAPPort=" + this.p_IMAPPort + " IMAPUser=" + this.p_IMAPUser + " RequestFolder=" + this.p_RequestFolder + " InboxFolder=" + this.p_InboxFolder + " ErrorFolder=" + this.p_ErrorFolder);
        }
        if (this.R_RequestType_ID < 1 && MRequestType.getDefault((Properties)this.getCtx()) == null) {
            throw new AdempiereException("request type: must define a default request type, or select one in request type field");
        }
        this.requestFolder = EmailSrv.getFolder((Store)emailSrv.getMailStore(), (String)this.p_RequestFolder, (Boolean)this.p_NestInbox, (boolean)true);
        this.errorFolder = EmailSrv.getFolder((Store)emailSrv.getMailStore(), (String)this.p_ErrorFolder, (Boolean)this.p_NestInbox, (boolean)true);
        this.lsFolderProcess.add(this.requestFolder);
        this.lsFolderProcess.add(this.errorFolder);
    }

    public boolean checkEmailHeader(EmailSrv.EmailContent emailHeader, Message emailRaw) throws MessagingException {
        boolean isCancel;
        boolean bl = isCancel = emailHeader.fromAddress.size() == 0;
        if (isCancel) {
            this.errorFolder.appendMessages(new Message[]{emailRaw});
            ++this.noError;
        }
        return isCancel;
    }

    public void processEmailContent(EmailSrv.EmailContent emailHeader, Message emailRaw, Store mailStore, Folder mailFolder) throws MessagingException, IOException {
        Trx trxRequest = null;
        try {
            try {
                trxRequest = Trx.get((String)Trx.createTrxName((String)"SvrProcess-makerequest"), (boolean)true);
                trxRequest.setDisplayName(String.valueOf(((Object)((Object)this)).getClass().getName()) + "_processEmailContent");
                trxRequest.start();
                this.createRequest(emailHeader, trxRequest.getTrxName());
                emailRaw.setFlag(Flags.Flag.SEEN, true);
                emailRaw.setFlag(Flags.Flag.ANSWERED, true);
                this.requestFolder.appendMessages(new Message[]{emailRaw});
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("message " + emailHeader.subject + " moved to " + this.p_RequestFolder + " folder");
                }
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("message info: Sent -> " + emailHeader.sentDate + " From -> " + ((String)emailHeader.fromAddress.get(0)).toString());
                }
                emailRaw.setFlag(Flags.Flag.DELETED, true);
                Message[] deleted = mailFolder.expunge();
                ++this.noRequest;
                trxRequest.commit(true);
            }
            catch (Exception e) {
                trxRequest.rollback();
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("message " + emailHeader.subject + " threw error");
                }
                e.printStackTrace();
                if (e instanceof AdempiereException) {
                    throw (AdempiereException)e;
                }
                if (e instanceof MessagingException) {
                    throw (MessagingException)e;
                }
                throw new AdempiereException(e.getMessage());
            }
        }
        finally {
            if (trxRequest != null) {
                trxRequest.close();
                trxRequest = null;
            }
        }
    }

    protected void createRequest(EmailSrv.EmailContent emailContent, String trxName) throws Exception {
        ArrayList imagesList;
        MUser us;
        String fromAddress = (String)emailContent.fromAddress.get(0);
        int maxlen = MColumn.get((Properties)this.getCtx(), (String)"R_Request", (String)"DocumentNo").getFieldLength();
        String documentNo = emailContent.messageID;
        if (documentNo.length() > maxlen) {
            documentNo = documentNo.substring(0, 30);
        }
        int retValuedup = 0;
        String sqldup = "SELECT R_Request_ID FROM R_Request WHERE AD_Client_ID = ? AND DocumentNo = ? AND StartDate = ?";
        CPreparedStatement pstmtdup = null;
        ResultSet rsdup = null;
        try {
            pstmtdup = DB.prepareStatement((String)sqldup, null);
            pstmtdup.setInt(1, this.getAD_Client_ID());
            pstmtdup.setString(2, documentNo);
            pstmtdup.setTimestamp(3, new Timestamp(emailContent.sentDate.getTime()));
            rsdup = pstmtdup.executeQuery();
            if (rsdup.next()) {
                retValuedup = rsdup.getInt(1);
            }
        }
        catch (Throwable throwable) {
            DB.close(rsdup, (Statement)pstmtdup);
            rsdup = null;
            pstmtdup = null;
            throw throwable;
        }
        DB.close((ResultSet)rsdup, (Statement)pstmtdup);
        rsdup = null;
        pstmtdup = null;
        if (retValuedup > 0) {
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("request already existed for msg -> " + emailContent.subject);
            }
            return;
        }
        int request_upd = 0;
        String sqlupd = "SELECT r_request_id   FROM r_request  WHERE ad_client_id = ?    AND summary LIKE 'FROM: ' || ? || '%'    AND (   documentno =               SUBSTR                  (?,                   INSTR                       (?,                        '<'                       )                  )         OR (    ? LIKE 'Re: %'             AND summary =                       'FROM: '                    || ?                    || CHR (10)                    || SUBSTR (?, 5)            )        ) ";
        CPreparedStatement pstmtupd = null;
        ResultSet rsupd = null;
        try {
            pstmtupd = DB.prepareStatement((String)sqlupd, null);
            pstmtupd.setInt(1, this.getAD_Client_ID());
            pstmtupd.setString(2, fromAddress);
            pstmtupd.setString(3, emailContent.subject);
            pstmtupd.setString(4, emailContent.subject);
            pstmtupd.setString(5, emailContent.subject);
            pstmtupd.setString(6, fromAddress);
            pstmtupd.setString(7, emailContent.subject);
            rsupd = pstmtupd.executeQuery();
            if (rsupd.next()) {
                request_upd = rsupd.getInt(1);
            }
        }
        catch (Throwable throwable) {
            DB.close(rsupd, (Statement)pstmtupd);
            rsupd = null;
            pstmtupd = null;
            throw throwable;
        }
        DB.close((ResultSet)rsupd, (Statement)pstmtupd);
        rsupd = null;
        pstmtupd = null;
        if (request_upd > 0) {
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("msg -> " + emailContent.subject + " is an answer for req " + request_upd);
            }
            this.updateRequest(request_upd, emailContent, trxName);
            return;
        }
        MRequest req = new MRequest(this.getCtx(), 0, trxName);
        StringBuilder msgreq = new StringBuilder("FROM: ").append(fromAddress).append("\n").append(emailContent.subject);
        req.setSummary(msgreq.toString());
        msgreq = new StringBuilder("FROM: ").append((String)emailContent.fromAddress.get(0)).append("\n").append(emailContent.getTextContent());
        req.setResult(msgreq.toString());
        req.setDocumentNo(documentNo);
        if (this.R_RequestType_ID > 0) {
            req.setR_RequestType_ID(this.R_RequestType_ID);
        } else {
            req.setR_RequestType_ID();
        }
        if (this.SalesRep_ID > 0) {
            req.setSalesRep_ID(this.SalesRep_ID);
        }
        if (this.AD_Role_ID > 0) {
            req.setAD_Role_ID(this.AD_Role_ID);
        }
        int retValueu = -1;
        String sqlu = "SELECT ad_user_id   FROM ad_user  WHERE UPPER (email) = UPPER (?)    AND ad_client_id = ?";
        CPreparedStatement pstmtu = null;
        ResultSet rsu = null;
        try {
            pstmtu = DB.prepareStatement((String)sqlu, null);
            pstmtu.setString(1, fromAddress);
            pstmtu.setInt(2, this.getAD_Client_ID());
            rsu = pstmtu.executeQuery();
            if (rsu.next()) {
                retValueu = rsu.getInt(1);
            }
        }
        catch (Throwable throwable) {
            DB.close(rsu, (Statement)pstmtu);
            rsu = null;
            pstmtu = null;
            throw throwable;
        }
        DB.close((ResultSet)rsu, (Statement)pstmtu);
        rsu = null;
        pstmtu = null;
        if (retValueu > 0) {
            req.setAD_User_ID(retValueu);
        } else if (this.AD_User_ID > 0) {
            req.setAD_User_ID(this.AD_User_ID);
        }
        if (req.getAD_User_ID() > 0 && (us = new MUser(this.getCtx(), req.getAD_User_ID(), trxName)).getC_BPartner_ID() > 0) {
            req.setC_BPartner_ID(us.getC_BPartner_ID());
        }
        if (req.getC_BPartner_ID() <= 0 && this.C_BPartner_ID > 0) {
            req.setC_BPartner_ID(this.C_BPartner_ID);
        }
        req.setStartDate(new Timestamp(emailContent.sentDate.getTime()));
        if (this.p_DefaultConfidentiality != null) {
            req.setConfidentialType(this.p_DefaultConfidentiality);
            req.setConfidentialTypeEntry(this.p_DefaultConfidentiality);
        }
        if (this.p_DefaultPriority != null) {
            req.setPriority(this.p_DefaultPriority);
            req.setPriorityUser(this.p_DefaultPriority);
        }
        req.saveEx(trxName);
        this.addLog(req.getR_Request_ID(), null, null, String.valueOf(Msg.parseTranslation((Properties)this.getCtx(), (String)"@Added@ @R_Request_ID@ ")) + req.getDocumentNo(), 417, req.getR_Request_ID());
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("created request " + req.getR_Request_ID() + " from msg -> " + emailContent.subject);
        }
        if ("H".equals(this.p_HTMLAttachmentType)) {
            String htmlContent = emailContent.getHtmlContent(true);
            if (htmlContent != null) {
                MAttachment attach = req.createAttachment();
                attach.addEntry(String.valueOf(emailContent.subject) + ".html", emailContent.getHtmlContent(true).getBytes(Charset.forName("UTF-8")));
                attach.saveEx(trxName);
            }
        } else if ("I".equals(this.p_HTMLAttachmentType) && (imagesList = emailContent.getHTMLImageBodyParts()) != null) {
            for (BodyPart image : imagesList) {
                MAttachment attach = req.createAttachment();
                attach.addEntry(image.getFileName(), EmailSrv.getBinaryData((Part)image));
                attach.saveEx(trxName);
            }
        }
        for (BodyPart attachFile : emailContent.lsAttachPart) {
            MAttachment attach = req.createAttachment();
            attach.addEntry(attachFile.getFileName(), EmailSrv.getBinaryData((Part)attachFile));
            attach.saveEx(trxName);
        }
    }

    protected void updateRequest(int request_upd, EmailSrv.EmailContent emailContent, String trxName) throws MessagingException, SQLException {
        MRequest requp = new MRequest(this.getCtx(), request_upd, trxName);
        StringBuilder msgreq = new StringBuilder("FROM: ").append((String)emailContent.fromAddress.get(0)).append("\n").append(emailContent.getTextContent());
        requp.setResult(msgreq.toString());
        requp.saveEx(trxName);
        this.addLog(requp.getR_Request_ID(), null, null, String.valueOf(Msg.parseTranslation((Properties)this.getCtx(), (String)"@Updated@ @R_Request_ID@ ")) + requp.getDocumentNo(), 417, requp.getR_Request_ID());
    }

    public void processEmailError(EmailSrv.EmailContent emailHeader, Message emailRaw, Store mailStore, Folder mailFolder) throws MessagingException {
        ++this.noError;
        this.errorFolder.appendMessages(new Message[]{emailRaw});
    }

    public List<Folder> getListFolder() {
        return this.lsFolderProcess;
    }
}

