/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProcessPara;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.model.MProjectPhase;
import org.compiere.model.MProjectTask;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.ProjectGenOrder;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;

@Process
public class ProjectPhaseGenOrder
extends SvrProcess {
    private int m_C_ProjectPhase_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            if (para[i].getParameter() != null) {
                MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        this.m_C_ProjectPhase_ID = this.getRecord_ID();
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("doIt - C_ProjectPhase_ID=" + this.m_C_ProjectPhase_ID);
        }
        if (this.m_C_ProjectPhase_ID == 0) {
            throw new IllegalArgumentException("C_ProjectPhase_ID == 0");
        }
        MProjectPhase fromPhase = new MProjectPhase(this.getCtx(), this.m_C_ProjectPhase_ID, this.get_TrxName());
        MProject fromProject = ProjectGenOrder.getProject(this.getCtx(), fromPhase.getC_Project_ID(), this.get_TrxName());
        MOrder order = new MOrder(fromProject, true, "WI");
        order.setDescription(String.valueOf(order.getDescription()) + " - " + fromPhase.getName());
        if (!order.save()) {
            throw new Exception("Could not create Order");
        }
        if (fromPhase.getM_Product_ID() != 0) {
            MOrderLine ol = new MOrderLine(order);
            ol.setLine(fromPhase.getSeqNo());
            StringBuilder sb = new StringBuilder().append(fromPhase.getName());
            if (fromPhase.getDescription() != null && fromPhase.getDescription().length() > 0) {
                sb.append(" - ").append(fromPhase.getDescription());
            }
            ol.setDescription(sb.toString());
            ol.setM_Product_ID(fromPhase.getM_Product_ID(), true);
            ol.setQty(fromPhase.getQty());
            ol.setPrice();
            if (fromPhase.getPriceActual() != null && fromPhase.getPriceActual().compareTo(Env.ZERO) != 0) {
                ol.setPrice(fromPhase.getPriceActual());
            }
            ol.setTax();
            if (!ol.save()) {
                this.log.log(Level.SEVERE, "doIt - Lines not generated");
            }
            StringBuilder msgreturn = new StringBuilder("@C_Order_ID@ ").append(order.getDocumentNo()).append(" (1)");
            return msgreturn.toString();
        }
        int count = 0;
        MProjectLine[] lines = fromPhase.getLines();
        int i = 0;
        while (i < lines.length) {
            MOrderLine ol = new MOrderLine(order);
            ol.setLine(lines[i].getLine());
            ol.setDescription(lines[i].getDescription());
            ol.setM_Product_ID(lines[i].getM_Product_ID(), true);
            ol.setQty(lines[i].getPlannedQty().subtract(lines[i].getInvoicedQty()));
            ol.setPrice();
            if (lines[i].getPlannedPrice() != null && lines[i].getPlannedPrice().compareTo(Env.ZERO) != 0) {
                ol.setPrice(lines[i].getPlannedPrice());
            }
            ol.setDiscount();
            ol.setTax();
            if (ol.save()) {
                ++count;
            }
            ++i;
        }
        if (lines.length != count) {
            this.log.log(Level.SEVERE, "Lines difference - ProjectLines=" + lines.length + " <> Saved=" + count);
        }
        MProjectTask[] tasks = fromPhase.getTasks();
        int i2 = 0;
        while (i2 < tasks.length) {
            MOrderLine ol = new MOrderLine(order);
            ol.setLine(tasks[i2].getSeqNo());
            StringBuilder sb = new StringBuilder().append(tasks[i2].getName());
            if (tasks[i2].getDescription() != null && tasks[i2].getDescription().length() > 0) {
                sb.append(" - ").append(tasks[i2].getDescription());
            }
            ol.setDescription(sb.toString());
            ol.setM_Product_ID(tasks[i2].getM_Product_ID(), true);
            ol.setQty(tasks[i2].getQty());
            ol.setPrice();
            ol.setTax();
            if (ol.save()) {
                ++count;
            }
            ++i2;
        }
        if (tasks.length != count - lines.length) {
            this.log.log(Level.SEVERE, "doIt - Lines difference - ProjectTasks=" + tasks.length + " <> Saved=" + count);
        }
        StringBuilder msgreturn = new StringBuilder("@C_Order_ID@ ").append(order.getDocumentNo()).append(" (").append(count).append(")");
        return msgreturn.toString();
    }
}

