/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MProcessPara;
import org.compiere.model.MProject;
import org.compiere.model.MProjectIssue;
import org.compiere.model.MProjectLine;
import org.compiere.model.MStorageOnHand;
import org.compiere.model.MTimeExpense;
import org.compiere.model.MTimeExpenseLine;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.wf.MWorkflow;

@Process
public class ProjectIssue
extends SvrProcess {
    private int m_C_Project_ID = 0;
    private int m_M_InOut_ID = 0;
    private int m_S_TimeExpense_ID = 0;
    private int m_M_Locator_ID = 0;
    private int m_C_ProjectLine_ID = 0;
    private int m_M_Product_ID = 0;
    private int m_M_AttributeSetInstance_ID = 0;
    private BigDecimal m_MovementQty = null;
    private Timestamp m_MovementDate = null;
    private String m_Description = null;
    private MProject m_project = null;
    private MProjectIssue[] m_projectIssues = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_Project_ID")) {
                    this.m_C_Project_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("M_InOut_ID")) {
                    this.m_M_InOut_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("S_TimeExpense_ID")) {
                    this.m_S_TimeExpense_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("M_Locator_ID")) {
                    this.m_M_Locator_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("C_ProjectLine_ID")) {
                    this.m_C_ProjectLine_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("M_Product_ID")) {
                    this.m_M_Product_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("M_AttributeSetInstance_ID")) {
                    this.m_M_AttributeSetInstance_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("MovementQty")) {
                    this.m_MovementQty = (BigDecimal)para[i].getParameter();
                } else if (name.equals("MovementDate")) {
                    this.m_MovementDate = (Timestamp)para[i].getParameter();
                } else if (name.equals("Description")) {
                    this.m_Description = (String)para[i].getParameter();
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        this.m_project = new MProject(this.getCtx(), this.m_C_Project_ID, this.get_TrxName());
        if (!"W".equals(this.m_project.getProjectCategory()) && !"A".equals(this.m_project.getProjectCategory())) {
            throw new IllegalArgumentException("Project not Work Order or Asset =" + this.m_project.getProjectCategory());
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.m_project.toString());
        }
        if (this.m_M_InOut_ID != 0) {
            return this.issueReceipt();
        }
        if (this.m_S_TimeExpense_ID != 0) {
            return this.issueExpense();
        }
        if (this.m_M_Locator_ID == 0) {
            throw new IllegalArgumentException("Locator missing");
        }
        if (this.m_C_ProjectLine_ID != 0) {
            return this.issueProjectLine();
        }
        return this.issueInventory();
    }

    private String issueReceipt() {
        MInOut inOut = new MInOut(this.getCtx(), this.m_M_InOut_ID, null);
        if (inOut.isSOTrx() || !inOut.isProcessed() || !"CO".equals(inOut.getDocStatus()) && !"CL".equals(inOut.getDocStatus())) {
            throw new IllegalArgumentException("Receipt not valid - " + inOut);
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(inOut.toString());
        }
        if (inOut.getC_Project_ID() == 0) {
            inOut.setC_Project_ID(this.m_project.getC_Project_ID());
            inOut.saveEx();
        } else if (inOut.getC_Project_ID() != this.m_project.getC_Project_ID()) {
            throw new IllegalArgumentException("Receipt for other Project (" + inOut.getC_Project_ID() + ")");
        }
        MInOutLine[] inOutLines = inOut.getLines(false);
        int counter = 0;
        int i = 0;
        while (i < inOutLines.length) {
            if (inOutLines[i].getM_Product_ID() != 0 && inOutLines[i].getMovementQty() != null && inOutLines[i].getMovementQty().signum() != 0 && !this.projectIssueHasReceipt(inOutLines[i].getM_InOutLine_ID())) {
                MProjectIssue pi = new MProjectIssue(this.m_project);
                pi.setMandatory(inOutLines[i].getM_Locator_ID(), inOutLines[i].getM_Product_ID(), inOutLines[i].getMovementQty());
                if (this.m_MovementDate != null) {
                    pi.setMovementDate(this.m_MovementDate);
                }
                if (this.m_Description != null && this.m_Description.length() > 0) {
                    pi.setDescription(this.m_Description);
                } else if (inOutLines[i].getDescription() != null) {
                    pi.setDescription(inOutLines[i].getDescription());
                } else if (inOut.getDescription() != null) {
                    pi.setDescription(inOut.getDescription());
                }
                pi.setM_InOutLine_ID(inOutLines[i].getM_InOutLine_ID());
                pi.saveEx();
                ProcessInfo processInfo = MWorkflow.runDocumentActionWorkflow((PO)pi, (String)"CO");
                if (processInfo.isError()) {
                    throw new RuntimeException(processInfo.getSummary());
                }
                pi.saveEx();
                MProjectLine pl = null;
                MProjectLine[] pls = this.m_project.getLines();
                int ii = 0;
                while (ii < pls.length) {
                    if (pls[ii].getC_OrderPO_ID() == inOut.getC_Order_ID() && pls[ii].getM_Product_ID() == inOutLines[i].getM_Product_ID() && pls[ii].getC_ProjectIssue_ID() == 0) {
                        pl = pls[ii];
                        break;
                    }
                    ++ii;
                }
                if (pl == null) {
                    pl = new MProjectLine(this.m_project);
                }
                pl.setMProjectIssue(pi);
                pl.saveEx();
                this.addLog(pi.getLine(), pi.getMovementDate(), pi.getMovementQty(), null);
                ++counter;
            }
            ++i;
        }
        StringBuilder msgreturn = new StringBuilder("@Created@ ").append(counter);
        return msgreturn.toString();
    }

    private String issueExpense() {
        MTimeExpense expense = new MTimeExpense(this.getCtx(), this.m_S_TimeExpense_ID, this.get_TrxName());
        if (!expense.isProcessed()) {
            throw new IllegalArgumentException("Time+Expense not processed - " + expense);
        }
        MTimeExpenseLine[] expenseLines = expense.getLines(false);
        int counter = 0;
        int i = 0;
        while (i < expenseLines.length) {
            if (expenseLines[i].getM_Product_ID() != 0 && expenseLines[i].getQty() != null && expenseLines[i].getQty().signum() != 0 && expenseLines[i].getC_Project_ID() == this.m_project.getC_Project_ID() && !this.projectIssueHasExpense(expenseLines[i].getS_TimeExpenseLine_ID())) {
                int M_Locator_ID = 0;
                M_Locator_ID = MStorageOnHand.getM_Locator_ID((int)expense.getM_Warehouse_ID(), (int)expenseLines[i].getM_Product_ID(), (int)0, (BigDecimal)expenseLines[i].getQty(), null);
                if (M_Locator_ID == 0) {
                    M_Locator_ID = expense.getM_Locator_ID();
                }
                MProjectIssue pi = new MProjectIssue(this.m_project);
                pi.setMandatory(M_Locator_ID, expenseLines[i].getM_Product_ID(), expenseLines[i].getQty());
                if (this.m_MovementDate != null) {
                    pi.setMovementDate(this.m_MovementDate);
                }
                if (this.m_Description != null && this.m_Description.length() > 0) {
                    pi.setDescription(this.m_Description);
                } else if (expenseLines[i].getDescription() != null) {
                    pi.setDescription(expenseLines[i].getDescription());
                }
                pi.setS_TimeExpenseLine_ID(expenseLines[i].getS_TimeExpenseLine_ID());
                pi.saveEx();
                ProcessInfo processInfo = MWorkflow.runDocumentActionWorkflow((PO)pi, (String)"CO");
                if (processInfo.isError()) {
                    throw new RuntimeException(processInfo.getSummary());
                }
                pi.saveEx();
                MProjectLine pl = new MProjectLine(this.m_project);
                pl.setMProjectIssue(pi);
                pl.saveEx();
                this.addLog(pi.getLine(), pi.getMovementDate(), pi.getMovementQty(), null);
                ++counter;
            }
            ++i;
        }
        StringBuilder msgreturn = new StringBuilder("@Created@ ").append(counter);
        return msgreturn.toString();
    }

    private String issueProjectLine() {
        MProjectLine pl = new MProjectLine(this.getCtx(), this.m_C_ProjectLine_ID, this.get_TrxName());
        if (pl.getM_Product_ID() == 0) {
            throw new IllegalArgumentException("Projet Line has no Product");
        }
        if (pl.getC_ProjectIssue_ID() != 0) {
            throw new IllegalArgumentException("Projet Line already been issued");
        }
        if (this.m_M_Locator_ID == 0) {
            throw new IllegalArgumentException("No Locator");
        }
        if (pl.getPlannedQty() == null || pl.getPlannedQty().signum() == 0) {
            pl.setPlannedQty(Env.ONE);
        }
        MProjectIssue pi = new MProjectIssue(this.m_project);
        pi.setMandatory(this.m_M_Locator_ID, pl.getM_Product_ID(), pl.getPlannedQty());
        if (this.m_MovementDate != null) {
            pi.setMovementDate(this.m_MovementDate);
        }
        if (this.m_Description != null && this.m_Description.length() > 0) {
            pi.setDescription(this.m_Description);
        } else if (pl.getDescription() != null) {
            pi.setDescription(pl.getDescription());
        }
        pi.saveEx();
        ProcessInfo processInfo = MWorkflow.runDocumentActionWorkflow((PO)pi, (String)"CO");
        if (processInfo.isError()) {
            throw new RuntimeException(processInfo.getSummary());
        }
        pi.saveEx();
        pl.setMProjectIssue(pi);
        pl.saveEx();
        this.addLog(pi.getLine(), pi.getMovementDate(), pi.getMovementQty(), null);
        return "@Created@ 1";
    }

    private String issueInventory() {
        if (this.m_M_Locator_ID == 0) {
            throw new IllegalArgumentException("No Locator");
        }
        if (this.m_M_Product_ID == 0) {
            throw new IllegalArgumentException("No Product");
        }
        if (this.m_MovementQty == null || this.m_MovementQty.signum() == 0) {
            this.m_MovementQty = Env.ONE;
        }
        MProjectIssue pi = new MProjectIssue(this.m_project);
        pi.setMandatory(this.m_M_Locator_ID, this.m_M_Product_ID, this.m_MovementQty);
        if (this.m_MovementDate != null) {
            pi.setMovementDate(this.m_MovementDate);
        }
        if (this.m_Description != null && this.m_Description.length() > 0) {
            pi.setDescription(this.m_Description);
        }
        pi.saveEx();
        ProcessInfo processInfo = MWorkflow.runDocumentActionWorkflow((PO)pi, (String)"CO");
        if (processInfo.isError()) {
            throw new RuntimeException(processInfo.getSummary());
        }
        pi.saveEx();
        MProjectLine pl = new MProjectLine(this.m_project);
        pl.setMProjectIssue(pi);
        pl.saveEx();
        this.addLog(pi.getLine(), pi.getMovementDate(), pi.getMovementQty(), null);
        return "@Created@ 1";
    }

    private boolean projectIssueHasExpense(int S_TimeExpenseLine_ID) {
        if (this.m_projectIssues == null) {
            this.m_projectIssues = this.m_project.getIssues();
        }
        int i = 0;
        while (i < this.m_projectIssues.length) {
            if (this.m_projectIssues[i].getS_TimeExpenseLine_ID() == S_TimeExpenseLine_ID && (this.m_projectIssues[i].getDocStatus().equals("CO") || this.m_projectIssues[i].getDocStatus().equals("CL"))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean projectIssueHasReceipt(int M_InOutLine_ID) {
        if (this.m_projectIssues == null) {
            this.m_projectIssues = this.m_project.getIssues();
        }
        int i = 0;
        while (i < this.m_projectIssues.length) {
            if (this.m_projectIssues[i].getM_InOutLine_ID() == M_InOutLine_ID && (this.m_projectIssues[i].getDocStatus().equals("CO") || this.m_projectIssues[i].getDocStatus().equals("CL"))) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

