/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MInvoice;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionLine;
import org.compiere.model.MProcessPara;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;

@Process
public class PaySelectionCreateFrom
extends SvrProcess {
    private boolean p_OnlyDiscount = false;
    private boolean p_OnlyDue = false;
    private boolean p_IncludeInDispute = false;
    private String p_MatchRequirement = "N";
    private String p_PaymentRule = null;
    private int p_C_BPartner_ID = 0;
    private int p_C_BP_Group_ID = 0;
    private int p_C_PaySelection_ID = 0;
    private boolean p_OnlyPositive = false;
    private Timestamp p_DueDate = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("OnlyDiscount")) {
                    this.p_OnlyDiscount = "Y".equals(para[i].getParameter());
                } else if (name.equals("OnlyDue")) {
                    this.p_OnlyDue = "Y".equals(para[i].getParameter());
                } else if (name.equals("IncludeInDispute")) {
                    this.p_IncludeInDispute = "Y".equals(para[i].getParameter());
                } else if (name.equals("MatchRequirement")) {
                    this.p_MatchRequirement = (String)para[i].getParameter();
                } else if (name.equals("PaymentRule")) {
                    this.p_PaymentRule = (String)para[i].getParameter();
                } else if (name.equals("C_BPartner_ID")) {
                    this.p_C_BPartner_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_BP_Group_ID")) {
                    this.p_C_BP_Group_ID = para[i].getParameterAsInt();
                } else if (name.equals("DueDate")) {
                    this.p_DueDate = (Timestamp)para[i].getParameter();
                } else if (name.equals("PositiveBalance")) {
                    this.p_OnlyPositive = "Y".equals(para[i].getParameter());
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
        this.p_C_PaySelection_ID = this.getRecord_ID();
    }

    /*
     * Unable to fully structure code
     */
    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("C_PaySelection_ID=" + this.p_C_PaySelection_ID + ", OnlyDiscount=" + this.p_OnlyDiscount + ", OnlyDue=" + this.p_OnlyDue + ", IncludeInDispute=" + this.p_IncludeInDispute + ", MatchRequirement=" + this.p_MatchRequirement + ", PaymentRule=" + this.p_PaymentRule + ", POsitiveBalancet=" + this.p_OnlyPositive + ", C_BP_Group_ID=" + this.p_C_BP_Group_ID + ", C_BPartner_ID=" + this.p_C_BPartner_ID);
        }
        if ((psel = new MPaySelection(this.getCtx(), this.p_C_PaySelection_ID, this.get_TrxName())).get_ID() == 0) {
            throw new IllegalArgumentException("Not found C_PaySelection_ID=" + this.p_C_PaySelection_ID);
        }
        if (psel.isProcessed()) {
            throw new IllegalArgumentException("@Processed@");
        }
        if (this.p_DueDate == null) {
            this.p_DueDate = psel.getPayDate();
        }
        sql = new StringBuilder("SELECT C_Invoice_ID,").append(" currencyConvertInvoice(i.C_Invoice_ID").append(",?,invoiceOpen(i.C_Invoice_ID, i.C_InvoicePaySchedule_ID), ?) AS PayAmt,").append(" currencyConvertInvoice(i.C_Invoice_ID").append(",?,invoiceDiscount(i.C_Invoice_ID,?,i.C_InvoicePaySchedule_ID),?) AS DiscountAmt,").append(" PaymentRule, IsSOTrx, ").append(" currencyConvert(invoiceWriteOff(i.C_Invoice_ID) ").append(",i.C_Currency_ID, ?,?,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID) AS WriteOffAmt ").append("FROM C_Invoice_v i ");
        sqlWhere = new StringBuilder("WHERE ");
        if ("D".equals(this.p_PaymentRule)) {
            sqlWhere.append("i.IsSOTrx='Y'");
        } else {
            sqlWhere.append("i.IsSOTrx='N'");
        }
        sqlWhere.append(" AND i.IsPaid='N' AND i.DocStatus IN ('CO','CL')").append(" AND i.AD_Client_ID=?").append(" AND NOT EXISTS (SELECT * FROM C_PaySelectionLine psl").append(" INNER JOIN C_PaySelectionCheck psc ON (psl.C_PaySelectionCheck_ID=psc.C_PaySelectionCheck_ID)").append(" LEFT OUTER JOIN C_Payment pmt ON (pmt.C_Payment_ID=psc.C_Payment_ID)").append(" WHERE i.C_Invoice_ID=psl.C_Invoice_ID AND psl.IsActive='Y'").append(" AND (pmt.DocStatus IS NULL OR pmt.DocStatus NOT IN ('VO','RE')) )").append(" AND i.C_Invoice_ID NOT IN (SELECT psl.C_Invoice_ID FROM C_PaySelectionLine psl WHERE psl.C_PaySelection_ID=?)");
        if (!this.p_IncludeInDispute) {
            sqlWhere.append(" AND i.IsInDispute='N'");
        }
        if (this.p_PaymentRule != null) {
            sqlWhere.append(" AND i.PaymentRule=?");
        }
        if (this.p_OnlyDiscount) {
            if (this.p_OnlyDue) {
                sqlWhere.append(" AND (");
            } else {
                sqlWhere.append(" AND ");
            }
            sqlWhere.append("invoiceDiscount(i.C_Invoice_ID,?,i.C_InvoicePaySchedule_ID) > 0");
        }
        if (this.p_OnlyDue) {
            if (this.p_OnlyDiscount) {
                sqlWhere.append(" OR ");
            } else {
                sqlWhere.append(" AND ");
            }
            sqlWhere.append("i.DueDate<=?");
            if (this.p_OnlyDiscount) {
                sqlWhere.append(")");
            }
        }
        if (this.p_C_BPartner_ID != 0) {
            sqlWhere.append(" AND i.C_BPartner_ID=?");
        } else if (this.p_C_BP_Group_ID != 0) {
            sqlWhere.append(" AND EXISTS (SELECT * FROM C_BPartner bp ").append("WHERE bp.C_BPartner_ID=i.C_BPartner_ID AND bp.C_BP_Group_ID=?)");
        }
        if (this.p_MatchRequirement.equals("P") || this.p_MatchRequirement.equals("B")) {
            sqlWhere.append(" AND EXISTS (SELECT * FROM C_InvoiceLine il ").append("WHERE i.C_Invoice_ID=il.C_Invoice_ID").append(" AND QtyInvoiced=(SELECT SUM(Qty) FROM M_MatchPO m ").append("WHERE il.C_InvoiceLine_ID=m.C_InvoiceLine_ID))");
        }
        if (this.p_MatchRequirement.equals("R") || this.p_MatchRequirement.equals("B")) {
            sqlWhere.append(" AND EXISTS (SELECT * FROM C_InvoiceLine il ").append("WHERE i.C_Invoice_ID=il.C_Invoice_ID").append(" AND QtyInvoiced=(SELECT SUM(Qty) FROM M_MatchInv m ").append("WHERE il.C_InvoiceLine_ID=m.C_InvoiceLine_ID))");
        }
        if (this.p_OnlyPositive) {
            subWhereClause = sqlWhere.toString();
            subWhereClause = subWhereClause.replaceAll("\\bi\\b", "i1");
            subWhereClause = subWhereClause.replaceAll("\\bpsl\\b", "psl1");
            subWhereClause = subWhereClause.replaceAll("\\bpsc\\b", "psc1");
            subWhereClause = subWhereClause.replaceAll("\\bpmt\\b", "pmt1");
            subWhereClause = subWhereClause.replaceAll("\\bbp\\b", "bp1");
            subWhereClause = subWhereClause.replaceAll("\\bil\\b", "il1");
            onlyPositiveWhere = " AND i.c_bpartner_id NOT IN ( SELECT i1.C_BPartner_ID FROM C_Invoice_v i1 " + subWhereClause.toString() + " GROUP BY i1.C_BPartner_ID" + " HAVING sum(invoiceOpen(i1.C_Invoice_ID, i1.C_InvoicePaySchedule_ID)) <= 0) ";
            sqlWhere.append(onlyPositiveWhere);
        }
        sql.append(sqlWhere.toString());
        lines = 0;
        C_CurrencyTo_ID = psel.getC_Currency_ID();
        try {
            var6_8 = null;
            var7_12 = null;
            try {
                pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                try {
                    index = 1;
                    pstmt.setInt(index++, C_CurrencyTo_ID);
                    pstmt.setTimestamp(index++, psel.getPayDate());
                    pstmt.setInt(index++, C_CurrencyTo_ID);
                    pstmt.setTimestamp(index++, psel.getPayDate());
                    pstmt.setTimestamp(index++, psel.getPayDate());
                    pstmt.setInt(index++, C_CurrencyTo_ID);
                    pstmt.setTimestamp(index++, psel.getPayDate());
                    pstmt.setInt(index++, psel.getAD_Client_ID());
                    pstmt.setInt(index++, this.p_C_PaySelection_ID);
                    if (this.p_PaymentRule != null) {
                        pstmt.setString(index++, this.p_PaymentRule);
                    }
                    if (this.p_OnlyDiscount) {
                        pstmt.setTimestamp(index++, psel.getPayDate());
                    }
                    if (this.p_OnlyDue) {
                        pstmt.setTimestamp(index++, this.p_DueDate);
                    }
                    if (this.p_C_BPartner_ID != 0) {
                        pstmt.setInt(index++, this.p_C_BPartner_ID);
                    } else if (this.p_C_BP_Group_ID != 0) {
                        pstmt.setInt(index++, this.p_C_BP_Group_ID);
                    }
                    if (this.p_OnlyPositive) {
                        pstmt.setInt(index++, psel.getAD_Client_ID());
                        pstmt.setInt(index++, this.p_C_PaySelection_ID);
                        if (this.p_PaymentRule != null) {
                            pstmt.setString(index++, this.p_PaymentRule);
                        }
                        if (this.p_OnlyDiscount) {
                            pstmt.setTimestamp(index++, psel.getPayDate());
                        }
                        if (this.p_OnlyDue) {
                            pstmt.setTimestamp(index++, this.p_DueDate);
                        }
                        if (this.p_C_BPartner_ID != 0) {
                            pstmt.setInt(index++, this.p_C_BPartner_ID);
                        } else if (this.p_C_BP_Group_ID != 0) {
                            pstmt.setInt(index++, this.p_C_BP_Group_ID);
                        }
                    }
                    rs = pstmt.executeQuery();
                    while (true) {
                        C_Invoice_ID = rs.getInt(1);
                        PayAmt = rs.getBigDecimal(2);
                        if (PayAmt == null) {
                            return "@Error@ @PaySelectionPayAmtIsNull@ (" + new MInvoice(this.getCtx(), C_Invoice_ID, this.get_TrxName()).getDocumentInfo() + ")";
                        }
                        if (C_Invoice_ID != 0) {
                            if (Env.ZERO.compareTo(PayAmt) == 0) {
                            }
                            DiscountAmt = rs.getBigDecimal(3);
                            WriteOffAmt = rs.getBigDecimal(6);
                            PaymentRule = rs.getString(4);
                            isSOTrx = "Y".equals(rs.getString(5));
                            pselLine = new MPaySelectionLine(psel, ++lines * 10, PaymentRule);
                            pselLine.setInvoice(C_Invoice_ID, isSOTrx, PayAmt, PayAmt.subtract(DiscountAmt).subtract(WriteOffAmt), DiscountAmt, WriteOffAmt);
                            if (!pselLine.save()) {
                                throw new IllegalStateException("Cannot save MPaySelectionLine");
                            }
                        }
                        break;
                    }
                }
                finally {
                    if (rs.next()) ** continue;
                }
            }
            catch (Throwable var7_13) {
                if (var6_8 == null) {
                    var6_8 = var7_13;
                } else if (var6_8 != var7_13) {
                    var6_8.addSuppressed(var7_13);
                }
                throw var6_8;
            }
        }
        catch (SQLException e) {
            throw new DBException((Exception)e);
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
        msgreturn = new StringBuilder("@C_PaySelectionLine_ID@  - #").append(lines);
        return msgreturn.toString();
    }
}

