/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MBankStatementLoader;
import org.compiere.model.MProcessPara;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Msg;

@Process
public class LoadBankStatement
extends SvrProcess {
    private int m_AD_Client_ID = 0;
    private int m_AD_Org_ID = 0;
    private int m_C_BankStmtLoader_ID = 0;
    private String fileName = "";
    private Properties m_ctx;
    private MBankStatementLoader m_controller = null;

    public LoadBankStatement() {
        this.log.info("LoadBankStatement");
    }

    protected void prepare() {
        this.log.info("");
        this.m_ctx = Env.getCtx();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("C_BankStatementLoader_ID")) {
                this.m_C_BankStmtLoader_ID = ((BigDecimal)para[i].getParameter()).intValue();
            } else if (name.equals("FileName")) {
                this.fileName = (String)para[i].getParameter();
            } else {
                MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
            }
            ++i;
        }
        this.m_AD_Client_ID = Env.getAD_Client_ID((Properties)this.m_ctx);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("AD_Client_ID=" + this.m_AD_Client_ID);
        }
        this.m_AD_Org_ID = Env.getAD_Org_ID((Properties)this.m_ctx);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("AD_Org_ID=" + this.m_AD_Org_ID);
            this.log.info("C_BankStatementLoader_ID=" + this.m_C_BankStmtLoader_ID);
        }
    }

    protected String doIt() throws Exception {
        this.log.info("LoadBankStatement.doIt");
        String message = "@Error@";
        this.m_controller = new MBankStatementLoader(this.m_ctx, this.m_C_BankStmtLoader_ID, this.fileName, this.get_TrxName());
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.m_controller.toString());
        }
        if (this.m_controller == null || this.m_controller.get_ID() == 0) {
            this.log.log(Level.SEVERE, "Invalid Loader");
        } else if (!this.m_controller.loadLines()) {
            message = String.valueOf(message) + this.m_controller.getErrorMessage() + " - " + this.m_controller.getErrorDescription();
            this.log.log(Level.SEVERE, String.valueOf(this.m_controller.getErrorMessage()) + " - " + this.m_controller.getErrorDescription());
        } else {
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Imported=" + this.m_controller.getLoadCount());
            }
            this.addLog(0, null, new BigDecimal(this.m_controller.getLoadCount()), Msg.getMsg((Properties)this.m_ctx, (String)"Inserted"));
            message = "@OK@";
        }
        return message;
    }
}

