/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MIssue;
import org.compiere.model.MSystem;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;

@Process
public class IssueReport
extends SvrProcess {
    private int m_AD_Issue_ID = 0;

    protected void prepare() {
        this.m_AD_Issue_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("AD_Issue_ID=" + this.m_AD_Issue_ID);
        }
        if (!MSystem.get((Properties)this.getCtx()).isAutoErrorReport()) {
            return "NOT reported - Enable Error Reporting in Window System";
        }
        MIssue issue = new MIssue(this.getCtx(), this.m_AD_Issue_ID, this.get_TrxName());
        if (issue.get_ID() == 0) {
            StringBuilder msgreturn = new StringBuilder("No Issue to report - ID=").append(this.m_AD_Issue_ID);
            return msgreturn.toString();
        }
        String error = issue.report();
        if (error != null) {
            throw new AdempiereSystemError(error);
        }
        if (issue.save()) {
            StringBuilder msgreturn = new StringBuilder("Issue Reported: ").append(issue.getRequestDocumentNo());
            return msgreturn.toString();
        }
        throw new AdempiereSystemError("Issue Not Saved");
    }
}

