/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.model.MProcessPara;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

@Process
public class InvoiceWriteOff
extends SvrProcess {
    private int p_C_BPartner_ID = 0;
    private int p_C_BP_Group_ID = 0;
    private int p_C_Invoice_ID = 0;
    private BigDecimal p_MaxInvWriteOffAmt = Env.ZERO;
    private String p_APAR = "R";
    private static String ONLY_AP = "P";
    private static String ONLY_AR = "R";
    private Timestamp p_DateInvoiced_From = null;
    private Timestamp p_DateInvoiced_To = null;
    private Timestamp p_DateAcct = null;
    private boolean p_CreatePayment = false;
    private int p_C_BankAccount_ID = 0;
    private boolean p_IsSimulation = true;
    private MAllocationHdr m_alloc = null;
    private MPayment m_payment = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null || para[i].getParameter_To() != null) {
                if (name.equals("C_BPartner_ID")) {
                    this.p_C_BPartner_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_BP_Group_ID")) {
                    this.p_C_BP_Group_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_Invoice_ID")) {
                    this.p_C_Invoice_ID = para[i].getParameterAsInt();
                } else if (name.equals("MaxInvWriteOffAmt")) {
                    this.p_MaxInvWriteOffAmt = (BigDecimal)para[i].getParameter();
                } else if (name.equals("APAR")) {
                    this.p_APAR = (String)para[i].getParameter();
                } else if (name.equals("DateInvoiced")) {
                    this.p_DateInvoiced_From = (Timestamp)para[i].getParameter();
                    this.p_DateInvoiced_To = (Timestamp)para[i].getParameter_To();
                } else if (name.equals("DateAcct")) {
                    this.p_DateAcct = (Timestamp)para[i].getParameter();
                } else if (name.equals("CreatePayment")) {
                    this.p_CreatePayment = "Y".equals(para[i].getParameter());
                } else if (name.equals("C_BankAccount_ID")) {
                    this.p_C_BankAccount_ID = para[i].getParameterAsInt();
                } else if (name.equals("IsSimulation")) {
                    this.p_IsSimulation = "Y".equals(para[i].getParameter());
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        int counter;
        block22: {
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("C_BPartner_ID=" + this.p_C_BPartner_ID + ", C_BP_Group_ID=" + this.p_C_BP_Group_ID + ", C_Invoice_ID=" + this.p_C_Invoice_ID + "; APAR=" + this.p_APAR + ", " + this.p_DateInvoiced_From + " - " + this.p_DateInvoiced_To + "; CreatePayment=" + this.p_CreatePayment + ", C_BankAccount_ID=" + this.p_C_BankAccount_ID);
            }
            if (this.p_C_BPartner_ID == 0 && this.p_C_Invoice_ID == 0 && this.p_C_BP_Group_ID == 0) {
                throw new AdempiereUserError("@FillMandatory@ @C_Invoice_ID@ / @C_BPartner_ID@ / ");
            }
            if (this.p_CreatePayment && this.p_C_BankAccount_ID == 0) {
                throw new AdempiereUserError("@FillMandatory@  @C_BankAccount_ID@");
            }
            StringBuilder sql = new StringBuilder("SELECT C_Invoice_ID,DocumentNo,DateInvoiced,").append(" C_Currency_ID,GrandTotal, invoiceOpen(C_Invoice_ID, 0) AS OpenAmt ").append("FROM C_Invoice WHERE ");
            if (this.p_C_Invoice_ID != 0) {
                sql.append("C_Invoice_ID=").append(this.p_C_Invoice_ID);
            } else {
                if (this.p_C_BPartner_ID != 0) {
                    sql.append("C_BPartner_ID=").append(this.p_C_BPartner_ID);
                } else {
                    sql.append("EXISTS (SELECT * FROM C_BPartner bp WHERE C_Invoice.C_BPartner_ID=bp.C_BPartner_ID AND bp.C_BP_Group_ID=").append(this.p_C_BP_Group_ID).append(")");
                }
                if (ONLY_AR.equals(this.p_APAR)) {
                    sql.append(" AND IsSOTrx='Y'");
                } else if (ONLY_AP.equals(this.p_APAR)) {
                    sql.append(" AND IsSOTrx='N'");
                }
                if (this.p_DateInvoiced_From != null && this.p_DateInvoiced_To != null) {
                    sql.append(" AND TRUNC(DateInvoiced) BETWEEN ").append(DB.TO_DATE((Timestamp)this.p_DateInvoiced_From, (boolean)true)).append(" AND ").append(DB.TO_DATE((Timestamp)this.p_DateInvoiced_To, (boolean)true));
                } else if (this.p_DateInvoiced_From != null) {
                    sql.append(" AND TRUNC(DateInvoiced) >= ").append(DB.TO_DATE((Timestamp)this.p_DateInvoiced_From, (boolean)true));
                } else if (this.p_DateInvoiced_To != null) {
                    sql.append(" AND TRUNC(DateInvoiced) <= ").append(DB.TO_DATE((Timestamp)this.p_DateInvoiced_To, (boolean)true));
                }
            }
            sql.append(" AND IsPaid='N' ORDER BY C_Currency_ID, C_BPartner_ID, DateInvoiced");
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer(sql.toString());
            }
            counter = 0;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        if (!this.writeOff(rs.getInt(1), rs.getString(2), rs.getTimestamp(3), rs.getInt(4), rs.getBigDecimal(6))) continue;
                        ++counter;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block22;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        this.processPayment();
        this.processAllocation();
        StringBuilder msgreturn = new StringBuilder("#").append(counter);
        return msgreturn.toString();
    }

    private boolean writeOff(int C_Invoice_ID, String DocumentNo, Timestamp DateInvoiced, int C_Currency_ID, BigDecimal OpenAmt) {
        if (OpenAmt == null || OpenAmt.signum() == 0) {
            return false;
        }
        if (OpenAmt.abs().compareTo(this.p_MaxInvWriteOffAmt) >= 0) {
            return false;
        }
        if (this.p_IsSimulation) {
            this.addLog(C_Invoice_ID, DateInvoiced, OpenAmt, DocumentNo);
            return true;
        }
        MInvoice invoice = new MInvoice(this.getCtx(), C_Invoice_ID, this.get_TrxName());
        if (!invoice.isSOTrx()) {
            OpenAmt = OpenAmt.negate();
        }
        if (this.m_alloc == null || C_Currency_ID != this.m_alloc.getC_Currency_ID()) {
            this.processAllocation();
            this.m_alloc = new MAllocationHdr(this.getCtx(), true, this.p_DateAcct, C_Currency_ID, String.valueOf(this.getProcessInfo().getTitle()) + " #" + this.getAD_PInstance_ID(), this.get_TrxName());
            this.m_alloc.setAD_Org_ID(invoice.getAD_Org_ID());
            if (!this.m_alloc.save()) {
                this.log.log(Level.SEVERE, "Cannot create allocation header");
                return false;
            }
        }
        if (this.p_CreatePayment && (this.m_payment == null || invoice.getC_BPartner_ID() != this.m_payment.getC_BPartner_ID() || C_Currency_ID != this.m_payment.getC_Currency_ID())) {
            this.processPayment();
            this.m_payment = new MPayment(this.getCtx(), 0, this.get_TrxName());
            this.m_payment.setAD_Org_ID(invoice.getAD_Org_ID());
            this.m_payment.setC_BankAccount_ID(this.p_C_BankAccount_ID);
            this.m_payment.setTenderType("K");
            this.m_payment.setDateTrx(this.p_DateAcct);
            this.m_payment.setDateAcct(this.p_DateAcct);
            this.m_payment.setDescription(String.valueOf(this.getProcessInfo().getTitle()) + " #" + this.getAD_PInstance_ID());
            this.m_payment.setC_BPartner_ID(invoice.getC_BPartner_ID());
            this.m_payment.setIsReceipt(true);
            this.m_payment.setC_Currency_ID(C_Currency_ID);
            if (!this.m_payment.save()) {
                this.log.log(Level.SEVERE, "Cannot create payment");
                return false;
            }
        }
        MAllocationLine aLine = null;
        if (this.p_CreatePayment) {
            aLine = new MAllocationLine(this.m_alloc, OpenAmt, Env.ZERO, Env.ZERO, Env.ZERO);
            this.m_payment.setPayAmt(this.m_payment.getPayAmt().add(OpenAmt));
            aLine.setC_Payment_ID(this.m_payment.getC_Payment_ID());
        } else {
            aLine = new MAllocationLine(this.m_alloc, Env.ZERO, Env.ZERO, OpenAmt, Env.ZERO);
        }
        aLine.setC_Invoice_ID(C_Invoice_ID);
        if (aLine.save()) {
            this.addLog(C_Invoice_ID, DateInvoiced, OpenAmt, DocumentNo);
            return true;
        }
        this.log.log(Level.SEVERE, "Cannot create allocation line for C_Invoice_ID=" + C_Invoice_ID);
        return false;
    }

    private boolean processAllocation() {
        if (this.m_alloc == null) {
            return true;
        }
        this.processPayment();
        if (!this.m_alloc.processIt("CO")) {
            this.log.warning("Allocation Process Failed: " + this.m_alloc + " - " + this.m_alloc.getProcessMsg());
            throw new IllegalStateException("Allocation Process Failed: " + this.m_alloc + " - " + this.m_alloc.getProcessMsg());
        }
        if (this.m_alloc.save()) {
            this.m_alloc = null;
            return true;
        }
        this.m_alloc = null;
        return false;
    }

    private boolean processPayment() {
        if (this.m_payment == null) {
            return true;
        }
        if (!this.m_payment.processIt("CO")) {
            this.log.warning("Payment Process Failed: " + this.m_payment + " - " + this.m_payment.getProcessMsg());
            throw new IllegalStateException("Payment Process Failed: " + this.m_payment + " - " + this.m_payment.getProcessMsg());
        }
        if (this.m_payment.save()) {
            this.m_payment = null;
            return true;
        }
        this.m_payment = null;
        return false;
    }
}

