/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaDefault;
import org.compiere.model.MDocType;
import org.compiere.model.MFactAcct;
import org.compiere.model.MGLCategory;
import org.compiere.model.MInvoice;
import org.compiere.model.MJournal;
import org.compiere.model.MJournalLine;
import org.compiere.model.MOrg;
import org.compiere.model.MProcessPara;
import org.compiere.model.Query;
import org.compiere.model.X_Fact_Acct;
import org.compiere.model.X_T_InvoiceGL;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

@Process
public class InvoiceNGL
extends SvrProcess {
    private int p_C_AcctSchema_ID = 0;
    private int p_C_ConversionTypeReval_ID = 0;
    private Timestamp p_DateReval = null;
    private String p_APAR = "A";
    private static String ONLY_AP = "P";
    private static String ONLY_AR = "R";
    private boolean p_IsAllCurrencies = false;
    private int p_C_Currency_ID = 0;
    private int p_C_DocTypeReval_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_AcctSchema_ID")) {
                    this.p_C_AcctSchema_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_ConversionTypeReval_ID")) {
                    this.p_C_ConversionTypeReval_ID = para[i].getParameterAsInt();
                } else if (name.equals("DateReval")) {
                    this.p_DateReval = (Timestamp)para[i].getParameter();
                } else if (name.equals("APAR")) {
                    this.p_APAR = (String)para[i].getParameter();
                } else if (name.equals("IsAllCurrencies")) {
                    this.p_IsAllCurrencies = "Y".equals((String)para[i].getParameter());
                } else if (name.equals("C_Currency_ID")) {
                    this.p_C_Currency_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_DocTypeReval_ID")) {
                    this.p_C_DocTypeReval_ID = para[i].getParameterAsInt();
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        int noT;
        StringBuilder sql;
        int no;
        if (this.p_IsAllCurrencies) {
            this.p_C_Currency_ID = 0;
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("C_AcctSchema_ID=" + this.p_C_AcctSchema_ID + ",C_ConversionTypeReval_ID=" + this.p_C_ConversionTypeReval_ID + ",DateReval=" + this.p_DateReval + ", APAR=" + this.p_APAR + ", IsAllCurrencies=" + this.p_IsAllCurrencies + ",C_Currency_ID=" + this.p_C_Currency_ID + ", C_DocType_ID=" + this.p_C_DocTypeReval_ID);
        }
        if (this.p_DateReval == null) {
            this.p_DateReval = new Timestamp(System.currentTimeMillis());
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("DELETE FROM T_InvoiceGL WHERE AD_PInstance_ID=").append(this.getAD_PInstance_ID())).toString(), (String)this.get_TrxName())) > 0 && this.log.isLoggable(Level.INFO)) {
            this.log.info("Deleted #" + no);
        }
        String dateStr = DB.TO_DATE((Timestamp)this.p_DateReval, (boolean)true);
        sql = new StringBuilder("INSERT INTO T_InvoiceGL (AD_Client_ID, AD_Org_ID, IsActive, Created,CreatedBy, Updated,UpdatedBy,").append(" AD_PInstance_ID, C_Invoice_ID, GrandTotal, OpenAmt, ").append(" Fact_Acct_ID, AmtSourceBalance, AmtAcctBalance, ").append(" AmtRevalDr, AmtRevalCr, ").append(this.p_C_DocTypeReval_ID == 0 ? "" : "C_DocTypeReval_ID, ").append("IsAllCurrencies, ").append(" DateReval, C_ConversionTypeReval_ID, AmtRevalDrDiff, AmtRevalCrDiff, APAR) ").append("SELECT DISTINCT i.AD_Client_ID, i.AD_Org_ID, i.IsActive, i.Created,i.CreatedBy, i.Updated,i.UpdatedBy,").append(this.getAD_PInstance_ID()).append(", i.C_Invoice_ID, ii.GrandTotal, invoiceOpen(i.C_Invoice_ID, 0), ").append(" fa.Fact_Acct_ID, fa.AmtSourceDr-fa.AmtSourceCr, fa.AmtAcctDr-fa.AmtAcctCr, ").append(" currencyConvert(fa.AmtSourceDr, i.C_Currency_ID, a.C_Currency_ID, ").append(dateStr).append(", ").append(this.p_C_ConversionTypeReval_ID).append(", i.AD_Client_ID, i.AD_Org_ID),").append(" currencyConvert(fa.AmtSourceCr, i.C_Currency_ID, a.C_Currency_ID, ").append(dateStr).append(", ").append(this.p_C_ConversionTypeReval_ID).append(", i.AD_Client_ID, i.AD_Org_ID),").append(this.p_C_DocTypeReval_ID == 0 ? "" : String.valueOf(String.valueOf(this.p_C_DocTypeReval_ID)) + ",").append(this.p_IsAllCurrencies ? "'Y'," : "'N',").append(dateStr).append(", ").append(this.p_C_ConversionTypeReval_ID).append(", 0, 0, '").append(this.p_APAR).append("' ").append("FROM C_Invoice_v i JOIN C_Invoice ii ON (i.C_Invoice_ID=ii.C_Invoice_ID)").append(" INNER JOIN Fact_Acct fa ON (fa.AD_Table_ID=318 AND fa.Record_ID=i.C_Invoice_ID").append(" AND (ii.GrandTotal=fa.AmtSourceDr OR ii.GrandTotal=fa.AmtSourceCr))").append(" INNER JOIN C_AcctSchema a ON (fa.C_AcctSchema_ID=a.C_AcctSchema_ID) ").append("WHERE i.IsPaid='N'").append(" AND EXISTS (SELECT * FROM C_ElementValue ev ").append("WHERE ev.C_ElementValue_ID=fa.Account_ID AND (ev.AccountType='A' OR ev.AccountType='L'))").append(" AND fa.C_AcctSchema_ID=").append(this.p_C_AcctSchema_ID);
        if (this.p_IsAllCurrencies) {
            sql.append(" AND i.C_Currency_ID<>a.C_Currency_ID");
        }
        if (ONLY_AR.equals(this.p_APAR)) {
            sql.append(" AND i.IsSOTrx='Y'");
        } else if (ONLY_AP.equals(this.p_APAR)) {
            sql.append(" AND i.IsSOTrx='N'");
        }
        if (!this.p_IsAllCurrencies && this.p_C_Currency_ID != 0) {
            sql.append(" AND i.C_Currency_ID=").append(this.p_C_Currency_ID);
        }
        if ((no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName())) != 0) {
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Inserted #" + no);
            }
        } else if (this.log.isLoggable(Level.FINER)) {
            this.log.warning("Inserted #" + no + " - " + sql);
        } else {
            this.log.warning("Inserted #" + no);
        }
        if ((noT = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE T_InvoiceGL gl ").append("SET (AmtRevalDrDiff,AmtRevalCrDiff)=").append("(SELECT gl.AmtRevalDr-fa.AmtAcctDr, gl.AmtRevalCr-fa.AmtAcctCr ").append("FROM Fact_Acct fa ").append("WHERE gl.Fact_Acct_ID=fa.Fact_Acct_ID) ").append("WHERE AD_PInstance_ID=").append(this.getAD_PInstance_ID())).toString(), (String)this.get_TrxName())) > 0 && this.log.isLoggable(Level.CONFIG)) {
            this.log.config("Difference #" + noT);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE T_InvoiceGL SET Percent = 100 ").append("WHERE GrandTotal=OpenAmt AND AD_PInstance_ID=").append(this.getAD_PInstance_ID())).toString(), (String)this.get_TrxName())) > 0 && this.log.isLoggable(Level.INFO)) {
            this.log.info("Not Paid #" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE T_InvoiceGL SET Percent = ROUND(OpenAmt*100/GrandTotal,6) ").append("WHERE GrandTotal<>OpenAmt AND GrandTotal <> 0 AND AD_PInstance_ID=").append(this.getAD_PInstance_ID())).toString(), (String)this.get_TrxName())) > 0 && this.log.isLoggable(Level.INFO)) {
            this.log.info("Partial Paid #" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE T_InvoiceGL SET AmtRevalDr = AmtRevalDr * Percent/100,").append(" AmtRevalCr = AmtRevalCr * Percent/100,").append(" AmtRevalDrDiff = AmtRevalDrDiff * Percent/100,").append(" AmtRevalCrDiff = AmtRevalCrDiff * Percent/100 ").append("WHERE Percent <> 100 AND AD_PInstance_ID=").append(this.getAD_PInstance_ID())).toString(), (String)this.get_TrxName())) > 0 && this.log.isLoggable(Level.CONFIG)) {
            this.log.config("Partial Calc #" + no);
        }
        String info = "";
        if (this.p_C_DocTypeReval_ID != 0) {
            if (this.p_C_Currency_ID != 0) {
                this.log.warning("Can create Journal only for all currencies");
            } else {
                info = this.createGLJournal();
            }
        }
        StringBuilder msgreturn = new StringBuilder("#").append(noT).append(info);
        return msgreturn.toString();
    }

    private String createGLJournal() {
        String whereClause = "AD_PInstance_ID=?";
        List list = new Query(this.getCtx(), "T_InvoiceGL", "AD_PInstance_ID=?", this.get_TrxName()).setParameters(new Object[]{this.getAD_PInstance_ID()}).setOrderBy("AD_Org_ID").list();
        if (list.size() == 0) {
            return " - No Records found";
        }
        MAcctSchema as = MAcctSchema.get((Properties)this.getCtx(), (int)this.p_C_AcctSchema_ID);
        MAcctSchemaDefault asDefaultAccts = MAcctSchemaDefault.get((Properties)this.getCtx(), (int)this.p_C_AcctSchema_ID);
        MGLCategory cat = MGLCategory.getDefaultSystem((Properties)this.getCtx());
        if (cat == null) {
            MDocType docType = MDocType.get((Properties)this.getCtx(), (int)this.p_C_DocTypeReval_ID);
            cat = MGLCategory.get((Properties)this.getCtx(), (int)docType.getGL_Category_ID());
        }
        MJournal journal = new MJournal(this.getCtx(), 0, this.get_TrxName());
        journal.setC_DocType_ID(this.p_C_DocTypeReval_ID);
        journal.setPostingType("A");
        journal.setDateDoc(this.p_DateReval);
        journal.setDateAcct(this.p_DateReval);
        journal.setC_Currency_ID(as.getC_Currency_ID());
        journal.setC_AcctSchema_ID(as.getC_AcctSchema_ID());
        journal.setC_ConversionType_ID(this.p_C_ConversionTypeReval_ID);
        journal.setGL_Category_ID(cat.getGL_Category_ID());
        journal.setDescription(this.getName());
        if (!journal.save()) {
            return " - Could not create Journal";
        }
        BigDecimal gainTotal = Env.ZERO;
        BigDecimal lossTotal = Env.ZERO;
        int AD_Org_ID = 0;
        MOrg org = null;
        int i = 0;
        while (i < list.size()) {
            MInvoice invoice;
            X_T_InvoiceGL gl = (X_T_InvoiceGL)list.get(i);
            if ((gl.getAmtRevalDrDiff().signum() != 0 || gl.getAmtRevalCrDiff().signum() != 0) && (invoice = new MInvoice(this.getCtx(), gl.getC_Invoice_ID(), null)).getC_Currency_ID() != as.getC_Currency_ID()) {
                if (AD_Org_ID == 0) {
                    AD_Org_ID = gl.getAD_Org_ID();
                }
                if (AD_Org_ID != gl.getAD_Org_ID()) {
                    this.createBalancing(asDefaultAccts, journal, gainTotal, lossTotal, AD_Org_ID, (i + 1) * 10);
                    AD_Org_ID = gl.getAD_Org_ID();
                    gainTotal = Env.ZERO;
                    lossTotal = Env.ZERO;
                    journal = null;
                }
                if (org == null) {
                    org = MOrg.get((Properties)this.getCtx(), (int)gl.getAD_Org_ID());
                    journal.setDescription(String.valueOf(this.getName()) + " - " + org.getName());
                    if (!journal.save()) {
                        return " - Could not set Description for Journal";
                    }
                }
                MJournalLine line = new MJournalLine(journal);
                line.setLine((i + 1) * 10);
                line.setDescription(invoice.getSummary());
                MFactAcct fa = new MFactAcct(this.getCtx(), gl.getFact_Acct_ID(), null);
                MAccount acct = MAccount.get((X_Fact_Acct)fa);
                line.setC_ValidCombination_ID(acct);
                BigDecimal dr = gl.getAmtRevalDrDiff();
                BigDecimal cr = gl.getAmtRevalCrDiff();
                if (acct.isActiva()) {
                    if (dr.signum() < 0) {
                        lossTotal = lossTotal.add(dr.negate());
                    } else if (dr.signum() > 0) {
                        gainTotal = gainTotal.add(dr);
                    }
                    if (cr.signum() > 0) {
                        lossTotal = lossTotal.add(cr);
                    }
                    if (cr.signum() < 0) {
                        gainTotal = gainTotal.add(cr.negate());
                    }
                } else {
                    if (cr.signum() < 0) {
                        gainTotal = gainTotal.add(cr.negate());
                    } else if (cr.signum() > 0) {
                        lossTotal = lossTotal.add(cr);
                    }
                    if (dr.signum() > 0) {
                        gainTotal = gainTotal.add(dr);
                    } else if (dr.signum() < 0) {
                        lossTotal = lossTotal.add(dr.negate());
                    }
                }
                line.setAmtSourceDr(dr);
                line.setAmtAcctDr(dr);
                line.setAmtSourceCr(cr);
                line.setAmtAcctCr(cr);
                line.saveEx();
            }
            ++i;
        }
        this.createBalancing(asDefaultAccts, journal, gainTotal, lossTotal, AD_Org_ID, (list.size() + 1) * 10);
        int noLines = journal.getLines(true).length;
        if (noLines == 0) {
            journal.deleteEx(true);
        } else {
            StringBuilder msgreturn = new StringBuilder(Msg.getElement((Properties)this.getCtx(), (String)"GL_Journal_ID")).append(" - ").append(journal.getDocumentNo()).append(" #").append(noLines);
            this.addLog(journal.getGL_Journal_ID(), null, null, msgreturn.toString(), 224, journal.getGL_Journal_ID());
        }
        return "OK";
    }

    private void createBalancing(MAcctSchemaDefault asDefaultAccts, MJournal journal, BigDecimal gainTotal, BigDecimal lossTotal, int AD_Org_ID, int lineNo) {
        MAccount acct;
        MAccount base;
        MJournalLine line;
        if (journal == null) {
            throw new IllegalArgumentException("Journal is null");
        }
        if (gainTotal.signum() != 0) {
            line = new MJournalLine(journal);
            line.setLine(lineNo + 1);
            base = MAccount.get((Properties)this.getCtx(), (int)asDefaultAccts.getUnrealizedGain_Acct());
            acct = MAccount.get((Properties)this.getCtx(), (int)asDefaultAccts.getAD_Client_ID(), (int)AD_Org_ID, (int)asDefaultAccts.getC_AcctSchema_ID(), (int)base.getAccount_ID(), (int)base.getC_SubAcct_ID(), (int)base.getM_Product_ID(), (int)base.getC_BPartner_ID(), (int)base.getAD_OrgTrx_ID(), (int)base.getC_LocFrom_ID(), (int)base.getC_LocTo_ID(), (int)base.getC_SalesRegion_ID(), (int)base.getC_Project_ID(), (int)base.getC_Campaign_ID(), (int)base.getC_Activity_ID(), (int)base.getUser1_ID(), (int)base.getUser2_ID(), (int)base.getUserElement1_ID(), (int)base.getUserElement2_ID(), (String)this.get_TrxName());
            line.setDescription(Msg.getElement((Properties)this.getCtx(), (String)"UnrealizedGain_Acct"));
            line.setC_ValidCombination_ID(acct.getC_ValidCombination_ID());
            line.setAmtSourceCr(gainTotal);
            line.setAmtAcctCr(gainTotal);
            line.saveEx();
        }
        if (lossTotal.signum() != 0) {
            line = new MJournalLine(journal);
            line.setLine(lineNo + 2);
            base = MAccount.get((Properties)this.getCtx(), (int)asDefaultAccts.getUnrealizedLoss_Acct());
            acct = MAccount.get((Properties)this.getCtx(), (int)asDefaultAccts.getAD_Client_ID(), (int)AD_Org_ID, (int)asDefaultAccts.getC_AcctSchema_ID(), (int)base.getAccount_ID(), (int)base.getC_SubAcct_ID(), (int)base.getM_Product_ID(), (int)base.getC_BPartner_ID(), (int)base.getAD_OrgTrx_ID(), (int)base.getC_LocFrom_ID(), (int)base.getC_LocTo_ID(), (int)base.getC_SalesRegion_ID(), (int)base.getC_Project_ID(), (int)base.getC_Campaign_ID(), (int)base.getC_Activity_ID(), (int)base.getUser1_ID(), (int)base.getUser2_ID(), (int)base.getUserElement1_ID(), (int)base.getUserElement2_ID(), (String)this.get_TrxName());
            line.setDescription(Msg.getElement((Properties)this.getCtx(), (String)"UnrealizedLoss_Acct"));
            line.setC_ValidCombination_ID(acct.getC_ValidCombination_ID());
            line.setAmtSourceDr(lossTotal);
            line.setAmtAcctDr(lossTotal);
            line.saveEx();
        }
    }
}

