/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceBatch;
import org.compiere.model.MInvoiceBatchLine;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MProcessPara;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.Msg;

@Process
public class InvoiceBatchProcess
extends SvrProcess {
    private int p_C_InvoiceBatch_ID = 0;
    private String p_DocAction = null;
    private MInvoice m_invoice = null;
    private String m_oldDocumentNo = null;
    private int m_oldC_BPartner_ID = 0;
    private int m_oldC_BPartner_Location_ID = 0;
    private int m_count = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DocAction")) {
                    this.p_DocAction = (String)para[i].getParameter();
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
        this.p_C_InvoiceBatch_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("C_InvoiceBatch_ID=" + this.p_C_InvoiceBatch_ID + ", DocAction=" + this.p_DocAction);
        }
        if (this.p_C_InvoiceBatch_ID == 0) {
            throw new AdempiereUserError("C_InvoiceBatch_ID = 0");
        }
        MInvoiceBatch batch = new MInvoiceBatch(this.getCtx(), this.p_C_InvoiceBatch_ID, this.get_TrxName());
        if (batch.get_ID() == 0) {
            throw new AdempiereUserError("@NotFound@: @C_InvoiceBatch_ID@ - " + this.p_C_InvoiceBatch_ID);
        }
        if (batch.isProcessed()) {
            throw new AdempiereUserError("@Processed@");
        }
        if (batch.getControlAmt().signum() != 0 && batch.getControlAmt().compareTo(batch.getDocumentAmt()) != 0) {
            throw new AdempiereUserError("@ControlAmt@ <> @DocumentAmt@");
        }
        MInvoiceBatchLine[] lines = batch.getLines(false);
        int i = 0;
        while (i < lines.length) {
            MInvoiceBatchLine line = lines[i];
            if (line.getC_Invoice_ID() == 0 && line.getC_InvoiceLine_ID() == 0) {
                if (this.m_oldDocumentNo != null && !this.m_oldDocumentNo.equals(line.getDocumentNo()) || this.m_oldC_BPartner_ID != line.getC_BPartner_ID() || this.m_oldC_BPartner_Location_ID != line.getC_BPartner_Location_ID()) {
                    this.completeInvoice();
                }
                if (this.m_invoice == null) {
                    this.m_invoice = new MInvoice(batch, line);
                    if (!this.m_invoice.save()) {
                        throw new AdempiereUserError("Cannot save Invoice");
                    }
                    this.m_oldDocumentNo = line.getDocumentNo();
                    this.m_oldC_BPartner_ID = line.getC_BPartner_ID();
                    this.m_oldC_BPartner_Location_ID = line.getC_BPartner_Location_ID();
                }
                if (line.isTaxIncluded() != this.m_invoice.isTaxIncluded()) {
                    throw new AdempiereUserError("Line " + line.getLine() + " TaxIncluded inconsistent");
                }
                MInvoiceLine invoiceLine = new MInvoiceLine(this.m_invoice);
                invoiceLine.setDescription(line.getDescription());
                invoiceLine.setC_Charge_ID(line.getC_Charge_ID());
                invoiceLine.setQty(line.getQtyEntered());
                invoiceLine.setPrice(line.getPriceEntered());
                invoiceLine.setC_Tax_ID(line.getC_Tax_ID());
                invoiceLine.setTaxAmt(line.getTaxAmt());
                invoiceLine.setLineNetAmt(line.getLineNetAmt());
                invoiceLine.setLineTotalAmt(line.getLineTotalAmt());
                if (!invoiceLine.save()) {
                    throw new AdempiereUserError("Cannot save Invoice Line");
                }
                line.setC_Invoice_ID(this.m_invoice.getC_Invoice_ID());
                line.setC_InvoiceLine_ID(invoiceLine.getC_InvoiceLine_ID());
                line.saveEx();
            }
            ++i;
        }
        this.completeInvoice();
        batch.setProcessed(true);
        batch.saveEx();
        StringBuilder msgreturn = new StringBuilder("#").append(this.m_count);
        return msgreturn.toString();
    }

    private void completeInvoice() {
        if (this.m_invoice == null) {
            return;
        }
        this.m_invoice.setDocAction(this.p_DocAction);
        if (!this.m_invoice.processIt(this.p_DocAction)) {
            this.log.warning("Invoice Process Failed: " + this.m_invoice + " - " + this.m_invoice.getProcessMsg());
            throw new IllegalStateException("Invoice Process Failed: " + this.m_invoice + " - " + this.m_invoice.getProcessMsg());
        }
        this.m_invoice.saveEx();
        String message = Msg.parseTranslation((Properties)this.getCtx(), (String)("@InvoiceProcessed@ " + this.m_invoice.getDocumentNo()));
        this.addBufferLog(0, this.m_invoice.getDateInvoiced(), this.m_invoice.getGrandTotal(), message, this.m_invoice.get_Table_ID(), this.m_invoice.getC_Invoice_ID());
        ++this.m_count;
        this.m_invoice = null;
    }
}

