/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MBankAccount;
import org.compiere.model.MPayment;
import org.compiere.model.MProcessPara;
import org.compiere.model.X_I_Payment;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

@Process
public class ImportPayment
extends SvrProcess {
    private int p_AD_Org_ID = 0;
    private int p_C_BankAccount_ID = 0;
    private boolean p_deleteOldImported = false;
    private String m_docAction = null;
    private Properties m_ctx;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("AD_Org_ID")) {
                this.p_AD_Org_ID = ((BigDecimal)para[i].getParameter()).intValue();
            } else if (name.equals("C_BankAccount_ID")) {
                this.p_C_BankAccount_ID = ((BigDecimal)para[i].getParameter()).intValue();
            } else if (name.equals("DeleteOldImported")) {
                this.p_deleteOldImported = "Y".equals(para[i].getParameter());
            } else if (name.equals("DocAction")) {
                this.m_docAction = (String)para[i].getParameter();
            } else {
                MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
            }
            ++i;
        }
        this.m_ctx = Env.getCtx();
    }

    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("C_BankAccount_ID" + this.p_C_BankAccount_ID);
        }
        MBankAccount ba = MBankAccount.get((Properties)this.getCtx(), (int)this.p_C_BankAccount_ID);
        if (this.p_C_BankAccount_ID == 0 || ba.get_ID() != this.p_C_BankAccount_ID) {
            throw new AdempiereUserError("@NotFound@ @C_BankAccount_ID@ - " + this.p_C_BankAccount_ID);
        }
        if (this.p_AD_Org_ID != ba.getAD_Org_ID() && ba.getAD_Org_ID() != 0) {
            this.p_AD_Org_ID = ba.getAD_Org_ID();
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("AD_Org_ID=" + this.p_AD_Org_ID);
        }
        StringBuilder sql = null;
        int no = 0;
        StringBuilder clientCheck = new StringBuilder(" AND AD_Client_ID=").append(ba.getAD_Client_ID());
        if (this.p_deleteOldImported) {
            sql = new StringBuilder("DELETE FROM I_Payment ").append("WHERE I_IsImported='Y'").append((CharSequence)clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Delete Old Impored =" + no);
            }
        }
        sql = new StringBuilder("UPDATE I_Payment ").append("SET AD_Client_ID = COALESCE (AD_Client_ID,").append(ba.getAD_Client_ID()).append("),").append(" AD_Org_ID = COALESCE (AD_Org_ID,").append(this.p_AD_Org_ID).append("),");
        sql.append(" IsActive = COALESCE (IsActive, 'Y'),").append(" Created = COALESCE (Created, getDate()),").append(" CreatedBy = COALESCE (CreatedBy, 0),").append(" Updated = COALESCE (Updated, getDate()),").append(" UpdatedBy = COALESCE (UpdatedBy, 0),").append(" I_ErrorMsg = ' ',").append(" I_IsImported = 'N' ").append("WHERE I_IsImported<>'Y' OR I_IsImported IS NULL OR AD_Client_ID IS NULL OR AD_Org_ID IS NULL OR AD_Client_ID=0 OR AD_Org_ID=0");
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Reset=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Payment o ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Org, '").append("WHERE (AD_Org_ID IS NULL OR AD_Org_ID=0").append(" OR EXISTS (SELECT * FROM AD_Org oo WHERE o.AD_Org_ID=oo.AD_Org_ID AND (oo.IsSummary='Y' OR oo.IsActive='N')))").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
            this.log.warning("Invalid Org=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Payment i ").append("SET C_BankAccount_ID=").append("( ").append(" SELECT C_BankAccount_ID ").append(" FROM C_BankAccount a, C_Bank b ").append(" WHERE b.IsOwnBank='Y' ").append(" AND a.AD_Client_ID=i.AD_Client_ID ").append(" AND a.C_Bank_ID=b.C_Bank_ID ").append(" AND a.AccountNo=i.BankAccountNo ").append(" AND b.RoutingNo=i.RoutingNo ").append(" OR b.SwiftCode=i.RoutingNo ").append(") ").append("WHERE i.C_BankAccount_ID IS NULL ").append("AND (i.I_IsImported<>'Y' ").append("OR i.I_IsImported IS NULL)").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.INFO)) {
            this.log.info("Bank Account (With Routing No)=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Payment i ").append("SET C_BankAccount_ID=").append("( ").append(" SELECT C_BankAccount_ID ").append(" FROM C_BankAccount a, C_Bank b ").append(" WHERE b.IsOwnBank='Y' ").append(" AND a.C_Bank_ID=b.C_Bank_ID ").append(" AND a.AccountNo=i.BankAccountNo ").append(" AND a.AD_Client_ID=i.AD_Client_ID ").append(") ").append("WHERE i.C_BankAccount_ID IS NULL ").append("AND (i.I_isImported<>'Y' ").append("OR i.I_isImported IS NULL)").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.INFO)) {
            this.log.info("Bank Account (Without Routing No)=" + no);
        }
        sql = new StringBuilder("UPDATE I_Payment i ").append("SET C_BankAccount_ID=(SELECT C_BankAccount_ID FROM C_BankAccount a WHERE a.C_BankAccount_ID=").append(this.p_C_BankAccount_ID);
        sql.append(" and a.AD_Client_ID=i.AD_Client_ID) ").append("WHERE i.C_BankAccount_ID IS NULL ").append("AND i.BankAccountNo IS NULL ").append("AND (i.I_isImported<>'Y' ").append("OR i.I_isImported IS NULL)").append((CharSequence)clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0 && this.log.isLoggable(Level.INFO)) {
            this.log.info("Bank Account=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Payment ").append("SET I_isImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Bank Account, ' ").append("WHERE C_BankAccount_ID IS NULL ").append("AND (I_isImported<>'Y' ").append("OR I_isImported IS NULL)").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
            this.log.warning("Invalid Bank Account=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Payment i ").append("SET C_Currency_ID=(SELECT C_Currency_ID FROM C_Currency c").append(" WHERE i.ISO_Code=c.ISO_Code AND c.AD_Client_ID IN (0,i.AD_Client_ID)) ").append("WHERE C_Currency_ID IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.INFO)) {
            this.log.info("Set Currency=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Payment i ").append("SET C_Currency_ID=(SELECT C_Currency_ID FROM C_BankAccount WHERE C_BankAccount_ID=i.C_BankAccount_ID) ").append("WHERE i.C_Currency_ID IS NULL ").append("AND i.ISO_Code IS NULL").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.INFO)) {
            this.log.info("Set Currency=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Payment ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No Currency,' ").append("WHERE C_Currency_ID IS NULL ").append("AND I_IsImported<>'E' ").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
            this.log.warning("No Currency=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Payment ").append("SET ChargeAmt=0 ").append("WHERE ChargeAmt IS NULL ").append("AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.INFO)) {
            this.log.info("Charge Amount=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Payment ").append("SET TaxAmt=0 ").append("WHERE TaxAmt IS NULL ").append("AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.INFO)) {
            this.log.info("Tax Amount=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Payment ").append("SET WriteOffAmt=0 ").append("WHERE WriteOffAmt IS NULL ").append("AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.INFO)) {
            this.log.info("WriteOff Amount=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Payment ").append("SET DiscountAmt=0 ").append("WHERE DiscountAmt IS NULL ").append("AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.INFO)) {
            this.log.info("Discount Amount=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Payment ").append("SET DateTrx=Created ").append("WHERE DateTrx IS NULL ").append("AND I_isImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.INFO)) {
            this.log.info("Trx Date=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Payment ").append("SET DateAcct=DateTrx ").append("WHERE DateAcct IS NULL ").append("AND I_isImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.INFO)) {
            this.log.info("Acct Date=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Payment i ").append("SET C_Invoice_ID=(SELECT MAX(C_Invoice_ID) FROM C_Invoice ii").append(" WHERE i.InvoiceDocumentNo=ii.DocumentNo AND i.AD_Client_ID=ii.AD_Client_ID) ").append("WHERE C_Invoice_ID IS NULL AND InvoiceDocumentNo IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.FINE)) {
            this.log.fine("Set Invoice from DocumentNo=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Payment i ").append("SET C_BPartner_ID=(SELECT MAX(C_BPartner_ID) FROM C_BPartner bp").append(" WHERE i.BPartnerValue=bp.Value AND i.AD_Client_ID=bp.AD_Client_ID) ").append("WHERE C_BPartner_ID IS NULL AND BPartnerValue IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.FINE)) {
            this.log.fine("Set BP from Value=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Payment i ").append("SET C_BPartner_ID=(SELECT MAX(C_BPartner_ID) FROM C_Invoice ii").append(" WHERE i.C_Invoice_ID=ii.C_Invoice_ID AND i.AD_Client_ID=ii.AD_Client_ID) ").append("WHERE C_BPartner_ID IS NULL AND C_Invoice_ID IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.FINE)) {
            this.log.fine("Set BP from Invoice=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Payment ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No BPartner,' ").append("WHERE C_BPartner_ID IS NULL ").append("AND I_IsImported<>'E' ").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
            this.log.warning("No BPartner=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Payment ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'Err=Invalid Payment<->Invoice, ' ").append("WHERE I_Payment_ID IN ").append("(SELECT I_Payment_ID ").append("FROM I_Payment i").append(" INNER JOIN C_Payment p ON (i.C_Payment_ID=p.C_Payment_ID) ").append("WHERE i.C_Invoice_ID IS NOT NULL ").append(" AND p.C_Invoice_ID IS NOT NULL ").append(" AND p.C_Invoice_ID<>i.C_Invoice_ID) ").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.INFO)) {
            this.log.info("Payment<->Invoice Mismatch=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Payment ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'Err=Invalid Payment<->BPartner, ' ").append("WHERE I_Payment_ID IN ").append("(SELECT I_Payment_ID ").append("FROM I_Payment i").append(" INNER JOIN C_Payment p ON (i.C_Payment_ID=p.C_Payment_ID) ").append("WHERE i.C_BPartner_ID IS NOT NULL ").append(" AND p.C_BPartner_ID IS NOT NULL ").append(" AND p.C_BPartner_ID<>i.C_BPartner_ID) ").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.INFO)) {
            this.log.info("Payment<->BPartner Mismatch=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Payment ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'Err=Invalid Invoice<->BPartner, ' ").append("WHERE I_Payment_ID IN ").append("(SELECT I_Payment_ID ").append("FROM I_Payment i").append(" INNER JOIN C_Invoice v ON (i.C_Invoice_ID=v.C_Invoice_ID) ").append("WHERE i.C_BPartner_ID IS NOT NULL ").append(" AND v.C_BPartner_ID IS NOT NULL ").append(" AND v.C_BPartner_ID<>i.C_BPartner_ID) ").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.INFO)) {
            this.log.info("Invoice<->BPartner Mismatch=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Payment ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'Err=Invalid Invoice.BPartner<->Payment.BPartner, ' ").append("WHERE I_Payment_ID IN ").append("(SELECT I_Payment_ID ").append("FROM I_Payment i").append(" INNER JOIN C_Invoice v ON (i.C_Invoice_ID=v.C_Invoice_ID)").append(" INNER JOIN C_Payment p ON (i.C_Payment_ID=p.C_Payment_ID) ").append("WHERE p.C_Invoice_ID<>v.C_Invoice_ID").append(" AND v.C_BPartner_ID<>p.C_BPartner_ID) ").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.INFO)) {
            this.log.info("Invoice.BPartner<->Payment.BPartner Mismatch=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Payment ").append("SET TrxType='S' ").append("WHERE TrxType IS NULL ").append("AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.INFO)) {
            this.log.info("TrxType Default=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Payment ").append("SET TenderType='K' ").append("WHERE TenderType IS NULL ").append("AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.INFO)) {
            this.log.info("TenderType Default=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Payment i ").append("SET C_DocType_ID=(SELECT C_DocType_ID FROM C_DocType d WHERE d.Name=i.DocTypeName").append(" AND d.DocBaseType IN ('ARR','APP') AND i.AD_Client_ID=d.AD_Client_ID) ").append("WHERE C_DocType_ID IS NULL AND DocTypeName IS NOT NULL AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.FINE)) {
            this.log.fine("Set DocType=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Payment ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid DocTypeName, ' ").append("WHERE C_DocType_ID IS NULL AND DocTypeName IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
            this.log.warning("Invalid DocTypeName=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Payment ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No DocType, ' ").append("WHERE C_DocType_ID IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
            this.log.warning("No DocType=" + no);
        }
        this.commitEx();
        sql = new StringBuilder("SELECT * FROM I_Payment").append(" WHERE I_IsImported='N'").append((CharSequence)clientCheck).append(" ORDER BY C_BankAccount_ID, CheckNo, DateTrx, R_AuthCode");
        MBankAccount account = null;
        int noInsert = 0;
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (CPreparedStatement pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());){
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    X_I_Payment imp = new X_I_Payment(this.m_ctx, rs, this.get_TrxName());
                    if (account == null || account.getC_BankAccount_ID() != imp.getC_BankAccount_ID()) {
                        account = MBankAccount.get((Properties)this.m_ctx, (int)imp.getC_BankAccount_ID());
                        if (this.log.isLoggable(Level.INFO)) {
                            this.log.info("New Account=" + account.getAccountNo());
                        }
                    }
                    MPayment payment = new MPayment(this.m_ctx, 0, this.get_TrxName());
                    payment.setAD_Org_ID(imp.getAD_Org_ID());
                    payment.setDocumentNo(imp.getDocumentNo());
                    payment.setPONum(imp.getPONum());
                    payment.setTrxType(imp.getTrxType());
                    payment.setTenderType(imp.getTenderType());
                    payment.setC_BankAccount_ID(imp.getC_BankAccount_ID());
                    payment.setRoutingNo(imp.getRoutingNo());
                    payment.setAccountNo(imp.getAccountNo());
                    payment.setIBAN(imp.getIBAN());
                    payment.setSwiftCode(imp.getSwiftCode());
                    payment.setCheckNo(imp.getCheckNo());
                    payment.setMicr(imp.getMicr());
                    if (imp.getCreditCardType() != null) {
                        payment.setCreditCardType(imp.getCreditCardType());
                    }
                    payment.setCreditCardNumber(imp.getCreditCardNumber());
                    if (imp.getCreditCardExpMM() != 0) {
                        payment.setCreditCardExpMM(imp.getCreditCardExpMM());
                    }
                    if (imp.getCreditCardExpYY() != 0) {
                        payment.setCreditCardExpYY(imp.getCreditCardExpYY());
                    }
                    payment.setCreditCardVV(imp.getCreditCardVV());
                    payment.setSwipe(imp.getSwipe());
                    payment.setDateAcct(imp.getDateTrx());
                    payment.setDateTrx(imp.getDateTrx());
                    payment.setC_BPartner_ID(imp.getC_BPartner_ID());
                    payment.setC_Invoice_ID(imp.getC_Invoice_ID());
                    payment.setC_DocType_ID(imp.getC_DocType_ID());
                    payment.setC_Currency_ID(imp.getC_Currency_ID());
                    payment.setC_Charge_ID(imp.getC_Charge_ID());
                    payment.setChargeAmt(imp.getChargeAmt());
                    payment.setTaxAmt(imp.getTaxAmt());
                    payment.setPayAmt(imp.getPayAmt());
                    payment.setWriteOffAmt(imp.getWriteOffAmt());
                    payment.setDiscountAmt(imp.getDiscountAmt());
                    payment.setWriteOffAmt(imp.getWriteOffAmt());
                    payment.setA_City(imp.getA_City());
                    payment.setA_Country(imp.getA_Country());
                    payment.setA_EMail(imp.getA_EMail());
                    payment.setA_Ident_DL(imp.getA_Ident_DL());
                    payment.setA_Ident_SSN(imp.getA_Ident_SSN());
                    payment.setA_Name(imp.getA_Name());
                    payment.setA_State(imp.getA_State());
                    payment.setA_Street(imp.getA_Street());
                    payment.setA_Zip(imp.getA_Zip());
                    payment.setR_AuthCode(imp.getR_AuthCode());
                    payment.setR_Info(imp.getR_Info());
                    payment.setR_PnRef(imp.getR_PnRef());
                    payment.setR_RespMsg(imp.getR_RespMsg());
                    payment.setR_Result(imp.getR_Result());
                    payment.setOrig_TrxID(imp.getOrig_TrxID());
                    payment.setVoiceAuthCode(imp.getVoiceAuthCode());
                    if (!payment.save()) continue;
                    imp.setC_Payment_ID(payment.getC_Payment_ID());
                    imp.setI_IsImported(true);
                    imp.setProcessed(true);
                    imp.saveEx();
                    ++noInsert;
                    if (payment == null || this.m_docAction == null || this.m_docAction.length() <= 0) continue;
                    payment.setDocAction(this.m_docAction);
                    if (!payment.processIt(this.m_docAction)) {
                        this.log.warning("Payment Process Failed: " + payment + " - " + payment.getProcessMsg());
                        throw new IllegalStateException("Payment Process Failed: " + payment + " - " + payment.getProcessMsg());
                    }
                    payment.saveEx();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
        }
        sql = new StringBuilder("UPDATE I_Payment ").append("SET I_IsImported='N', Updated=getDate() ").append("WHERE I_IsImported<>'Y'").append((CharSequence)clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), "@Errors@");
        this.addLog(0, null, new BigDecimal(noInsert), "@C_Payment_ID@: @Inserted@");
        return "";
    }
}

