/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MProcessPara;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.TimeUtil;

@Process
public class FactAcctReset
extends SvrProcess {
    private int p_AD_Client_ID = 0;
    private int p_AD_Table_ID = 0;
    private boolean p_DeletePosting = false;
    private boolean p_AlsoWithoutPostings = false;
    private int m_countReset = 0;
    private int m_countDelete = 0;
    private Timestamp p_DateAcct_From = null;
    private Timestamp p_DateAcct_To = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null || para[i].getParameter_To() != null) {
                if (name.equals("AD_Client_ID")) {
                    this.p_AD_Client_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("AD_Table_ID")) {
                    this.p_AD_Table_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("DeletePosting")) {
                    this.p_DeletePosting = "Y".equals(para[i].getParameter());
                } else if (name.equals("DateAcct")) {
                    this.p_DateAcct_From = (Timestamp)para[i].getParameter();
                    this.p_DateAcct_To = (Timestamp)para[i].getParameter_To();
                } else if (name.equals("AlsoWithoutPostings")) {
                    this.p_AlsoWithoutPostings = "Y".equals(para[i].getParameter());
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        block9: {
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("AD_Client_ID=" + this.p_AD_Client_ID + ", AD_Table_ID=" + this.p_AD_Table_ID + ", DeletePosting=" + this.p_DeletePosting);
            }
            String sql = "SELECT AD_Table_ID, TableName FROM AD_Table t WHERE t.IsView='N'";
            if (this.p_AD_Table_ID > 0) {
                sql = String.valueOf(sql) + " AND t.AD_Table_ID=" + this.p_AD_Table_ID;
            }
            sql = String.valueOf(sql) + " AND EXISTS (SELECT * FROM AD_Column c WHERE t.AD_Table_ID=c.AD_Table_ID AND c.ColumnName='Posted' AND c.IsActive='Y')";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int AD_Table_ID = rs.getInt(1);
                        String TableName = rs.getString(2);
                        if (this.p_DeletePosting) {
                            this.delete(TableName, AD_Table_ID);
                            continue;
                        }
                        this.reset(TableName);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return "@Updated@ = " + this.m_countReset + ", @Deleted@ = " + this.m_countDelete;
    }

    private void reset(String TableName) {
        int invalid;
        String sql = "UPDATE " + TableName + " SET Processing='N' WHERE AD_Client_ID=" + this.p_AD_Client_ID + " AND (Processing<>'N' OR Processing IS NULL)";
        int unlocked = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        if (unlocked + (invalid = DB.executeUpdate((String)(sql = "UPDATE " + TableName + " SET Posted='N' WHERE AD_Client_ID=" + this.p_AD_Client_ID + " AND (Posted NOT IN ('Y','N') OR Posted IS NULL) AND Processed='Y'"), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.valueOf(TableName) + " - Unlocked=" + unlocked + " - Invalid=" + invalid);
        }
        this.m_countReset += unlocked + invalid;
    }

    private void delete(String TableName, int AD_Table_ID) {
        boolean autoPeriod;
        Timestamp today = TimeUtil.trunc((Timestamp)new Timestamp(System.currentTimeMillis()), (String)"D");
        MAcctSchema as = MClient.get((Properties)this.getCtx(), (int)this.getAD_Client_ID()).getAcctSchema();
        boolean bl = autoPeriod = as != null && as.isAutoPeriodControl();
        if (autoPeriod) {
            Timestamp temp = TimeUtil.addDays((Timestamp)today, (int)(-as.getPeriod_OpenHistory()));
            if (this.p_DateAcct_From == null || this.p_DateAcct_From.before(temp)) {
                this.p_DateAcct_From = temp;
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("DateAcct From set to: " + this.p_DateAcct_From);
                }
            }
            temp = TimeUtil.addDays((Timestamp)today, (int)as.getPeriod_OpenFuture());
            if (this.p_DateAcct_To == null || this.p_DateAcct_To.after(temp)) {
                this.p_DateAcct_To = temp;
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("DateAcct To set to: " + this.p_DateAcct_To);
                }
            }
        }
        this.reset(TableName);
        String docBaseType = null;
        if (AD_Table_ID == 318) {
            docBaseType = "IN ('API','APC','ARI','ARC','ARF')";
        } else if (AD_Table_ID == 319) {
            docBaseType = "IN ('MMS','MMR')";
        } else if (AD_Table_ID == 335) {
            docBaseType = "IN ('APP','ARR')";
        } else if (AD_Table_ID == 259) {
            docBaseType = "IN ('SOO','POO')";
        } else if (AD_Table_ID == 623) {
            docBaseType = "= 'PJI'";
        } else if (AD_Table_ID == 392) {
            docBaseType = "= 'CMB'";
        } else if (AD_Table_ID == 407) {
            docBaseType = "= 'CMC'";
        } else if (AD_Table_ID == 735) {
            docBaseType = "= 'CMA'";
        } else if (AD_Table_ID == 224 || AD_Table_ID == 53275 || AD_Table_ID == 53128) {
            docBaseType = "= 'GLJ'";
        } else if (AD_Table_ID == 323) {
            docBaseType = "= 'MMM'";
        } else if (AD_Table_ID == 702) {
            docBaseType = "= 'POR'";
        } else if (AD_Table_ID == 321) {
            docBaseType = "= 'MMI'";
        } else if (AD_Table_ID == 325) {
            docBaseType = "= 'MMP'";
        } else if (AD_Table_ID == 472) {
            docBaseType = "= 'MXI'";
        } else if (AD_Table_ID == 473) {
            docBaseType = "= 'MXP'";
        } else if (AD_Table_ID == 53027) {
            docBaseType = "IN ('MOP','MOF','MQO')";
        } else if (AD_Table_ID == 53037) {
            docBaseType = "= 'DOO'";
        } else if (AD_Table_ID == 53092) {
            docBaseType = "= 'HRP'";
        } else if (AD_Table_ID == 53035) {
            docBaseType = "= 'MCC'";
        } else if (AD_Table_ID == 53137 || AD_Table_ID == 53127) {
            docBaseType = "= 'GLD'";
        }
        if (docBaseType == null) {
            String s = String.valueOf(TableName) + ": Unknown DocBaseType";
            this.log.severe(s);
            this.addLog(s);
            docBaseType = "";
            return;
        }
        docBaseType = " AND pc.DocBaseType " + docBaseType;
        String sql1 = "UPDATE " + TableName + " SET Posted='N', Processing='N' " + "WHERE AD_Client_ID=" + this.p_AD_Client_ID + " AND (Posted<>'N' OR Posted IS NULL OR Processing<>'N' OR Processing IS NULL)" + " AND EXISTS (SELECT 1 FROM C_PeriodControl pc" + " INNER JOIN Fact_Acct fact ON (fact.C_Period_ID=pc.C_Period_ID) " + " WHERE fact.AD_Table_ID=" + AD_Table_ID + " AND fact.Record_ID=" + TableName + "." + TableName + "_ID";
        if (!autoPeriod) {
            sql1 = String.valueOf(sql1) + " AND pc.PeriodStatus = 'O'" + docBaseType;
        }
        if (this.p_DateAcct_From != null) {
            sql1 = String.valueOf(sql1) + " AND TRUNC(fact.DateAcct) >= " + DB.TO_DATE((Timestamp)this.p_DateAcct_From);
        }
        if (this.p_DateAcct_To != null) {
            sql1 = String.valueOf(sql1) + " AND TRUNC(fact.DateAcct) <= " + DB.TO_DATE((Timestamp)this.p_DateAcct_To);
        }
        sql1 = String.valueOf(sql1) + ")";
        if (this.log.isLoggable(Level.FINE)) {
            this.log.log(Level.FINE, sql1);
        }
        int reset = DB.executeUpdate((String)sql1, (String)this.get_TrxName());
        String sql2 = "DELETE FROM Fact_Acct WHERE AD_Client_ID=" + this.p_AD_Client_ID + " AND AD_Table_ID=" + AD_Table_ID;
        sql2 = !autoPeriod ? String.valueOf(sql2) + " AND EXISTS (SELECT 1 FROM C_PeriodControl pc WHERE pc.PeriodStatus = 'O'" + docBaseType + " AND Fact_Acct.C_Period_ID=pc.C_Period_ID)" : String.valueOf(sql2) + " AND EXISTS (SELECT 1 FROM C_PeriodControl pc WHERE Fact_Acct.C_Period_ID=pc.C_Period_ID)";
        if (this.p_DateAcct_From != null) {
            sql2 = String.valueOf(sql2) + " AND TRUNC(Fact_Acct.DateAcct) >= " + DB.TO_DATE((Timestamp)this.p_DateAcct_From);
        }
        if (this.p_DateAcct_To != null) {
            sql2 = String.valueOf(sql2) + " AND TRUNC(Fact_Acct.DateAcct) <= " + DB.TO_DATE((Timestamp)this.p_DateAcct_To);
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.log(Level.FINE, sql2);
        }
        int deleted = DB.executeUpdate((String)sql2, (String)this.get_TrxName());
        this.m_countReset += reset;
        String dateColumn = "DateAcct";
        switch (AD_Table_ID) {
            case 321: 
            case 323: 
            case 325: 
            case 623: {
                dateColumn = "MovementDate";
                break;
            }
            case 702: {
                dateColumn = "DateDoc";
                break;
            }
            case 53027: 
            case 53037: {
                dateColumn = "DateOrdered";
            }
        }
        int reset3 = 0;
        if (this.p_AlsoWithoutPostings) {
            String sql3 = "UPDATE " + TableName + " SET Posted='N', Processing='N' " + "WHERE AD_Client_ID=" + this.p_AD_Client_ID + " AND IsActive='Y'" + " AND (Posted<>'N' OR Posted IS NULL OR Processing<>'N' OR Processing IS NULL)" + " AND NOT EXISTS (SELECT 1 FROM Fact_Acct fact" + " WHERE fact.AD_Table_ID=" + AD_Table_ID + " AND fact.Record_ID=" + TableName + "." + TableName + "_ID)";
            if (!autoPeriod) {
                sql3 = String.valueOf(sql3) + " AND EXISTS (SELECT 1 FROM C_PeriodControl pc JOIN C_Period p ON (pc.C_Period_ID=p.C_Period_ID) WHERE TRUNC(" + TableName + "." + dateColumn + ") BETWEEN p.StartDate AND p.EndDate" + " AND pc.PeriodStatus = 'O'" + docBaseType + ")";
            }
            if (this.p_DateAcct_From != null) {
                sql3 = String.valueOf(sql3) + " AND TRUNC(" + TableName + "." + dateColumn + ") >= " + DB.TO_DATE((Timestamp)this.p_DateAcct_From);
            }
            if (this.p_DateAcct_To != null) {
                sql3 = String.valueOf(sql3) + " AND TRUNC(" + TableName + "." + dateColumn + ") <= " + DB.TO_DATE((Timestamp)this.p_DateAcct_To);
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.log(Level.FINE, sql3);
            }
            reset3 = DB.executeUpdate((String)sql3, (String)this.get_TrxName());
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(String.valueOf(TableName) + "(" + AD_Table_ID + ") - Reset=" + (reset + reset3) + " - Deleted=" + deleted);
        }
        String s = String.valueOf(TableName) + " - Reset=" + (reset + reset3) + " - Deleted=" + deleted;
        this.addLog(s);
        this.m_countReset += reset3;
        this.m_countDelete += deleted;
    }
}

