/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.adempiere.exceptions.BPartnerNoAddressException;
import org.compiere.model.MBPartner;
import org.compiere.model.MDunningLevel;
import org.compiere.model.MDunningRun;
import org.compiere.model.MDunningRunEntry;
import org.compiere.model.MDunningRunLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.model.MProcessPara;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

@Process
public class DunningRunCreate
extends SvrProcess {
    private boolean p_IncludeInDispute = false;
    private boolean p_OnlySOTrx = false;
    private boolean p_IsAllCurrencies = false;
    private int p_SalesRep_ID = 0;
    private int p_C_Currency_ID = 0;
    private int p_C_BPartner_ID = 0;
    private int p_C_BP_Group_ID = 0;
    private int p_C_DunningRun_ID = 0;
    private int p_AD_Org_ID = 0;
    private MDunningRun m_run = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("IncludeInDispute")) {
                    this.p_IncludeInDispute = "Y".equals(para[i].getParameter());
                } else if (name.equals("OnlySOTrx")) {
                    this.p_OnlySOTrx = "Y".equals(para[i].getParameter());
                } else if (name.equals("IsAllCurrencies")) {
                    this.p_IsAllCurrencies = "Y".equals(para[i].getParameter());
                } else if (name.equals("SalesRep_ID")) {
                    this.p_SalesRep_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_Currency_ID")) {
                    this.p_C_Currency_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_BPartner_ID")) {
                    this.p_C_BPartner_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_BP_Group_ID")) {
                    this.p_C_BP_Group_ID = para[i].getParameterAsInt();
                } else if (name.equals("AD_Org_ID")) {
                    this.p_AD_Org_ID = para[i].getParameterAsInt();
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
        this.p_C_DunningRun_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("C_DunningRun_ID=" + this.p_C_DunningRun_ID + ", Dispute=" + this.p_IncludeInDispute + ", C_BP_Group_ID=" + this.p_C_BP_Group_ID + ", C_BPartner_ID=" + this.p_C_BPartner_ID);
        }
        this.m_run = new MDunningRun(this.getCtx(), this.p_C_DunningRun_ID, this.get_TrxName());
        if (this.m_run.get_ID() == 0) {
            throw new IllegalArgumentException("Not found MDunningRun");
        }
        if (!this.m_run.deleteEntries(true)) {
            throw new IllegalArgumentException("Cannot delete existing entries");
        }
        if (this.p_SalesRep_ID == 0) {
            throw new IllegalArgumentException("No SalesRep");
        }
        if (this.p_C_Currency_ID == 0) {
            throw new IllegalArgumentException("No Currency");
        }
        MDunningLevel[] mDunningLevelArray = this.m_run.getLevels();
        int n = mDunningLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            MDunningLevel l_level = mDunningLevelArray[n2];
            this.addInvoices(l_level);
            this.addPayments(l_level);
            if (l_level.isChargeFee()) {
                this.addFees(l_level);
            }
            this.checkDunningEntry(l_level);
            ++n2;
        }
        int entries = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT COUNT(*) FROM C_DunningRunEntry WHERE C_DunningRun_ID=?", (int)this.m_run.get_ID());
        StringBuilder msgreturn = new StringBuilder("@C_DunningRunEntry_ID@ #").append(entries);
        return msgreturn.toString();
    }

    private int addInvoices(MDunningLevel level) {
        int count;
        block22: {
            MDunningLevel[] previousLevels;
            count = 0;
            StringBuilder sql = new StringBuilder("SELECT i.C_Invoice_ID, i.C_Currency_ID,");
            sql.append(" i.GrandTotal*i.MultiplierAP,");
            sql.append(" invoiceOpen(i.C_Invoice_ID,i.C_InvoicePaySchedule_ID)*MultiplierAP,");
            sql.append(" COALESCE(daysBetween(?,ips.DueDate),paymentTermDueDays(i.C_PaymentTerm_ID,i.DateInvoiced,?)),");
            sql.append(" i.IsInDispute, i.C_BPartner_ID, i.C_InvoicePaySchedule_ID ");
            sql.append("FROM C_Invoice_v i ");
            sql.append(" LEFT OUTER JOIN C_InvoicePaySchedule ips ON (i.C_InvoicePaySchedule_ID=ips.C_InvoicePaySchedule_ID) ");
            sql.append("WHERE i.IsPaid='N' AND i.AD_Client_ID=?");
            sql.append(" AND i.DocStatus IN ('CO','CL')");
            sql.append(" AND (i.DunningGrace IS NULL OR i.DunningGrace<?) ");
            sql.append(" AND EXISTS (SELECT * FROM C_DunningLevel dl ");
            sql.append("WHERE dl.C_DunningLevel_ID=?");
            sql.append(" AND dl.C_Dunning_ID IN ");
            sql.append("(SELECT COALESCE(bp.C_Dunning_ID, bpg.C_Dunning_ID) ");
            sql.append("FROM C_BPartner bp");
            sql.append(" INNER JOIN C_BP_Group bpg ON (bp.C_BP_Group_ID=bpg.C_BP_Group_ID) ");
            sql.append("WHERE i.C_BPartner_ID=bp.C_BPartner_ID");
            sql.append(" AND (bp.DunningGrace IS NULL OR bp.DunningGrace<?)))");
            if (this.p_C_BPartner_ID != 0) {
                sql.append(" AND i.C_BPartner_ID=?");
            } else if (this.p_C_BP_Group_ID != 0) {
                sql.append(" AND EXISTS (SELECT * FROM C_BPartner bp ").append("WHERE i.C_BPartner_ID=bp.C_BPartner_ID AND bp.C_BP_Group_ID=?)");
            }
            if (this.p_OnlySOTrx) {
                sql.append(" AND i.IsSOTrx='Y'");
            }
            if (!this.p_IsAllCurrencies) {
                sql.append(" AND i.C_Currency_ID=").append(this.p_C_Currency_ID);
            }
            if (this.p_AD_Org_ID != 0) {
                sql.append(" AND i.AD_Org_ID=").append(this.p_AD_Org_ID);
            }
            String sql2 = "";
            if (level.getParent().isCreateLevelsSequentially() && (previousLevels = level.getPreviousLevels()) != null && previousLevels.length > 0) {
                StringBuilder sqlAppend = new StringBuilder();
                MDunningLevel[] mDunningLevelArray = previousLevels;
                int n = previousLevels.length;
                int n2 = 0;
                while (n2 < n) {
                    MDunningLevel element = mDunningLevelArray[n2];
                    sqlAppend.append(" AND i.C_Invoice_ID IN (SELECT C_Invoice_ID FROM C_DunningRunLine WHERE ");
                    sqlAppend.append("C_DunningRunEntry_ID IN (SELECT C_DunningRunEntry_ID FROM C_DunningRunEntry WHERE ");
                    sqlAppend.append("C_DunningRun_ID IN (SELECT C_DunningRun_ID FROM C_DunningRunEntry WHERE ");
                    sqlAppend.append("C_DunningLevel_ID=");
                    sqlAppend.append(element.get_ID());
                    sqlAppend.append(")) AND Processed<>'N')");
                    ++n2;
                }
                sql.append(sqlAppend.toString());
            }
            sql2 = "SELECT COUNT(*), COALESCE(DAYSBETWEEN(MAX(dr2.DunningDate), MAX(dr.DunningDate)),0)FROM C_DunningRun dr2, C_DunningRun dr INNER JOIN C_DunningRunEntry dre ON (dr.C_DunningRun_ID=dre.C_DunningRun_ID) INNER JOIN C_DunningRunLine drl ON (dre.C_DunningRunEntry_ID=drl.C_DunningRunEntry_ID) WHERE dr2.C_DunningRun_ID=? AND drl.C_Invoice_ID=?";
            BigDecimal DaysAfterDue = level.getDaysAfterDue();
            int DaysBetweenDunning = level.getDaysBetweenDunning();
            CPreparedStatement pstmt = null;
            CPreparedStatement pstmt2 = null;
            ResultSet rs = null;
            ResultSet rs2 = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                    pstmt.setTimestamp(1, this.m_run.getDunningDate());
                    pstmt.setTimestamp(2, this.m_run.getDunningDate());
                    pstmt.setInt(3, this.m_run.getAD_Client_ID());
                    pstmt.setTimestamp(4, this.m_run.getDunningDate());
                    pstmt.setInt(5, level.getC_DunningLevel_ID());
                    pstmt.setTimestamp(6, this.m_run.getDunningDate());
                    if (this.p_C_BPartner_ID != 0) {
                        pstmt.setInt(7, this.p_C_BPartner_ID);
                    } else if (this.p_C_BP_Group_ID != 0) {
                        pstmt.setInt(7, this.p_C_BP_Group_ID);
                    }
                    pstmt2 = DB.prepareStatement((String)sql2.toString(), (String)this.get_TrxName());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int C_Invoice_ID = rs.getInt(1);
                        int C_Currency_ID = rs.getInt(2);
                        BigDecimal GrandTotal = rs.getBigDecimal(3);
                        BigDecimal Open = rs.getBigDecimal(4);
                        int DaysDue = rs.getInt(5);
                        boolean IsInDispute = "Y".equals(rs.getString(6));
                        int C_BPartner_ID = rs.getInt(7);
                        int C_InvoicePaySchedule_ID = rs.getInt(8);
                        StringBuilder msglog = new StringBuilder().append("DaysAfterDue: ").append(DaysAfterDue.intValue()).append(" isShowAllDue: ").append(level.isShowAllDue());
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.fine(msglog.toString());
                        }
                        msglog = new StringBuilder().append("C_Invoice_ID - DaysDue - GrandTotal: ").append(C_Invoice_ID).append(" - ").append(DaysDue).append(" - ").append(GrandTotal);
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.fine(msglog.toString());
                        }
                        msglog = new StringBuilder("C_InvoicePaySchedule_ID: ").append(C_InvoicePaySchedule_ID);
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.fine(msglog.toString());
                        }
                        if (!this.p_IncludeInDispute && IsInDispute || DaysDue > 0 && DaysDue < DaysAfterDue.intValue() && !level.isShowAllDue() || Env.ZERO.compareTo(Open) == 0) continue;
                        int TimesDunned = 0;
                        int DaysAfterLast = 0;
                        pstmt2.setInt(1, this.m_run.get_ID());
                        pstmt2.setInt(2, C_Invoice_ID);
                        rs2 = pstmt2.executeQuery();
                        if (rs2.next()) {
                            TimesDunned = rs2.getInt(1);
                            DaysAfterLast = rs2.getInt(2);
                        }
                        DB.close((ResultSet)rs2);
                        rs2 = null;
                        if (DaysBetweenDunning != 0 && TimesDunned > 0 && DaysAfterLast < DaysBetweenDunning && !level.isShowAllDue() && !level.isShowNotDue() || DaysDue < 0 && !level.isShowNotDue()) continue;
                        if (DaysAfterLast < DaysBetweenDunning) {
                            TimesDunned *= -1;
                        }
                        if (!this.createInvoiceLine(C_Invoice_ID, C_InvoicePaySchedule_ID, C_Currency_ID, GrandTotal, Open, DaysDue, IsInDispute, C_BPartner_ID, TimesDunned, DaysAfterLast, level.getC_DunningLevel_ID())) continue;
                        ++count;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "addInvoices", (Throwable)e);
                    this.getProcessInfo().addLog(this.getProcessInfo().getAD_PInstance_ID(), null, null, e.getLocalizedMessage());
                    DB.close(rs, (Statement)pstmt);
                    DB.close(rs2, pstmt2);
                    rs = null;
                    pstmt = null;
                    rs2 = null;
                    pstmt2 = null;
                    break block22;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                DB.close(rs2, pstmt2);
                rs = null;
                pstmt = null;
                rs2 = null;
                pstmt2 = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            DB.close(rs2, (Statement)pstmt2);
            rs = null;
            pstmt = null;
            rs2 = null;
            pstmt2 = null;
        }
        return count;
    }

    private boolean createInvoiceLine(int C_Invoice_ID, int C_InvoicePaySchedule_ID, int C_Currency_ID, BigDecimal GrandTotal, BigDecimal Open, int DaysDue, boolean IsInDispute, int C_BPartner_ID, int TimesDunned, int DaysAfterLast, int c_DunningLevel_ID) {
        MDunningRunEntry entry = null;
        try {
            entry = this.m_run.getEntry(C_BPartner_ID, this.p_C_Currency_ID, this.p_SalesRep_ID, c_DunningLevel_ID);
        }
        catch (BPartnerNoAddressException e) {
            StringBuilder msg = new StringBuilder("@Skip@ @C_Invoice_ID@ ");
            msg.append(MInvoice.get((Properties)this.getCtx(), (int)C_Invoice_ID).getDocumentInfo().toString());
            msg.append(", @C_BPartner_ID@ ");
            msg.append(MBPartner.get((Properties)this.getCtx(), (int)C_BPartner_ID).getName().toString());
            msg.append(" @No@ @IsActive@ @C_BPartner_Location_ID@");
            this.getProcessInfo().addLog(this.getProcessInfo().getAD_PInstance_ID(), null, null, msg.toString());
            return false;
        }
        if (entry.get_ID() == 0 && !entry.save()) {
            throw new IllegalStateException("Cannot save MDunningRunEntry");
        }
        MDunningRunLine line = new MDunningRunLine(entry);
        line.setInvoice(C_Invoice_ID, C_Currency_ID, GrandTotal, Open, Env.ZERO, DaysDue, IsInDispute, TimesDunned, DaysAfterLast);
        line.setC_InvoicePaySchedule_ID(C_InvoicePaySchedule_ID);
        if (!line.save()) {
            throw new IllegalStateException("Cannot save MDunningRunLine");
        }
        return true;
    }

    private int addPayments(MDunningLevel level) {
        int count;
        block15: {
            StringBuilder sql = new StringBuilder("SELECT C_Payment_ID, C_Currency_ID, PayAmt,");
            sql.append(" paymentAvailable(C_Payment_ID), C_BPartner_ID ");
            sql.append("FROM C_Payment_v p ");
            sql.append("WHERE AD_Client_ID=?");
            sql.append(" AND IsAllocated='N' AND C_BPartner_ID IS NOT NULL");
            sql.append(" AND C_Charge_ID IS NULL");
            sql.append(" AND DocStatus IN ('CO','CL')");
            sql.append(" AND EXISTS (SELECT * FROM C_DunningLevel dl ");
            sql.append("WHERE dl.C_DunningLevel_ID=?");
            sql.append(" AND dl.C_Dunning_ID IN ");
            sql.append("(SELECT COALESCE(bp.C_Dunning_ID, bpg.C_Dunning_ID) ");
            sql.append("FROM C_BPartner bp");
            sql.append(" INNER JOIN C_BP_Group bpg ON (bp.C_BP_Group_ID=bpg.C_BP_Group_ID) ");
            sql.append("WHERE p.C_BPartner_ID=bp.C_BPartner_ID))");
            if (this.p_C_BPartner_ID != 0) {
                sql.append(" AND C_BPartner_ID=?");
            } else if (this.p_C_BP_Group_ID != 0) {
                sql.append(" AND EXISTS (SELECT * FROM C_BPartner bp ").append("WHERE p.C_BPartner_ID=bp.C_BPartner_ID AND bp.C_BP_Group_ID=?)");
            }
            if (!level.isStatement()) {
                sql.append(" AND C_BPartner_ID IN (SELECT C_BPartner_ID FROM C_DunningRunEntry WHERE C_DunningRun_ID=").append(this.m_run.get_ID()).append(")");
            }
            if (this.p_OnlySOTrx) {
                sql.append(" AND IsReceipt='Y'");
            }
            if (this.p_AD_Org_ID != 0) {
                sql.append(" AND p.AD_Org_ID=").append(this.p_AD_Org_ID);
            }
            count = 0;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                    pstmt.setInt(1, this.getAD_Client_ID());
                    pstmt.setInt(2, level.getC_DunningLevel_ID());
                    if (this.p_C_BPartner_ID != 0) {
                        pstmt.setInt(3, this.p_C_BPartner_ID);
                    } else if (this.p_C_BP_Group_ID != 0) {
                        pstmt.setInt(3, this.p_C_BP_Group_ID);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int C_Payment_ID = rs.getInt(1);
                        int C_Currency_ID = rs.getInt(2);
                        BigDecimal PayAmt = rs.getBigDecimal(3).negate();
                        BigDecimal OpenAmt = rs.getBigDecimal(4).negate();
                        int C_BPartner_ID = rs.getInt(5);
                        if (Env.ZERO.compareTo(OpenAmt) == 0 || !this.createPaymentLine(C_Payment_ID, C_Currency_ID, PayAmt, OpenAmt, C_BPartner_ID, level.getC_DunningLevel_ID())) continue;
                        ++count;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    this.getProcessInfo().addLog(this.getProcessInfo().getAD_PInstance_ID(), null, null, e.getLocalizedMessage());
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block15;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return count;
    }

    private boolean createPaymentLine(int C_Payment_ID, int C_Currency_ID, BigDecimal PayAmt, BigDecimal OpenAmt, int C_BPartner_ID, int c_DunningLevel_ID) {
        MDunningRunEntry entry = null;
        try {
            entry = this.m_run.getEntry(C_BPartner_ID, this.p_C_Currency_ID, this.p_SalesRep_ID, c_DunningLevel_ID);
        }
        catch (BPartnerNoAddressException e) {
            MPayment payment = new MPayment(this.getCtx(), C_Payment_ID, null);
            StringBuilder msg = new StringBuilder("@Skip@ @C_Payment_ID@ ");
            msg.append(payment.getDocumentInfo().toString());
            msg.append(", @C_BPartner_ID@ ");
            msg.append(MBPartner.get((Properties)this.getCtx(), (int)C_BPartner_ID).getName().toString());
            msg.append(" @No@ @IsActive@ @C_BPartner_Location_ID@");
            this.getProcessInfo().addLog(this.getProcessInfo().getAD_PInstance_ID(), null, null, msg.toString());
            return false;
        }
        if (entry.get_ID() == 0 && !entry.save()) {
            throw new IllegalStateException("Cannot save MDunningRunEntry");
        }
        MDunningRunLine line = new MDunningRunLine(entry);
        line.setPayment(C_Payment_ID, C_Currency_ID, PayAmt, OpenAmt);
        if (!line.save()) {
            throw new IllegalStateException("Cannot save MDunningRunLine");
        }
        return true;
    }

    private void addFees(MDunningLevel level) {
        boolean onlyInvoices = level.isStatement();
        MDunningRunEntry[] entries = this.m_run.getEntries(true, onlyInvoices);
        if (entries != null && entries.length > 0) {
            MDunningRunEntry[] mDunningRunEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                MDunningRunEntry element = mDunningRunEntryArray[n2];
                if (!level.isShowAllDue() || !level.isShowNotDue() || element.getAmt().compareTo(Env.ZERO) >= 0) {
                    MDunningRunLine line = new MDunningRunLine(element);
                    line.setFee(this.p_C_Currency_ID, level.getFeeAmt());
                    if (!line.save()) {
                        throw new IllegalStateException("Cannot save MDunningRunLine");
                    }
                    element.setQty(element.getQty().subtract(Env.ONE));
                }
                ++n2;
            }
        }
    }

    private void checkDunningEntry(MDunningLevel level) {
        MDunningRunEntry[] entries;
        if (level.isShowAllDue() && (entries = this.m_run.getEntries(true)) != null && entries.length > 0) {
            MDunningRunEntry[] mDunningRunEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                MDunningRunEntry element = mDunningRunEntryArray[n2];
                boolean entryDelete = true;
                MDunningRunLine[] lines = element.getLines(true);
                int j = 0;
                while (j < lines.length) {
                    if (lines[j].getTimesDunned() < 0) {
                        lines[j].setTimesDunned(lines[j].getTimesDunned() * -1);
                        if (!lines[j].save()) {
                            throw new IllegalStateException("Cannot save MDunningRunLine");
                        }
                    } else {
                        entryDelete = false;
                    }
                    ++j;
                }
                if (entryDelete) {
                    element.delete(false);
                }
                ++n2;
            }
        }
    }
}

