/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MColumn;
import org.compiere.model.MMenu;
import org.compiere.model.MPInstance;
import org.compiere.model.MProcessPara;
import org.compiere.model.MTab;
import org.compiere.model.MTable;
import org.compiere.model.MWindow;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.process.TabCreateFields;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

@Process
public class CreateWindowFromTable
extends SvrProcess {
    private int p_AD_Table_ID = 0;
    private String p_WindowType = null;
    private boolean p_IsSOTrx = false;
    private boolean p_isNewWindow = false;
    private int p_AD_Window_ID = 0;
    private int p_TabLevel = 0;
    private boolean p_isCreateMenu = false;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("WindowType")) {
                    this.p_WindowType = para[i].getParameterAsString();
                } else if (name.equals("IsSOTrx")) {
                    this.p_IsSOTrx = para[i].getParameterAsBoolean();
                } else if (name.equals("IsNewWindow")) {
                    this.p_isNewWindow = para[i].getParameterAsBoolean();
                } else if (name.equals("AD_Window_ID")) {
                    this.p_AD_Window_ID = para[i].getParameterAsInt();
                } else if (name.equals("TabLevel")) {
                    this.p_TabLevel = para[i].getParameterAsInt();
                } else if (name.equals("IsCreateMenu")) {
                    this.p_isCreateMenu = para[i].getParameterAsBoolean();
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
        this.p_AD_Table_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        MTable table;
        if (this.p_AD_Table_ID == 0) {
            throw new AdempiereException("@NotFound@ @AD_Table_ID@ " + this.p_AD_Table_ID);
        }
        if (!this.p_isNewWindow && this.p_AD_Window_ID == 0) {
            throw new AdempiereException("@Mandatory@ @AD_Window_ID@");
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Source AD_Table_ID=" + this.p_AD_Table_ID);
        }
        if ((table = new MTable(this.getCtx(), this.p_AD_Table_ID, this.get_TrxName())) != null) {
            MWindow window;
            String entityType = table.getEntityType();
            if (!this.isTableValid(table)) {
                throw new AdempiereException(Msg.getMsg((Properties)this.getCtx(), (String)"NewWindowNoValid"));
            }
            int tabSeqNo = 0;
            if (this.p_isNewWindow) {
                if ("T".equals(this.p_WindowType) && !table.columnExistsInDB("Processed")) {
                    throw new AdempiereException(Msg.getMsg((Properties)this.getCtx(), (String)"TrxWindowMandatoryProcessed"));
                }
                int i = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT 1 FROM AD_Window WHERE AD_Window.name = ?", (String)table.getName());
                if (i == 1) {
                    throw new AdempiereException(Msg.getMsg((Properties)this.getCtx(), (String)"DuplicatedWindowName", (Object[])new Object[]{table.getName()}));
                }
                window = new MWindow(this.getCtx(), 0, this.get_TrxName());
                window.setName(table.getName());
                window.setIsSOTrx(this.p_IsSOTrx);
                window.setWindowType(this.p_WindowType);
                window.setEntityType(entityType);
                window.saveEx();
                this.addLog(window.getAD_Window_ID(), null, null, "@AD_Window_ID@: " + window.getName(), window.get_Table_ID(), window.getAD_Window_ID());
                this.p_TabLevel = 0;
                tabSeqNo = 10;
            } else {
                int n;
                if (this.p_TabLevel > 0) {
                    boolean hasParentLinkColumn = false;
                    MColumn[] mColumnArray = table.getColumns(false);
                    n = mColumnArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MColumn column = mColumnArray[n2];
                        if (column.isParent()) {
                            hasParentLinkColumn = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!hasParentLinkColumn) {
                        throw new AdempiereException(Msg.getMsg((Properties)this.getCtx(), (String)"NoParentLink"));
                    }
                }
                window = new MWindow(this.getCtx(), this.p_AD_Window_ID, this.get_TrxName());
                int maxTabLevel = -1;
                int maxTabSeqNo = 0;
                MTab[] mTabArray = window.getTabs(true, this.get_TrxName());
                int n3 = mTabArray.length;
                n = 0;
                while (n < n3) {
                    MTab tab = mTabArray[n];
                    if (tab.getTabLevel() > maxTabLevel) {
                        maxTabLevel = tab.getTabLevel();
                    }
                    if (tab.getSeqNo() > maxTabSeqNo) {
                        maxTabSeqNo = tab.getSeqNo();
                    }
                    ++n;
                }
                tabSeqNo = maxTabSeqNo + 10;
                if (maxTabLevel == 0 && this.p_TabLevel == 0 || this.p_TabLevel > maxTabLevel + 1) {
                    throw new AdempiereException(Msg.getMsg((Properties)this.getCtx(), (String)"MaxTabLevel", (Object[])new Object[]{maxTabLevel + 1}));
                }
            }
            MTab tab = new MTab(window);
            tab.setSeqNo(tabSeqNo);
            tab.setName(table.getName());
            tab.setAD_Table_ID(this.p_AD_Table_ID);
            tab.setTabLevel(this.p_TabLevel);
            tab.setIsSingleRow(true);
            if (table.columnExistsInDB("Value")) {
                tab.setOrderByClause(String.valueOf(table.getTableName()) + ".Value");
            } else if (table.columnExistsInDB("Name")) {
                tab.setOrderByClause(String.valueOf(table.getTableName()) + ".Name");
            } else {
                tab.setOrderByClause(String.valueOf(table.getTableName()) + ".Created DESC");
            }
            if (table.getTableName().toLowerCase().endsWith("_trl")) {
                tab.setIsTranslationTab(true);
                tab.setIsInsertRecord(false);
                if (table.columnExistsInDB("AD_Language")) {
                    tab.setOrderByClause(String.valueOf(table.getTableName()) + ".AD_Language");
                }
            }
            tab.saveEx();
            this.addLog(tab.getAD_Tab_ID(), null, null, "@AD_Tab_ID@: " + tab.getName(), tab.get_Table_ID(), tab.getAD_Tab_ID());
            ProcessInfo processInfo = new ProcessInfo("", 174, 0, tab.getAD_Tab_ID());
            MPInstance instance = new MPInstance(this.getCtx(), 174, 0);
            instance.saveEx();
            processInfo.setAD_PInstance_ID(instance.getAD_PInstance_ID());
            TabCreateFields createFields = new TabCreateFields();
            boolean success = createFields.startProcess(this.getCtx(), processInfo, Trx.get((String)this.get_TrxName(), (boolean)false));
            if (!success) {
                StringBuilder msgout = new StringBuilder("Process=").append(processInfo.getTitle()).append(" Called from=").append("CreateWindowFromTable").append(" Error=").append(processInfo.isError()).append(" Summary=").append(processInfo.getSummary());
                this.log.severe(msgout.toString());
                throw new AdempiereException(processInfo.getSummary());
            }
            if (this.p_isCreateMenu && this.p_isNewWindow) {
                MMenu menu = new MMenu(this.getCtx(), 0, this.get_TrxName());
                menu.setName(window.getName());
                menu.setEntityType(entityType);
                menu.setIsSOTrx(this.p_IsSOTrx);
                menu.setAction("W");
                menu.setAD_Window_ID(window.getAD_Window_ID());
                menu.saveEx();
                this.addLog(menu.getAD_Menu_ID(), null, null, "@AD_Menu_ID@: " + menu.getName(), menu.get_Table_ID(), menu.getAD_Menu_ID());
            }
            if (table.getAD_Window_ID() <= 0) {
                table.setAD_Window_ID(window.getAD_Window_ID());
            }
            table.saveEx();
        }
        return "@OK@";
    }

    public boolean isTableValid(MTable table) {
        boolean hasIsActive = false;
        boolean hasAD_Client_ID = false;
        boolean hasAD_Org_ID = false;
        boolean hasCreated = false;
        boolean hasUpdated = false;
        boolean hasCreatedBy = false;
        boolean hasUpdatedBy = false;
        MColumn[] mColumnArray = table.getColumns(true);
        int n = mColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            MColumn column = mColumnArray[n2];
            if (column.getAD_Element_ID() == 102) {
                hasAD_Client_ID = true;
            } else if (column.getAD_Element_ID() == 113) {
                hasAD_Org_ID = true;
            } else if (column.getAD_Element_ID() == 245) {
                hasCreated = true;
            } else if (column.getAD_Element_ID() == 246) {
                hasCreatedBy = true;
            } else if (column.getAD_Element_ID() == 348) {
                hasIsActive = true;
            } else if (column.getAD_Element_ID() == 607) {
                hasUpdated = true;
            } else if (column.getAD_Element_ID() == 608) {
                hasUpdatedBy = true;
            }
            ++n2;
        }
        return hasIsActive && hasAD_Client_ID && hasAD_Org_ID && hasCreated && hasUpdated && hasCreatedBy && hasUpdatedBy;
    }
}

