/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MProcessPara;
import org.compiere.model.MRMA;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

@Process
public class CreateFromRMA
extends SvrProcess {
    private int p_M_RMA_ID = 0;
    private ArrayList<Integer> selectionIDList = new ArrayList();
    private HashMap<String, Object> selectionValueMap = new HashMap();
    private int m_created = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("M_RMA_ID")) {
                    this.p_M_RMA_ID = para[i].getParameterAsInt();
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        if (this.p_M_RMA_ID == 0) {
            throw new AdempiereUserError("@NotFound@ @M_RMA_ID@");
        }
        if (this.getProcessInfo().getAD_InfoWindow_ID() > 0) {
            return this.createLines();
        }
        throw new AdempiereException("@NotSupported@");
    }

    private String createLines() {
        String ColumnName;
        int T_Selection_ID;
        MRMA rma = new MRMA(this.getCtx(), this.p_M_RMA_ID, this.get_TrxName());
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config(rma.toString());
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT t.T_Selection_ID, v.Line, v.M_InOut_ID, v.M_InOutLine_ID, ");
        sql.append("v.MovementQty, v.Description ");
        sql.append("FROM T_Selection t, M_RMA_CreateFrom_v v ");
        sql.append("WHERE t.T_Selection_ID=v.M_RMA_CreateFrom_v_ID ");
        sql.append("AND t.AD_PInstance_ID=? ");
        sql.append("ORDER BY v.Line, v.M_InOut_ID, t.T_Selection_ID ");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                pstmt.setInt(1, this.getAD_PInstance_ID());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    T_Selection_ID = rs.getInt("T_Selection_ID");
                    if (!this.selectionIDList.contains(T_Selection_ID)) {
                        this.selectionIDList.add(T_Selection_ID);
                    }
                    ColumnName = "M_InOutLine_ID";
                    String key = String.valueOf(ColumnName) + "_" + T_Selection_ID;
                    this.selectionValueMap.put(key, rs.getInt(ColumnName));
                    ColumnName = "MovementQty";
                    key = String.valueOf(ColumnName) + "_" + T_Selection_ID;
                    this.selectionValueMap.put(key, rs.getBigDecimal(ColumnName));
                    ColumnName = "Description";
                    key = String.valueOf(ColumnName) + "_" + T_Selection_ID;
                    this.selectionValueMap.put(key, rs.getString(ColumnName));
                }
            }
            catch (Exception e) {
                throw new AdempiereException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        sql = new StringBuilder();
        sql.append("SELECT T_Selection_ID, ColumnName, Value_String, Value_Number, Value_Date ");
        sql.append("FROM T_Selection_InfoWindow ");
        sql.append("WHERE AD_PInstance_ID=? ");
        sql.append("ORDER BY T_Selection_ID, ColumnName ");
        pstmt = null;
        rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                pstmt.setInt(1, this.getAD_PInstance_ID());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    T_Selection_ID = rs.getInt("T_Selection_ID");
                    ColumnName = rs.getString("ColumnName");
                    String Value_String = rs.getString("Value_String");
                    Number Value_Number = null;
                    Value_Number = ColumnName.toUpperCase().endsWith("_ID") ? Integer.valueOf(rs.getInt("Value_Number")) : rs.getBigDecimal("Value_Number");
                    Timestamp Value_Date = rs.getTimestamp("Value_Date");
                    String key = String.valueOf(ColumnName) + "_" + T_Selection_ID;
                    Object value = null;
                    if (Value_String != null) {
                        value = Value_String;
                    } else if (Value_Number != null) {
                        value = Value_Number;
                    } else if (Value_Date != null) {
                        value = Value_Date;
                    }
                    this.selectionValueMap.put(key, value);
                }
            }
            catch (Exception e) {
                throw new AdempiereException((Throwable)e);
            }
        }
        finally {
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        int i = 0;
        while (i < this.selectionIDList.size()) {
            int T_Selection_ID2 = this.selectionIDList.get(i);
            String ColumnName2 = "M_InOutLine_ID";
            String key = String.valueOf(ColumnName2) + "_" + T_Selection_ID2;
            Object value = this.selectionValueMap.get(key);
            int M_InOutLine_ID = value != null ? ((Number)value).intValue() : 0;
            ColumnName2 = "MovementQty";
            key = String.valueOf(ColumnName2) + "_" + T_Selection_ID2;
            value = this.selectionValueMap.get(key);
            BigDecimal MovementQty = value != null ? (BigDecimal)value : null;
            ColumnName2 = "Description";
            key = String.valueOf(ColumnName2) + "_" + T_Selection_ID2;
            value = this.selectionValueMap.get(key);
            String Description = value != null ? (String)value : null;
            rma.createLineFrom(M_InOutLine_ID, MovementQty, Description);
            ++this.m_created;
            ++i;
        }
        StringBuilder msgreturn = new StringBuilder("@Created@ = ").append(this.m_created);
        return msgreturn.toString();
    }
}

