/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MProcessPara;
import org.compiere.model.MProduct;
import org.compiere.model.MRMA;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

@Process
public class CreateFromInvoice
extends SvrProcess {
    private int p_C_Invoice_ID = 0;
    private ArrayList<Integer> selectionIDList = new ArrayList();
    private HashMap<String, Object> selectionValueMap = new HashMap();
    private int m_created = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_Invoice_ID")) {
                    this.p_C_Invoice_ID = para[i].getParameterAsInt();
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        if (this.p_C_Invoice_ID == 0) {
            throw new AdempiereUserError("@NotFound@ @C_Invoice_ID@");
        }
        if (this.getProcessInfo().getAD_InfoWindow_ID() > 0) {
            return this.createLines();
        }
        throw new AdempiereException("@NotSupported@");
    }

    private String createLines() {
        Object value;
        String key;
        String ColumnName;
        int T_Selection_ID;
        MInvoice invoice = new MInvoice(this.getCtx(), this.p_C_Invoice_ID, this.get_TrxName());
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config(invoice.toString());
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT t.T_Selection_ID, t.ViewID, v.AD_Table_ID, v.Line, v.C_Order_ID, v.M_InOut_ID, v.M_RMA_ID, ");
        sql.append("v.Qty, v.C_UOM_ID, v.M_Product_ID, v.C_OrderLine_ID, v.M_InOutLine_ID, v.M_RMALine_ID ");
        sql.append("FROM T_Selection t, C_Invoice_CreateFrom_v v ");
        sql.append("WHERE (t.ViewID || '_' || t.T_Selection_ID)=(v.AD_Table_ID || '_' || v.C_Invoice_CreateFrom_v_ID) ");
        sql.append("AND t.AD_PInstance_ID=? ");
        sql.append("ORDER BY v.Line, v.AD_Table_ID, t.T_Selection_ID ");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                pstmt.setInt(1, this.getAD_PInstance_ID());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    T_Selection_ID = rs.getInt("T_Selection_ID");
                    if (!this.selectionIDList.contains(T_Selection_ID)) {
                        this.selectionIDList.add(T_Selection_ID);
                    }
                    ColumnName = "AD_Table_ID";
                    String key2 = String.valueOf(ColumnName) + "_" + T_Selection_ID;
                    this.selectionValueMap.put(key2, rs.getInt(ColumnName));
                    ColumnName = "Line";
                    key2 = String.valueOf(ColumnName) + "_" + T_Selection_ID;
                    this.selectionValueMap.put(key2, rs.getInt(ColumnName));
                    ColumnName = "C_Order_ID";
                    key2 = String.valueOf(ColumnName) + "_" + T_Selection_ID;
                    this.selectionValueMap.put(key2, rs.getInt(ColumnName));
                    ColumnName = "M_InOut_ID";
                    key2 = String.valueOf(ColumnName) + "_" + T_Selection_ID;
                    this.selectionValueMap.put(key2, rs.getInt(ColumnName));
                    ColumnName = "M_RMA_ID";
                    key2 = String.valueOf(ColumnName) + "_" + T_Selection_ID;
                    this.selectionValueMap.put(key2, rs.getInt(ColumnName));
                    ColumnName = "Qty";
                    key2 = String.valueOf(ColumnName) + "_" + T_Selection_ID;
                    this.selectionValueMap.put(key2, rs.getBigDecimal(ColumnName));
                    ColumnName = "C_UOM_ID";
                    key2 = String.valueOf(ColumnName) + "_" + T_Selection_ID;
                    this.selectionValueMap.put(key2, rs.getInt(ColumnName));
                    ColumnName = "M_Product_ID";
                    key2 = String.valueOf(ColumnName) + "_" + T_Selection_ID;
                    this.selectionValueMap.put(key2, rs.getInt(ColumnName));
                    ColumnName = "C_OrderLine_ID";
                    key2 = String.valueOf(ColumnName) + "_" + T_Selection_ID;
                    this.selectionValueMap.put(key2, rs.getInt(ColumnName));
                    ColumnName = "M_InOutLine_ID";
                    key2 = String.valueOf(ColumnName) + "_" + T_Selection_ID;
                    this.selectionValueMap.put(key2, rs.getInt(ColumnName));
                    ColumnName = "M_RMALine_ID";
                    key2 = String.valueOf(ColumnName) + "_" + T_Selection_ID;
                    this.selectionValueMap.put(key2, rs.getInt(ColumnName));
                }
            }
            catch (Exception e) {
                throw new AdempiereException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        sql = new StringBuilder();
        sql.append("SELECT T_Selection_ID, ColumnName, Value_String, Value_Number, Value_Date ");
        sql.append("FROM T_Selection_InfoWindow ");
        sql.append("WHERE AD_PInstance_ID=? ");
        sql.append("ORDER BY T_Selection_ID, ColumnName ");
        pstmt = null;
        rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                pstmt.setInt(1, this.getAD_PInstance_ID());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    T_Selection_ID = rs.getInt("T_Selection_ID");
                    ColumnName = rs.getString("ColumnName");
                    String Value_String = rs.getString("Value_String");
                    Number Value_Number = null;
                    Value_Number = ColumnName.toUpperCase().endsWith("_ID") ? Integer.valueOf(rs.getInt("Value_Number")) : rs.getBigDecimal("Value_Number");
                    Timestamp Value_Date = rs.getTimestamp("Value_Date");
                    key = String.valueOf(ColumnName) + "_" + T_Selection_ID;
                    value = null;
                    if (Value_String != null) {
                        value = Value_String;
                    } else if (Value_Number != null) {
                        value = Value_Number;
                    } else if (Value_Date != null) {
                        value = Value_Date;
                    }
                    this.selectionValueMap.put(key, value);
                }
            }
            catch (Exception e) {
                throw new AdempiereException((Throwable)e);
            }
        }
        finally {
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        MOrder m_order = null;
        MRMA m_rma = null;
        int i = 0;
        while (i < this.selectionIDList.size()) {
            int M_RMA_ID;
            int C_Order_ID;
            int T_Selection_ID2 = this.selectionIDList.get(i);
            String ColumnName2 = "C_Order_ID";
            key = String.valueOf(ColumnName2) + "_" + T_Selection_ID2;
            value = this.selectionValueMap.get(key);
            int n = C_Order_ID = value != null ? ((Number)value).intValue() : 0;
            if (C_Order_ID != 0 && (m_order == null || m_order.getC_Order_ID() != C_Order_ID) && (m_order = new MOrder(this.getCtx(), C_Order_ID, this.get_TrxName())) != null) {
                invoice.setOrder(m_order);
                invoice.saveEx();
            }
            int n2 = M_RMA_ID = (value = this.selectionValueMap.get(key = String.valueOf(ColumnName2 = "M_RMA_ID") + "_" + T_Selection_ID2)) != null ? ((Number)value).intValue() : 0;
            if (M_RMA_ID != 0 && (m_rma == null || m_rma.getM_RMA_ID() != M_RMA_ID) && (m_rma = new MRMA(this.getCtx(), M_RMA_ID, this.get_TrxName())) != null) {
                invoice.setM_RMA_ID(m_rma.getM_RMA_ID());
                invoice.saveEx();
            }
            BigDecimal QtyEntered = (value = this.selectionValueMap.get(key = String.valueOf(ColumnName2 = "Qty") + "_" + T_Selection_ID2)) != null ? (BigDecimal)value : null;
            ColumnName2 = "C_UOM_ID";
            key = String.valueOf(ColumnName2) + "_" + T_Selection_ID2;
            value = this.selectionValueMap.get(key);
            int C_UOM_ID = value != null ? ((Number)value).intValue() : 0;
            ColumnName2 = "M_Product_ID";
            key = String.valueOf(ColumnName2) + "_" + T_Selection_ID2;
            value = this.selectionValueMap.get(key);
            int M_Product_ID = value != null ? ((Number)value).intValue() : 0;
            ColumnName2 = "C_OrderLine_ID";
            key = String.valueOf(ColumnName2) + "_" + T_Selection_ID2;
            value = this.selectionValueMap.get(key);
            int C_OrderLine_ID = value != null ? ((Number)value).intValue() : 0;
            ColumnName2 = "M_InOutLine_ID";
            key = String.valueOf(ColumnName2) + "_" + T_Selection_ID2;
            value = this.selectionValueMap.get(key);
            int M_InOutLine_ID = value != null ? ((Number)value).intValue() : 0;
            ColumnName2 = "M_RMALine_ID";
            key = String.valueOf(ColumnName2) + "_" + T_Selection_ID2;
            value = this.selectionValueMap.get(key);
            int M_RMALine_ID = value != null ? ((Number)value).intValue() : 0;
            int precision = 2;
            if (M_Product_ID != 0) {
                MProduct product = MProduct.get((Properties)this.getCtx(), (int)M_Product_ID);
                precision = product.getUOMPrecision();
            }
            QtyEntered = QtyEntered.setScale(precision, RoundingMode.HALF_DOWN);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Line QtyEntered=" + QtyEntered + ", Product=" + M_Product_ID + ", OrderLine=" + C_OrderLine_ID + ", InOutLine_ID=" + M_InOutLine_ID);
            }
            invoice.createLineFrom(C_OrderLine_ID, M_InOutLine_ID, M_RMALine_ID, M_Product_ID, C_UOM_ID, QtyEntered);
            ++this.m_created;
            ++i;
        }
        invoice.updateFrom(m_order);
        StringBuilder msgreturn = new StringBuilder("@Created@ = ").append(this.m_created);
        return msgreturn.toString();
    }
}

