/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MColumn;
import org.compiere.model.MProcessPara;
import org.compiere.model.MTable;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.CacheMgt;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.SecureEngine;

@Process
public class ColumnEncryption
extends SvrProcess {
    private boolean p_IsEncrypted = false;
    private boolean p_ChangeSetting = false;
    private int p_MaxLength = 0;
    private String p_TestValue = null;
    private int p_AD_Column_ID = 0;
    private int count;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("IsEncrypted")) {
                    this.p_IsEncrypted = "Y".equals(para[i].getParameter());
                } else if (name.equals("ChangeSetting")) {
                    this.p_ChangeSetting = "Y".equals(para[i].getParameter());
                } else if (name.equals("MaxLength")) {
                    this.p_MaxLength = para[i].getParameterAsInt();
                } else if (name.equals("TestValue")) {
                    this.p_TestValue = (String)para[i].getParameter();
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
        this.p_AD_Column_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        int encLength;
        MColumn column;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("AD_Column_ID=" + this.p_AD_Column_ID + ", IsEncrypted=" + this.p_IsEncrypted + ", ChangeSetting=" + this.p_ChangeSetting + ", MaxLength=" + this.p_MaxLength);
        }
        if ((column = new MColumn(this.getCtx(), this.p_AD_Column_ID, this.get_TrxName())).get_ID() == 0 || column.get_ID() != this.p_AD_Column_ID) {
            throw new AdempiereUserError("@NotFound@ @AD_Column_ID@ - " + this.p_AD_Column_ID);
        }
        String columnName = column.getColumnName();
        int dt = column.getAD_Reference_ID();
        if (column.isKey() || column.isParent() || column.isStandardColumn() || column.isUUIDColumn() || column.isVirtualColumn() || column.isIdentifier() || column.isTranslated() || DisplayType.isLookup((int)dt) || DisplayType.isLOB((int)dt) || DisplayType.isDate((int)dt) || DisplayType.isNumeric((int)dt) || "DocumentNo".equalsIgnoreCase(column.getColumnName()) || "Value".equalsIgnoreCase(column.getColumnName()) || "Name".equalsIgnoreCase(column.getColumnName())) {
            if (column.isEncrypted()) {
                column.setIsEncrypted(false);
                column.saveEx();
            }
            StringBuilder msgreturn = new StringBuilder().append(columnName).append(": cannot be encrypted");
            throw new Exception(msgreturn.toString());
        }
        StringBuilder msglog = new StringBuilder("Encryption Class = ").append(SecureEngine.getClassName());
        this.addLog(0, null, null, msglog.toString());
        boolean error = false;
        if (this.p_IsEncrypted && this.p_TestValue != null && this.p_TestValue.length() > 0) {
            String encString = SecureEngine.encrypt((String)this.p_TestValue, (int)0);
            msglog = new StringBuilder("Encrypted Test Value=").append(encString);
            this.addLog(0, null, null, msglog.toString());
            String clearString = SecureEngine.decrypt((String)encString, (int)0);
            if (this.p_TestValue.equals(clearString)) {
                msglog = new StringBuilder("Decrypted=").append(clearString).append(" (same as test value)");
                this.addLog(0, null, null, msglog.toString());
            } else {
                msglog = new StringBuilder("Decrypted=").append(clearString).append(" (NOT the same as test value - check algorithm)");
                this.addLog(0, null, null, msglog.toString());
                error = true;
            }
            encLength = encString.length();
            msglog = new StringBuilder("Test Length=").append(this.p_TestValue.length()).append(" -> ").append(encLength);
            this.addLog(0, null, null, msglog.toString());
            if (encLength <= column.getFieldLength()) {
                msglog = new StringBuilder("Encrypted Length (").append(encLength).append(") fits into field (").append(column.getFieldLength()).append(")");
                this.addLog(0, null, null, msglog.toString());
            } else {
                msglog = new StringBuilder("Encrypted Length (").append(encLength).append(") does NOT fit into field (").append(column.getFieldLength()).append(") - resize field");
                this.addLog(0, null, null, msglog.toString());
                error = true;
            }
        }
        if (this.p_IsEncrypted && this.p_MaxLength != 0) {
            StringBuilder testClear = new StringBuilder();
            testClear.append("1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ");
            while (testClear.length() < this.p_MaxLength) {
                testClear.append((CharSequence)testClear);
            }
            testClear.delete(this.p_MaxLength, testClear.length());
            msglog = new StringBuilder().append("Test=").append(testClear.toString()).append(" (").append(this.p_MaxLength).append(")");
            if (this.log.isLoggable(Level.CONFIG)) {
                this.log.config(msglog.toString());
            }
            String encString = SecureEngine.encrypt((String)testClear.toString(), (int)0);
            encLength = encString.length();
            msglog = new StringBuilder("Test Max Length=").append(testClear.length()).append(" -> ").append(encLength);
            this.addLog(0, null, null, msglog.toString());
            if (encLength <= column.getFieldLength()) {
                msglog = new StringBuilder("Encrypted Max Length (").append(encLength).append(") fits into field (").append(column.getFieldLength()).append(")");
                this.addLog(0, null, null, msglog.toString());
            } else {
                msglog = new StringBuilder("Encrypted Max Length (").append(encLength).append(") does NOT fit into field (").append(column.getFieldLength()).append(") - resize field");
                this.addLog(0, null, null, msglog.toString());
                error = true;
            }
        }
        if (error) {
            msglog = new StringBuilder("Encryption NOT changed - Encryption=").append(column.isEncrypted());
            this.addLog(0, null, null, msglog.toString());
        } else {
            this.count = 0;
            if (this.p_ChangeSetting && column.isEncrypted() != this.p_IsEncrypted) {
                int columnID = column.get_ID();
                MTable table = MTable.get((Properties)this.getCtx(), (int)column.getAD_Table_ID());
                if (this.p_IsEncrypted) {
                    int oldLength = column.getFieldLength();
                    int newLength = this.encryptedColumnLength(this.p_MaxLength > 0 ? this.p_MaxLength : oldLength);
                    if (newLength > oldLength && this.changeFieldLength(table, column, newLength) < 0) {
                        this.log.warning("EncryptError [ChangeFieldLength]: ColumnID=" + columnID + ", NewLength=" + newLength);
                        throw new Exception();
                    }
                    this.count = this.encryptColumnContents(columnName, column.getAD_Table_ID());
                    if (this.count == -1) {
                        this.log.warning("EncryptError: No records encrypted.");
                        throw new Exception();
                    }
                } else {
                    this.count = this.decryptColumnContents(columnName, column.getAD_Table_ID());
                    if (this.count == -1) {
                        this.log.warning("DecryptError: No records decrypted.");
                        throw new Exception();
                    }
                }
                column.setIsEncrypted(this.p_IsEncrypted);
                if (column.save()) {
                    this.addLog(0, null, null, "#" + (this.p_IsEncrypted ? "Encrypted=" : "Decrypted=") + this.count);
                    msglog = new StringBuilder("Encryption CHANGED - Encryption=").append(column.isEncrypted());
                    this.addLog(0, null, null, msglog.toString());
                } else {
                    this.addLog(0, null, null, "Save Error");
                }
            } else {
                this.addLog(0, null, null, "Can't perform " + (this.p_IsEncrypted ? "encryption. " : "decryption. ") + "Column is " + (this.p_IsEncrypted ? "already Encrypted." : " not Encrypted."));
            }
        }
        StringBuilder msgreturn = new StringBuilder("Encryption=").append(column.isEncrypted());
        return msgreturn.toString();
    }

    private int encryptColumnContents(String columnName, int tableID) throws Exception {
        String tableName = MTable.getTableName((Properties)this.getCtx(), (int)tableID);
        return this.encryptColumnContents(columnName, tableName);
    }

    private int encryptColumnContents(String columnName, String tableName) throws Exception {
        int recordsEncrypted = 0;
        StringBuilder idColumnName = new StringBuilder(tableName).append("_ID");
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("SELECT ").append((CharSequence)idColumnName).append(",").append(columnName).append(",AD_Client_ID");
        selectSql.append(" FROM ").append(tableName);
        selectSql.append(" ORDER BY 1");
        StringBuilder updateSql = new StringBuilder();
        updateSql.append("UPDATE ").append(tableName);
        updateSql.append(" SET ").append(columnName).append("=?");
        updateSql.append(" WHERE ").append((CharSequence)idColumnName).append("=?");
        CPreparedStatement selectStmt = null;
        CPreparedStatement updateStmt = null;
        ResultSet rs = null;
        try {
            selectStmt = DB.prepareStatement((String)selectSql.toString(), (String)this.get_TrxName());
            updateStmt = DB.prepareStatement((String)updateSql.toString(), (String)this.get_TrxName());
            rs = selectStmt.executeQuery();
            recordsEncrypted = 0;
            while (rs.next()) {
                int id = rs.getInt(1);
                String value = rs.getString(2);
                int AD_Client_ID = rs.getInt(3);
                value = SecureEngine.encrypt((String)value, (int)AD_Client_ID);
                updateStmt.setString(1, value);
                updateStmt.setInt(2, id);
                if (updateStmt.executeUpdate() != 1) {
                    this.log.severe("EncryptError: Table=" + tableName + ", ID=" + id);
                    throw new Exception();
                }
                ++recordsEncrypted;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs);
            DB.close((Statement)selectStmt);
            DB.close(updateStmt);
            throw throwable;
        }
        DB.close((ResultSet)rs);
        DB.close((Statement)selectStmt);
        DB.close((Statement)updateStmt);
        return recordsEncrypted;
    }

    private int decryptColumnContents(String columnName, int tableID) throws Exception {
        String tableName = MTable.getTableName((Properties)this.getCtx(), (int)tableID);
        return this.decryptColumnContents(columnName, tableName);
    }

    private int decryptColumnContents(String columnName, String tableName) throws Exception {
        int recordsDecrypted = 0;
        StringBuilder idColumnName = new StringBuilder(tableName).append("_ID");
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("SELECT ").append((CharSequence)idColumnName).append(",").append(columnName).append(",AD_Client_ID");
        selectSql.append(" FROM ").append(tableName);
        selectSql.append(" ORDER BY ").append((CharSequence)idColumnName);
        StringBuilder updateSql = new StringBuilder();
        updateSql.append("UPDATE ").append(tableName);
        updateSql.append(" SET ").append(columnName).append("=?");
        updateSql.append(" WHERE ").append((CharSequence)idColumnName).append("=?");
        CPreparedStatement selectStmt = null;
        CPreparedStatement updateStmt = null;
        ResultSet rs = null;
        try {
            selectStmt = DB.prepareStatement((String)selectSql.toString(), (String)this.get_TrxName());
            updateStmt = DB.prepareStatement((String)updateSql.toString(), (String)this.get_TrxName());
            rs = selectStmt.executeQuery();
            recordsDecrypted = 0;
            while (rs.next()) {
                int id = rs.getInt(1);
                String value = rs.getString(2);
                int AD_Client_ID = rs.getInt(3);
                value = SecureEngine.decrypt((String)value, (int)AD_Client_ID);
                updateStmt.setString(1, value);
                updateStmt.setInt(2, id);
                if (updateStmt.executeUpdate() != 1) {
                    this.log.severe("DecryptError: Table=" + tableName + ", ID=" + id);
                    throw new Exception();
                }
                ++recordsDecrypted;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs);
            DB.close((Statement)selectStmt);
            DB.close(updateStmt);
            throw throwable;
        }
        DB.close((ResultSet)rs);
        DB.close((Statement)selectStmt);
        DB.close((Statement)updateStmt);
        return recordsDecrypted;
    }

    private int encryptedColumnLength(int colLength) {
        StringBuilder str = new StringBuilder();
        int i = 0;
        while (i < colLength) {
            str.append("1");
            ++i;
        }
        str = new StringBuilder().append(SecureEngine.encrypt((String)str.toString(), (int)0));
        return str.length();
    }

    private int changeFieldLength(MTable table, MColumn column, int length) throws Exception {
        column.setFieldLength(length);
        column.saveEx();
        String sql = column.getSQLModify(table, false);
        int no = -1;
        if (sql.indexOf("; ") == -1) {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        } else {
            String[] statements = sql.toString().split("; ");
            int i = 0;
            while (i < statements.length) {
                int count = DB.executeUpdateEx((String)statements[i], (String)this.get_TrxName());
                no += count;
                ++i;
            }
        }
        return no;
    }

    protected void postProcess(boolean success) {
        if (this.count > 0 && success) {
            CacheMgt.get().reset();
        }
    }
}

