/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MBPartner;
import org.compiere.model.MProcessPara;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.Msg;

@Process
public class BPartnerOrgUnLink
extends SvrProcess {
    private int p_C_BPartner_ID;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_BPartner_ID")) {
                    this.p_C_BPartner_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("doIt - C_BPartner_ID=" + this.p_C_BPartner_ID);
        }
        if (this.p_C_BPartner_ID == 0) {
            throw new IllegalArgumentException("No Business Partner ID");
        }
        MBPartner bp = new MBPartner(this.getCtx(), this.p_C_BPartner_ID, this.get_TrxName());
        if (bp.get_ID() == 0) {
            throw new AdempiereUserError(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"BPartnerNotFound")) + " - C_BPartner_ID=" + this.p_C_BPartner_ID);
        }
        if (bp.getAD_OrgBP_ID() == 0) {
            throw new IllegalArgumentException("Business Partner not linked to an Organization");
        }
        bp.setAD_OrgBP_ID(0);
        if (!bp.save()) {
            throw new IllegalArgumentException("Business Partner not changed");
        }
        return "OK";
    }
}

