/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MAging;
import org.compiere.model.MProcessPara;
import org.compiere.model.MRole;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.TimeUtil;

@Process
public class Aging
extends SvrProcess {
    private Timestamp p_StatementDate = null;
    private boolean p_DateAcct = false;
    private boolean p_IsSOTrx = false;
    private int p_ConvertCurrencyTo_ID = 0;
    private int p_AD_Org_ID = 0;
    private int p_C_BP_Group_ID = 0;
    private int p_C_BPartner_ID = 0;
    private boolean p_IsListInvoices = false;
    private int m_statementOffset = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("StatementDate")) {
                    this.p_StatementDate = (Timestamp)para[i].getParameter();
                } else if (name.equals("DateAcct")) {
                    this.p_DateAcct = "Y".equals(para[i].getParameter());
                } else if (name.equals("IsSOTrx")) {
                    this.p_IsSOTrx = "Y".equals(para[i].getParameter());
                } else if (!name.equals("C_Currency_ID")) {
                    if (name.equals("ConvertAmountsInCurrency_ID")) {
                        this.p_ConvertCurrencyTo_ID = para[i].getParameterAsInt();
                    } else if (name.equals("AD_Org_ID")) {
                        this.p_AD_Org_ID = ((BigDecimal)para[i].getParameter()).intValue();
                    } else if (name.equals("C_BP_Group_ID")) {
                        this.p_C_BP_Group_ID = ((BigDecimal)para[i].getParameter()).intValue();
                    } else if (name.equals("C_BPartner_ID")) {
                        this.p_C_BPartner_ID = ((BigDecimal)para[i].getParameter()).intValue();
                    } else if (name.equals("IsListInvoices")) {
                        this.p_IsListInvoices = "Y".equals(para[i].getParameter());
                    } else {
                        MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                    }
                }
            }
            ++i;
        }
        if (this.p_StatementDate == null) {
            this.p_StatementDate = new Timestamp(System.currentTimeMillis());
        } else {
            this.m_statementOffset = TimeUtil.getDaysBetween((Timestamp)new Timestamp(System.currentTimeMillis()), (Timestamp)this.p_StatementDate);
        }
    }

    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("StatementDate=" + this.p_StatementDate + ", IsSOTrx=" + this.p_IsSOTrx + ", ConvertAmountsInCurrency_ID=" + this.p_ConvertCurrencyTo_ID + ", AD_Org_ID=" + this.p_AD_Org_ID + ", C_BP_Group_ID=" + this.p_C_BP_Group_ID + ", C_BPartner_ID=" + this.p_C_BPartner_ID + ", IsListInvoices=" + this.p_IsListInvoices);
        }
        String dateacct = DB.TO_DATE((Timestamp)this.p_StatementDate);
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT bp.C_BP_Group_ID, oi.C_BPartner_ID,oi.C_Invoice_ID,oi.C_InvoicePaySchedule_ID, oi.C_Currency_ID, oi.IsSOTrx, oi.DateInvoiced, oi.NetDays,oi.DueDate,oi.DaysDue, ");
        if (this.p_ConvertCurrencyTo_ID == 0) {
            if (!this.p_DateAcct) {
                sql.append(" oi.GrandTotal, oi.PaidAmt, oi.OpenAmt ");
            } else {
                sql.append(" oi.GrandTotal, invoicePaidToDate(oi.C_Invoice_ID, oi.C_Currency_ID, 1," + dateacct + ") AS PaidAmt, invoiceOpenToDate(oi.C_Invoice_ID,oi.C_InvoicePaySchedule_ID," + dateacct + ") AS OpenAmt ");
            }
        } else {
            String s = "," + this.p_ConvertCurrencyTo_ID;
            sql.append("currencyConvertInvoice(oi.C_Invoice_ID").append(s).append(")");
            if (!this.p_DateAcct) {
                sql.append(", currencyConvertInvoice(oi.C_Invoice_ID").append(s).append(",oi.PaidAmt), currencyConvertInvoice(oi.C_Invoice_ID").append(s).append(",oi.OpenAmt)");
            } else {
                sql.append(", currencyConvertInvoice(oi.C_Invoice_ID").append(s).append(",invoicePaidToDate(oi.C_Invoice_ID, oi.C_Currency_ID, 1," + dateacct + ")), " + "currencyConvertInvoice(oi.C_Invoice_ID").append(s).append(",invoiceOpenToDate(oi.C_Invoice_ID,oi.C_InvoicePaySchedule_ID," + dateacct + "))");
            }
        }
        sql.append(",oi.C_Activity_ID,oi.C_Campaign_ID,oi.C_Project_ID,oi.AD_Org_ID ");
        if (!this.p_DateAcct) {
            sql.append(" FROM RV_OpenItem oi");
        } else {
            sql.append(" FROM RV_OpenItemToDate oi");
        }
        sql.append(" INNER JOIN C_BPartner bp ON (oi.C_BPartner_ID=bp.C_BPartner_ID) WHERE oi.ISSoTrx=").append(this.p_IsSOTrx ? "'Y'" : "'N'");
        if (this.p_C_BPartner_ID > 0) {
            sql.append(" AND oi.C_BPartner_ID=").append(this.p_C_BPartner_ID);
        } else if (this.p_C_BP_Group_ID > 0) {
            sql.append(" AND bp.C_BP_Group_ID=").append(this.p_C_BP_Group_ID);
        }
        if (this.p_AD_Org_ID > 0) {
            sql.append(" AND oi.AD_Org_ID=").append(this.p_AD_Org_ID);
        }
        if (this.p_DateAcct) {
            sql.append(" AND invoiceOpenToDate(oi.C_Invoice_ID,oi.C_InvoicePaySchedule_ID," + dateacct + ") <> 0 ");
        }
        sql.append(" ORDER BY oi.C_BPartner_ID, oi.C_Currency_ID, oi.C_Invoice_ID");
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest(sql.toString());
        }
        String finalSql = MRole.getDefault((Properties)this.getCtx(), (boolean)false).addAccessSQL(sql.toString(), "oi", true, false);
        this.log.finer(finalSql);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        MAging aging = null;
        int counter = 0;
        int rows = 0;
        int AD_PInstance_ID = this.getAD_PInstance_ID();
        try {
            try {
                pstmt = DB.prepareStatement((String)finalSql, (String)this.get_TrxName());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int C_BP_Group_ID = rs.getInt(1);
                    int C_BPartner_ID = rs.getInt(2);
                    int C_Invoice_ID = this.p_IsListInvoices ? rs.getInt(3) : 0;
                    int C_InvoicePaySchedule_ID = this.p_IsListInvoices ? rs.getInt(4) : 0;
                    int C_Currency_ID = rs.getInt(5);
                    boolean IsSOTrx = "Y".equals(rs.getString(6));
                    Timestamp DueDate = rs.getTimestamp(9);
                    int DaysDue = rs.getInt(10) + this.m_statementOffset;
                    BigDecimal GrandTotal = rs.getBigDecimal(11);
                    BigDecimal OpenAmt = rs.getBigDecimal(13);
                    int C_Activity_ID = this.p_IsListInvoices ? rs.getInt(14) : 0;
                    int C_Campaign_ID = this.p_IsListInvoices ? rs.getInt(15) : 0;
                    int C_Project_ID = this.p_IsListInvoices ? rs.getInt(16) : 0;
                    int AD_Org_ID = rs.getInt(17);
                    ++rows;
                    if (aging == null || AD_PInstance_ID != aging.getAD_PInstance_ID() || C_BPartner_ID != aging.getC_BPartner_ID() || C_Currency_ID != aging.getC_Currency_ID() || C_Invoice_ID != aging.getC_Invoice_ID() || C_InvoicePaySchedule_ID != aging.getC_InvoicePaySchedule_ID()) {
                        if (aging != null) {
                            aging.saveEx();
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.fine("#" + ++counter + " - " + aging);
                            }
                        }
                        aging = new MAging(this.getCtx(), AD_PInstance_ID, this.p_StatementDate, C_BPartner_ID, C_Currency_ID, C_Invoice_ID, C_InvoicePaySchedule_ID, C_BP_Group_ID, AD_Org_ID, DueDate, IsSOTrx, this.get_TrxName());
                        aging.setC_Activity_ID(C_Activity_ID);
                        aging.setC_Campaign_ID(C_Campaign_ID);
                        aging.setC_Project_ID(C_Project_ID);
                        aging.setDateAcct(this.p_DateAcct);
                        aging.setConvertAmountsInCurrency_ID(this.p_ConvertCurrencyTo_ID);
                    }
                    aging.add(DueDate, DaysDue, GrandTotal, OpenAmt);
                }
                if (aging != null) {
                    aging.saveEx();
                    ++counter;
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("#" + counter + " - " + aging);
                    }
                }
            }
            catch (SQLException e) {
                throw new DBException(e, finalSql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("#" + counter + " - rows=" + rows);
        }
        return "";
    }
}

