/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProcessPara;
import org.compiere.model.MProductPrice;
import org.compiere.model.X_I_PriceList;
import org.compiere.model.X_M_ProductPriceVendorBreak;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

@Process
public class ImportPriceList
extends SvrProcess {
    private int m_AD_Client_ID = 0;
    private boolean m_deleteOldImported = false;
    private boolean p_importPriceList = true;
    private boolean p_importPriceStd = true;
    private boolean p_importPriceLimit = true;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("AD_Client_ID")) {
                this.m_AD_Client_ID = ((BigDecimal)para[i].getParameter()).intValue();
            } else if (name.equals("DeleteOldImported")) {
                this.m_deleteOldImported = "Y".equals(para[i].getParameter());
            } else if (name.equals("IsImportPriceList")) {
                this.p_importPriceList = "Y".equals(para[i].getParameter());
            } else if (name.equals("IsImportPriceStd")) {
                this.p_importPriceStd = "Y".equals(para[i].getParameter());
            } else if (name.equals("IsImportPriceLimit")) {
                this.p_importPriceLimit = "Y".equals(para[i].getParameter());
            } else {
                MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String doIt() throws Exception {
        StringBuilder sql = null;
        int no = 0;
        StringBuilder clientCheck = new StringBuilder(" AND AD_Client_ID=").append(this.m_AD_Client_ID);
        int m_discountschema_id = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT MIN(M_DiscountSchema_ID) FROM M_DiscountSchema WHERE DiscountType='P' AND IsActive='Y' AND AD_Client_ID=?", (int)this.m_AD_Client_ID);
        if (m_discountschema_id <= 0) {
            throw new AdempiereUserError("Price List Schema not configured");
        }
        if (this.m_deleteOldImported) {
            sql = new StringBuilder("DELETE FROM I_PriceList WHERE I_IsImported='Y'").append((CharSequence)clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Delete Old Impored =" + no);
            }
        }
        sql = new StringBuilder("UPDATE I_PriceList ").append("SET AD_Client_ID = COALESCE (AD_Client_ID, ").append(this.m_AD_Client_ID).append("),").append(" AD_Org_ID = COALESCE (AD_Org_ID, 0),").append(" IsActive = COALESCE (IsActive, 'Y'),").append(" Created = COALESCE (Created, getDate()),").append(" CreatedBy = COALESCE (CreatedBy, 0),").append(" Updated = COALESCE (Updated, getDate()),").append(" UpdatedBy = COALESCE (UpdatedBy, 0),").append(" EnforcePriceLimit = COALESCE (EnforcePriceLimit, 'N'),").append(" IsSOPriceList = COALESCE (IsSOPriceList, 'N'),").append(" IsTaxIncluded = COALESCE (IsTaxIncluded, 'N'),").append(" PricePrecision = COALESCE (PricePrecision, 2),").append(" I_ErrorMsg = ' ',").append(" I_IsImported = 'N' ").append("WHERE I_IsImported<>'Y' OR I_IsImported IS NULL");
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Reset=" + no);
        }
        sql = new StringBuilder("UPDATE I_PriceList ").append("SET C_BPartner_ID=(SELECT C_BPartner_ID FROM C_BPartner p").append(" WHERE I_PriceList.BPartner_Value=p.Value AND I_PriceList.AD_Client_ID=p.AD_Client_ID) ").append("WHERE C_BPartner_ID IS NULL AND BPartner_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("BPartner=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_PriceList ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid BPartner,' ").append("WHERE C_BPartner_ID IS NULL AND BPartner_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
            this.log.warning("Invalid BPartner=" + no);
        }
        sql = new StringBuilder("UPDATE I_PriceList ").append("SET M_Product_ID=(SELECT MAX(M_Product_ID) FROM M_Product p").append(" WHERE I_PriceList.ProductValue=p.Value AND I_PriceList.AD_Client_ID=p.AD_Client_ID) ").append("WHERE M_Product_ID IS NULL AND ProductValue IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Product from Value=" + no);
        sql = new StringBuilder("UPDATE I_PriceList ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Product, ' ").append("WHERE M_Product_ID IS NULL AND (ProductValue IS NOT NULL)").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid Product=" + no);
        }
        sql = new StringBuilder("UPDATE I_PriceList ").append("SET M_PriceList_ID=(SELECT M_PriceList_ID FROM M_PriceList p").append(" WHERE I_PriceList.Name=p.Name AND I_PriceList.AD_Client_ID=p.AD_Client_ID) ").append("WHERE M_PriceList_ID IS NULL").append(" AND I_IsImported='N'").append((CharSequence)clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Price List Existing Value=" + no);
        }
        sql = new StringBuilder("UPDATE I_PriceList ").append("SET M_PriceList_Version_ID=(SELECT M_PriceList_Version_ID FROM M_PriceList_Version p").append(" WHERE I_PriceList.ValidFrom=p.ValidFrom AND I_PriceList.M_PriceList_ID=p.M_PriceList_ID) ").append("WHERE M_PriceList_ID IS NOT NULL AND M_PriceList_Version_ID IS NULL").append(" AND I_IsImported='N'").append((CharSequence)clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Price List Version Existing Value=" + no);
        }
        sql = new StringBuilder("UPDATE I_PriceList ").append("SET ISO_Code=(SELECT ISO_Code FROM C_Currency c").append(" INNER JOIN C_AcctSchema a ON (a.C_Currency_ID=c.C_Currency_ID)").append(" INNER JOIN AD_ClientInfo ci ON (a.C_AcctSchema_ID=ci.C_AcctSchema1_ID)").append(" WHERE ci.AD_Client_ID=I_PriceList.AD_Client_ID) ").append("WHERE C_Currency_ID IS NULL AND ISO_Code IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Currency Default=" + no);
        sql = new StringBuilder("UPDATE I_PriceList ").append("SET C_Currency_ID=(SELECT C_Currency_ID FROM C_Currency c").append(" WHERE I_PriceList.ISO_Code=c.ISO_Code AND c.AD_Client_ID IN (0,I_PriceList.AD_Client_ID)) ").append("WHERE C_Currency_ID IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("doIt- Set Currency=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_PriceList ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Currency,' ").append("WHERE C_Currency_ID IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
            this.log.warning("Invalid Currency=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_PriceList ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Mandatory Name or PriceListID,' ").append("WHERE Name IS NULL AND M_PriceList_ID IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
            this.log.warning("No Mandatory Name=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_PriceList ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Mandatory ValidFrom or PriceListVersionID,' ").append("WHERE ValidFrom IS NULL AND M_PriceList_Version_ID IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
            this.log.warning("No Mandatory ValidFrom=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_PriceList ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No Mandatory BreakValue,' ").append("WHERE BreakValue IS NULL AND (C_BPartner_ID IS NOT NULL OR BPartner_Value IS NOT NULL)").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
            this.log.warning("No Mandatory BreakValue=" + no);
        }
        this.commitEx();
        int noInsertpp = 0;
        int noUpdatepp = 0;
        int noInsertppvb = 0;
        int noUpdateppvb = 0;
        int noInsertpl = 0;
        int noInsertplv = 0;
        this.log.fine("start inserting/updating ...");
        sql = new StringBuilder("SELECT * FROM I_PriceList WHERE I_IsImported='N'").append((CharSequence)clientCheck);
        CPreparedStatement pstmt_setImported = null;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt_setImported = DB.prepareStatement((String)"UPDATE I_PriceList SET I_IsImported='Y', M_PriceList_ID=?, M_PriceList_Version_ID=?, Updated=getDate(), Processed='Y' WHERE I_PriceList_ID=?", (String)this.get_TrxName());
            pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int M_PriceList_Version_ID;
                int M_PriceList_ID;
                int I_PriceList_ID;
                block46: {
                    MPriceListVersion pricelistversion;
                    X_I_PriceList imp;
                    block45: {
                        MPriceList pricelist;
                        StringBuilder msglog;
                        block44: {
                            imp = new X_I_PriceList(this.getCtx(), rs, this.get_TrxName());
                            I_PriceList_ID = imp.getI_PriceList_ID();
                            M_PriceList_ID = imp.getM_PriceList_ID();
                            if (M_PriceList_ID == 0 && (M_PriceList_ID = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT M_PriceList_ID FROM M_PriceList WHERE IsActive='Y' AND AD_Client_ID=? AND Name=?", (int)this.m_AD_Client_ID, (String)imp.getName())) < 0) {
                                M_PriceList_ID = 0;
                            }
                            boolean newPriceList = M_PriceList_ID == 0;
                            msglog = new StringBuilder("I_PriceList_ID=").append(I_PriceList_ID).append(", M_PriceList_ID=").append(M_PriceList_ID);
                            this.log.fine(msglog.toString());
                            pricelist = null;
                            if (newPriceList) {
                                pricelist = new MPriceList(imp);
                                if (pricelist.save()) {
                                    M_PriceList_ID = pricelist.getM_PriceList_ID();
                                    this.log.finer("Insert Price List");
                                    ++noInsertpl;
                                    break block44;
                                } else {
                                    StringBuilder sql0 = new StringBuilder("UPDATE I_PriceList i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append(DB.TO_STRING((String)"Insert Price List failed")).append("WHERE I_PriceList_ID=").append(I_PriceList_ID);
                                    DB.executeUpdate((String)sql0.toString(), (String)this.get_TrxName());
                                    continue;
                                }
                            }
                            pricelist = new MPriceList(this.getCtx(), M_PriceList_ID, this.get_TrxName());
                        }
                        M_PriceList_Version_ID = imp.getM_PriceList_Version_ID();
                        if (M_PriceList_Version_ID == 0 && (M_PriceList_Version_ID = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT M_PriceList_Version_ID FROM M_PriceList_Version WHERE IsActive='Y' AND ValidFrom=? AND M_PriceList_ID=?", (Object[])new Object[]{imp.getValidFrom(), M_PriceList_ID})) < 0) {
                            M_PriceList_Version_ID = 0;
                        }
                        boolean newPriceListVersion = M_PriceList_Version_ID == 0;
                        msglog = new StringBuilder("I_PriceList_ID=").append(I_PriceList_ID).append(", M_PriceList_Version_ID=").append(M_PriceList_Version_ID);
                        this.log.fine(msglog.toString());
                        pricelistversion = null;
                        if (newPriceListVersion) {
                            pricelistversion = new MPriceListVersion(pricelist);
                            pricelistversion.setValidFrom(imp.getValidFrom());
                            pricelistversion.setName(String.valueOf(pricelist.getName()) + " " + imp.getValidFrom());
                            pricelistversion.setM_DiscountSchema_ID(m_discountschema_id);
                            if (pricelistversion.save()) {
                                M_PriceList_Version_ID = pricelistversion.getM_PriceList_Version_ID();
                                this.log.finer("Insert Price List Version");
                                ++noInsertplv;
                                break block45;
                            } else {
                                StringBuilder sql0 = new StringBuilder("UPDATE I_PriceList i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append(DB.TO_STRING((String)"Insert Price List Version failed")).append("WHERE I_PriceList_ID=").append(I_PriceList_ID);
                                DB.executeUpdate((String)sql0.toString(), (String)this.get_TrxName());
                                continue;
                            }
                        }
                        pricelistversion = new MPriceListVersion(this.getCtx(), M_PriceList_Version_ID, this.get_TrxName());
                    }
                    if (imp.getC_BPartner_ID() > 0) {
                        int M_ProductPriceVendorBreak_ID = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT M_ProductPriceVendorBreak_ID FROM M_ProductPriceVendorBreak WHERE M_PriceList_Version_ID=? AND IsActive='Y' AND C_BPartner_ID=? AND M_Product_ID=? AND BreakValue=?", (Object[])new Object[]{pricelistversion.getM_PriceList_Version_ID(), imp.getC_BPartner_ID(), imp.getM_Product_ID(), imp.getBreakValue()});
                        if (M_ProductPriceVendorBreak_ID < 0) {
                            M_ProductPriceVendorBreak_ID = 0;
                        }
                        X_M_ProductPriceVendorBreak ppvb = new X_M_ProductPriceVendorBreak(this.getCtx(), M_ProductPriceVendorBreak_ID, this.get_TrxName());
                        boolean isInsert = false;
                        if (M_ProductPriceVendorBreak_ID == 0) {
                            ppvb.setM_PriceList_Version_ID(pricelistversion.getM_PriceList_Version_ID());
                            ppvb.setC_BPartner_ID(imp.getC_BPartner_ID());
                            ppvb.setM_Product_ID(imp.getM_Product_ID());
                            ppvb.setBreakValue(imp.getBreakValue());
                            isInsert = true;
                        }
                        if (this.p_importPriceLimit) {
                            ppvb.setPriceLimit(imp.getPriceLimit());
                        }
                        if (this.p_importPriceList) {
                            ppvb.setPriceList(imp.getPriceList());
                        }
                        if (this.p_importPriceStd) {
                            ppvb.setPriceStd(imp.getPriceStd());
                        }
                        if (ppvb.save()) {
                            if (isInsert) {
                                ++noInsertppvb;
                            } else {
                                ++noUpdateppvb;
                            }
                            this.log.finer("Insert/Update Product Price Vendor Break");
                            break block46;
                        } else {
                            StringBuilder sql0 = new StringBuilder("UPDATE I_PriceList i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append(DB.TO_STRING((String)"Insert/Update Product Price Vendor Break Version failed")).append("WHERE I_PriceList_ID=").append(I_PriceList_ID);
                            DB.executeUpdate((String)sql0.toString(), (String)this.get_TrxName());
                            continue;
                        }
                    }
                    MProductPrice pp = MProductPrice.get((Properties)this.getCtx(), (int)pricelistversion.getM_PriceList_Version_ID(), (int)imp.getM_Product_ID(), (String)this.get_TrxName());
                    boolean isInsert = false;
                    if (pp != null) {
                        if (this.p_importPriceLimit) {
                            pp.setPriceLimit(imp.getPriceLimit());
                        }
                        if (this.p_importPriceList) {
                            pp.setPriceList(imp.getPriceList());
                        }
                        if (this.p_importPriceStd) {
                            pp.setPriceStd(imp.getPriceStd());
                        }
                    } else {
                        pp = new MProductPrice(pricelistversion, imp.getM_Product_ID(), this.p_importPriceList ? imp.getPriceList() : Env.ZERO, this.p_importPriceStd ? imp.getPriceStd() : Env.ZERO, this.p_importPriceLimit ? imp.getPriceLimit() : Env.ZERO);
                        isInsert = true;
                    }
                    if (pp.save()) {
                        this.log.finer("Insert/Update Product Price");
                        if (isInsert) {
                            ++noInsertpp;
                        } else {
                            ++noUpdatepp;
                        }
                    } else {
                        StringBuilder sql0 = new StringBuilder("UPDATE I_PriceList i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append(DB.TO_STRING((String)"Insert/Update Product Price failed")).append("WHERE I_PriceList_ID=").append(I_PriceList_ID);
                        DB.executeUpdate((String)sql0.toString(), (String)this.get_TrxName());
                        continue;
                    }
                }
                pstmt_setImported.setInt(1, M_PriceList_ID);
                pstmt_setImported.setInt(2, M_PriceList_Version_ID);
                pstmt_setImported.setInt(3, I_PriceList_ID);
                no = pstmt_setImported.executeUpdate();
                this.commitEx();
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            DB.close((Statement)pstmt_setImported);
            pstmt_setImported = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        DB.close((Statement)pstmt_setImported);
        pstmt_setImported = null;
        sql = new StringBuilder("UPDATE I_PriceList ").append("SET I_IsImported='N', Updated=getDate() ").append("WHERE I_IsImported<>'Y'").append((CharSequence)clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), "@Errors@");
        this.addLog(0, null, new BigDecimal(noInsertpl), "@M_PriceList_ID@: @Inserted@");
        this.addLog(0, null, new BigDecimal(noInsertplv), "@M_PriceList_Version_ID@: @Inserted@");
        this.addLog(0, null, new BigDecimal(noInsertpp), "Product Price: @Inserted@");
        this.addLog(0, null, new BigDecimal(noUpdatepp), "Product Price: @Updated@");
        this.addLog(0, null, new BigDecimal(noInsertppvb), "@M_ProductPriceVendorBreak_ID@: @Inserted@");
        this.addLog(0, null, new BigDecimal(noUpdateppvb), "@M_ProductPriceVendorBreak_ID@: @Updated@");
        return "";
    }
}

