/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MBankAccount;
import org.compiere.model.MCash;
import org.compiere.model.MCashBook;
import org.compiere.model.MCashLine;
import org.compiere.model.MProcessPara;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.Env;

@Process
public class ImmediateBankTransfer
extends SvrProcess {
    private String p_docAction = "CO";
    private int m_created = 0;
    private int m_C_Currency_ID;
    private String p_Name = "";
    private String p_Description = "";
    private int p_C_CashBook_ID = 0;
    private BigDecimal p_Amount = Env.ZERO;
    private int p_From_C_BankAccount_ID = 0;
    private int p_To_C_BankAccount_ID = 0;
    private Timestamp p_StatementDate = null;
    private Timestamp p_DateAcct = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("From_C_BankAccount_ID")) {
                this.p_From_C_BankAccount_ID = ((BigDecimal)para[i].getParameter()).intValue();
            } else if (name.equals("To_C_BankAccount_ID")) {
                this.p_To_C_BankAccount_ID = ((BigDecimal)para[i].getParameter()).intValue();
            } else if (name.equals("C_CashBook_ID")) {
                this.p_C_CashBook_ID = ((BigDecimal)para[i].getParameter()).intValue();
            } else if (name.equals("Amount")) {
                this.p_Amount = (BigDecimal)para[i].getParameter();
            } else if (name.equals("Name")) {
                this.p_Name = (String)para[i].getParameter();
            } else if (name.equals("Description")) {
                this.p_Description = (String)para[i].getParameter();
            } else if (name.equals("StatementDate")) {
                this.p_StatementDate = (Timestamp)para[i].getParameter();
            } else if (name.equals("DateAcct")) {
                this.p_DateAcct = (Timestamp)para[i].getParameter();
            } else {
                MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        StringBuilder msglog = new StringBuilder("From Bank=").append(this.p_From_C_BankAccount_ID).append(" - To Bank=").append(this.p_To_C_BankAccount_ID).append(" - C_CashBook_ID=").append(this.p_C_CashBook_ID).append(" - Amount=").append(this.p_Amount).append(" - Name=").append(this.p_Name).append(" - Description=").append(this.p_Description).append(" - Statement Date=").append(this.p_StatementDate).append(" - Date Account=").append(this.p_DateAcct);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(msglog.toString());
        }
        if (this.p_To_C_BankAccount_ID == 0 || this.p_From_C_BankAccount_ID == 0) {
            throw new IllegalArgumentException("Banks required");
        }
        if (this.p_Name == null || this.p_Name.length() == 0) {
            throw new IllegalArgumentException("Name required");
        }
        if (this.p_To_C_BankAccount_ID == this.p_From_C_BankAccount_ID) {
            throw new AdempiereUserError("Banks From and To must be different");
        }
        if (!this.isSameCurrency()) {
            throw new AdempiereUserError("Banks and CashBook must have same currency");
        }
        if (this.p_Amount.signum() == 0) {
            throw new AdempiereUserError("Amount required");
        }
        if (this.p_StatementDate == null) {
            this.p_StatementDate = Env.getContextAsDate((Properties)this.getCtx(), (String)"#Date");
        }
        if (this.p_StatementDate == null) {
            this.p_StatementDate = new Timestamp(System.currentTimeMillis());
        }
        if (this.p_DateAcct == null) {
            this.p_DateAcct = this.p_StatementDate;
        }
        this.generateBankTransfer();
        return "@Created@ = " + this.m_created;
    }

    private boolean isSameCurrency() {
        MCashBook mcash = new MCashBook(this.getCtx(), this.p_C_CashBook_ID, this.get_TrxName());
        MBankAccount mBankFrom = new MBankAccount(this.getCtx(), this.p_From_C_BankAccount_ID, this.get_TrxName());
        MBankAccount mBankTo = new MBankAccount(this.getCtx(), this.p_To_C_BankAccount_ID, this.get_TrxName());
        if (mcash.getC_Currency_ID() != mBankFrom.getC_Currency_ID() || mcash.getC_Currency_ID() != mBankTo.getC_Currency_ID()) {
            return false;
        }
        this.m_C_Currency_ID = mcash.getC_Currency_ID();
        return true;
    }

    private MCash createCash() {
        MCash cash = new MCash(this.getCtx(), 0, this.get_TrxName());
        cash.setName(this.p_Name);
        cash.setDescription(this.p_Description);
        cash.setDateAcct(this.p_DateAcct);
        cash.setStatementDate(this.p_StatementDate);
        cash.setC_CashBook_ID(this.p_C_CashBook_ID);
        if (!cash.save()) {
            throw new IllegalStateException("Could not create Cash");
        }
        return cash;
    }

    private MCashLine[] createCashLines(MCash cash) {
        ArrayList<MCashLine> cashLineList = new ArrayList<MCashLine>();
        MCashLine cashLine = new MCashLine(cash);
        cashLine.setAmount(this.p_Amount);
        cashLine.setC_BankAccount_ID(this.p_From_C_BankAccount_ID);
        cashLine.setC_Currency_ID(this.m_C_Currency_ID);
        if (this.p_Description != null) {
            cashLine.setDescription(this.p_Description);
        } else {
            cashLine.setDescription(this.p_Name);
        }
        cashLine.setCashType("T");
        if (!cashLine.save()) {
            throw new IllegalStateException("Could not create Cash line (From Bank)");
        }
        cashLineList.add(cashLine);
        cashLine = new MCashLine(cash);
        cashLine.setAmount(this.p_Amount.negate());
        cashLine.setC_BankAccount_ID(this.p_To_C_BankAccount_ID);
        cashLine.setC_Currency_ID(this.m_C_Currency_ID);
        if (this.p_Description != null) {
            cashLine.setDescription(this.p_Description);
        } else {
            cashLine.setDescription(this.p_Name);
        }
        cashLine.setCashType("T");
        if (!cashLine.save()) {
            throw new IllegalStateException("Could not create Cash line (To Bank)");
        }
        cashLineList.add(cashLine);
        MCashLine[] cashLines = new MCashLine[cashLineList.size()];
        cashLineList.toArray(cashLines);
        return cashLines;
    }

    private void generateBankTransfer() {
        MCash cash = this.createCash();
        MCashLine[] cashLines = this.createCashLines(cash);
        StringBuilder processMsg = new StringBuilder().append(cash.getDocumentNo());
        cash.setDocAction(this.p_docAction);
        if (!cash.processIt(this.p_docAction)) {
            processMsg.append(" (NOT Processed)");
            StringBuilder msglog = new StringBuilder("Cash Processing failed: ").append(cash).append(" - ").append(cash.getProcessMsg());
            this.log.warning(msglog.toString());
            msglog = new StringBuilder("Cash Processing failed: ").append(cash).append(" - ").append(cash.getProcessMsg()).append(" / please complete it manually");
            this.addLog(cash.getC_Cash_ID(), cash.getStatementDate(), null, msglog.toString());
            throw new IllegalStateException("Cash Processing failed: " + cash + " - " + cash.getProcessMsg());
        }
        if (!cash.save()) {
            throw new IllegalStateException("Could not create Cash");
        }
        this.addLog(cash.getC_Cash_ID(), cash.getStatementDate(), null, processMsg.toString());
        ++this.m_created;
    }
}

