/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.delete.process;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.plugin.delete.model.MCustomDeleteProfile;
import jpiere.plugin.delete.model.MCustomDeleteProfileLine;
import jpiere.plugin.delete.model.MDeleteClientLogJP;
import jpiere.plugin.delete.model.MDeleteProfile;
import jpiere.plugin.delete.process.JPiereDeleteClientRecords;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MColumn;
import org.compiere.model.MRefList;
import org.compiere.model.MTable;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class JPiereDeleteClientReport
extends SvrProcess {
    private int p_JP_DeleteProfile_ID = 0;
    private int p_Referenced_Table_ID = 0;
    private boolean p_IsAllowLogging = false;
    private int AD_PInstance_ID = 0;
    private MDeleteProfile m_DeleteProfile = null;
    private String[] customDeleteTables;
    private String[] tables;
    private JPiereDeleteClientRecords deleteClientRecordsProcess;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("JP_DeleteProfile_ID")) {
                this.p_JP_DeleteProfile_ID = para[i].getParameterAsInt();
            } else if (name.equals("Referenced_Table_ID")) {
                this.p_Referenced_Table_ID = para[i].getParameterAsInt();
            } else if (name.equals("IsAllowLogging")) {
                this.p_IsAllowLogging = para[i].getParameterAsBoolean();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
        this.AD_PInstance_ID = this.getAD_PInstance_ID();
    }

    protected String doIt() throws Exception {
        if (this.p_JP_DeleteProfile_ID <= 0 && this.p_Referenced_Table_ID <= 0) {
            return Msg.getMsg((Properties)this.getCtx(), (String)"NotFound");
        }
        this.deleteClientRecordsProcess = new JPiereDeleteClientRecords();
        if (this.p_JP_DeleteProfile_ID > 0) {
            this.createTableList();
        } else if (this.p_Referenced_Table_ID > 0) {
            this.createReferenceList();
        }
        return "";
    }

    private String createTableList() throws Exception {
        this.m_DeleteProfile = new MDeleteProfile(this.getCtx(), this.p_JP_DeleteProfile_ID, null);
        MCustomDeleteProfile[] customDPs = this.m_DeleteProfile.getCustomDeleteProfiles();
        ArrayList<String> customDeleteTableList = new ArrayList<String>();
        int i = 0;
        while (i < customDPs.length) {
            customDeleteTableList.add(customDPs[i].getAD_Table().getTableName());
            MCustomDeleteProfileLine[] customDPLines = customDPs[i].getCustomDeleteProfileLines();
            int j = 0;
            while (j < customDPLines.length) {
                customDeleteTableList.add(customDPLines[j].getAD_Table().getTableName());
                ++j;
            }
            ++i;
        }
        this.customDeleteTables = customDeleteTableList.toArray(new String[customDeleteTableList.size()]);
        if (this.m_DeleteProfile.getJP_Delete_Client().equals("TA") || this.m_DeleteProfile.getJP_Delete_Client().equals("TC")) {
            this.tables = this.deleteClientRecordsProcess.stringArray_Merge(JPiereDeleteClientRecords.TrxTables, this.customDeleteTables);
        } else if (this.m_DeleteProfile.getJP_Delete_Client().equals("IC")) {
            this.tables = this.deleteClientRecordsProcess.stringArray_Merge(JPiereDeleteClientRecords.IniTables, this.deleteClientRecordsProcess.stringArray_Merge(JPiereDeleteClientRecords.TrxTables, this.customDeleteTables));
        } else if (this.m_DeleteProfile.getJP_Delete_Client().equals("CD")) {
            this.tables = this.customDeleteTables;
        }
        i = 0;
        while (i < this.tables.length) {
            MTable m_Table;
            MDeleteClientLogJP log = new MDeleteClientLogJP(this.getCtx(), 0, null);
            log.setAD_PInstance_ID(this.getAD_PInstance_ID());
            log.setJP_Delete_Client(this.m_DeleteProfile.getJP_Delete_Client());
            log.setJP_DeleteProfile_ID(this.p_JP_DeleteProfile_ID);
            log.setReferenced_Table_ID(this.p_Referenced_Table_ID);
            if (this.tables[i].toUpperCase().startsWith("I_")) {
                if (this.m_DeleteProfile.getJP_Delete_Client().equals("CD")) {
                    log.setDescription("IMPORT TABLE - " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_Delete_NotDelete"));
                } else {
                    log.setDescription("IMPORT TABLE - " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_Delete_AllDelete"));
                }
            }
            if (this.tables[i].toUpperCase().startsWith("T_") && !this.tables[i].toUpperCase().equals("T_DeleteClientLogJP".toUpperCase())) {
                if (this.m_DeleteProfile.getJP_Delete_Client().equals("CD")) {
                    log.setDescription("TEMPORARY TABLE - " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_Delete_NotDelete"));
                } else {
                    log.setDescription("TEMPORARY TABLE - " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_Delete_AllDelete"));
                }
            }
            if (Util.isEmpty((String)log.getDescription())) {
                int j = 0;
                while (j < this.customDeleteTables.length) {
                    if (this.tables[i].toUpperCase().equals(this.customDeleteTables[j].toUpperCase())) {
                        log.setDescription(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Delete_CustomDPTable")) + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_Delete_FollowDeleteProfile"));
                    }
                    ++j;
                }
            }
            if (Util.isEmpty((String)log.getDescription())) {
                int j = 0;
                while (j < JPiereDeleteClientRecords.TrxTables.length) {
                    if (this.tables[i].toUpperCase().equals(JPiereDeleteClientRecords.TrxTables[j].toUpperCase())) {
                        if (this.m_DeleteProfile.getJP_Delete_Client().equals("CD")) {
                            log.setDescription(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Delete_TrxTable")) + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_Delete_NotDelete"));
                        } else {
                            log.setDescription(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Delete_TrxTable")) + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_Delete_AllDelete"));
                        }
                    }
                    ++j;
                }
            }
            if (Util.isEmpty((String)log.getDescription())) {
                int j = 0;
                while (j < JPiereDeleteClientRecords.IniTables.length) {
                    if (this.tables[i].toUpperCase().equals(JPiereDeleteClientRecords.IniTables[j].toUpperCase())) {
                        if (this.m_DeleteProfile.getJP_Delete_Client().equals("IC")) {
                            log.setDescription(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Delete_IniTable")) + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_Delete_FollowDeleteProfile"));
                        } else {
                            log.setDescription(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Delete_IniTable")) + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_Delete_NotDelete"));
                        }
                    }
                    ++j;
                }
            }
            if ((m_Table = MTable.get((Properties)this.getCtx(), (String)this.tables[i])).get_ID() != 0) {
                log.setAD_Table_ID(m_Table.get_ID());
                log.setTableName(m_Table.getTableName());
                log.setAccessLevel(m_Table.getAccessLevel());
                log.setAD_Window_ID(m_Table.getAD_Window_ID());
                log.setIsAllowLogging(this.p_IsAllowLogging);
                if (this.deleteClientRecordsProcess.hasColumn(String.valueOf(this.tables[i]) + "_ID", this.tables[i])) {
                    log.setColumnName(String.valueOf(this.tables[i]) + "_ID");
                }
                log.saveEx();
            }
            ++i;
        }
        if (!this.p_IsAllowLogging) {
            return "";
        }
        ArrayList<String> TABLELIST_AD = this.createTableList_AD();
        boolean isContain = false;
        for (String TABLE : TABLELIST_AD) {
            MTable m_Table;
            isContain = false;
            int i2 = 0;
            while (i2 < this.tables.length) {
                if (TABLE.equals(this.tables[i2].toUpperCase())) {
                    isContain = true;
                    break;
                }
                ++i2;
            }
            if (isContain || (m_Table = MTable.get((Properties)this.getCtx(), (String)TABLE)).get_ID() == 0) continue;
            MDeleteClientLogJP log = new MDeleteClientLogJP(this.getCtx(), 0, null);
            log.setAD_PInstance_ID(this.AD_PInstance_ID);
            log.setJP_Delete_Client(this.m_DeleteProfile.getJP_Delete_Client());
            log.setJP_DeleteProfile_ID(this.p_JP_DeleteProfile_ID);
            log.setReferenced_Table_ID(this.p_Referenced_Table_ID);
            if (this.m_DeleteProfile.getJP_Delete_Client().equals("TA") || this.m_DeleteProfile.getJP_Delete_Client().equals("TC") || this.m_DeleteProfile.getJP_Delete_Client().equals("CD")) {
                if (m_Table.getAccessLevel().equals("4")) {
                    log.setDescription(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Delete_OtherTable")) + " ( " + MRefList.get((Properties)this.getCtx(), (int)5, (String)"4", null) + " ) - " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_Delete_NotDelete"));
                } else {
                    log.setDescription(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Delete_OtherTable")) + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_Delete_NotDelete"));
                }
            } else if (this.m_DeleteProfile.getJP_Delete_Client().equals("IC")) {
                if (m_Table.getAccessLevel().equals("4")) {
                    log.setDescription(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Delete_OtherTable")) + " ( " + MRefList.get((Properties)this.getCtx(), (int)5, (String)"4", null) + " ) - " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_Delete_NotDelete"));
                } else {
                    log.setDescription(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Delete_OtherTable")) + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_Delete_AllDelete"));
                }
            }
            log.setAD_Table_ID(m_Table.get_ID());
            log.setTableName(m_Table.getTableName());
            log.setAccessLevel(m_Table.getAccessLevel());
            log.setAD_Window_ID(m_Table.getAD_Window_ID());
            log.setIsAllowLogging(this.p_IsAllowLogging);
            if (this.deleteClientRecordsProcess.hasColumn(String.valueOf(m_Table.getTableName()) + "_ID", m_Table.getTableName())) {
                log.setColumnName(String.valueOf(m_Table.getTableName()) + "_ID");
            }
            log.saveEx();
        }
        return "";
    }

    private String createReferenceList() throws Exception {
        if (this.p_Referenced_Table_ID == 0) {
            return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"NotFound")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Table_ID");
        }
        MTable m_Table = MTable.get((Properties)this.getCtx(), (int)this.p_Referenced_Table_ID);
        if (m_Table.get_ID() == 0) {
            return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"NotFound")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Table_ID");
        }
        String getTableSQL = "SELECT UPPER(TableName) FROM AD_Table t INNER JOIN AD_Column c ON(t.AD_Table_ID = C.AD_Table_ID) WHERE IsView='N' and UPPER(ColumnName)=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)getTableSQL, (String)this.get_TrxName());
                pstmt.setString(1, (String.valueOf(m_Table.getTableName()) + "_ID").toUpperCase());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    MTable table;
                    if (rs.getString(1).equals(m_Table.getTableName().toUpperCase()) || (table = MTable.get((Properties)this.getCtx(), (String)rs.getString(1))).get_ID() == 0) continue;
                    MDeleteClientLogJP log = new MDeleteClientLogJP(this.getCtx(), 0, null);
                    log.setAD_PInstance_ID(this.AD_PInstance_ID);
                    log.setJP_DeleteProfile_ID(this.p_JP_DeleteProfile_ID);
                    boolean isContain = false;
                    int i = 0;
                    while (i < JPiereDeleteClientRecords.TrxTables.length) {
                        if (JPiereDeleteClientRecords.TrxTables[i].toUpperCase().equals(table.getTableName().toUpperCase())) {
                            isContain = true;
                            break;
                        }
                        ++i;
                    }
                    if (isContain) {
                        log.setDescription(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Delete_TrxTable"));
                    } else {
                        i = 0;
                        while (i < JPiereDeleteClientRecords.IniTables.length) {
                            if (JPiereDeleteClientRecords.IniTables[i].toUpperCase().equals(table.getTableName().toUpperCase())) {
                                isContain = true;
                                break;
                            }
                            ++i;
                        }
                        if (isContain) {
                            log.setDescription(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Delete_IniTable"));
                        } else {
                            log.setDescription(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Delete_OtherTable"));
                        }
                    }
                    log.setAD_Table_ID(table.get_ID());
                    log.setTableName(table.getTableName());
                    log.setAccessLevel(table.getAccessLevel());
                    log.setAD_Window_ID(table.getAD_Window_ID());
                    log.setReferenced_Table_ID(this.p_Referenced_Table_ID);
                    MColumn[] columns = table.getColumns(false);
                    MColumn col = null;
                    int i2 = 0;
                    while (i2 < columns.length) {
                        if (columns[i2].getColumnName().toUpperCase().equals((String.valueOf(m_Table.getTableName()) + "_ID").toUpperCase())) {
                            col = MColumn.get((Properties)this.getCtx(), (int)columns[i2].get_ID());
                            break;
                        }
                        ++i2;
                    }
                    if (col != null) {
                        log.setAD_Column_ID(col.get_ID());
                        log.setColumnName(col.getColumnName());
                        log.setAD_Reference_ID(col.getAD_Reference_ID());
                        log.setAD_Reference_Value_ID(col.getAD_Reference_Value_ID());
                        log.setAD_Val_Rule_ID(col.getAD_Val_Rule_ID());
                        log.setFKConstraintName(col.getFKConstraintName());
                        log.setFKConstraintType(col.getFKConstraintType());
                        log.setIsKey(col.isKey());
                        log.setIsParent(col.isParent());
                        log.setIsMandatory(col.isMandatory());
                        log.setDefaultValue(col.getDefaultValue());
                        log.setMandatoryLogic(col.getMandatoryLogic());
                        log.setColumnSQL(col.getColumnSQL());
                    }
                    log.setIsAllowLogging(this.p_IsAllowLogging);
                    log.saveEx();
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, getTableSQL.toString(), (Throwable)e);
                throw new DBException(e, getTableSQL.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        ArrayList<Integer> list_of_reference = this.deleteClientRecordsProcess.getReferenceList(m_Table.getTableName());
        if (list_of_reference.size() != 0) {
            ArrayList<JPiereDeleteClientRecords.TableColumn> tableColumnList = this.deleteClientRecordsProcess.getIndirectReferTableColumn(String.valueOf(m_Table.getTableName()) + "_ID", list_of_reference);
            for (JPiereDeleteClientRecords.TableColumn tableColumn : tableColumnList) {
                MTable table = MTable.get((Properties)this.getCtx(), (String)tableColumn.tableName);
                if (table.get_ID() == 0) continue;
                MDeleteClientLogJP log = new MDeleteClientLogJP(this.getCtx(), 0, null);
                log.setAD_PInstance_ID(this.getAD_PInstance_ID());
                log.setJP_DeleteProfile_ID(this.p_JP_DeleteProfile_ID);
                boolean isContain = false;
                int i = 0;
                while (i < JPiereDeleteClientRecords.TrxTables.length) {
                    if (JPiereDeleteClientRecords.TrxTables[i].toUpperCase().equals(table.getTableName().toUpperCase())) {
                        isContain = true;
                        break;
                    }
                    ++i;
                }
                if (isContain) {
                    log.setDescription(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Delete_TrxTable"));
                } else {
                    i = 0;
                    while (i < JPiereDeleteClientRecords.IniTables.length) {
                        if (JPiereDeleteClientRecords.IniTables[i].toUpperCase().equals(table.getTableName().toUpperCase())) {
                            isContain = true;
                            break;
                        }
                        ++i;
                    }
                    if (isContain) {
                        log.setDescription(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Delete_IniTable"));
                    } else {
                        log.setDescription(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Delete_OtherTable"));
                    }
                }
                log.setAD_Table_ID(table.get_ID());
                log.setTableName(table.getTableName());
                log.setAccessLevel(table.getAccessLevel());
                log.setAD_Window_ID(table.getAD_Window_ID());
                log.setReferenced_Table_ID(this.p_Referenced_Table_ID);
                MColumn[] columns = table.getColumns(false);
                MColumn col = null;
                int i3 = 0;
                while (i3 < columns.length) {
                    if (columns[i3].getColumnName().toUpperCase().equals(tableColumn.columnName.toUpperCase())) {
                        col = MColumn.get((Properties)this.getCtx(), (int)columns[i3].get_ID());
                        break;
                    }
                    ++i3;
                }
                if (col != null) {
                    log.setAD_Column_ID(col.get_ID());
                    log.setColumnName(col.getColumnName());
                    log.setAD_Reference_ID(col.getAD_Reference_ID());
                    log.setAD_Reference_Value_ID(col.getAD_Reference_Value_ID());
                    log.setAD_Val_Rule_ID(col.getAD_Val_Rule_ID());
                    log.setFKConstraintName(col.getFKConstraintName());
                    log.setFKConstraintType(col.getFKConstraintType());
                    log.setIsKey(col.isKey());
                    log.setIsParent(col.isParent());
                    log.setIsMandatory(col.isMandatory());
                    log.setDefaultValue(col.getDefaultValue());
                    log.setMandatoryLogic(col.getMandatoryLogic());
                    log.setColumnSQL(col.getColumnSQL());
                }
                log.setIsAllowLogging(this.p_IsAllowLogging);
                log.saveEx();
            }
        }
        return "";
    }

    private ArrayList<String> createTableList_AD() {
        String getTableListSQL = "SELECT UPPER(tablename) FROM AD_TABLE a WHERE a.isview = 'N' AND EXISTS (SELECT ad_column_id FROM AD_COLUMN c  WHERE a.ad_table_id = c.ad_table_id AND UPPER (c.columnname) = 'AD_CLIENT_ID') ORDER BY tablename";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            try {
                pstmt = DB.prepareStatement((String)getTableListSQL, (String)this.get_TrxName());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    list.add(rs.getString(1));
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, getTableListSQL, (Throwable)e);
                throw new DBException(e, getTableListSQL);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return list;
    }
}

