/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.delete.process;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import jpiere.plugin.delete.model.MCustomDeleteProfile;
import jpiere.plugin.delete.model.MCustomDeleteProfileLine;
import jpiere.plugin.delete.model.MDeleteClientLogJP;
import jpiere.plugin.delete.model.MDeleteProfile;
import org.adempiere.exceptions.DBException;
import org.adempiere.util.IProcessUI;
import org.compiere.db.AdempiereDatabase;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MColumn;
import org.compiere.model.MCostType;
import org.compiere.model.MRole;
import org.compiere.model.MSequence;
import org.compiere.model.MTable;
import org.compiere.model.MUser;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class JPiereDeleteClientRecords
extends SvrProcess {
    private int p_LookupClientID = 0;
    private String p_JP_Delete_Client = "TC";
    private int p_JP_DeleteProfile_ID = 0;
    private boolean p_IsTruncateJP = false;
    private boolean p_IsAllowLogging = false;
    private boolean DEBUG_BULK_UPDATE_LOG = false;
    private int JP_CustomDeleteProfile_ID = 0;
    private int JP_CustomDeleteProfileLine_ID = 0;
    public static final String TYPE_DELETE_CLIENT = "DC";
    public static final String TYPE_INITIALIZE_CLIENT = "IC";
    public static final String TYPE_ALL_TRANSACTION = "TA";
    public static final String TYPE_CLIENT_TRANSACTION = "TC";
    public static final String TYPE_CUSTOM_DELETE = "CD";
    public static final String TREAT_SET_NULL = "TSN";
    public static final String TREAT_SET_VALUE = "TSV";
    public static final String TREAT_DELETE = "TDE";
    public static final String TREAT_IF_MANDATORY_DELETE_ELSE_VALUE = "IDV";
    public static final String TREAT_IF_MANDATORY_DELETE_ELSE_NULL = "IDN";
    public static final String TREAT_IF_MANDATORY_VALUE_ELSE_NULL = "IVN";
    public static final String TREAT_IF_MANDATORY_VALUE_ELSE_DELETE = "IVD";
    private static final boolean WHERE_IN = true;
    private static final boolean WHERE_NOT_IN = false;
    private ArrayList<String> TABLELIST_DB;
    private ArrayList<String> TABLELIST_AD;
    private String[] Tables_DeleteAllRecords;
    private String[] Tables_Not_DeleteAllRecords;
    private String[] Tables_CustomDelete;
    private IProcessUI processMonitor = null;
    private MDeleteProfile m_DeleteProfile = null;
    MTable[] AD_TABLE_Alls;
    TreeMap<String, Integer> beforDeleteTableInfo = new TreeMap();
    public static String[] TrxTables = new String[]{"C_Order", "C_OrderLine", "C_OrderTax", "C_POSPayment", "C_OrderPaySchedule", "C_OrderLandedCost", "C_OrderLandedCostAllocation", "M_InOut", "M_InOutLine", "M_InOutLineMA", "M_Package", "M_PackageMPS", "M_PackageLine", "M_InOutConfirm", "M_InOutLineConfirm", "C_Invoice", "C_InvoiceLine", "C_InvoiceTax", "C_InvoicePaySchedule", "C_InvoiceBatch", "C_InvoiceBatchLine", "C_LandedCost", "C_LandedCostAllocation", "M_MatchPO", "M_MatchInv", "C_RfQ_Topic", "C_RfQ_TopicSubscriber", "C_RfQ_TopicSubscriberOnly", "C_RfQ", "C_RfQLine", "C_RfQLineQty", "C_RfQResponse", "C_RfQResponseLine", "C_RfQResponseLineQty", "M_Requisition", "M_RequisitionLine", "S_TimeExpense", "S_TimeExpenseLine", "C_CommissionRun", "C_CommissionDetail", "C_CommissionAmt", "M_RMA", "M_RMALine", "M_RMATax", "C_AllocationHdr", "C_AllocationLine", "C_BankStatement", "C_BankStatementLine", "JP_BankStatementTax", "C_PaySelection", "C_PaySelectionLine", "C_PaySelectionCheck", "C_PaymentBatch", "C_Payment", "C_PaymentAllocate", "C_PaymentTransaction", "C_Cash", "C_CashLine", "C_CashPlan", "C_CashPlanLine", "M_Transaction", "M_Transactionallocation", "M_StorageOnHand", "M_StorageReservation", "M_CostDetail", "M_CostQueue", "M_Cost", "M_CostHistory", "M_Inventory", "M_InventoryLine", "M_InventoryLineMA", "M_Movement", "M_MovementLine", "M_MovementLineMA", "M_MovementConfirm", "M_MovementLineConfirm", "M_Production", "M_ProductionLine", "M_ProductionLineMA", "M_QualityTestResult", "Fact_Acct", "Fact_Acct_Summary", "Fact_Reconciliation", "GL_JournalBatch", "GL_Journal", "GL_JournalLine", "C_Opportunity", "C_ContactActivity", "R_Request", "R_RequestUpdates", "R_RequestAction", "R_RequestUpdate", "C_RevenueRecognition_Plan", "C_RevenueRecognition_Run", "C_ServiceLevel", "C_ServiceLevelLine", "S_ResourceAssignment", "C_ProjectIssueMA", "C_ProjectLine", "C_Recurring", "C_Recurring_Run"};
    public static String[] IniTables = new String[]{"AD_Client", "AD_ClientInfo", "AD_ClientShare", "AD_Org", "AD_OrgInfo", "AD_OrgType", "M_Warehouse", "M_Locator", "M_Warehouse_Acct", "AD_Role", "AD_Role_OrgAccess", "AD_User_Roles", "AD_Window_Access", "AD_Process_Access", "AD_Form_Access", "AD_InfoWindow_Access", "AD_Workflow_Access", "AD_Task_Access", "AD_Document_Action_Access", "AD_Role_Included", "AD_User", "AD_User_Substitute", "AD_User_OrgAccess", "AD_Preference", "C_Calendar", "C_Year", "C_Period", "C_PeriodControl", "C_NonBusinessDay", "C_AcctSchema", "C_AcctSchema_Element", "C_AcctSchema_GL", "C_AcctSchema_Default", "C_Element", "C_ElementValue", "C_ElementValue_Trl", "C_SubAcct", "C_ValidCombination", "GL_Category", "GL_Category_Trl", "C_TaxCategory", "C_TaxCategory_Trl", "C_Tax", "C_Tax_Acct", "C_TaxPostal", "C_Tax_Trl", "C_TaxProvider", "C_TaxProviderCfg", "C_TaxGroup", "C_DocType", "C_DocType_Trl", "C_Charge", "C_Charge_Acct", "C_Charge_Trl", "C_ChargeType", "C_ChargeType_DocType", "C_PaymentTerm", "C_PaymentTerm_Trl", "C_PaySchedule", "C_PaymentTerm", "C_InvoiceSchedule", "C_Currency", "C_Currency_Trl", "C_Currency_Acct", "C_ConversionType", "C_Bank", "C_BankAccount", "C_BankAccountDoc", "C_BankAccount_Processor", "C_BankStatementLoader", "C_BankAccount_Acct", "PA_Report", "PA_ReportLineSet", "PA_ReportLine", "PA_ReportSource", "PA_ReportColumnSet", "PA_ReportColumn", "PA_ReportCube", "PA_Hierarchy", "AD_Workflow", "AD_WF_Node", "AD_WF_Node_Para", "AD_WF_Node_Trl", "AD_WF_Block", "AD_WF_NodeNext", "AD_WF_NextCondition", "AD_Workflow_Trl", "AD_WF_Responsible", "C_BP_Group", "C_BP_Group_Acct", "C_BPartner", "C_BPartner_Location", "C_BP_BankAccount", "C_BP_ShippingAcct", "C_BP_Customer_Acct", "C_BP_Vendor_Acct", "C_BP_Relation", "C_SalesStage", "C_SalesStage_Trl", "R_RequestType", "R_RequestTypeUpdates", "R_Group", "R_GroupUpdates", "R_Category", "R_CategoryUpdates", "R_Resolution", "R_Status", "R_StatusCategory", "R_StandardResponse", "R_InterestArea", "R_ContactInterest", "R_MailText", "R_MailText_Trl", "R_IssueKnown", "R_IssueProject", "R_IssueRecommendation", "R_IssueStatus", "R_IssueSystem", "R_IssueUser", "C_Greeting", "C_Greeting_Trl", "M_Product_Category", "M_Product_Category_Trl", "M_Product_Category_Acct", "M_Product", "M_Product_Trl", "M_Product_BOM", "M_Substitute", "M_RelatedProduct", "M_Replenish", "M_Product_PO", "C_BPartner_Product", "M_Product_Acct", "M_PriceList", "M_PriceList_Version", "M_ProductPrice", "M_ProductPriceVendorBreak", "M_PriceList_Trl", "M_PriceList_Version_Trl", "M_DiscountSchema", "M_DiscountSchemaBreak", "M_CostType", "M_CostElement", "M_Attribute", "M_AttributeValue", "M_AttributeSet", "M_AttributeUse", "M_AttributeSetExclude", "C_UOM", "C_Location", "C_Country", "C_Country_Trl", "C_Region", "C_Region_Trl", "C_City", "C_CountryGroupCountry", "AD_PrintFormat", "AD_PrintFormat_Trl", "AD_PrintFormatItem", "AD_PrintFormatItem_Trl", "AD_PrintGraph", "AD_PrintForm", "AD_PrintColor", "AD_PrintFont", "AD_PrintPaper", "AD_PrintTableFormat", "AD_ImpFormat", "AD_ImpFormat_Row", "AD_AlertProcessor", "AD_LdapProcessor", "AD_WorkflowProcessor", "C_AcctProcessor", "R_RequestProcessor", "R_RequestProcessor_Route", "C_PaymentProcessor", "AD_Sequence", "AD_SysConfig", "AD_Menu", "AD_Menu_Trl", "AD_Tree", "AD_TreeBar", "AD_TreeNode", "AD_TreeNodeBP", "AD_TreeNodeCMC", "AD_TreeNodeCMM", "AD_TreeNodeCMS", "AD_TreeNodeCMT", "AD_TreeNodeMM", "AD_TreeNodePR", "AD_TreeNodeU1", "AD_TreeNodeU2", "AD_TreeNodeU3", "AD_TreeNodeU4", "AD_Image", "AD_Password_History", "AD_CtxHelp", "AD_ReplicationStrategy", "AD_StorageProvider"};

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("LookupClientID")) {
                this.p_LookupClientID = para[i].getParameterAsInt();
            } else if (name.equals("JP_Delete_Client")) {
                this.p_JP_Delete_Client = para[i].getParameterAsString();
            } else if (name.equals("JP_DeleteProfile_ID")) {
                this.p_JP_DeleteProfile_ID = para[i].getParameterAsInt();
            } else if (name.equals("IsTruncateJP")) {
                this.p_IsTruncateJP = para[i].getParameterAsBoolean();
            } else if (name.equals("IsAllowLogging")) {
                this.p_IsAllowLogging = para[i].getParameterAsBoolean();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        MClient m_Client;
        int AD_User_ID = Env.getAD_User_ID((Properties)Env.getCtx());
        if (AD_User_ID == 100) {
            String msg = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Delete_SuperUser_CanNot");
            this.addLog(msg);
            this.createLog("", "", msg, "", "", "", false);
            return msg;
        }
        if (this.p_JP_Delete_Client.equals(TYPE_CLIENT_TRANSACTION) || this.p_JP_Delete_Client.equals(TYPE_DELETE_CLIENT) || this.p_JP_Delete_Client.equals(TYPE_INITIALIZE_CLIENT) || this.p_JP_Delete_Client.equals(TYPE_CUSTOM_DELETE)) {
            if (this.p_LookupClientID == 0) {
                MClient client = new MClient(this.getCtx(), 0, null);
                String msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"DeleteError")) + " " + client.getName() + " " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Client_ID");
                this.addLog(msg);
                this.createLog("", "", msg, "", "", "", false);
                return msg;
            }
        } else if (this.p_JP_Delete_Client.equals(TYPE_ALL_TRANSACTION) && this.p_LookupClientID != 0) {
            String msg = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Delete_AllTransactionRecords");
            this.addLog(msg);
            this.createLog("", "", msg, "", "", "", false);
            return msg;
        }
        if (Util.isEmpty((String)(m_Client = MClient.get((Properties)this.getCtx(), (int)this.p_LookupClientID)).getName())) {
            String msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"NoRecordID")) + " : " + "AD_Client_ID = " + this.p_LookupClientID;
            this.addLog(msg);
            this.createLog("", "", msg, "", "", "", false);
            return msg;
        }
        if (this.p_JP_Delete_Client.equals(TYPE_CLIENT_TRANSACTION) || this.p_JP_Delete_Client.equals(TYPE_ALL_TRANSACTION) || this.p_JP_Delete_Client.equals(TYPE_INITIALIZE_CLIENT) || this.p_JP_Delete_Client.equals(TYPE_CUSTOM_DELETE)) {
            if (this.p_JP_DeleteProfile_ID != 0) {
                this.m_DeleteProfile = new MDeleteProfile(this.getCtx(), this.p_JP_DeleteProfile_ID, null);
            }
            if (this.p_JP_DeleteProfile_ID == 0 && (this.p_JP_Delete_Client.equals(TYPE_INITIALIZE_CLIENT) || this.p_JP_Delete_Client.equals(TYPE_CUSTOM_DELETE))) {
                String msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"FillMandatory")) + " " + Msg.getElement(null, (String)"JP_DeleteProfile_ID");
                this.addLog(msg);
                this.createLog("", "", msg, "", "", "", false);
                return msg;
            }
        }
        this.addBufferLog(0, null, null, "Process Log", MTable.getTable_ID((String)"AD_PInstance"), this.getAD_PInstance_ID());
        this.processMonitor = Env.getProcessUI((Properties)this.getCtx());
        StringBuilder message = new StringBuilder();
        try {
            try {
                this.executeUpdateConstraint("D");
                this.commitEx();
                this.TABLELIST_DB = this.createTableList_DB();
                this.TABLELIST_AD = this.createTableList_AD();
                this.doBeforeCheck(this.p_JP_Delete_Client);
                String msg = this.beforJPiereDeleteProcess();
                if (!Util.isEmpty((String)msg)) {
                    message.append("Befor Delete Process : " + msg);
                }
                if (this.p_JP_Delete_Client.equals(TYPE_DELETE_CLIENT)) {
                    this.p_IsTruncateJP = false;
                    this.p_JP_DeleteProfile_ID = 0;
                    this.m_DeleteProfile = null;
                    msg = this.doDeleteClient();
                    if (!Util.isEmpty((String)msg)) {
                        message.append("-->Delete Client : " + msg);
                    }
                } else if (this.p_JP_Delete_Client.equals(TYPE_ALL_TRANSACTION) || this.p_JP_Delete_Client.equals(TYPE_CLIENT_TRANSACTION)) {
                    msg = this.doDeleteTransactions(this.p_JP_Delete_Client);
                    if (!Util.isEmpty((String)msg)) {
                        message.append("-->Delete Transactions : " + msg);
                    }
                } else if (this.p_JP_Delete_Client.equals(TYPE_INITIALIZE_CLIENT)) {
                    this.p_IsTruncateJP = false;
                    msg = this.doInitializeClient();
                    if (!Util.isEmpty((String)msg)) {
                        message.append("-->Initialize Client : " + msg);
                    }
                } else if (this.p_JP_Delete_Client.equals(TYPE_CUSTOM_DELETE)) {
                    this.p_IsTruncateJP = false;
                    msg = this.doCustomDeleteProfile(this.m_DeleteProfile);
                    if (!Util.isEmpty((String)msg)) {
                        message.append("-->Custom Delete : " + msg);
                    }
                }
                if (!Util.isEmpty((String)(msg = this.afterJPiereDeleteProcess()))) {
                    message.append("-->After Delete Process : " + msg);
                }
                msg = this.doAfterCheck(this.p_JP_Delete_Client);
                message.append(msg);
            }
            catch (Exception e) {
                message.append("--------> Plese Check Process Log");
                if (e instanceof DBException) {
                    DBException dbe = (DBException)e;
                    this.addLog(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + " SQL: " + dbe.getSQL());
                    this.addLog(dbe.toString());
                    this.createLog("", "", String.valueOf(dbe.getMessage()) + "  SQL: " + dbe.getSQL(), "", "", "", false);
                } else {
                    this.addLog(e.toString());
                    this.createLog("", "", e.toString(), "", "", "", false);
                }
                throw new Exception(String.valueOf(e.toString()) + message.toString());
            }
        }
        finally {
            this.executeUpdateConstraint("O");
            this.commitEx();
        }
        if (Util.isEmpty((String)message.toString())) {
            message.append(Msg.getMsg((Properties)this.getCtx(), (String)Msg.getMsg((Properties)this.getCtx(), (String)"Success")));
        } else {
            message.append("--------> Plese Check Process Log");
        }
        this.addLog(message.toString());
        this.createLog("", "", message.toString(), "", "", "", true);
        return message.toString();
    }

    private String beforJPiereDeleteProcess() throws Exception {
        if (this.p_JP_Delete_Client.equals(TYPE_CUSTOM_DELETE)) {
            return "";
        }
        this.addLog("### BEFOR PROCESS ###");
        this.createLog("", "", "### BEFOR PROCESS ###", "", "", "", true);
        this.createLog("", "", "##### DELETE U_RoleMenu Table that data  may be inconsistent #####", "", "", "", false);
        ArrayList<Integer> AD_Role_IDs = this.getIDList("AD_Role_ID", "AD_Role", "AD_Client_ID = 0", TYPE_ALL_TRANSACTION);
        this.executeDeleteSQL("U_RoleMenu", this.createWhereInIDs("AD_Role_ID", AD_Role_IDs, false), TYPE_ALL_TRANSACTION, false, "BEFORE_PROCESS");
        this.commitEx();
        this.createLog("", "", "COMMIT", "", "", "", false);
        this.createLog("", "", "##### DELETE AD_ChangeLog and AD_Session WHERE AD_Client_ID <> 0 #####", "", "", "BEFORE_PROCESS", false);
        this.executeDeleteSQL("AD_ChangeLog", "AD_Client_ID <> 0", TYPE_ALL_TRANSACTION, false, "BEFORE_PROCESS");
        this.executeDeleteSQL("AD_ChangeLog", "AD_Client_ID = 0 AND AD_Session_ID IN (SELECT DISTINCT(AD_Session_ID) FROM AD_Session WHERE AD_Client_ID <> 0 )", TYPE_ALL_TRANSACTION, false, "BEFORE_PROCESS");
        this.commitEx();
        this.executeDeleteSQL("AD_Session", "AD_Client_ID <> 0", TYPE_ALL_TRANSACTION, false, "BEFORE_PROCESS");
        this.commitEx();
        this.createLog("", "", "COMMIT", "", "", "", false);
        if (this.p_LookupClientID != 0 && (this.p_JP_Delete_Client.equals(TYPE_INITIALIZE_CLIENT) || this.p_JP_Delete_Client.equals(TYPE_DELETE_CLIENT))) {
            this.createLog("", "", "### DELETE AD_Preference Table that data may be inconsistent ###", "", "", "", false);
            ArrayList<Integer> AD_User_IDs = this.getIDList("AD_User_ID", "AD_User", "AD_Client_ID <> " + this.p_LookupClientID, TYPE_ALL_TRANSACTION);
            this.executeDeleteSQL("AD_Preference", String.valueOf(this.createWhereInIDs("AD_User_ID", AD_User_IDs, false)) + " AND AD_Client_ID <> " + this.p_LookupClientID, TYPE_ALL_TRANSACTION, false, "BEFORE_PROCESS");
            this.commitEx();
            this.createLog("", "", "COMMIT", "", "", "", false);
        }
        this.createLog("", "", "##### DELETE IMPORT AND TEMPORARY TABLES #####", "", "", "", false);
        for (String IorT_TABLE : this.TABLELIST_AD) {
            if (IorT_TABLE.startsWith("I_")) {
                this.executeDeleteSQL(IorT_TABLE, null, TYPE_ALL_TRANSACTION, false, "BEFORE_PROCESS");
                continue;
            }
            if (!IorT_TABLE.startsWith("T_") || IorT_TABLE.toUpperCase().equals("T_DeleteClientLogJP".toUpperCase())) continue;
            this.executeDeleteSQL(IorT_TABLE, null, TYPE_ALL_TRANSACTION, false, "BEFORE_PROCESS");
        }
        this.commitEx();
        this.createLog("", "", "COMMIT", "", "", "", false);
        return "";
    }

    private String afterJPiereDeleteProcess() throws Exception {
        this.addLog("### AFTER PROCESS ###");
        this.createLog("", "", "### AFTER PROCESS ###", "", "", "", true);
        if (this.m_DeleteProfile == null || !this.p_JP_Delete_Client.equals(TYPE_INITIALIZE_CLIENT)) {
            return "";
        }
        this.commitEx();
        String name2 = this.m_DeleteProfile.getName2();
        if (!Util.isEmpty((String)name2)) {
            this.addLog("##### RENEAME CLIENT #####");
            this.createLog("", "", "##### RENEAME CLIENT #####", "", "", "", false);
            MClient client = new MClient(this.getCtx(), this.p_LookupClientID, this.get_TrxName());
            String oldName = client.getName();
            client.setName(name2);
            client.saveEx(this.get_TrxName());
            ArrayList<Integer> AD_Role_IDs = this.getIDList("AD_Role_ID", "AD_Role", "Name LIKE '%" + oldName + "%'", TYPE_INITIALIZE_CLIENT);
            for (Integer AD_Role_ID : AD_Role_IDs) {
                MRole role = new MRole(this.getCtx(), AD_Role_ID.intValue(), this.get_TrxName());
                if (role.get_ID() == 0 || !role.getName().contains(oldName)) continue;
                role.setName(role.getName().replace(oldName, name2));
                role.saveEx(this.get_TrxName());
            }
            ArrayList<Integer> AD_User_IDs = this.getIDList("AD_User_ID", "AD_User", "Name LIKE '%" + oldName + "%'", TYPE_INITIALIZE_CLIENT);
            for (Integer AD_User_ID : AD_User_IDs) {
                MUser user = new MUser(this.getCtx(), AD_User_ID.intValue(), this.get_TrxName());
                if (user.get_ID() == 0 || !user.getName().contains(oldName)) continue;
                user.setName(user.getName().replace(oldName, name2));
                user.saveEx(this.get_TrxName());
            }
            ArrayList<Integer> C_BPartner_IDs = this.getIDList("C_BPartner_ID", "C_BPartner", "Name LIKE '%" + oldName + "%'", TYPE_INITIALIZE_CLIENT);
            for (Integer C_BPartner_ID : C_BPartner_IDs) {
                MBPartner bp = new MBPartner(this.getCtx(), C_BPartner_ID.intValue(), this.get_TrxName());
                if (bp.get_ID() == 0 || !bp.getName().contains(oldName)) continue;
                bp.setName(bp.getName().replace(oldName, name2));
                bp.saveEx(this.get_TrxName());
            }
            ArrayList<Integer> C_AcctSchema_IDs = this.getIDList("C_AcctSchema_ID", "C_AcctSchema", null, TYPE_INITIALIZE_CLIENT);
            for (Integer C_AcctSchema_ID : C_AcctSchema_IDs) {
                MAcctSchema as = new MAcctSchema(this.getCtx(), C_AcctSchema_ID.intValue(), this.get_TrxName());
                if (as.get_ID() == 0 || !as.getName().contains(oldName)) continue;
                as.setName(as.getName().replace(oldName, name2));
                as.saveEx(this.get_TrxName());
            }
            ArrayList<Integer> M_CostType_IDs = this.getIDList(" M_CostType_ID", " M_CostType", null, TYPE_INITIALIZE_CLIENT);
            for (Integer M_CostType_ID : M_CostType_IDs) {
                MCostType costType = new MCostType(this.getCtx(), M_CostType_ID.intValue(), this.get_TrxName());
                if (costType.get_ID() == 0 || !costType.getName().contains(oldName)) continue;
                costType.setName(costType.getName().replace(oldName, name2));
                costType.saveEx(this.get_TrxName());
            }
        }
        return "";
    }

    private String doDeleteClient() throws Exception {
        this.doDeleteTransactions(TYPE_CLIENT_TRANSACTION);
        this.addLog("### DELETE A CLIENT ###");
        this.createLog("", "", "### DELETE A CLIENT ###", "", "", "", true);
        StringBuilder message = new StringBuilder("");
        String[] exceptionTables = new String[]{};
        String[] ExclusionTable = this.stringArray_Merge(TrxTables, exceptionTables);
        this.addLog("##### DELETE ALL RECORDS BELONG TO DELETE CLIENT EXCEPT TRANSACTION TABLES #####");
        this.createLog("", "", "##### DELETE ALL RECORDS BELONG TO DELETE CLIENT EXCEPT TRANSACTION TABLES #####", "", "", "", false);
        boolean isContaine = false;
        for (String AD_TABLE : this.TABLELIST_AD) {
            isContaine = false;
            int i = 0;
            while (i < ExclusionTable.length) {
                if (AD_TABLE.toUpperCase().equals(ExclusionTable[i].toUpperCase())) {
                    isContaine = true;
                }
                ++i;
            }
            if (isContaine) continue;
            int deletes = this.executeDeleteSQL(AD_TABLE, null, TYPE_DELETE_CLIENT, false, "DELETE_CLIENT");
            if (deletes == -1) {
                this.createLog("", "", "NOT FOUND: " + AD_TABLE, "", "", "", true);
                continue;
            }
            if (deletes != -2 && deletes != -3) continue;
        }
        this.addLog("##### DELETE ALL RECORDS REFER TO DELETE CLIENT #####");
        this.createLog("", "", "#####  DELETE ALL RECORDS REFER TO DELETE CLIENT #####", "", "", "", false);
        ArrayList<Integer> clientList = new ArrayList<Integer>();
        clientList.add(this.p_LookupClientID);
        this.bulkUpdate_canNotReferTableDirect("AD_Client", clientList, true, TREAT_DELETE, 0, ExclusionTable, false, TYPE_ALL_TRANSACTION);
        this.doResetKeyID(this.TABLELIST_AD.toArray(new String[this.TABLELIST_AD.size()]));
        return message.toString();
    }

    private String doDeleteTransactions(String type) throws Exception {
        this.addLog("### DELETE TRANSACTION TABLES ###");
        this.createLog("", "", "### DELETE TRANSACTION TABLES ###", "", "", "", true);
        StringBuilder message = new StringBuilder("");
        ArrayList<String> NotFoundTableList = new ArrayList<String>();
        this.addLog("##### DELETE REDORDS IN TRANSACTION TABLES #####");
        this.createLog("", "", "##### DELETE REDORDS IN TRANSACTION TABLES #####", "", "", "", false);
        int i = 0;
        while (i < TrxTables.length) {
            if (this.Tables_CustomDelete == null || !this.stringArray_IsIN(this.Tables_CustomDelete, TrxTables[i])) {
                int deletes = this.executeDeleteSQL(TrxTables[i], null, type, this.p_IsTruncateJP, "TRX_TABLE");
                if (deletes == -1) {
                    this.createLog("", "", "NOT FOUND: " + TrxTables[i], "", "", "", true);
                    NotFoundTableList.add(TrxTables[i]);
                } else if (deletes == -2 || deletes == -3) {
                    // empty if block
                }
            }
            ++i;
        }
        this.commitEx();
        this.createLog("", "", "COMMIT", "", "", "", false);
        if (!this.p_JP_Delete_Client.equals(TYPE_DELETE_CLIENT)) {
            if (!type.equals(TYPE_ALL_TRANSACTION) && !this.p_IsTruncateJP) {
                this.addLog("##### IF MANDATORY DELETE ELSE SET NULL TO RECORDS THAT CAN REFER TRANSACTION TABLES DIRECTLY #####");
                this.createLog("", "", "##### IF MANDATORY DELETE ELSE SET NULL TO RECORDS THAT CAN REFER TRANSACTION TABLES DIRECTLY #####", "", "", "", false);
                int returnInt = 0;
                int i2 = 0;
                while (i2 < TrxTables.length) {
                    returnInt = this.bulkUpdate_canReferTableDirect(TrxTables[i2], null, false, TREAT_IF_MANDATORY_DELETE_ELSE_NULL, 0, this.stringArray_Merge(TrxTables, this.Tables_CustomDelete), false, type);
                    this.bulkUpdate_Log(returnInt, TrxTables[i2], this.DEBUG_BULK_UPDATE_LOG);
                    ++i2;
                }
                this.commitEx();
                this.createLog("", "", "COMMIT", "", "", "", false);
                this.addLog("##### IF MANDATORY DELETE ELSE SET NULL TO RECORDS THAT CAN NOT REFER TRANSACTION TABLES DIRECTLY #####");
                this.createLog("", "", "##### IF MANDATORY DELETE ELSE SET NULL TO RECORDS THAT CAN NOT REFER TRANSACTION TABLES DIRECTLY #####", "", "", "", false);
                i2 = 0;
                while (i2 < TrxTables.length) {
                    returnInt = this.bulkUpdate_canNotReferTableDirect(TrxTables[i2], null, false, TREAT_IF_MANDATORY_DELETE_ELSE_NULL, 0, this.stringArray_Merge(TrxTables, this.Tables_CustomDelete), false, type);
                    this.bulkUpdate_Log(returnInt, TrxTables[i2], this.DEBUG_BULK_UPDATE_LOG);
                    ++i2;
                }
                this.commitEx();
                this.createLog("", "", "COMMIT", "", "", "", false);
            }
            this.addLog("##### INITIALIZE DOCUMENT NUMBER THAT ARE USED BY DOCUMENT TYPE ONLY #####");
            this.createLog("", "", "##### INITIALIZE DOCUMENT NUMBER THAT ARE USED BY DOCUMENT TYPE ONLY #####", "", "", "", false);
            ArrayList<Integer> DocSequenceList = this.getIDList("DocNoSequence_ID", "C_DocType", "DocNoSequence_ID is not null", this.p_JP_Delete_Client);
            for (Integer AD_Sequence_ID : DocSequenceList) {
                String updateSequenceSQL = "UPDATE AD_Sequence SET CurrentNext = StartNo WHERE AD_Sequence_ID=" + AD_Sequence_ID.toString();
                CPreparedStatement pstmt = null;
                Object rs = null;
                int updates = 0;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)updateSequenceSQL, (String)this.get_TrxName());
                        updates = pstmt.executeUpdate();
                        if (updates != 1) {
                            this.createLog("AD_Sequence", null, "UPDETE Doc Sequence ERROR", updateSequenceSQL, "", "", false);
                        }
                    }
                    catch (SQLException e) {
                        this.log.log(Level.SEVERE, updateSequenceSQL, (Throwable)e);
                        throw new DBException(e, updateSequenceSQL);
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                MSequence m_sequence = new MSequence(this.getCtx(), AD_Sequence_ID.intValue(), null);
                this.createLog("AD_Sequence", null, "RESET DOCNO - " + m_sequence.getName() + " : " + Msg.getElement((Properties)this.getCtx(), (String)"CurrentNext") + " ---> " + m_sequence.getStartNo(), updateSequenceSQL, "", "DOCUMENT_NUMBER", false);
            }
            this.commitEx();
            this.createLog("", "", "COMMIT", "", "", "", false);
            for (Integer AD_Sequence_ID : DocSequenceList) {
                this.executeDeleteSQL("AD_Sequence_No", "AD_Sequence_ID=" + AD_Sequence_ID.toString(), this.p_JP_Delete_Client, false, "DOCUMENT_NUMBER");
            }
            this.commitEx();
            this.createLog("", "", "COMMIT", "", "", "", false);
            if (this.m_DeleteProfile != null && (this.p_JP_Delete_Client.equals(TYPE_ALL_TRANSACTION) || this.p_JP_Delete_Client.equals(TYPE_CLIENT_TRANSACTION))) {
                this.doCustomDeleteProfile(this.m_DeleteProfile);
            }
        }
        this.executeReset("C_BPartner", "totalopenbalance=0, actuallifetimevalue=0, firstsale=null", type);
        this.commitEx();
        this.executeReset("C_BankAccount", "Currentbalance=0", type);
        this.commitEx();
        this.executeReset("C_Project", "InvoicedAmt=0, InvoicedQty=0, ProjectBalanceAmt=0", type);
        this.commitEx();
        if (this.Tables_CustomDelete != null && (this.p_JP_Delete_Client.equals(TYPE_ALL_TRANSACTION) || this.p_JP_Delete_Client.equals(TYPE_CLIENT_TRANSACTION))) {
            this.doResetKeyID(this.stringArray_Merge(TrxTables, this.Tables_CustomDelete));
        } else if (this.Tables_CustomDelete == null && (this.p_JP_Delete_Client.equals(TYPE_ALL_TRANSACTION) || this.p_JP_Delete_Client.equals(TYPE_CLIENT_TRANSACTION))) {
            this.doResetKeyID(TrxTables);
        }
        return message.toString();
    }

    private String doInitializeClient() throws Exception {
        if (this.m_DeleteProfile == null || this.m_DeleteProfile.get_ID() == 0) {
            return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"NotFound")) + " " + Msg.getElement((Properties)this.getCtx(), (String)"JP_DeleteProfile_ID");
        }
        String message = this.doDeleteTransactions(TYPE_CLIENT_TRANSACTION);
        this.createLog("", "", message, "", "", "", true);
        this.addLog("### INITIALIZE CLIENT START ###");
        this.createLog("", "", "### INITIALIZE CLIENT START ###", "", "", "", true);
        this.addLog("##### DELETE TABLES EXCEPT TRXTABLES AND INITABLES, TABLES OF DELETE PROFILE #####");
        this.createLog("", "", "##### DELETE TABLES EXCEPT TRXTABLES AND INITABLES, TABLES OF DELETE PROFILE #####", "", "", "", true);
        ArrayList<String> list_of_DeleteTables = new ArrayList<String>();
        for (String AD_TABLE : this.TABLELIST_AD) {
            boolean isContain = false;
            int i = 0;
            while (i < TrxTables.length) {
                if (TrxTables[i].toUpperCase().equals(AD_TABLE)) {
                    isContain = true;
                    break;
                }
                ++i;
            }
            if (isContain) continue;
            i = 0;
            while (i < IniTables.length) {
                if (IniTables[i].toUpperCase().equals(AD_TABLE)) {
                    isContain = true;
                    break;
                }
                ++i;
            }
            if (isContain) continue;
            MCustomDeleteProfile[] customDPs = this.m_DeleteProfile.getCustomDeleteProfiles();
            int i2 = 0;
            while (i2 < customDPs.length) {
                if (customDPs[i2].getAD_Table().getTableName().toUpperCase().equals(AD_TABLE)) {
                    isContain = true;
                    break;
                }
                MCustomDeleteProfileLine[] customDPLines = customDPs[i2].getCustomDeleteProfileLines();
                int j = 0;
                while (j < customDPLines.length) {
                    if (customDPLines[j].getAD_Table().getTableName().toUpperCase().equals(AD_TABLE)) {
                        isContain = true;
                        break;
                    }
                    ++j;
                }
                if (isContain) break;
                ++i2;
            }
            if (isContain) continue;
            int deletes = this.executeDeleteSQL(AD_TABLE, null, TYPE_INITIALIZE_CLIENT, false, "DELETE_OTEHR_TEBLES");
            if (deletes == -1) {
                this.createLog("", "", "NOT FOUND: " + AD_TABLE, "", "", "", true);
                continue;
            }
            if (deletes == -2 || deletes == -3 || deletes < -3) continue;
            list_of_DeleteTables.add(AD_TABLE);
        }
        this.commitEx();
        this.createLog("", "", "COMMIT", "", "", "", false);
        this.Tables_DeleteAllRecords = this.stringArray_Merge(list_of_DeleteTables.toArray(new String[list_of_DeleteTables.size()]), TrxTables);
        this.Tables_Not_DeleteAllRecords = this.stringArray_Subtraction(this.TABLELIST_AD.toArray(new String[this.TABLELIST_AD.size()]), this.Tables_DeleteAllRecords);
        this.createLog("", "", "####### SPECIAL TREATMENT TABLES THAT ARE DELETED ALL DATA. REFERRED RECORDS DELETE. #######", "", "", "", true);
        for (String table : list_of_DeleteTables) {
            if (table.equalsIgnoreCase("C_Campaign")) {
                this.executeDeleteSQL("C_AcctSchema_Element", "ElementType = 'MC'", TYPE_INITIALIZE_CLIENT, false);
                continue;
            }
            if (table.equalsIgnoreCase("C_Activity")) {
                this.executeDeleteSQL("C_AcctSchema_Element", "ElementType = 'AY'", TYPE_INITIALIZE_CLIENT, false);
                continue;
            }
            if (table.equalsIgnoreCase("C_Activity")) {
                this.executeDeleteSQL("C_AcctSchema_Element", "ElementType = 'AY'", TYPE_INITIALIZE_CLIENT, false);
                continue;
            }
            if (table.equalsIgnoreCase("C_Project")) {
                this.executeDeleteSQL("C_AcctSchema_Element", "ElementType = 'PJ'", TYPE_INITIALIZE_CLIENT, false);
                continue;
            }
            if (!table.equalsIgnoreCase("C_SalesRegion")) continue;
            this.executeDeleteSQL("C_AcctSchema_Element", "ElementType = 'SR'", TYPE_INITIALIZE_CLIENT, false);
        }
        this.createLog("", "", "####### GENERAL TREATMENT TABLES THAT ARE DELETED ALL DATA. SET NULL TO COLUMN OF FK #######", "", "", "", true);
        int returnInt = 0;
        for (String table : list_of_DeleteTables) {
            if (this.isAccessLevelSystemTable(table, true)) continue;
            returnInt = this.bulkUpdate_canReferTableDirect(table, null, false, TREAT_SET_NULL, 0, this.Tables_Not_DeleteAllRecords, true, TYPE_INITIALIZE_CLIENT);
            this.bulkUpdate_Log(returnInt, table, this.DEBUG_BULK_UPDATE_LOG);
            returnInt = this.bulkUpdate_canNotReferTableDirect(table, null, false, TREAT_SET_NULL, 0, this.Tables_Not_DeleteAllRecords, true, TYPE_INITIALIZE_CLIENT);
            this.bulkUpdate_Log(returnInt, table, this.DEBUG_BULK_UPDATE_LOG);
        }
        this.commitEx();
        this.createLog("", "", "COMMIT", "", "", "", false);
        this.deleteOrg(this.m_DeleteProfile.getJP_AD_Org_ID_Where());
        this.deleteRole(this.m_DeleteProfile.getJP_AD_Role_ID_Where());
        this.deleteUser(this.m_DeleteProfile.getJP_AD_User_ID_Where());
        this.deleteBPartner(this.m_DeleteProfile.getJP_C_BPartner_ID_Where());
        this.deleteProduct(this.m_DeleteProfile.getJP_M_Product_ID_Where());
        this.doCustomDeleteProfile(this.m_DeleteProfile);
        this.doResetKeyID(this.TABLELIST_AD.toArray(new String[this.TABLELIST_AD.size()]));
        return "";
    }

    /*
     * Unable to fully structure code
     */
    private String doCustomDeleteProfile(MDeleteProfile deleteProfile) throws Exception {
        this.addLog("### DELETE TABLES OF CUSTOM DELETE PROFILE ###");
        this.createLog("", "", "### DELETE TABLES OF CUSTOM DELETE PROFILE ###", "", "", "", true);
        customDeleteProfiles = deleteProfile.getCustomDeleteProfiles();
        returnInt = 0;
        i = 0;
        while (i < customDeleteProfiles.length) {
            block6: {
                block7: {
                    block5: {
                        this.JP_CustomDeleteProfile_ID = customDeleteProfiles[i].get_ID();
                        if (!customDeleteProfiles[i].isDeleteDataNotUseJP()) break block5;
                        this.createLog("", "", "##### DELETE " + customDeleteProfiles[i].getAD_Table().getTableName() + " RECORDS THAT ARE NOTE USED #####", "", "", "", true);
                        returnInt = this.bulkDelete_NotUseRecords(customDeleteProfiles[i].getAD_Table().getTableName(), deleteProfile.getJP_Delete_Client());
                        this.bulkUpdate_Log(returnInt, customDeleteProfiles[i].getAD_Table().getTableName(), this.DEBUG_BULK_UPDATE_LOG);
                        break block6;
                    }
                    if (!deleteProfile.getJP_Delete_Client().equals("TA") || !this.p_IsTruncateJP) break block7;
                    tableName = customDeleteProfiles[i].getAD_Table().getTableName();
                    this.executeDeleteSQL(tableName, null, "TA", true, "CUSTOM_TABLE_TRUNCATE");
                    ** GOTO lbl54
                }
                if (Util.isEmpty((String)customDeleteProfiles[i].getWhereClause())) {
                    this.createLog("", "", "##### DON'T DELETE " + customDeleteProfiles[i].getAD_Table().getTableName() + " #####", "", "", "", false);
                } else {
                    this.createLog("", "", "##### DELETE " + customDeleteProfiles[i].getAD_Table().getTableName() + " #####", "", "", "", true);
                    m_ProfileLines = customDeleteProfiles[i].getCustomDeleteProfileLines();
                    list_of_excludeTables = new ArrayList<String>();
                    j = 0;
                    while (j < m_ProfileLines.length) {
                        list_of_excludeTables.add(m_ProfileLines[j].getAD_Table().getTableName());
                        ++j;
                    }
                    excludeTables = list_of_excludeTables.toArray(new String[list_of_excludeTables.size()]);
                    tableName = customDeleteProfiles[i].getAD_Table().getTableName();
                    IDs = this.getIDList(String.valueOf(tableName) + "_ID", tableName, customDeleteProfiles[i].getWhereClause(), deleteProfile.getJP_Delete_Client());
                    treat = customDeleteProfiles[i].getJP_TreatForeignKey();
                    value = customDeleteProfiles[i].getJP_ForeignKey_Value();
                    this.executeDeleteSQL(tableName, this.createWhereInIDs(String.valueOf(tableName) + "_ID", IDs, false), deleteProfile.getJP_Delete_Client(), this.p_IsTruncateJP, "CUSTOM_TABLE_DELETE");
                    this.bulkUpdate_canReferTableDirect(tableName, IDs, false, treat, value, excludeTables, false, deleteProfile.getJP_Delete_Client());
                    this.bulkUpdate_canNotReferTableDirect(tableName, IDs, false, treat, value, excludeTables, false, deleteProfile.getJP_Delete_Client());
                    j = 0;
                    while (j < m_ProfileLines.length) {
                        this.JP_CustomDeleteProfileLine_ID = m_ProfileLines[j].get_ID();
                        lineTableName = m_ProfileLines[j].getAD_Table().getTableName();
                        linkColumn = m_ProfileLines[j].getAD_Column().getColumnName();
                        lineTreat = m_ProfileLines[j].getJP_TreatForeignKey();
                        lineValue = m_ProfileLines[j].getJP_ForeignKey_Value();
                        this.executeUpdateSQL(lineTableName, linkColumn, lineTreat, lineValue, this.createWhereInIDs(linkColumn, IDs, false), deleteProfile.getJP_Delete_Client(), "CUSTOM_TABLE_LINE_UPDATE");
                        ++j;
                    }
lbl54:
                    // 2 sources

                    this.JP_CustomDeleteProfileLine_ID = 0;
                }
            }
            ++i;
        }
        this.JP_CustomDeleteProfile_ID = 0;
        return "";
    }

    private boolean doResetKeyID(String[] tableNames) {
        this.addLog("### RESET COUNT OF PRIMARY KEY ID ###");
        this.createLog(null, null, "### RESET COUNT OF PRIMARY KEY ID ###", "", "", "", true);
        int i = 0;
        while (i < tableNames.length) {
            for (String AD_TABLE : this.TABLELIST_AD) {
                MSequence seq;
                if (!tableNames[i].toUpperCase().equals(AD_TABLE)) continue;
                if (!this.hasColumn(String.valueOf(tableNames[i]) + "_ID", tableNames[i]) || this.isAccessLevelSystemTable(tableNames[i], true) || tableNames[i].toUpperCase().startsWith("AD_") || (seq = MSequence.get((Properties)this.getCtx(), (String)tableNames[i])) == null || seq.get_ID() == 0) break;
                StringBuilder msg = new StringBuilder("RESET ID - " + tableNames[i] + " : " + Msg.getElement((Properties)this.getCtx(), (String)"CurrentNext") + " : " + seq.getCurrentNext() + "----->");
                int maxID = this.getMaxPrimaryKey_ID(tableNames[i]);
                if (maxID < 1) {
                    seq.setCurrentNext(seq.getStartNo());
                    seq.saveEx(this.get_TrxName());
                } else if (maxID >= 1000000) {
                    seq.setCurrentNext(maxID + seq.getIncrementNo());
                    seq.saveEx(this.get_TrxName());
                }
                msg.append(seq.getCurrentNext());
                this.createLog(tableNames[i], null, msg.toString(), null, null, "Max ID = " + maxID + " # " + Msg.getElement((Properties)this.getCtx(), (String)"StartNo") + " = " + seq.getStartNo() + " # " + Msg.getElement((Properties)this.getCtx(), (String)"IncrementNo") + " = " + seq.getIncrementNo() + " # " + Msg.getElement((Properties)this.getCtx(), (String)"CurrentNext") + " = " + seq.getCurrentNext(), false);
            }
            ++i;
        }
        return true;
    }

    private String doBeforeCheck(String type) {
        this.addLog("### CHECK DATA BEFORE DELETE ###");
        this.createLog("", "", "### CHECK DATA BEFORE DELETE ###", "", "", "", true);
        List list = new Query(this.getCtx(), "AD_Table", "IsView='N'", this.get_TrxName()).list();
        this.AD_TABLE_Alls = list.toArray(new MTable[list.size()]);
        for (String AD_TABLE : this.TABLELIST_AD) {
            this.beforDeleteTableInfo.put(AD_TABLE.toUpperCase(), this.countRecords(AD_TABLE, null, TYPE_ALL_TRANSACTION));
        }
        ArrayList<String> NotHave_AD_Client_ID = new ArrayList<String>();
        boolean isContain = false;
        int i = 0;
        while (i < this.AD_TABLE_Alls.length) {
            isContain = false;
            for (String AD_TABLE : this.TABLELIST_AD) {
                if (!this.AD_TABLE_Alls[i].getTableName().toUpperCase().equals(AD_TABLE)) continue;
                isContain = true;
                break;
            }
            if (!isContain) {
                NotHave_AD_Client_ID.add(this.AD_TABLE_Alls[i].getTableName());
            }
            ++i;
        }
        ArrayList<String> Not_IN_AD = new ArrayList<String>();
        for (String DB_TABLE : this.TABLELIST_DB) {
            isContain = false;
            int i2 = 0;
            while (i2 < this.AD_TABLE_Alls.length) {
                if (DB_TABLE.equals(this.AD_TABLE_Alls[i2].getTableName().toUpperCase())) {
                    isContain = true;
                    break;
                }
                ++i2;
            }
            if (isContain) continue;
            Not_IN_AD.add(DB_TABLE);
        }
        ArrayList<String> Not_IN_DB = new ArrayList<String>();
        int i3 = 0;
        while (i3 < this.AD_TABLE_Alls.length) {
            isContain = false;
            for (String DB_TABLE : this.TABLELIST_DB) {
                if (!this.AD_TABLE_Alls[i3].getTableName().toUpperCase().equals(DB_TABLE)) continue;
                isContain = true;
                break;
            }
            if (!isContain) {
                Not_IN_DB.add(this.AD_TABLE_Alls[i3].getTableName());
            }
            ++i3;
        }
        String msg = new String();
        msg = "There are " + this.TABLELIST_DB.size() + " tables in Data Base.";
        this.addLog(msg);
        this.createLog("", "", msg, "", "", "", false);
        msg = "There are " + this.AD_TABLE_Alls.length + " tables in Application Dictonary.";
        this.addLog(msg);
        this.createLog("", "", msg, "", "", "", false);
        if (Not_IN_AD.size() > 0) {
            msg = "Tables that are not registering in Application Dictionary are " + Not_IN_AD.size() + " " + this.ArrayListToString(Not_IN_AD) + ". ";
            this.addLog(msg);
            this.createLog("", "", msg, "", "", "", false);
        }
        if (Not_IN_DB.size() > 0) {
            msg = "Tables that are not registering in Data Base are " + Not_IN_DB.size() + " " + this.ArrayListToString(Not_IN_DB) + ". ";
            this.addLog(msg);
            this.createLog("", "", msg, "", "", "", false);
        }
        if (NotHave_AD_Client_ID.size() > 0) {
            msg = "Tables in AD that have a column of AD_Client_ID are " + this.TABLELIST_AD.size() + ". ";
            this.addLog(msg);
            this.createLog("", "", msg, "", "", "", false);
            msg = "Tables in AD that do not have a column of AD_Client_ID are " + NotHave_AD_Client_ID.size() + " " + this.ArrayListToString(NotHave_AD_Client_ID) + ". ";
            this.addLog(msg);
            this.createLog("", "", msg, "", "", "", false);
        }
        ArrayList<String> deleteTrxTableList = new ArrayList<String>();
        ArrayList<String> unexpectedTrxTableList = new ArrayList<String>();
        if (type.equals(TYPE_ALL_TRANSACTION) || type.equals(TYPE_CLIENT_TRANSACTION) || type.equals(TYPE_INITIALIZE_CLIENT)) {
            int i4 = 0;
            while (i4 < TrxTables.length) {
                isContain = false;
                for (String table : this.TABLELIST_AD) {
                    if (!TrxTables[i4].toUpperCase().equals(table)) continue;
                    isContain = true;
                    break;
                }
                if (isContain) {
                    deleteTrxTableList.add(TrxTables[i4]);
                } else {
                    unexpectedTrxTableList.add(TrxTables[i4]);
                }
                ++i4;
            }
            msg = "Transactions Tables that will delete are " + (TrxTables.length - unexpectedTrxTableList.size()) + ". ";
            this.addLog(msg);
            this.createLog("", "", String.valueOf(msg) + " " + this.ArrayListToString(unexpectedTrxTableList) + ". ", "", "", "", false);
        }
        ArrayList<String> deleteIniTableList = new ArrayList<String>();
        ArrayList<String> unexpectedIniTableList = new ArrayList<String>();
        if (type.equals(TYPE_INITIALIZE_CLIENT)) {
            int i5 = 0;
            while (i5 < IniTables.length) {
                isContain = false;
                for (String table : this.TABLELIST_AD) {
                    if (!IniTables[i5].toUpperCase().equals(table)) continue;
                    isContain = true;
                    break;
                }
                if (isContain) {
                    deleteIniTableList.add(IniTables[i5]);
                } else {
                    unexpectedIniTableList.add(IniTables[i5]);
                }
                ++i5;
            }
            msg = "Initialize Tables are " + (IniTables.length - unexpectedIniTableList.size()) + ". ";
            this.addLog(msg);
            this.createLog("", "", String.valueOf(msg) + " " + this.ArrayListToString(unexpectedIniTableList) + ". ", "", "", "", false);
        }
        if (this.m_DeleteProfile != null && !type.equals(TYPE_DELETE_CLIENT)) {
            MCustomDeleteProfile[] customDPs = this.m_DeleteProfile.getCustomDeleteProfiles();
            ArrayList<String> customDeleteTableList = new ArrayList<String>();
            int i6 = 0;
            while (i6 < customDPs.length) {
                customDeleteTableList.add(customDPs[i6].getAD_Table().getTableName());
                MCustomDeleteProfileLine[] customDPLines = customDPs[i6].getCustomDeleteProfileLines();
                int j = 0;
                while (j < customDPLines.length) {
                    customDeleteTableList.add(customDPLines[j].getAD_Table().getTableName());
                    ++j;
                }
                ++i6;
            }
            this.Tables_CustomDelete = customDeleteTableList.toArray(new String[customDeleteTableList.size()]);
            msg = "Custom Delete Tables are " + this.Tables_CustomDelete.length + ". ";
            this.addLog(msg);
            this.createLog("", "", String.valueOf(msg) + " " + this.ArrayListToString(customDeleteTableList) + ". ", "", "", "", false);
            if (type.equals(TYPE_ALL_TRANSACTION) || type.equals(TYPE_CLIENT_TRANSACTION)) {
                ArrayList<String> commonTables = new ArrayList<String>();
                int i7 = 0;
                while (i7 < TrxTables.length) {
                    if (this.stringArray_IsIN(this.Tables_CustomDelete, TrxTables[i7])) {
                        commonTables.add(TrxTables[i7]);
                    }
                    ++i7;
                }
                msg = "Tables that are included in Transaction Tables and Custom Tables are " + commonTables.size() + " " + this.ArrayListToString(commonTables) + ". ";
                this.addLog(msg);
                this.createLog("", "", msg, "", "", "", false);
            } else if (type.equals(TYPE_INITIALIZE_CLIENT)) {
                ArrayList<String> commonTables = new ArrayList<String>();
                int i8 = 0;
                while (i8 < IniTables.length) {
                    if (this.stringArray_IsIN(this.Tables_CustomDelete, IniTables[i8])) {
                        commonTables.add(IniTables[i8]);
                    }
                    ++i8;
                }
                msg = "Tables that are included in Initialize Tables and Custom Tables are " + commonTables.size() + ". ";
                this.addLog(msg);
                this.createLog("", "", String.valueOf(msg) + " " + this.ArrayListToString(commonTables) + ". ", "", "", "", false);
            }
        }
        return "";
    }

    private String doAfterCheck(String type) {
        this.addLog("### CHECK DATA AFTER DELETE ###");
        this.createLog("", "", "### CHECK DATA AFTER DELETE ###", "", "", "", true);
        ArrayList<String> RemainRecordsTableList = new ArrayList<String>();
        ArrayList<String> UnexpectedTableList = new ArrayList<String>();
        String[] checkTables = null;
        checkTables = type.equals(TYPE_CLIENT_TRANSACTION) || type.equals(TYPE_ALL_TRANSACTION) ? (this.Tables_CustomDelete == null ? TrxTables : this.stringArray_Merge(TrxTables, this.Tables_CustomDelete)) : (this.Tables_CustomDelete != null && type.equals(TYPE_CUSTOM_DELETE) ? this.Tables_CustomDelete : this.TABLELIST_AD.toArray(new String[this.TABLELIST_AD.size()]));
        int i = 0;
        while (i < checkTables.length) {
            for (String AD_TABLE : this.TABLELIST_AD) {
                if (!checkTables[i].toUpperCase().equals(AD_TABLE)) continue;
                int countsALL = this.countRecords(checkTables[i], null, TYPE_ALL_TRANSACTION);
                int countsClient = this.countRecords(checkTables[i], null, TYPE_DELETE_CLIENT);
                if (countsClient < 0) {
                    this.createLog("", "", "Error: unexpected Table: " + checkTables[i], "", "", "", true);
                    UnexpectedTableList.add(checkTables[i]);
                    break;
                }
                int beforeRecords = this.beforDeleteTableInfo.get(checkTables[i].toUpperCase());
                if (this.stringArray_IsIN(TrxTables, checkTables[i]) || type.equals(TYPE_DELETE_CLIENT)) {
                    boolean isOK = false;
                    if (type.equals(TYPE_ALL_TRANSACTION)) {
                        if (countsALL == 0) {
                            isOK = true;
                        }
                    } else if (countsClient == 0) {
                        isOK = true;
                    }
                    this.createLog(checkTables[i], null, "CHECK - " + checkTables[i] + "  -->" + (type.equals(TYPE_ALL_TRANSACTION) ? "" : "Client Records : " + countsClient) + ", Deleted Records : " + (beforeRecords - countsALL) + ", Before Records : " + beforeRecords + ", Remain Records : " + countsALL, null, null, isOK ? "OK" : "NG", false);
                } else {
                    this.createLog(checkTables[i], null, "CHECK - " + checkTables[i] + "  -->" + (type.equals(TYPE_ALL_TRANSACTION) ? "" : "Client Records : " + countsClient) + ", Deleted Records : " + (beforeRecords - countsALL) + ", Before Records : " + beforeRecords + ", Remain Records : " + countsALL, null, null, null, false);
                }
                if (!type.equals(TYPE_DELETE_CLIENT) || countsClient <= 0) break;
                RemainRecordsTableList.add(checkTables[i]);
                break;
            }
            ++i;
        }
        if (UnexpectedTableList.size() > 0) {
            String msg = "Unexpected Table is " + this.ArrayListToString(UnexpectedTableList);
            this.addLog(msg);
            this.createLog("", "", msg, "", "", "", false);
        }
        String msg = "Total Tables checked is " + checkTables.length + (type.equals(TYPE_DELETE_CLIENT) ? " and Remain Records Table is " + RemainRecordsTableList.size() : "") + " and Unexpected Table is " + UnexpectedTableList.size();
        this.addLog(msg);
        this.createLog("", "", msg, "", "", "", false);
        return "";
    }

    private String ArrayListToString(ArrayList<String> arrayList) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (arrayList.size() == 0) {
            return "";
        }
        int i = 0;
        for (String string : arrayList) {
            if (i == 0) {
                stringBuilder.append("( " + string);
            } else {
                stringBuilder.append(", " + string);
            }
            ++i;
        }
        stringBuilder.append(" )");
        return stringBuilder.toString();
    }

    /*
     * Unable to fully structure code
     */
    private String deleteOrg(String where) throws Exception {
        if (Util.isEmpty((String)where)) {
            this.createLog("", "", "##### DON'T DELETE ORGANIZATION #####", "", "", "", false);
            return "";
        }
        this.addLog("##### DELETE ORGANIZATION #####");
        this.createLog("", "", "##### DELETE ORGANIZATION #####", "", "", "", true);
        AD_Org_IDs = this.getIDList("AD_Org_ID", "AD_Org", where, "IC");
        AD_Org_IDs.add(0);
        this.createLog("", "", "####### UPDATE ORG BEFORE DELETE #######", "", "", "", true);
        this.executeUpdateSQL("C_BPartner", "AD_OrgBP_ID", "TSN", 0, this.createWhereInIDs("AD_OrgBP_ID", AD_Org_IDs, false), "IC");
        acctSchemas = MAcctSchema.getClientAcctSchema((Properties)this.getCtx(), (int)this.p_LookupClientID);
        isContain = false;
        i = 0;
        while (i < acctSchemas.length) {
            isContain = false;
            if (acctSchemas[i].getAD_OrgOnly_ID() == 0) ** GOTO lbl-1000
            for (Integer AD_Org_ID : AD_Org_IDs) {
                if (AD_Org_ID.intValue() != acctSchemas[i].getAD_OrgOnly_ID()) continue;
                isContain = true;
                break;
            }
            if (!isContain) {
                as_ID = acctSchemas[i].getC_AcctSchema_ID();
                this.executeDeleteSQL("C_AcctSchema", "C_AcctSchema_ID = " + as_ID, "IC", false, "DELETE_ACCTSCHEMA");
                list_of_as_ID = new ArrayList<Integer>();
                list_of_as_ID.add(as_ID);
                returnInt = this.bulkUpdate_canReferTableDirect("C_AcctSchema", list_of_as_ID, true, "IDN", 0, this.Tables_Not_DeleteAllRecords, true, "IC");
                this.bulkUpdate_Log(returnInt, "C_AcctSchema", this.DEBUG_BULK_UPDATE_LOG);
                returnInt = this.bulkUpdate_canNotReferTableDirect("C_AcctSchema", list_of_as_ID, true, "IDN", 0, this.Tables_Not_DeleteAllRecords, true, "IC");
                this.bulkUpdate_Log(returnInt, "AD_Org", this.DEBUG_BULK_UPDATE_LOG);
            } else lbl-1000:
            // 2 sources

            {
                if ((ase_OO = acctSchemas[i].getAcctSchemaElement("OO")) != null) {
                    isContain = false;
                    for (Integer AD_Org_ID : AD_Org_IDs) {
                        if (AD_Org_ID.intValue() != ase_OO.getOrg_ID()) continue;
                        isContain = true;
                        break;
                    }
                    if (!isContain) {
                        ase_OO.setOrg_ID(AD_Org_IDs.get(0).intValue());
                        ase_OO.saveEx(this.get_TrxName());
                    }
                }
                if ((ase_OT = acctSchemas[i].getAcctSchemaElement("OT")) != null) {
                    isContain = false;
                    for (Integer AD_Org_ID : AD_Org_IDs) {
                        if (AD_Org_ID.intValue() != ase_OT.getOrg_ID()) continue;
                        isContain = true;
                        break;
                    }
                    if (!isContain) {
                        ase_OT.setOrg_ID(AD_Org_IDs.get(0).intValue());
                        ase_OT.saveEx(this.get_TrxName());
                    }
                }
            }
            ++i;
        }
        tables = new String[]{"C_BPartner", "C_AcctSchema", "C_AcctSchema_Element"};
        this.createLog("", "", "####### DELETE RELATION TABLES OF AD_Org CAN REFER TABLE DIRECT #######", "", "", "", true);
        returnInt = 0;
        returnInt = this.bulkUpdate_canReferTableDirect("AD_Org", AD_Org_IDs, false, "TDE", 0, this.Tables_Not_DeleteAllRecords, true, "IC");
        this.bulkUpdate_Log(returnInt, "AD_Org", this.DEBUG_BULK_UPDATE_LOG);
        this.createLog("", "", "####### DELETE RELATION TABLES OF AD_Org CAN NOT REFER TABLE DIRECT #######", "", "", "", true);
        returnInt = this.bulkUpdate_canNotReferTableDirect("AD_Org", AD_Org_IDs, false, "IDN", 0, this.stringArray_Subtraction(this.Tables_Not_DeleteAllRecords, tables), true, "IC");
        this.bulkUpdate_Log(returnInt, "AD_Org", this.DEBUG_BULK_UPDATE_LOG);
        this.createLog("", "", "####### DELETE AD_Org TABLE #######", "", "", "", true);
        this.executeDeleteSQL("AD_Org", this.createWhereInIDs("AD_Org_ID", AD_Org_IDs, false), "IC", false, "DELETE_ORG");
        this.commitEx();
        this.createLog("", "", "COMMIT", "", "", "", false);
        this.createLog("", "", "####### DELETE RECORDS OR SET NULL TO FK COLUMN THAT REFFERED RECORD OF C_BANKACCOUNT TABLE #######", "", "", "", true);
        C_BankAccount_IDs = this.getIDList("C_BankAccount_ID", "C_BankAccount", null, "IC");
        returnInt = this.bulkUpdate_canReferTableDirect("C_BankAccount", C_BankAccount_IDs, false, "IDN", 0, null, true, "IC");
        this.bulkUpdate_Log(returnInt, "C_BankAccount", this.DEBUG_BULK_UPDATE_LOG);
        returnInt = this.bulkUpdate_canNotReferTableDirect("C_BankAccount", C_BankAccount_IDs, false, "IDN", 0, null, true, "IC");
        this.bulkUpdate_Log(returnInt, "AD_Org", this.DEBUG_BULK_UPDATE_LOG);
        return "";
    }

    private String deleteRole(String where) throws Exception {
        if (Util.isEmpty((String)where)) {
            this.createLog("", "", "##### DON'T DELETE ROLE #####", "", "", "", false);
            return "";
        }
        this.addLog("##### DELETE ROLE #####");
        this.createLog("", "", "##### DELETE ROLE #####", "", "", "", true);
        ArrayList<Integer> AD_Role_IDs = this.getIDList("AD_Role_ID", "AD_Role", where, TYPE_INITIALIZE_CLIENT);
        AD_Role_IDs.add(0);
        this.executeDeleteSQL("PA_DashboardPreference", this.createWhereInIDs("AD_Role_ID", AD_Role_IDs, false), TYPE_INITIALIZE_CLIENT, false, "DELETE_USER");
        String[] tables = new String[]{"AD_WF_Responsible", "PA_DashboardPreference"};
        int returnInt = 0;
        returnInt = this.bulkUpdate_canReferTableDirect("AD_Role", AD_Role_IDs, false, TREAT_SET_VALUE, 0, tables, true, TYPE_INITIALIZE_CLIENT);
        this.bulkUpdate_Log(returnInt, "AD_Role", this.DEBUG_BULK_UPDATE_LOG);
        returnInt = this.bulkUpdate_canReferTableDirect("AD_Role", AD_Role_IDs, false, TREAT_IF_MANDATORY_DELETE_ELSE_NULL, 0, this.stringArray_Subtraction(this.Tables_Not_DeleteAllRecords, tables), true, TYPE_INITIALIZE_CLIENT);
        this.bulkUpdate_Log(returnInt, "AD_Role", this.DEBUG_BULK_UPDATE_LOG);
        returnInt = this.bulkUpdate_canNotReferTableDirect("AD_Role", AD_Role_IDs, false, TREAT_IF_MANDATORY_DELETE_ELSE_NULL, 0, this.stringArray_Subtraction(this.Tables_Not_DeleteAllRecords, tables), true, TYPE_INITIALIZE_CLIENT);
        this.bulkUpdate_Log(returnInt, "AD_Role", this.DEBUG_BULK_UPDATE_LOG);
        this.executeDeleteSQL("AD_Role", this.createWhereInIDs("AD_Role_ID", AD_Role_IDs, false), TYPE_INITIALIZE_CLIENT, false, "DELETE_ROLE");
        return "";
    }

    private String deleteUser(String where) throws Exception {
        if (Util.isEmpty((String)where)) {
            this.createLog("", "", "##### DON'T DELETE USER #####", "", "", "", false);
            return "";
        }
        this.addLog("##### DELETE USER #####");
        this.createLog("", "", "##### DELETE USER #####", "", "", "", true);
        this.createLog("", "", "####### UPDATE All CreatedBy and UpdatedBy COLUMNS TO Super User #######", "", "", "", true);
        for (String AD_TABLE : this.TABLELIST_AD) {
            if (this.hasColumn("CreatedBy", AD_TABLE)) {
                this.executeUpdateSQL(AD_TABLE, "CreatedBy", TREAT_SET_VALUE, 100, null, TYPE_INITIALIZE_CLIENT);
            }
            if (!this.hasColumn("UpdatedBy", AD_TABLE)) continue;
            this.executeUpdateSQL(AD_TABLE, "UpdatedBy", TREAT_SET_VALUE, 100, null, TYPE_INITIALIZE_CLIENT);
        }
        ArrayList<Integer> AD_User_IDs = this.getIDList("AD_User_ID", "AD_User", where, TYPE_INITIALIZE_CLIENT);
        AD_User_IDs.add(100);
        AD_User_IDs.add(0);
        this.createLog("", "", "####### DELETE PREFERENCE #######", "", "", "", true);
        this.executeDeleteSQL("AD_Preference", this.createWhereInIDs("AD_User_ID", AD_User_IDs, false), TYPE_INITIALIZE_CLIENT, false, "DELETE_USER");
        this.executeDeleteSQL("PA_DashboardPreference", this.createWhereInIDs("AD_User_ID", AD_User_IDs, false), TYPE_INITIALIZE_CLIENT, false, "DELETE_USER");
        this.executeDeleteSQL("AD_Password_History", this.createWhereInIDs("AD_User_ID", AD_User_IDs, false), TYPE_INITIALIZE_CLIENT, false, "DELETE_USER");
        String[] tables = new String[]{"AD_Preference", "PA_DashboardPreference", "AD_Password_History"};
        this.createLog("", "", "####### DELETE RELATION TABLES OF AD_User CAN REFER TABLE DIRECT #######", "", "", "", true);
        int returnInt = 0;
        returnInt = this.bulkUpdate_canReferTableDirect("AD_User", AD_User_IDs, false, TREAT_IF_MANDATORY_DELETE_ELSE_NULL, 100, this.stringArray_Subtraction(this.Tables_Not_DeleteAllRecords, tables), true, TYPE_INITIALIZE_CLIENT);
        this.bulkUpdate_Log(returnInt, "AD_User", this.DEBUG_BULK_UPDATE_LOG);
        this.createLog("", "", "####### DELETE RELATION TABLES OF AD_User CAN NOT REFER TABLE DIRECT #######", "", "", "", true);
        returnInt = this.bulkUpdate_canNotReferTableDirect("AD_User", AD_User_IDs, false, TREAT_IF_MANDATORY_DELETE_ELSE_NULL, 100, this.stringArray_Subtraction(this.Tables_Not_DeleteAllRecords, tables), true, TYPE_INITIALIZE_CLIENT);
        this.bulkUpdate_Log(returnInt, "AD_User", this.DEBUG_BULK_UPDATE_LOG);
        this.createLog("", "", "####### DELETE AD_User TABLE #######", "", "", "", true);
        this.executeDeleteSQL("AD_User", this.createWhereInIDs("AD_User_ID", AD_User_IDs, false), TYPE_INITIALIZE_CLIENT, false, "DELETE_USER");
        return "";
    }

    private String deleteBPartner(String where) throws Exception {
        if (Util.isEmpty((String)where)) {
            this.createLog("", "", "##### DON'T DELETE BUSINESS PARTNER #####", "", "", "", false);
            return "";
        }
        this.addLog("##### DELETE BUSINESS PARTNER #####");
        this.createLog("", "", "##### DELETE BUSINESS PARTNER #####", "", "", "", true);
        ArrayList<Integer> C_BP_IDs = this.getIDList("C_BPartner_ID", "C_BPartner", where, TYPE_INITIALIZE_CLIENT);
        int returnInt = 0;
        returnInt = this.bulkUpdate_canReferTableDirect("C_BPartner", C_BP_IDs, false, TREAT_IF_MANDATORY_DELETE_ELSE_NULL, 0, this.Tables_Not_DeleteAllRecords, true, TYPE_INITIALIZE_CLIENT);
        this.bulkUpdate_Log(returnInt, "C_BPartner", this.DEBUG_BULK_UPDATE_LOG);
        returnInt = this.bulkUpdate_canNotReferTableDirect("C_BPartner", C_BP_IDs, false, TREAT_IF_MANDATORY_DELETE_ELSE_NULL, 0, this.Tables_Not_DeleteAllRecords, true, TYPE_INITIALIZE_CLIENT);
        this.bulkUpdate_Log(returnInt, "C_BPartner", this.DEBUG_BULK_UPDATE_LOG);
        this.executeDeleteSQL("C_BPartner", this.createWhereInIDs("C_BPartner_ID", C_BP_IDs, false), TYPE_INITIALIZE_CLIENT, false, "DELETE_BP");
        return "";
    }

    private String deleteProduct(String where) throws Exception {
        if (Util.isEmpty((String)where)) {
            this.createLog("", "", "##### DON'T DELETE PRODUCT #####", "", "", "", false);
            return "";
        }
        this.addLog("##### DELETE PRODUCT #####");
        this.createLog("", "", "##### DELETE PRODUCT #####", "", "", "", true);
        ArrayList<Integer> M_Product_IDs = this.getIDList("M_Product_ID", "M_Product", where, TYPE_INITIALIZE_CLIENT);
        String[] tables = new String[]{""};
        int returnInt = 0;
        returnInt = this.bulkUpdate_canReferTableDirect("M_Product", M_Product_IDs, false, TREAT_IF_MANDATORY_DELETE_ELSE_NULL, 0, this.stringArray_Subtraction(this.Tables_Not_DeleteAllRecords, tables), true, TYPE_INITIALIZE_CLIENT);
        this.bulkUpdate_Log(returnInt, "M_Product", this.DEBUG_BULK_UPDATE_LOG);
        returnInt = this.bulkUpdate_canNotReferTableDirect("M_Product", M_Product_IDs, false, TREAT_IF_MANDATORY_DELETE_ELSE_NULL, 0, this.stringArray_Subtraction(this.Tables_Not_DeleteAllRecords, tables), true, TYPE_INITIALIZE_CLIENT);
        this.bulkUpdate_Log(returnInt, "M_Product", this.DEBUG_BULK_UPDATE_LOG);
        this.executeDeleteSQL("M_Product", this.createWhereInIDs("M_Product_ID", M_Product_IDs, false), TYPE_INITIALIZE_CLIENT, false, "DELETE_PRODUCT");
        return "";
    }

    private int executeDeleteSQL(String table, String where, String type, boolean isTruncate) {
        return this.executeDeleteSQL(table, where, type, isTruncate, "");
    }

    private int executeDeleteSQL(String table, String where, String type, boolean isTruncate, String help) {
        if (table == null || !this.isAppDictionaryTable(table) || !this.isDataBaseTable(table)) {
            return -1;
        }
        StringBuilder DeleteSQL = new StringBuilder();
        if (type.equals(TYPE_ALL_TRANSACTION) && isTruncate) {
            DeleteSQL.append("TRUNCATE TABLE " + table + " CASCADE");
        } else {
            DeleteSQL.append("DELETE FROM " + table);
        }
        if (!Util.isEmpty((String)where)) {
            if (!type.equals(TYPE_ALL_TRANSACTION) || !isTruncate) {
                if (type.equals(TYPE_ALL_TRANSACTION) && !isTruncate) {
                    DeleteSQL.append(" WHERE " + where);
                } else {
                    DeleteSQL.append(" WHERE " + where + " AND AD_Client_ID = " + this.p_LookupClientID);
                }
            }
        } else if (!type.equals(TYPE_ALL_TRANSACTION)) {
            DeleteSQL.append(" WHERE AD_Client_ID = " + this.p_LookupClientID);
        }
        CPreparedStatement pstmt = null;
        Object rs = null;
        int deletes = 0;
        try {
            try {
                pstmt = DB.prepareStatement((String)DeleteSQL.toString(), (String)this.get_TrxName());
                deletes = pstmt.executeUpdate();
                if (deletes != 0 || this.p_IsAllowLogging) {
                    this.createLog(table, null, "DELETE : " + deletes, DeleteSQL.toString(), null, help, false);
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, DeleteSQL.toString(), (Throwable)e);
                throw new DBException(e, DeleteSQL.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return deletes;
    }

    private int executeUpdateSQL(String table, String column_ID, String treat, int value, String where, String type) {
        return this.executeUpdateSQL(table, column_ID, treat, value, where, type, null);
    }

    private int executeUpdateSQL(String table, String column_ID, String treat, int value, String where, String type, String help) {
        if (type.equals(TYPE_ALL_TRANSACTION) && this.p_IsTruncateJP) {
            return -3;
        }
        if (treat == null) {
            return -1;
        }
        if (treat.equals(TREAT_DELETE)) {
            return this.executeDeleteSQL(table, where, type, false);
        }
        if (!(treat.equals(TREAT_SET_NULL) || treat.equals(TREAT_SET_VALUE) || treat.equals(TREAT_IF_MANDATORY_DELETE_ELSE_NULL) || treat.equals(TREAT_IF_MANDATORY_DELETE_ELSE_VALUE) || treat.equals(TREAT_IF_MANDATORY_VALUE_ELSE_DELETE) || treat.equals(TREAT_IF_MANDATORY_VALUE_ELSE_NULL))) {
            return -1;
        }
        if (table == null || column_ID == null) {
            return -1;
        }
        if (!this.isAppDictionaryTable(table) || !this.isDataBaseTable(table)) {
            return -1;
        }
        if (!this.hasColumn(column_ID, table)) {
            return -1;
        }
        if (!this.isIDColumn(column_ID, table)) {
            return -1;
        }
        if (treat.equals(TREAT_IF_MANDATORY_DELETE_ELSE_NULL) || treat.equals(TREAT_IF_MANDATORY_DELETE_ELSE_VALUE) || treat.equals(TREAT_IF_MANDATORY_VALUE_ELSE_DELETE) || treat.equals(TREAT_IF_MANDATORY_VALUE_ELSE_NULL)) {
            treat = this.treatAutoJudge(table, column_ID, treat, value);
        }
        if (treat.equals(TREAT_DELETE)) {
            return this.executeDeleteSQL(table, where, type, false);
        }
        StringBuilder updateSQL = new StringBuilder("UPDATE " + table + " SET " + column_ID);
        if (treat.equals(TREAT_SET_NULL)) {
            updateSQL.append(" = null ");
        } else if (treat.equals(TREAT_SET_VALUE)) {
            updateSQL.append(" = " + value);
        } else {
            return -1;
        }
        if (!Util.isEmpty((String)where)) {
            updateSQL.append(" WHERE " + where);
            if (!type.equals(TYPE_ALL_TRANSACTION)) {
                updateSQL.append(" AND AD_Client_ID = " + this.p_LookupClientID);
            }
        } else if (!type.equals(TYPE_ALL_TRANSACTION)) {
            updateSQL.append(" WHERE AD_Client_ID = " + this.p_LookupClientID);
        }
        CPreparedStatement pstmt = null;
        Object rs = null;
        int updates = 0;
        try {
            try {
                pstmt = DB.prepareStatement((String)updateSQL.toString(), (String)this.get_TrxName());
                updates = pstmt.executeUpdate();
                if (updates != 0 || this.p_IsAllowLogging) {
                    this.createLog(table, column_ID, "UPDATE : " + updates, updateSQL.toString(), treat, help, false);
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, updateSQL.toString(), (Throwable)e);
                throw new DBException(e, updateSQL.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return updates;
    }

    private int executeReset(String TableName, String setClause, String type) {
        StringBuilder updateSQL = new StringBuilder("UPDATE " + TableName + " SET " + setClause);
        if (!type.equals(TYPE_ALL_TRANSACTION)) {
            updateSQL.append(" WHERE AD_Client_ID = " + this.p_LookupClientID);
        }
        CPreparedStatement pstmt = null;
        Object rs = null;
        int updates = 0;
        try {
            try {
                pstmt = DB.prepareStatement((String)updateSQL.toString(), (String)this.get_TrxName());
                updates = pstmt.executeUpdate();
                if (updates != 0 || this.p_IsAllowLogging) {
                    this.createLog(TableName, null, "UPDATE : " + updates, updateSQL.toString(), null, "Reset " + TableName, false);
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, updateSQL.toString(), (Throwable)e);
                throw new DBException(e, updateSQL.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return updates;
    }

    private int executeUpdateConstraint(String s) {
        if (s.equals("D")) {
            this.addLog("### INVALID FK CONSTRAINT ###");
            this.createLog("", "", "### INVALID FK CONSTRAINT ###", "", "", "", true);
        } else if (s.equals("O")) {
            this.addLog("### VALID FK CONSTRAINT ###");
            this.createLog("", "", "### VALID FK CONSTRAINT ###", "", "", "", true);
        } else {
            return -1;
        }
        AdempiereDatabase adempiereDB = DB.getDatabase();
        String schemaName = adempiereDB.getSchema();
        String updateConstraintSQL = "update pg_trigger set tgenabled = ? where oid in (  select tr.oid from pg_class cl, pg_trigger tr, pg_namespace ns    where tr.tgrelid = cl.oid      and cl.relnamespace = ns.oid     and ns.nspname = ?)";
        CPreparedStatement pstmt = null;
        Object rs = null;
        int updates = 0;
        try {
            try {
                pstmt = DB.prepareStatement((String)updateConstraintSQL, (String)this.get_TrxName());
                pstmt.setString(1, s);
                pstmt.setString(2, schemaName);
                updates = pstmt.executeUpdate();
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, updateConstraintSQL, (Throwable)e);
                throw new DBException(e, updateConstraintSQL);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return updates;
    }

    private int executeLockTable(String table, String lockMode) {
        if (table == null) {
            return -1;
        }
        if (!this.isAppDictionaryTable(table) || !this.isDataBaseTable(table)) {
            return -1;
        }
        StringBuilder lockSQL = new StringBuilder("LOCK TABLE " + table);
        if (!Util.isEmpty((String)lockMode)) {
            lockSQL.append(" IN " + lockMode + " MODE ");
        }
        CPreparedStatement pstmt = null;
        Object rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)lockSQL.toString(), (String)this.get_TrxName());
                pstmt.execute();
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, lockSQL.toString(), (Throwable)e);
                throw new DBException(e, lockSQL.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return 0;
    }

    private int countRecords(String table, String where, String type) {
        if (!this.isAppDictionaryTable(table) || !this.isDataBaseTable(table)) {
            return -1;
        }
        StringBuilder countSQL = new StringBuilder("SELECT COUNT(*) FROM " + table);
        if (!Util.isEmpty((String)where)) {
            countSQL.append(" WHERE " + where);
            if (!type.equals(TYPE_ALL_TRANSACTION)) {
                countSQL.append(" AND AD_Client_ID = " + this.p_LookupClientID);
            }
        } else if (!type.equals(TYPE_ALL_TRANSACTION)) {
            countSQL.append(" WHERE AD_Client_ID = " + this.p_LookupClientID);
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int counts = 0;
        try {
            try {
                pstmt = DB.prepareStatement((String)countSQL.toString(), (String)this.get_TrxName());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    counts = rs.getInt(1);
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, countSQL.toString(), (Throwable)e);
                throw new DBException(e, countSQL.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return counts;
    }

    private ArrayList<Integer> getIDList(String column_ID, String table, String where, String type) {
        ArrayList<Integer> listID = new ArrayList<Integer>();
        StringBuilder distinctSQL = new StringBuilder("SELECT DISTINCT " + column_ID + " FROM " + table);
        if (!Util.isEmpty((String)where)) {
            distinctSQL.append(" WHERE " + where);
            if (!type.equals(TYPE_ALL_TRANSACTION)) {
                distinctSQL.append(" AND AD_Client_ID = " + this.p_LookupClientID);
            }
        } else if (!type.equals(TYPE_ALL_TRANSACTION)) {
            distinctSQL.append(" WHERE AD_Client_ID = " + this.p_LookupClientID);
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)distinctSQL.toString(), (String)this.get_TrxName());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    listID.add(rs.getInt(1));
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, distinctSQL.toString(), (Throwable)e);
                throw new DBException(e, distinctSQL.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return listID;
    }

    private int getMaxPrimaryKey_ID(String table) {
        StringBuilder selectMaxSQL = new StringBuilder("SELECT MAX(" + table + "_ID)" + " FROM " + table);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int maxID = 0;
        try {
            try {
                pstmt = DB.prepareStatement((String)selectMaxSQL.toString(), (String)this.get_TrxName());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    maxID = rs.getInt(1);
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, selectMaxSQL.toString(), (Throwable)e);
                throw new DBException(e, selectMaxSQL.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return maxID;
    }

    private int bulkUpdate_canReferTableDirect(String tableName, ArrayList<Integer> IDs, boolean isIN_IDs, String treat, int value, String[] tables, boolean isIN_Tables, String type) throws Exception {
        if (type.equals(TYPE_ALL_TRANSACTION) && this.p_IsTruncateJP) {
            return -5;
        }
        if (!this.isAppDictionaryTable(tableName) || !this.isDataBaseTable(tableName)) {
            return -1;
        }
        if (!this.hasColumn(String.valueOf(tableName) + "_ID", tableName)) {
            return -2;
        }
        int processed = 0;
        String getTableSQL = "SELECT UPPER(TableName) FROM AD_Table t INNER JOIN AD_Column c ON(t.AD_Table_ID = C.AD_Table_ID) WHERE IsView='N' and UPPER(ColumnName)=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)getTableSQL, (String)this.get_TrxName());
                pstmt.setString(1, (String.valueOf(tableName) + "_ID").toUpperCase());
                rs = pstmt.executeQuery();
                boolean isExecuteTable = false;
                while (rs.next()) {
                    if (rs.getString(1).equals(tableName.toUpperCase())) continue;
                    if (tables != null) {
                        int j;
                        isExecuteTable = !isIN_Tables;
                        if (isIN_Tables) {
                            j = 0;
                            while (j < tables.length) {
                                if (rs.getString(1).equals(tables[j].toUpperCase())) {
                                    isExecuteTable = true;
                                    break;
                                }
                                ++j;
                            }
                        } else {
                            j = 0;
                            while (j < tables.length) {
                                if (rs.getString(1).equals(tables[j].toUpperCase())) {
                                    isExecuteTable = false;
                                    break;
                                }
                                ++j;
                            }
                        }
                        if (!isExecuteTable) continue;
                    }
                    this.executeUpdateSQL(rs.getString(1), String.valueOf(tableName) + "_ID", treat, value, this.createWhereInIDs(String.valueOf(tableName) + "_ID", IDs, isIN_IDs), type, "REFERENCE_DIRECT");
                    ++processed;
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, getTableSQL.toString(), (Throwable)e);
                throw new DBException(e, getTableSQL.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return processed;
    }

    private int bulkUpdate_canNotReferTableDirect(String tableName, ArrayList<Integer> IDs, boolean isIN_IDs, String treat, int value, String[] tables, boolean isIN_Tables, String type) throws Exception {
        if (type.equals(TYPE_ALL_TRANSACTION) && this.p_IsTruncateJP) {
            return -5;
        }
        if (!this.isAppDictionaryTable(tableName) || !this.isDataBaseTable(tableName)) {
            return -1;
        }
        if (!this.hasColumn(String.valueOf(tableName) + "_ID", tableName)) {
            return -2;
        }
        int processed = 0;
        ArrayList<Integer> referenceList = this.getReferenceList(tableName);
        if (referenceList.size() == 0) {
            return -3;
        }
        ArrayList<TableColumn> tableColumnList = this.getIndirectReferTableColumn(String.valueOf(tableName) + "_ID", referenceList);
        boolean isExecuteTable = false;
        for (TableColumn tableColumn : tableColumnList) {
            if (tables != null) {
                int j;
                isExecuteTable = !isIN_Tables;
                if (isIN_Tables) {
                    j = 0;
                    while (j < tables.length) {
                        if (tableColumn.tableName.toUpperCase().equals(tables[j].toUpperCase())) {
                            isExecuteTable = true;
                            break;
                        }
                        ++j;
                    }
                } else {
                    j = 0;
                    while (j < tables.length) {
                        if (tableColumn.tableName.toUpperCase().equals(tables[j].toUpperCase())) {
                            isExecuteTable = false;
                            break;
                        }
                        ++j;
                    }
                }
                if (!isExecuteTable) continue;
            }
            if (tableColumn.columnName.toUpperCase().equals("CreatedBy".toUpperCase()) || tableColumn.columnName.toUpperCase().equals("UpdatedBy".toUpperCase())) continue;
            this.executeUpdateSQL(tableColumn.tableName, tableColumn.columnName, treat, value, this.createWhereInIDs(tableColumn.columnName, IDs, isIN_IDs), type, "REFERENCE_INDIRECT");
            ++processed;
        }
        return processed;
    }

    /*
     * Exception decompiling
     */
    private int bulkDelete_NotUseRecords(String tableName, String type) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 10[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void bulkUpdate_Log(int returnInt, String tableName, boolean isCreatLog) {
        if (returnInt < 0 && isCreatLog) {
            if (returnInt == -1) {
                this.createLog("", "", String.valueOf(tableName) + " is not found. Checked at bulk method.", "", "", "", false);
            } else if (returnInt == -2) {
                this.createLog("", "", String.valueOf(tableName) + " does not have a column of " + tableName + "_ID" + ". Checked at bulk method.", "", "", "", false);
            } else if (returnInt == -3) {
                this.createLog("", "", String.valueOf(tableName) + " does not have the Reference. Checked at bulk method.", "", "", "", false);
            } else if (returnInt == -4) {
                this.createLog("", "", String.valueOf(tableName) + " DELETE ERROR Not 1.", "", "", "", false);
            } else if (returnInt == -5) {
                this.createLog("", "", String.valueOf(tableName) + " TRUNCATE ", "", "", "", false);
            }
        } else if (returnInt == 0 && isCreatLog && this.p_IsAllowLogging || isCreatLog) {
            // empty if block
        }
    }

    public String treatAutoJudge(String tableName, String columnName, String treat, int value) {
        if (!(treat.equals(TREAT_IF_MANDATORY_DELETE_ELSE_NULL) || treat.equals(TREAT_IF_MANDATORY_DELETE_ELSE_VALUE) || treat.equals(TREAT_IF_MANDATORY_VALUE_ELSE_DELETE) || treat.equals(TREAT_IF_MANDATORY_VALUE_ELSE_NULL))) {
            return treat;
        }
        MTable m_Table = MTable.get((Properties)this.getCtx(), (String)tableName);
        MColumn m_Column = m_Table.getColumn(columnName);
        if (treat.equals(TREAT_IF_MANDATORY_DELETE_ELSE_NULL)) {
            if (m_Column.isMandatory()) {
                return TREAT_DELETE;
            }
            return TREAT_SET_NULL;
        }
        if (treat.equals(TREAT_IF_MANDATORY_DELETE_ELSE_VALUE)) {
            if (m_Column.isMandatory()) {
                return TREAT_DELETE;
            }
            int count = this.countRecords(tableName, String.valueOf(columnName) + "=" + value, TYPE_ALL_TRANSACTION);
            if (count > 0) {
                return TREAT_SET_VALUE;
            }
            return TREAT_SET_NULL;
        }
        if (treat.equals(TREAT_IF_MANDATORY_VALUE_ELSE_DELETE)) {
            if (m_Column.isMandatory()) {
                int count = this.countRecords(tableName, String.valueOf(columnName) + "=" + value, TYPE_ALL_TRANSACTION);
                if (count > 0) {
                    return TREAT_SET_VALUE;
                }
                return TREAT_DELETE;
            }
            return TREAT_DELETE;
        }
        if (treat.equals(TREAT_IF_MANDATORY_VALUE_ELSE_NULL)) {
            if (m_Column.isMandatory()) {
                int count = this.countRecords(tableName, String.valueOf(columnName) + "=" + value, TYPE_ALL_TRANSACTION);
                if (count > 0) {
                    return TREAT_SET_VALUE;
                }
                return TREAT_DELETE;
            }
            return TREAT_SET_NULL;
        }
        return treat;
    }

    public String[] stringArray_Merge(String[] stringArray1, String[] stringArray2) {
        if ((stringArray1 == null || stringArray1.length == 0) && stringArray2 != null) {
            return stringArray2;
        }
        if ((stringArray2 == null || stringArray2.length == 0) && stringArray1 != null) {
            return stringArray1;
        }
        if (stringArray1 == null && stringArray2 == null) {
            return null;
        }
        ArrayList<String> stringList = new ArrayList<String>();
        int i = 0;
        while (i < stringArray1.length) {
            stringList.add(stringArray1[i]);
            ++i;
        }
        boolean isContain = false;
        int i2 = 0;
        while (i2 < stringArray2.length) {
            isContain = false;
            int j = 0;
            while (j < stringArray1.length) {
                if (stringArray2[i2].toUpperCase().equals(stringArray1[j].toUpperCase())) {
                    isContain = true;
                    break;
                }
                ++j;
            }
            if (!isContain) {
                stringList.add(stringArray2[i2]);
            }
            ++i2;
        }
        return stringList.toArray(new String[stringList.size()]);
    }

    public String[] stringArray_Subtraction(String[] stringArray1, String[] stringArray2) {
        if ((stringArray1 == null || stringArray1.length == 0) && stringArray2 != null) {
            return stringArray2;
        }
        if ((stringArray2 == null || stringArray2.length == 0) && stringArray1 != null) {
            return stringArray1;
        }
        if (stringArray1 == null && stringArray2 == null) {
            return null;
        }
        ArrayList<String> stringList = new ArrayList<String>();
        boolean isContain = false;
        int i = 0;
        while (i < stringArray1.length) {
            isContain = false;
            int j = 0;
            while (j < stringArray2.length) {
                if (stringArray1[i].toUpperCase().equals(stringArray2[j].toUpperCase())) {
                    isContain = true;
                    break;
                }
                ++j;
            }
            if (!isContain) {
                stringList.add(stringArray1[i]);
            }
            ++i;
        }
        return stringList.toArray(new String[stringList.size()]);
    }

    public boolean stringArray_IsIN(String[] stringArray1, String string) {
        boolean isContaine = false;
        int i = 0;
        while (i < stringArray1.length) {
            if (stringArray1[i].toUpperCase().equals(string.toUpperCase())) {
                isContaine = true;
                break;
            }
            ++i;
        }
        return isContaine;
    }

    private boolean isAccessLevelSystemTable(String tableName, boolean isSystemOnly) {
        MTable m_Table = MTable.get((Properties)this.getCtx(), (String)tableName);
        if (m_Table.get_ID() == 0) {
            return false;
        }
        return isSystemOnly ? m_Table.getAccessLevel().equals("4") : m_Table.getAccessLevel().equals("4") || m_Table.getAccessLevel().equals("6") || m_Table.getAccessLevel().equals("7");
    }

    public boolean hasColumn(String columnName, String tableName) {
        MTable m_Table = MTable.get((Properties)this.getCtx(), (String)tableName);
        MColumn[] columns = m_Table.getColumns(false);
        boolean isContain = false;
        int i = 0;
        while (i < columns.length) {
            if (columns[i].getColumnName().toUpperCase().equals(columnName.toUpperCase())) {
                if (!Util.isEmpty((String)columns[i].getColumnSQL())) break;
                isContain = true;
                break;
            }
            ++i;
        }
        return isContain;
    }

    private boolean isIDColumn(String columnName, String tableName) {
        MTable m_Table = MTable.get((Properties)this.getCtx(), (String)tableName);
        MColumn column = m_Table.getColumn(columnName);
        if (DisplayType.isID((int)column.getAD_Reference_ID())) {
            return true;
        }
        return columnName.endsWith("_ID");
    }

    private String createWhereInIDs(String column_ID, ArrayList<Integer> IDs, boolean isIN) {
        if (column_ID == null) {
            return null;
        }
        if (IDs == null || IDs.size() == 0) {
            return null;
        }
        StringBuilder where = new StringBuilder(column_ID);
        if (isIN) {
            where.append(" IN (");
        } else {
            where.append(" Not IN (");
        }
        int i = 0;
        for (Integer ID : IDs) {
            if (i == 0) {
                where.append(ID.toString());
            } else {
                where.append("," + ID.toString());
            }
            ++i;
        }
        where.append(")");
        return where.toString();
    }

    public ArrayList<TableColumn> getIndirectReferTableColumn(String column_ID, ArrayList<Integer> referenceList) {
        ArrayList<TableColumn> tableColumnList = new ArrayList<TableColumn>();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        StringBuilder getTableColumnSQL = new StringBuilder("SELECT tablename, columnname FROM AD_COLUMN c, AD_TABLE t WHERE ad_reference_value_id in(");
        int i = 0;
        while (i < referenceList.size()) {
            if (i > 0) {
                getTableColumnSQL.append(",");
            }
            getTableColumnSQL.append(referenceList.get(i).toString());
            ++i;
        }
        getTableColumnSQL.append(") AND UPPER (columnname) <> '" + column_ID.toUpperCase() + "' AND t.ad_table_id = c.ad_table_id AND t.IsView='N' ");
        try {
            try {
                pstmt = DB.prepareStatement((String)getTableColumnSQL.toString(), (String)this.get_TrxName());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    tableColumnList.add(new TableColumn(rs.getString(1), rs.getString(2)));
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, getTableColumnSQL.toString(), (Throwable)e);
                throw new DBException(e, getTableColumnSQL.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return tableColumnList;
    }

    public ArrayList<Integer> getReferenceList(String tableName) {
        String getReferenceListSQL = "SELECT r.AD_Reference_ID FROM AD_Reference r INNER JOIN adempiere.AD_Ref_Table rt ON(r.AD_Reference_ID=rt.AD_Reference_ID) INNER JOIN adempiere.AD_Table t ON(rt.AD_Table_ID=t.AD_Table_ID) WHERE UPPER(t.TableName) = '" + tableName.toUpperCase() + "'";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<Integer> referenceList = new ArrayList<Integer>();
        try {
            try {
                pstmt = DB.prepareStatement((String)getReferenceListSQL, (String)this.get_TrxName());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    referenceList.add(rs.getInt(1));
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, getReferenceListSQL, (Throwable)e);
                throw new DBException(e, getReferenceListSQL);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return referenceList;
    }

    private boolean isAppDictionaryTable(String tableName) {
        if (this.TABLELIST_AD == null) {
            this.TABLELIST_AD = this.createTableList_AD();
        }
        for (String AD_TABLE : this.TABLELIST_AD) {
            if (!tableName.toUpperCase().equals(AD_TABLE.toUpperCase())) continue;
            return true;
        }
        return false;
    }

    private boolean isDataBaseTable(String tableName) {
        if (this.TABLELIST_DB == null) {
            this.TABLELIST_DB = this.createTableList_DB();
        }
        for (String DB_TABLE : this.TABLELIST_DB) {
            if (!tableName.toUpperCase().equals(DB_TABLE.toUpperCase())) continue;
            return true;
        }
        return false;
    }

    private ArrayList<String> createTableList_DB() {
        AdempiereDatabase adempiereDB = DB.getDatabase();
        String schemaName = adempiereDB.getSchema();
        String getTableListSQL = "SELECT UPPER(tablename) FROM pg_tables WHERE schemaname = ? ORDER BY tablename";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            try {
                pstmt = DB.prepareStatement((String)getTableListSQL, (String)this.get_TrxName());
                pstmt.setString(1, schemaName);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    list.add(rs.getString(1));
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, getTableListSQL, (Throwable)e);
                throw new DBException(e, getTableListSQL);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return list;
    }

    private ArrayList<String> createTableList_AD() {
        String getTableListSQL = "SELECT UPPER(tablename) FROM AD_TABLE a WHERE a.isview = 'N' AND EXISTS (SELECT ad_column_id FROM AD_COLUMN c  WHERE a.ad_table_id = c.ad_table_id AND UPPER (c.columnname) = 'AD_CLIENT_ID') ORDER BY tablename";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            try {
                pstmt = DB.prepareStatement((String)getTableListSQL, (String)this.get_TrxName());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    list.add(rs.getString(1));
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, getTableListSQL, (Throwable)e);
                throw new DBException(e, getTableListSQL);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return list;
    }

    private void createLog(String tableName, String columnName, String description, String SQL, String treat, String help, boolean isDisplay) {
        if (isDisplay && this.processMonitor != null) {
            this.processMonitor.statusUpdate(description);
        }
        MDeleteClientLogJP log = new MDeleteClientLogJP(this.getCtx(), 0, null);
        log.setAD_PInstance_ID(this.getAD_PInstance_ID());
        log.setJP_Delete_Client(this.p_JP_Delete_Client);
        if (this.p_JP_DeleteProfile_ID != 0) {
            log.setJP_DeleteProfile_ID(this.p_JP_DeleteProfile_ID);
        }
        if (this.JP_CustomDeleteProfile_ID != 0) {
            log.setJP_CustomDeleteProfile_ID(this.JP_CustomDeleteProfile_ID);
        }
        if (this.JP_CustomDeleteProfileLine_ID != 0) {
            log.setJP_CustomDeleteProfileLine_ID(this.JP_CustomDeleteProfileLine_ID);
        }
        log.setLookupClientID(this.p_LookupClientID);
        log.setIsTruncateJP(this.p_IsTruncateJP);
        log.setIsAllowLogging(this.p_IsAllowLogging);
        if (!Util.isEmpty((String)description)) {
            log.setDescription(description);
        }
        if (!Util.isEmpty((String)SQL)) {
            log.setSQLStatement(SQL);
        }
        if (!Util.isEmpty((String)treat)) {
            log.setJP_TreatForeignKey(treat);
        }
        if (!Util.isEmpty((String)help)) {
            log.setHelp(help);
        }
        if (Util.isEmpty((String)tableName)) {
            log.saveEx(this.get_TrxName());
            return;
        }
        MTable m_Table = MTable.get((Properties)this.getCtx(), (String)tableName);
        if (m_Table.get_ID() == 0) {
            log.saveEx(this.get_TrxName());
            return;
        }
        log.setAD_Table_ID(m_Table.get_ID());
        log.setTableName(m_Table.getTableName());
        log.setAccessLevel(m_Table.getAccessLevel());
        log.setAD_Window_ID(m_Table.getAD_Window_ID());
        MColumn m_Column = null;
        if (!Util.isEmpty((String)columnName)) {
            MColumn[] columns = m_Table.getColumns(false);
            int i = 0;
            while (i < columns.length) {
                if (columns[i].getColumnName().toUpperCase().equals(columnName.toUpperCase())) {
                    m_Column = columns[i];
                    break;
                }
                ++i;
            }
        }
        if (m_Column != null) {
            log.setAD_Column_ID(m_Column.get_ID());
            log.setColumnName(m_Column.getColumnName());
            log.setAD_Reference_ID(m_Column.getAD_Reference_ID());
            log.setAD_Reference_Value_ID(m_Column.getAD_Reference_Value_ID());
            log.setAD_Val_Rule_ID(m_Column.getAD_Val_Rule_ID());
            log.setFKConstraintName(m_Column.getFKConstraintName());
            log.setFKConstraintType(m_Column.getFKConstraintType());
            log.setIsKey(m_Column.isKey());
            log.setIsParent(m_Column.isParent());
            log.setIsMandatory(m_Column.isMandatory());
            log.setDefaultValue(m_Column.getDefaultValue());
            log.setMandatoryLogic(m_Column.getMandatoryLogic());
            log.setColumnSQL(m_Column.getColumnSQL());
        }
        log.saveEx(this.get_TrxName());
    }

    class TableColumn {
        public String tableName;
        public String columnName;

        public TableColumn(String tableName, String columnName) {
            this.tableName = tableName;
            this.columnName = columnName;
        }
    }
}

