/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.install;

import java.io.File;
import java.util.logging.Level;
import org.apache.tools.ant.DefaultLogger;
import org.compiere.install.ConfigurationData;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.Ini;
import org.eclipse.ant.core.AntRunner;

public class SilentSetup {
    public SilentSetup() {
        String fileName;
        File env;
        String adempiereHome = System.getProperty("IDEMPIERE_HOME");
        if (adempiereHome == null || adempiereHome.length() == 0) {
            adempiereHome = System.getProperty("user.dir");
        }
        if (!(env = new File(fileName = String.valueOf(adempiereHome) + File.separator + "idempiereEnv.properties")).exists()) {
            CLogger.get().severe("Usage: Please edit idempiereEnvTemplate.properties and save as idempiereEnv.properties");
            return;
        }
        Ini.setShowLicenseDialog((boolean)false);
        ConfigurationData data = new ConfigurationData(null);
        if (!data.load()) {
            return;
        }
        if (!data.test(null)) {
            CLogger.get().severe("");
            CLogger.get().severe("ERROR: One or more of the configuration test failed.");
            CLogger.get().severe("");
            return;
        }
        if (!data.save()) {
            return;
        }
        try {
            String path = String.valueOf(System.getProperty("user.dir")) + "/org.adempiere.install/build.xml";
            File file = new File(path);
            System.out.println("file=" + path + " exists=" + file.exists());
            if (file.exists()) {
                AntRunner runner = new AntRunner();
                runner.setBuildFileLocation(path);
                runner.setMessageOutputLevel(3);
                runner.addBuildLogger(DefaultLogger.class.getName());
                runner.run();
                runner.stop();
            }
        }
        catch (Exception e) {
            CLogger.get().log(Level.SEVERE, "ant", (Throwable)e);
        }
    }

    public static void main(String[] args) {
        CLogMgt.initialize((boolean)false);
        Level logLevel = Level.INFO;
        if (args.length > 0) {
            try {
                logLevel = Level.parse(args[0]);
            }
            catch (IllegalArgumentException e) {
                CLogger.get().warning("Unrecognized log level: " + args[0] + " defaulting to: " + logLevel);
            }
        }
        CLogMgt.setLevel((Level)logLevel);
        new SilentSetup();
    }
}

