/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.install;

import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.install.Config;
import org.compiere.install.ConfigurationData;
import org.compiere.util.CLogMgt;

public class ConfigVM
extends Config {
    public ConfigVM(ConfigurationData data) {
        super(data);
    }

    @Override
    public void init() {
        String javaHome = System.getProperty("java.home");
        log.fine(javaHome);
        this.p_data.setJavaHome(javaHome);
    }

    @Override
    public String test() {
        File javaHome = new File(this.p_data.getJavaHome());
        boolean pass = javaHome.exists();
        String error = "Not found: Java Home";
        if (this.getPanel() != null) {
            this.signalOK(this.getPanel().okJavaHome, "ErrorJavaHome", pass, true, error);
        }
        if (!pass) {
            return error;
        }
        if (CLogMgt.isLevelFinest()) {
            CLogMgt.printProperties((Properties)System.getProperties(), (String)"System", (boolean)true);
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("OK: JavaHome=" + javaHome.getAbsolutePath());
        }
        this.setProperty("JAVA_HOME", javaHome.getAbsolutePath());
        System.setProperty("JAVA_HOME", javaHome.getAbsolutePath());
        this.setProperty("IDEMPIERE_JAVA_OPTIONS", this.p_data.getJavaOptions());
        pass = false;
        String thisJV = System.getProperty("java.version");
        int pointPos = thisJV.indexOf(".");
        int thisJVint = 0;
        thisJVint = pointPos >= 0 ? Integer.valueOf(thisJV.substring(0, pointPos)).intValue() : Integer.valueOf(thisJV).intValue();
        int minSupportedVersion = 11;
        boolean bl = pass = thisJVint >= minSupportedVersion;
        if (pass && log.isLoggable(Level.INFO)) {
            log.info("OK: Version=" + thisJV);
        }
        error = "Wrong Java Version = " + thisJV + ": Should be " + minSupportedVersion + " and above.";
        if (this.getPanel() != null) {
            this.signalOK(this.getPanel().okJavaHome, "ErrorJavaHome", pass, true, error);
        }
        if (!pass) {
            return error;
        }
        return null;
    }
}

