/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.groupware.process;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Properties;
import jpiere.plugin.groupware.model.MToDoReminder;
import jpiere.plugin.groupware.model.MToDoTeamReminder;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Msg;

public class ToDoReminderMessage
extends SvrProcess {
    private int p_AD_Client_ID = 0;
    private int record_ID = 0;
    private MTable m_Table = null;
    private LocalDateTime now = LocalDateTime.now();
    private long plusMin = 5L;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            ++i;
        }
        this.record_ID = this.getRecord_ID();
        this.p_AD_Client_ID = this.getAD_Client_ID();
        int AD_Table_ID = this.getProcessInfo().getTable_ID();
        if (AD_Table_ID != 0) {
            this.m_Table = MTable.get((Properties)this.getCtx(), (int)AD_Table_ID);
        }
    }

    protected String doIt() throws Exception {
        if (this.m_Table == null) {
            this.createPersonalToDoRemainderFromTeamToDoReminder();
            this.sendMessageFromPersonalToDoRemainder();
        } else if ("JP_ToDo_Reminder".equals(this.m_Table.getTableName())) {
            if (this.record_ID == 0) {
                this.sendMessageFromPersonalToDoRemainder();
            } else {
                this.sendMessageFromPersonalToDoRemainder(new MToDoReminder(this.getCtx(), this.record_ID, this.get_TrxName()));
            }
        } else if ("JP_ToDo_Team_Reminder".equals(this.m_Table.getTableName())) {
            if (this.record_ID == 0) {
                this.createPersonalToDoRemainderFromTeamToDoReminder();
            } else {
                this.createPersonalToDoRemainderFromTeamToDoReminder(new MToDoTeamReminder(this.getCtx(), this.record_ID, this.get_TrxName()));
            }
        } else {
            this.createPersonalToDoRemainderFromTeamToDoReminder();
            this.sendMessageFromPersonalToDoRemainder();
        }
        return Msg.getMsg((Properties)this.getCtx(), (String)"Success");
    }

    private boolean sendMessageFromPersonalToDoRemainder() throws Exception {
        Timestamp remindTime = Timestamp.valueOf(this.now.plusMinutes(this.plusMin));
        StringBuilder whereClauseFinal = new StringBuilder(" AD_Client_ID = ? AND Processed = 'N' ").append(" AND IsSentReminderJP = 'N' AND JP_ToDo_ReminderType = 'B' AND IsActive = 'Y' AND ").append("JP_ToDo_RemindTime <= ? ");
        List list = new Query(this.getCtx(), "JP_ToDo_Reminder", whereClauseFinal.toString(), this.get_TrxName()).setParameters(new Object[]{this.p_AD_Client_ID, remindTime}).list();
        for (MToDoReminder reminder : list) {
            this.sendMessageFromPersonalToDoRemainder(reminder);
            this.commitEx();
        }
        return true;
    }

    private boolean sendMessageFromPersonalToDoRemainder(MToDoReminder todoReminder) throws Exception {
        int AD_BroadcastMessage_ID = todoReminder.sendMessageRemainder();
        if (AD_BroadcastMessage_ID > 0) {
            todoReminder.setAD_BroadcastMessage_ID(AD_BroadcastMessage_ID);
            todoReminder.setIsSentReminderJP(true);
            todoReminder.saveEx();
            return true;
        }
        return false;
    }

    private boolean createPersonalToDoRemainderFromTeamToDoReminder() throws Exception {
        Timestamp remindTime = Timestamp.valueOf(this.now.plusMinutes(this.plusMin));
        StringBuilder whereClauseFinal = new StringBuilder(" AD_Client_ID = ? AND Processed = 'N' ").append(" AND IsSentReminderJP = 'N' AND JP_ToDo_ReminderType = 'B' AND IsActive = 'Y' AND ").append("JP_ToDo_RemindTime <= ? ");
        List list = new Query(this.getCtx(), "JP_ToDo_Team_Reminder", whereClauseFinal.toString(), this.get_TrxName()).setParameters(new Object[]{this.p_AD_Client_ID, remindTime}).list();
        for (MToDoTeamReminder reminder : list) {
            this.createPersonalToDoRemainderFromTeamToDoReminder(reminder);
            this.commitEx();
        }
        return true;
    }

    private boolean createPersonalToDoRemainderFromTeamToDoReminder(MToDoTeamReminder reminder) throws Exception {
        return reminder.createPersonalToDoRemainder();
    }
}

