/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.groupware.process;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.plugin.groupware.model.MToDoMemberAdditional;
import jpiere.plugin.groupware.model.MToDoTeam;
import jpiere.plugin.groupware.model.MToDoTeamReminder;
import jpiere.plugin.groupware.util.GroupwareTeamUtil;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.util.ProcessUtil;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_NonBusinessDay;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;

public class CreateTeamToDoRepeatedly
extends SvrProcess {
    private int p_JP_ToDo_Team_ID = 0;
    private int p_JP_Offset_Value = 0;
    private String p_JP_Repetition_Interval = null;
    private Timestamp p_DateTo = null;
    private int p_JP_NonBusinessDayCalendar_ID = 0;
    private int p_C_Country_ID = 0;
    private String p_JP_NonBusinessDayToDoHandling = null;
    private boolean p_IsCopyReminderJP = false;
    private boolean p_IsCreateToDoJP = false;
    private boolean p_IsScheduledStartDateEndOfMonth = false;
    private boolean p_IsScheduledEndDateEndOfMonth = false;
    private MToDoTeam m_TeamToDo = null;
    private List<Long> diffList_RemindTime = new ArrayList<Long>();
    private Timestamp v_JP_ToDo_ScheduledStartTime = null;
    private Timestamp v_JP_ToDo_ScheduledEndTime = null;
    private MToDoTeam v_TeamToDo = null;
    List<X_C_NonBusinessDay> list_NonBusinessDays = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("JP_Offset_Value")) {
                    this.p_JP_Offset_Value = para[i].getParameterAsInt();
                } else if (name.equals("JP_Repetition_Interval")) {
                    this.p_JP_Repetition_Interval = para[i].getParameterAsString();
                } else if (name.equals("DateTo")) {
                    this.p_DateTo = para[i].getParameterAsTimestamp();
                } else if (name.equals("JP_NonBusinessDayCalendar_ID")) {
                    this.p_JP_NonBusinessDayCalendar_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_Country_ID")) {
                    this.p_C_Country_ID = para[i].getParameterAsInt();
                } else if (name.equals("JP_NonBusinessDayToDoHandling")) {
                    this.p_JP_NonBusinessDayToDoHandling = para[i].getParameterAsString();
                } else if (name.equals("IsCopyReminderJP")) {
                    this.p_IsCopyReminderJP = para[i].getParameterAsBoolean();
                } else if (name.equals("IsCreateToDoJP")) {
                    this.p_IsCreateToDoJP = para[i].getParameterAsBoolean();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.p_JP_ToDo_Team_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        LocalTime localTime;
        LocalDate endOfMonth;
        this.v_TeamToDo = this.m_TeamToDo = new MToDoTeam(this.getCtx(), this.p_JP_ToDo_Team_ID, this.get_TrxName());
        if ("M".equals(this.m_TeamToDo.getJP_ToDo_Type())) {
            if (this.getTable_ID() == 0) {
                return "JP_ToDo_Memo_CouldNotCreateRepeatedly";
            }
            throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"JP_ToDo_Memo_CouldNotCreateRepeatedly"));
        }
        MToDoTeamReminder[] reminders = this.m_TeamToDo.getReminders();
        Timestamp scheduledEndTime = null;
        Timestamp remindTime = null;
        int i = 0;
        while (i < reminders.length) {
            scheduledEndTime = this.m_TeamToDo.getJP_ToDo_ScheduledEndTime();
            remindTime = reminders[i].getJP_ToDo_RemindTime();
            this.diffList_RemindTime.add(scheduledEndTime.getTime() - remindTime.getTime());
            ++i;
        }
        if (this.p_JP_Repetition_Interval.equals("M")) {
            LocalDate localDate = this.m_TeamToDo.getJP_ToDo_ScheduledStartDate().toLocalDateTime().toLocalDate();
            if (localDate.compareTo(endOfMonth = localDate.with(TemporalAdjusters.lastDayOfMonth())) == 0) {
                this.p_IsScheduledStartDateEndOfMonth = true;
            }
            if ((localDate = this.m_TeamToDo.getJP_ToDo_ScheduledEndDate().toLocalDateTime().toLocalDate()).compareTo(endOfMonth = localDate.with(TemporalAdjusters.lastDayOfMonth())) == 0) {
                this.p_IsScheduledEndDateEndOfMonth = true;
            }
        }
        if (this.m_TeamToDo.getJP_Processing3().equals("Y")) {
            if (this.getTable_ID() == 0) {
                return "JP_ToDo_AlreadyCreatedRepeatedly";
            }
            throw new AdempiereException(Msg.getMsg((Properties)this.getCtx(), (String)"JP_ToDo_AlreadyCreatedRepeatedly"));
        }
        this.v_JP_ToDo_ScheduledStartTime = this.calculateNextScheduleTime(this.m_TeamToDo.getJP_ToDo_ScheduledStartTime());
        if (this.p_IsScheduledStartDateEndOfMonth) {
            LocalDate localDate = this.v_JP_ToDo_ScheduledStartTime.toLocalDateTime().toLocalDate();
            endOfMonth = localDate.with(TemporalAdjusters.lastDayOfMonth());
            localTime = this.v_JP_ToDo_ScheduledStartTime.toLocalDateTime().toLocalTime();
            this.v_JP_ToDo_ScheduledStartTime = Timestamp.valueOf(LocalDateTime.of(endOfMonth, localTime));
        }
        this.v_JP_ToDo_ScheduledEndTime = this.calculateNextScheduleTime(this.m_TeamToDo.getJP_ToDo_ScheduledEndTime());
        if (this.p_IsScheduledEndDateEndOfMonth) {
            LocalDate localDate = this.v_JP_ToDo_ScheduledEndTime.toLocalDateTime().toLocalDate();
            endOfMonth = localDate.with(TemporalAdjusters.lastDayOfMonth());
            localTime = this.v_JP_ToDo_ScheduledEndTime.toLocalDateTime().toLocalTime();
            this.v_JP_ToDo_ScheduledEndTime = Timestamp.valueOf(LocalDateTime.of(endOfMonth, localTime));
        }
        this.p_DateTo = Timestamp.valueOf(LocalDateTime.of(this.p_DateTo.toLocalDateTime().toLocalDate(), LocalTime.MAX));
        while (this.p_DateTo.compareTo(this.v_JP_ToDo_ScheduledStartTime) >= 0) {
            this.createTeamToDo();
            this.v_JP_ToDo_ScheduledStartTime = this.calculateNextScheduleTime(this.v_JP_ToDo_ScheduledStartTime);
            if (this.p_IsScheduledStartDateEndOfMonth) {
                LocalDate localDate = this.v_JP_ToDo_ScheduledStartTime.toLocalDateTime().toLocalDate();
                endOfMonth = localDate.with(TemporalAdjusters.lastDayOfMonth());
                localTime = this.v_JP_ToDo_ScheduledStartTime.toLocalDateTime().toLocalTime();
                this.v_JP_ToDo_ScheduledStartTime = Timestamp.valueOf(LocalDateTime.of(endOfMonth, localTime));
            }
            this.v_JP_ToDo_ScheduledEndTime = this.calculateNextScheduleTime(this.v_JP_ToDo_ScheduledEndTime);
            if (!this.p_IsScheduledEndDateEndOfMonth) continue;
            LocalDate localDate = this.v_JP_ToDo_ScheduledEndTime.toLocalDateTime().toLocalDate();
            endOfMonth = localDate.with(TemporalAdjusters.lastDayOfMonth());
            localTime = this.v_JP_ToDo_ScheduledEndTime.toLocalDateTime().toLocalTime();
            this.v_JP_ToDo_ScheduledEndTime = Timestamp.valueOf(LocalDateTime.of(endOfMonth, localTime));
        }
        this.m_TeamToDo.setJP_Processing3("Y");
        this.m_TeamToDo.saveEx(this.get_TrxName());
        if (this.getTable_ID() == 0) {
            return "Success";
        }
        return Msg.getMsg((Properties)this.getCtx(), (String)"Success");
    }

    private void createTeamToDo() {
        Timestamp ts;
        boolean isNonBusinessDay;
        MToDoTeam new_TeamToDo = new MToDoTeam(this.getCtx(), 0, this.get_TrxName());
        PO.copyValues((PO)this.v_TeamToDo, (PO)new_TeamToDo);
        if ("S".equals(new_TeamToDo.getJP_ToDo_Type())) {
            if (Util.isEmpty((String)this.p_JP_NonBusinessDayToDoHandling) || this.p_JP_NonBusinessDayToDoHandling.equals("B")) {
                new_TeamToDo.setJP_ToDo_ScheduledStartDate(this.v_JP_ToDo_ScheduledStartTime);
                new_TeamToDo.setJP_ToDo_ScheduledStartTime(this.v_JP_ToDo_ScheduledStartTime);
            } else {
                isNonBusinessDay = this.checkNonBusinessDay(this.v_JP_ToDo_ScheduledStartTime.toLocalDateTime().toLocalDate());
                if (isNonBusinessDay) {
                    if (this.p_JP_NonBusinessDayToDoHandling.equals("A") || this.p_JP_Repetition_Interval.equals("D")) {
                        return;
                    }
                    if (this.p_JP_NonBusinessDayToDoHandling.equals("C")) {
                        ts = this.preDay(this.v_JP_ToDo_ScheduledStartTime);
                        new_TeamToDo.setJP_ToDo_ScheduledStartDate(ts);
                        new_TeamToDo.setJP_ToDo_ScheduledStartTime(ts);
                    } else if (this.p_JP_NonBusinessDayToDoHandling.equals("D")) {
                        ts = this.nextDay(this.v_JP_ToDo_ScheduledStartTime);
                        new_TeamToDo.setJP_ToDo_ScheduledStartDate(ts);
                        new_TeamToDo.setJP_ToDo_ScheduledStartTime(ts);
                    }
                } else {
                    new_TeamToDo.setJP_ToDo_ScheduledStartDate(this.v_JP_ToDo_ScheduledStartTime);
                    new_TeamToDo.setJP_ToDo_ScheduledStartTime(this.v_JP_ToDo_ScheduledStartTime);
                }
            }
        }
        if (Util.isEmpty((String)this.p_JP_NonBusinessDayToDoHandling)) {
            new_TeamToDo.setJP_ToDo_ScheduledEndDate(this.v_JP_ToDo_ScheduledEndTime);
            new_TeamToDo.setJP_ToDo_ScheduledEndTime(this.v_JP_ToDo_ScheduledEndTime);
        } else {
            isNonBusinessDay = this.checkNonBusinessDay(this.v_JP_ToDo_ScheduledEndTime.toLocalDateTime().toLocalDate());
            if (isNonBusinessDay) {
                if (this.p_JP_NonBusinessDayToDoHandling.equals("A") || this.p_JP_Repetition_Interval.equals("D")) {
                    return;
                }
                if (this.p_JP_NonBusinessDayToDoHandling.equals("C")) {
                    ts = this.preDay(this.v_JP_ToDo_ScheduledEndTime);
                    new_TeamToDo.setJP_ToDo_ScheduledEndDate(ts);
                    new_TeamToDo.setJP_ToDo_ScheduledEndTime(ts);
                } else if (this.p_JP_NonBusinessDayToDoHandling.equals("D")) {
                    ts = this.nextDay(this.v_JP_ToDo_ScheduledEndTime);
                    new_TeamToDo.setJP_ToDo_ScheduledEndDate(ts);
                    new_TeamToDo.setJP_ToDo_ScheduledEndTime(ts);
                }
            } else {
                new_TeamToDo.setJP_ToDo_ScheduledEndDate(this.v_JP_ToDo_ScheduledEndTime);
                new_TeamToDo.setJP_ToDo_ScheduledEndTime(this.v_JP_ToDo_ScheduledEndTime);
            }
        }
        if (new_TeamToDo.getJP_ToDo_ScheduledStartDate().compareTo(new_TeamToDo.getJP_ToDo_ScheduledEndDate()) > 0 || "T".equals(new_TeamToDo.getJP_ToDo_Type())) {
            new_TeamToDo.setJP_ToDo_ScheduledStartDate(this.v_JP_ToDo_ScheduledEndTime);
            new_TeamToDo.setJP_ToDo_ScheduledStartTime(this.v_JP_ToDo_ScheduledEndTime);
        }
        new_TeamToDo.setJP_ToDo_Team_Related_ID(this.p_JP_ToDo_Team_ID);
        new_TeamToDo.setJP_ToDo_Status("NY");
        new_TeamToDo.saveEx(this.get_TrxName());
        this.createAdditionalTeamMemberUser(new_TeamToDo);
        if (this.p_IsCopyReminderJP) {
            this.createTeamToDoRemainder(new_TeamToDo);
        }
        if (this.p_IsCreateToDoJP) {
            this.createToDo(new_TeamToDo);
        }
        this.v_TeamToDo = new_TeamToDo;
    }

    private void createAdditionalTeamMemberUser(MToDoTeam new_TeamToDo) {
        MUser[] users = this.m_TeamToDo.getAdditionalTeamMemberUser();
        MToDoMemberAdditional tdma = null;
        int i = 0;
        while (i < users.length) {
            tdma = new MToDoMemberAdditional(this.getCtx(), 0, this.get_TrxName());
            tdma.setJP_ToDo_Team_ID(new_TeamToDo.getJP_ToDo_Team_ID());
            tdma.setAD_Org_ID(0);
            tdma.setAD_User_ID(users[i].getAD_User_ID());
            tdma.saveEx(this.get_TrxName());
            ++i;
        }
    }

    private void createTeamToDoRemainder(MToDoTeam new_TeamToDo) {
        MToDoTeamReminder[] m_TeamToDoReminders = this.v_TeamToDo.getReminders();
        MToDoTeamReminder tdtr = null;
        Timestamp remindTime = null;
        int i = 0;
        while (i < m_TeamToDoReminders.length) {
            tdtr = new MToDoTeamReminder(this.getCtx(), 0, this.get_TrxName());
            tdtr.setAD_Org_ID(0);
            tdtr.setJP_ToDo_Team_ID(new_TeamToDo.getJP_ToDo_Team_ID());
            tdtr.setJP_ToDo_ReminderType(m_TeamToDoReminders[i].getJP_ToDo_ReminderType());
            tdtr.setDescription(m_TeamToDoReminders[i].getDescription());
            remindTime = new Timestamp(new_TeamToDo.getJP_ToDo_ScheduledEndTime().getTime() - this.diffList_RemindTime.get(i));
            tdtr.setJP_ToDo_RemindTime(remindTime);
            tdtr.setIsSentReminderJP(false);
            tdtr.setJP_Mandatory_Statistics_Info(m_TeamToDoReminders[i].getJP_Mandatory_Statistics_Info());
            tdtr.saveEx(this.get_TrxName());
            ++i;
        }
    }

    private void createToDo(MToDoTeam new_TeamToDo) {
        String className = "jpiere.plugin.groupware.process.CreateToDoFromTeamToDo";
        ProcessInfo pi = new ProcessInfo("Create ToDo From Team ToDo", 0);
        pi.setClassName(className);
        pi.setAD_Client_ID(this.getAD_Client_ID());
        pi.setAD_User_ID(this.getAD_User_ID());
        pi.setAD_PInstance_ID(this.getAD_PInstance_ID());
        pi.setRecord_ID(new_TeamToDo.getJP_ToDo_Team_ID());
        ArrayList<ProcessInfoParameter> list = new ArrayList<ProcessInfoParameter>();
        list.add(new ProcessInfoParameter("JP_Team_ID", (Object)new_TeamToDo.getJP_Team_ID(), null, null, null));
        ProcessInfoParameter[] pars = new ProcessInfoParameter[list.size()];
        list.toArray(pars);
        pi.setParameter(pars);
        ProcessUtil.startJavaProcess((Properties)this.getCtx(), (ProcessInfo)pi, (Trx)Trx.get((String)this.get_TrxName(), (boolean)true), (boolean)false, null);
    }

    private Timestamp calculateNextScheduleTime(Timestamp timestamp) {
        return GroupwareTeamUtil.calculateNextScheduleTime(timestamp, this.p_JP_Offset_Value, this.p_JP_Repetition_Interval);
    }

    private boolean checkNonBusinessDay(LocalDate localDate) {
        if (this.list_NonBusinessDays == null) {
            StringBuilder whereClause = null;
            StringBuilder orderClause = null;
            ArrayList<Comparable<Integer>> list_parameters = new ArrayList<Comparable<Integer>>();
            Object[] parameters = null;
            LocalDateTime toDayMin = LocalDateTime.of(this.m_TeamToDo.getJP_ToDo_ScheduledStartTime().toLocalDateTime().toLocalDate(), LocalTime.MIN);
            LocalDateTime toDayMax = LocalDateTime.of(this.p_DateTo.toLocalDateTime().toLocalDate(), LocalTime.MAX);
            whereClause = new StringBuilder(" AD_Client_ID=? ");
            list_parameters.add(Integer.valueOf(Env.getAD_Client_ID((Properties)this.getCtx())));
            whereClause = whereClause.append(" AND C_Calendar_ID = ? ");
            list_parameters.add(Integer.valueOf(this.p_JP_NonBusinessDayCalendar_ID));
            whereClause = whereClause.append(" AND Date1 <= ? AND Date1 >= ? AND IsActive='Y' ");
            list_parameters.add(Timestamp.valueOf(toDayMax));
            list_parameters.add(Timestamp.valueOf(toDayMin));
            if (this.p_C_Country_ID == 0) {
                whereClause = whereClause.append(" AND C_Country_ID IS NULL ");
            } else {
                whereClause = whereClause.append(" AND ( C_Country_ID IS NULL OR C_Country_ID = ? ) ");
                list_parameters.add(Integer.valueOf(this.p_C_Country_ID));
            }
            parameters = list_parameters.toArray(new Object[list_parameters.size()]);
            orderClause = new StringBuilder("Date1");
            this.list_NonBusinessDays = new Query(Env.getCtx(), "C_NonBusinessDay", whereClause.toString(), null).setParameters(parameters).setOrderBy(orderClause.toString()).list();
        }
        boolean isNonBusinessDay = false;
        for (X_C_NonBusinessDay nonBusinessDay : this.list_NonBusinessDays) {
            if (nonBusinessDay.getDate1().toLocalDateTime().toLocalDate().compareTo(localDate) != 0) continue;
            isNonBusinessDay = true;
            break;
        }
        return isNonBusinessDay;
    }

    private Timestamp preDay(Timestamp timestamp) {
        LocalDate localDate = timestamp.toLocalDateTime().toLocalDate();
        LocalTime localTime = timestamp.toLocalDateTime().toLocalTime();
        boolean isNonBusinessDay = true;
        while (isNonBusinessDay) {
            localDate = localDate.minusDays(1L);
            isNonBusinessDay = this.checkNonBusinessDay(localDate);
        }
        return Timestamp.valueOf(LocalDateTime.of(localDate, localTime));
    }

    private Timestamp nextDay(Timestamp timestamp) {
        LocalDate localDate = timestamp.toLocalDateTime().toLocalDate();
        LocalTime localTime = timestamp.toLocalDateTime().toLocalTime();
        boolean isNonBusinessDay = true;
        while (isNonBusinessDay) {
            localDate = localDate.plusDays(1L);
            isNonBusinessDay = this.checkNonBusinessDay(localDate);
        }
        return Timestamp.valueOf(LocalDateTime.of(localDate, localTime));
    }
}

