/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.groupware.form;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.Properties;
import jpiere.plugin.groupware.model.MGroupwareUser;
import org.compiere.model.I_C_NonBusinessDay;
import org.compiere.model.MCountry;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.calendar.impl.SimpleCalendarEvent;

public class NonBusinessDayCalendarEvent
extends SimpleCalendarEvent {
    public NonBusinessDayCalendarEvent(I_C_NonBusinessDay nonBusinessDay, MGroupwareUser gUser) {
        if (Util.isEmpty((String)nonBusinessDay.getName())) {
            String name = Msg.getElement((Properties)Env.getCtx(), (String)"C_NonBusinessDay_ID");
            if (nonBusinessDay.getC_Country_ID() == 0) {
                this.setTitle(name);
                this.setContent(name);
            } else {
                MCountry country = MCountry.get((Properties)Env.getCtx(), (int)nonBusinessDay.getC_Country_ID());
                String countryName = country.getTrlName();
                this.setTitle(String.valueOf(name) + " [" + countryName + "]");
                this.setContent(String.valueOf(name) + " [" + countryName + "]");
            }
        } else if (nonBusinessDay.getC_Country_ID() == 0) {
            this.setTitle(nonBusinessDay.getName());
            this.setContent(nonBusinessDay.getName());
        } else {
            MCountry country = MCountry.get((Properties)Env.getCtx(), (int)nonBusinessDay.getC_Country_ID());
            String countryName = country.getTrlName();
            this.setTitle(String.valueOf(nonBusinessDay.getName()) + " [" + countryName + "]");
            this.setContent(String.valueOf(nonBusinessDay.getName()) + " [" + countryName + "]");
        }
        LocalDate localDate = nonBusinessDay.getDate1().toLocalDateTime().toLocalDate();
        Timestamp ts_From = Timestamp.valueOf(LocalDateTime.of(localDate, LocalTime.MIN));
        Timestamp ts_To = Timestamp.valueOf(LocalDateTime.of(localDate, LocalTime.MAX));
        this.setBeginDate(new Date(ts_From.getTime()));
        this.setEndDate(new Date(ts_To.getTime()));
        if (Util.isEmpty((String)gUser.getJP_NonBusinessDayColor())) {
            this.setHeaderColor("#ff0000");
            this.setContentColor("#ff0000");
        } else {
            this.setHeaderColor(gUser.getJP_NonBusinessDayColor());
            this.setContentColor(gUser.getJP_NonBusinessDayColor());
        }
        this.setLocked(true);
    }
}

