/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.groupware.util;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import jpiere.plugin.groupware.form.ToDoCalendarEvent;
import jpiere.plugin.groupware.model.MToDo;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.editor.WEditor;
import org.compiere.model.MForm;
import org.compiere.model.Query;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.zkoss.calendar.Calendars;
import org.zkoss.zk.ui.Component;
import org.zkoss.zul.Div;
import org.zkoss.zul.Html;

public class GroupwareToDoUtil {
    public static final String JP_REPETITION_INTERVAL_EVERYDAYS = "D";
    public static final String JP_REPETITION_INTERVAL_EVERYMONTHS = "M";
    public static final String JP_REPETITION_INTERVAL_EVERYWEEKS = "W";
    public static final String JP_REPETITION_INTERVAL_EVERYYEARS = "Y";
    public static final String CALENDAR_EVENT_DAY = "onDayClick";
    public static final String CALENDAR_EVENT_WEEK = "onWeekClick";
    public static final String CALENDAR_EVENT_MONTH = "onMonthkClick";
    public static final String CALENDAR_ONEDAY_VIEW = "ONE";
    public static final String CALENDAR_FIVEDAYS_VIEW = "FIVE";
    public static final String CALENDAR_SEVENDAYS_VIEW = "SEVEN";
    public static final String CALENDAR_MONTH_VIEW = "MONTH";
    public static final String DEFAULT_COLOR1 = "#7EAAC6";
    public static final String DEFAULT_COLOR2 = "#ACD5EE";
    private static final int MAX_TITLE_LENGTH = 20;
    public static final String STYLE_ZOOMABLE_LABEL = "cursor: pointer; text-decoration: underline;";

    public static String trimName(String name) {
        if (name == null) {
            return null;
        }
        if (name.length() <= 20) {
            return name;
        }
        name = String.valueOf(name.substring(0, 17)) + "...";
        return name;
    }

    public static MForm getToDoCallendarForm() {
        StringBuilder whereClause = new StringBuilder("classname=?");
        List list = new Query(Env.getCtx(), "AD_Form", whereClause.toString(), null).setParameters(new Object[]{"jpiere.plugin.groupware.form.ToDoCalendar"}).list();
        if (list.size() > 0) {
            return (MForm)list.get(0);
        }
        return null;
    }

    public static Div getDividingLine() {
        Div div = new Div();
        div.appendChild((Component)new Html("&nbsp;"));
        div.setStyle("display: inline-block; border-left: 1px dotted #888888;margin: 5px 2px 0px 2px;");
        return div;
    }

    public static Div createSpaceDiv() {
        Div div = new Div();
        div.appendChild((Component)new Html("&nbsp;"));
        return div;
    }

    public static Div createLabelDiv(WEditor editor, String string, boolean isPositionAdjust) {
        Label label = new Label(string);
        return GroupwareToDoUtil.createLabelDiv(editor, label, isPositionAdjust);
    }

    public static Div createLabelDiv(WEditor editor, Label label, boolean isPositionAdjust) {
        label.rightAlign();
        label.setMandatory(editor == null ? false : editor.isMandatory());
        if (editor != null && (editor.getColumnName().equals("AD_User_ID") || editor.getColumnName().equals("JP_ToDo_Category_ID") || editor.getColumnName().equals("JP_Team_ID"))) {
            label.setStyle(STYLE_ZOOMABLE_LABEL);
        }
        Div div = new Div();
        div.setSclass("form-label");
        if (isPositionAdjust) {
            div.setStyle("padding-top:4px");
        }
        div.appendChild((Component)label);
        if (editor != null && editor.isMandatory()) {
            div.appendChild(label.getDecorator());
        }
        return div;
    }

    public static Div createLabelDiv(Label label, boolean isMandatory) {
        label.setMandatory(isMandatory);
        Div div = new Div();
        div.setSclass("form-label");
        div.appendChild((Component)label);
        if (isMandatory) {
            div.appendChild(label.getDecorator());
        }
        return div;
    }

    public static Div createEditorDiv(WEditor editor, boolean isPositionAdjust) {
        Div div = new Div();
        if (isPositionAdjust) {
            div.setStyle("padding-top:4px");
        }
        div.appendChild(editor.getComponent());
        return div;
    }

    public static List<ToDoCalendarEvent> getToDoCalendarEvents(Calendars calendars, boolean isDisplayName, String whereClause, String orderClause, Object ... parameters) {
        List list_ToDoes = new Query(Env.getCtx(), "JP_ToDo", whereClause.toString(), null).setParameters(parameters).setOrderBy(orderClause).list();
        ArrayList<ToDoCalendarEvent> list_Events = new ArrayList<ToDoCalendarEvent>();
        for (MToDo toDo : list_ToDoes) {
            list_Events.add(new ToDoCalendarEvent(toDo));
        }
        return list_Events;
    }

    public static String dateFormat(LocalDate localDate) {
        SimpleDateFormat dateFormater = DisplayType.getDateFormat();
        Date date = new Date(Timestamp.valueOf(LocalDateTime.of(localDate, LocalTime.MIN)).getTime());
        return dateFormater.format(date);
    }
}

