/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.win32.DEVMODE;
import org.eclipse.swt.internal.win32.DEVMODEA;
import org.eclipse.swt.internal.win32.DEVMODEW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PRINTDLG;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PrintDialog
extends Dialog {
    static final TCHAR DialogClass = new TCHAR(0, OS.IsWinCE ? "Dialog" : "#32770", true);
    PrinterData printerData = new PrinterData();
    static /* synthetic */ Class class$0;

    public PrintDialog(Shell shell) {
        this(shell, 32768);
    }

    public PrintDialog(Shell shell, int n) {
        super(shell, PrintDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    static int checkBits(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n2 | n3 | n4 | n5 | n6 | n7;
        if ((n & n8) == 0) {
            n |= n2;
        }
        if ((n & n2) != 0) {
            n = n & ~n8 | n2;
        }
        if ((n & n3) != 0) {
            n = n & ~n8 | n3;
        }
        if ((n & n4) != 0) {
            n = n & ~n8 | n4;
        }
        if ((n & n5) != 0) {
            n = n & ~n8 | n5;
        }
        if ((n & n6) != 0) {
            n = n & ~n8 | n6;
        }
        if ((n & n7) != 0) {
            n = n & ~n8 | n7;
        }
        return n;
    }

    static int checkStyle(Shell shell, int n) {
        int n2 = 229376;
        if ((n & 0x10000000) != 0 && ((n &= 0xEFFFFFFF) & n2) == 0) {
            n |= shell == null ? 65536 : 32768;
        }
        if ((n & n2) == 0) {
            n |= 0x10000;
        }
        if (((n &= 0xF7FFFFFF) & 0x6000000) == 0 && shell != null) {
            if ((shell.getStyle() & 0x2000000) != 0) {
                n |= 0x2000000;
            }
            if ((shell.getStyle() & 0x4000000) != 0) {
                n |= 0x4000000;
            }
        }
        return PrintDialog.checkBits(n, 0x2000000, 0x4000000, 0, 0, 0, 0);
    }

    public void setPrinterData(PrinterData printerData) {
        if (printerData == null) {
            printerData = new PrinterData();
        }
        this.printerData = printerData;
    }

    public PrinterData getPrinterData() {
        return this.printerData;
    }

    public int getScope() {
        return this.printerData.scope;
    }

    public void setScope(int n) {
        this.printerData.scope = n;
    }

    public int getStartPage() {
        return this.printerData.startPage;
    }

    public void setStartPage(int n) {
        this.printerData.startPage = n;
    }

    public int getEndPage() {
        return this.printerData.endPage;
    }

    public void setEndPage(int n) {
        this.printerData.endPage = n;
    }

    public boolean getPrintToFile() {
        return this.printerData.printToFile;
    }

    public void setPrintToFile(boolean bl) {
        this.printerData.printToFile = bl;
    }

    protected void checkSubclass() {
        String string;
        String string2 = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.printing.PrintDialog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(string = clazz.getName()).equals(string2)) {
            SWT.error(43);
        }
    }

    public PrinterData open() {
        Object[] objectArray;
        int n;
        int n2;
        int n3;
        Shell shell = this.getParent();
        int n4 = this.getStyle();
        long l = shell.handle;
        long l2 = shell.handle;
        boolean bl = false;
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10) && (n3 = n4 & 0x6000000) != (n2 = shell.getStyle() & 0x6000000)) {
            n = 0x100000;
            if (n3 == 0x4000000) {
                n |= 0x400000;
            }
            l = OS.CreateWindowEx(n, DialogClass, null, 0, Integer.MIN_VALUE, 0, Integer.MIN_VALUE, 0, l2, 0L, OS.GetModuleHandle(null), null);
            bl = OS.IsWindowEnabled(l2);
            if (bl) {
                OS.EnableWindow(l2, false);
            }
        }
        PrinterData printerData = null;
        PRINTDLG pRINTDLG = new PRINTDLG();
        pRINTDLG.lStructSize = PRINTDLG.sizeof;
        pRINTDLG.hwndOwner = l;
        n = 0;
        if (this.printerData.name != null) {
            objectArray = Printer.getPrinterList();
            if (objectArray.length > 0) {
                int n5 = 0;
                while (n5 < objectArray.length) {
                    if (objectArray[n5].name.equals(this.printerData.name)) {
                        n = 1;
                        break;
                    }
                    ++n5;
                }
            }
            if (n != 0) {
                TCHAR tCHAR = new TCHAR(0, this.printerData.name, true);
                int n6 = tCHAR.length() * TCHAR.sizeof;
                short[] sArray = new short[4];
                int n7 = sArray.length * 2;
                sArray[1] = (short)sArray.length;
                long l3 = OS.GlobalAlloc(66, n7 + n6);
                long l4 = OS.GlobalLock(l3);
                OS.MoveMemory(l4, sArray, n7);
                OS.MoveMemory(l4 + (long)n7, tCHAR, n6);
                OS.GlobalUnlock(l3);
                pRINTDLG.hDevNames = l3;
            }
        }
        if (n == 0) {
            pRINTDLG.Flags = 1024;
            boolean bl2 = OS.PrintDlg(pRINTDLG);
            n = bl2 ? 1 : 0;
            if (bl2 && pRINTDLG.hDevNames != 0L) {
                OS.GlobalFree(pRINTDLG.hDevNames);
                pRINTDLG.hDevNames = 0L;
            }
        }
        if (n != 0) {
            int n8;
            int n9;
            long l5;
            objectArray = this.printerData.otherData;
            if (objectArray != null && objectArray.length != 0) {
                long l6 = OS.GlobalAlloc(66, objectArray.length);
                long l7 = OS.GlobalLock(l6);
                OS.MoveMemory(l7, (byte[])objectArray, objectArray.length);
                OS.GlobalUnlock(l6);
                if (pRINTDLG.hDevMode != 0L) {
                    OS.GlobalFree(pRINTDLG.hDevMode);
                }
                pRINTDLG.hDevMode = l6;
            }
            if ((l5 = pRINTDLG.hDevMode) == 0L) {
                pRINTDLG.hDevMode = l5 = OS.GlobalAlloc(66, DEVMODE.sizeof);
            }
            long l8 = OS.GlobalLock(l5);
            DEVMODE dEVMODE = OS.IsUnicode ? new DEVMODEW() : new DEVMODEA();
            OS.MoveMemory(dEVMODE, l8, OS.IsUnicode ? OS.DEVMODEW_sizeof() : OS.DEVMODEA_sizeof());
            if (this.printerData.name != null) {
                int n10 = Math.min(this.printerData.name.length(), 31);
                if (OS.IsUnicode) {
                    int n11 = 0;
                    while (n11 < n10) {
                        dEVMODE.dmDeviceName[n11] = this.printerData.name.charAt(n11);
                        ++n11;
                    }
                } else {
                    byte[] byArray = this.printerData.name.getBytes();
                    n9 = 0;
                    while (n9 < n10) {
                        ((DEVMODEA)dEVMODE).dmDeviceName[n9] = byArray[n9];
                        ++n9;
                    }
                }
            }
            dEVMODE.dmFields |= 1;
            dEVMODE.dmOrientation = (short)(this.printerData.orientation == 1 ? 1 : 2);
            if (this.printerData.copyCount != 1) {
                dEVMODE.dmFields |= 0x100;
                dEVMODE.dmCopies = (short)this.printerData.copyCount;
            }
            if (this.printerData.collate) {
                dEVMODE.dmFields |= 0x8000;
                dEVMODE.dmCollate = 1;
            }
            if (this.printerData.duplex != -1) {
                dEVMODE.dmFields |= 0x1000;
                switch (this.printerData.duplex) {
                    case 2: {
                        dEVMODE.dmDuplex = (short)3;
                        break;
                    }
                    case 1: {
                        dEVMODE.dmDuplex = (short)2;
                        break;
                    }
                    default: {
                        dEVMODE.dmDuplex = 1;
                    }
                }
            }
            OS.MoveMemory(l8, dEVMODE, OS.IsUnicode ? OS.DEVMODEW_sizeof() : OS.DEVMODEA_sizeof());
            OS.GlobalUnlock(l5);
            pRINTDLG.Flags = 262144;
            if (this.printerData.printToFile) {
                pRINTDLG.Flags |= 0x20;
            }
            switch (this.printerData.scope) {
                case 1: {
                    pRINTDLG.Flags |= 2;
                    break;
                }
                case 2: {
                    pRINTDLG.Flags |= 1;
                    break;
                }
                default: {
                    pRINTDLG.Flags |= 0;
                }
            }
            pRINTDLG.nMinPage = 1;
            pRINTDLG.nMaxPage = (short)-1;
            pRINTDLG.nFromPage = (short)Math.min(65535, Math.max(1, this.printerData.startPage));
            pRINTDLG.nToPage = (short)Math.min(65535, Math.max(1, this.printerData.endPage));
            Display display = shell.getDisplay();
            Shell[] shellArray = display.getShells();
            if ((this.getStyle() & 0x30000) != 0) {
                n9 = 0;
                while (n9 < shellArray.length) {
                    if (shellArray[n9].isEnabled() && shellArray[n9] != shell) {
                        shellArray[n9].setEnabled(false);
                    } else {
                        shellArray[n9] = null;
                    }
                    ++n9;
                }
            }
            String string = "org.eclipse.swt.internal.win32.runMessagesInIdle";
            Object object = display.getData(string);
            display.setData(string, new Boolean(true));
            n = OS.PrintDlg(pRINTDLG) ? 1 : 0;
            display.setData(string, object);
            if ((this.getStyle() & 0x30000) != 0) {
                n8 = 0;
                while (n8 < shellArray.length) {
                    if (shellArray[n8] != null && !shellArray[n8].isDisposed()) {
                        shellArray[n8].setEnabled(true);
                    }
                    ++n8;
                }
            }
            if (n != 0) {
                short s;
                l5 = pRINTDLG.hDevNames;
                n8 = OS.GlobalSize(l5) / TCHAR.sizeof * TCHAR.sizeof;
                l8 = OS.GlobalLock(l5);
                short[] sArray = new short[4];
                OS.MoveMemory(sArray, l8, 2 * sArray.length);
                TCHAR tCHAR = new TCHAR(0, n8);
                OS.MoveMemory(tCHAR, l8, n8);
                OS.GlobalUnlock(l5);
                short s2 = sArray[0];
                int n12 = 0;
                while (s2 + n12 < n8) {
                    if (tCHAR.tcharAt(s2 + n12) == 0) break;
                    ++n12;
                }
                String string2 = tCHAR.toString(s2, n12);
                short s3 = sArray[1];
                n12 = 0;
                while (s3 + n12 < n8) {
                    if (tCHAR.tcharAt(s3 + n12) == 0) break;
                    ++n12;
                }
                String string3 = tCHAR.toString(s3, n12);
                printerData = new PrinterData(string2, string3);
                if ((pRINTDLG.Flags & 2) != 0) {
                    printerData.scope = 1;
                    printerData.startPage = pRINTDLG.nFromPage & 0xFFFF;
                    printerData.endPage = pRINTDLG.nToPage & 0xFFFF;
                } else if ((pRINTDLG.Flags & 1) != 0) {
                    printerData.scope = 2;
                }
                boolean bl3 = printerData.printToFile = (pRINTDLG.Flags & 0x20) != 0;
                if (printerData.printToFile) {
                    printerData.fileName = this.printerData.fileName;
                }
                printerData.copyCount = pRINTDLG.nCopies;
                printerData.collate = (pRINTDLG.Flags & 0x10) != 0;
                l5 = pRINTDLG.hDevMode;
                n8 = OS.GlobalSize(l5);
                l8 = OS.GlobalLock(l5);
                printerData.otherData = new byte[n8];
                OS.MoveMemory(printerData.otherData, l8, n8);
                dEVMODE = OS.IsUnicode ? new DEVMODEW() : new DEVMODEA();
                OS.MoveMemory(dEVMODE, l8, OS.IsUnicode ? OS.DEVMODEW_sizeof() : OS.DEVMODEA_sizeof());
                if ((dEVMODE.dmFields & 1) != 0) {
                    s = dEVMODE.dmOrientation;
                    int n13 = printerData.orientation = s == 2 ? 2 : 1;
                }
                if ((dEVMODE.dmFields & 0x1000) != 0) {
                    s = dEVMODE.dmDuplex;
                    printerData.duplex = s == 1 ? 0 : (s == 3 ? 2 : 1);
                }
                OS.GlobalUnlock(l5);
                this.printerData = printerData;
            }
        }
        if (pRINTDLG.hDevNames != 0L) {
            OS.GlobalFree(pRINTDLG.hDevNames);
            pRINTDLG.hDevNames = 0L;
        }
        if (pRINTDLG.hDevMode != 0L) {
            OS.GlobalFree(pRINTDLG.hDevMode);
            pRINTDLG.hDevMode = 0L;
        }
        if (l2 != l) {
            if (bl) {
                OS.EnableWindow(l2, true);
            }
            OS.SetActiveWindow(l2);
            OS.DestroyWindow(l);
        }
        return printerData;
    }
}

