/*
 * Decompiled with CFR 0.152.
 */
package jp.thisnor.dre.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jp.thisnor.dre.app.ImageUtils;
import jp.thisnor.dre.core.FileEntry;

public class ZippedFileEntry
implements FileEntry {
    private final File file;
    private final String pathInZip;
    private String name;
    private long size;
    private long lastModified;
    private int width = -1;
    private int height = -1;
    private FileEntry[] subEntries;

    public ZippedFileEntry(File file, String pathInZip) {
        this.file = file;
        this.pathInZip = pathInZip;
    }

    @Override
    public String getPath() {
        return String.valueOf(this.file.getPath()) + File.separator + this.pathInZip;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            int sepPos = Math.max(this.pathInZip.lastIndexOf(47, this.pathInZip.length() - 2), this.pathInZip.lastIndexOf(92, this.pathInZip.length() - 2));
            this.name = this.pathInZip.substring(sepPos + 1);
            if (this.name.endsWith("/") || this.name.endsWith("\\")) {
                this.name = this.name.substring(0, this.name.length() - 1);
            }
        }
        return this.name;
    }

    @Override
    public long getSize() {
        if (this.size == 0L) {
            ZipFile zip = null;
            try {
                try {
                    zip = new ZipFile(this.file);
                    this.size = zip.getInputStream(zip.getEntry(this.pathInZip)).available();
                }
                catch (IOException iOException) {
                    try {
                        if (zip != null) {
                            zip.close();
                        }
                    }
                    catch (IOException iOException2) {}
                }
            }
            finally {
                try {
                    if (zip != null) {
                        zip.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return this.size;
    }

    @Override
    public long getLastModified() {
        if (this.lastModified == 0L) {
            ZipFile zip = null;
            try {
                try {
                    zip = new ZipFile(this.file);
                    this.lastModified = zip.getEntry(this.pathInZip).getTime();
                }
                catch (IOException iOException) {
                    try {
                        if (zip != null) {
                            zip.close();
                        }
                    }
                    catch (IOException iOException2) {}
                }
            }
            finally {
                try {
                    if (zip != null) {
                        zip.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return this.lastModified;
    }

    @Override
    public int getWidth() {
        if (this.width == -1) {
            ImageUtils.ImageSize size = ImageUtils.getImageSize((FileEntry)this);
            if (size != null) {
                this.width = size.width;
                this.height = size.height;
            } else {
                this.width = Integer.MIN_VALUE;
                this.height = Integer.MIN_VALUE;
            }
        }
        return this.width;
    }

    @Override
    public int getHeight() {
        if (this.height == -1) {
            ImageUtils.ImageSize size = ImageUtils.getImageSize((FileEntry)this);
            if (size != null) {
                this.width = size.width;
                this.height = size.height;
            } else {
                this.width = Integer.MIN_VALUE;
                this.height = Integer.MIN_VALUE;
            }
        }
        return this.height;
    }

    @Override
    public boolean isDirectory() {
        return this.pathInZip.endsWith("/") || this.pathInZip.endsWith("\\") || this.pathInZip.isEmpty();
    }

    @Override
    public FileEntry[] subEntries() {
        if (this.subEntries == null) {
            ZipFile zipFile = null;
            try {
                try {
                    zipFile = new ZipFile(this.file);
                    Enumeration<? extends ZipEntry> subEntryEnum = zipFile.entries();
                    HashSet<String> subDirEntrySet = new HashSet<String>();
                    ArrayList<ZippedFileEntry> subEntryList = new ArrayList<ZippedFileEntry>();
                    while (subEntryEnum.hasMoreElements()) {
                        ZipEntry e = subEntryEnum.nextElement();
                        String name = e.getName();
                        if (name.length() <= this.pathInZip.length() || !name.startsWith(this.pathInZip)) continue;
                        int sepPos = Math.max(name.indexOf("/", this.pathInZip.length()), name.indexOf("\\", this.pathInZip.length()));
                        if (sepPos == -1) {
                            subEntryList.add(new ZippedFileEntry(this.file, name));
                            continue;
                        }
                        String dirName = name.substring(0, sepPos + 1);
                        if (subDirEntrySet.contains(dirName)) continue;
                        subEntryList.add(new ZippedFileEntry(this.file, dirName));
                        subDirEntrySet.add(dirName);
                    }
                    this.subEntries = subEntryList.toArray(new FileEntry[subEntryList.size()]);
                }
                catch (IOException e) {
                    FileEntry[] fileEntryArray = new FileEntry[]{};
                    try {
                        if (zipFile != null) {
                            zipFile.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return fileEntryArray;
                }
            }
            finally {
                try {
                    if (zipFile != null) {
                        zipFile.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return this.subEntries;
    }

    @Override
    public FileEntry getParent() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZippedFileEntry)) {
            return false;
        }
        ZippedFileEntry e = (ZippedFileEntry)o;
        return e.file.equals(this.file) && e.pathInZip.equals(this.pathInZip);
    }

    public int hashCode() {
        return this.file.hashCode() * 31 + this.pathInZip.hashCode();
    }

    public String toString() {
        return this.getPath();
    }

    @Override
    public InputStream open() throws IOException {
        return new ZippedFileEntryInputStream(this.file, this.pathInZip);
    }

    private static class ZippedFileEntryInputStream
    extends InputStream {
        private final ZipFile zipFile;
        private final InputStream in;

        private ZippedFileEntryInputStream(File file, String path) throws IOException {
            this.zipFile = new ZipFile(file);
            this.in = this.zipFile.getInputStream(this.zipFile.getEntry(path));
        }

        @Override
        public int read() throws IOException {
            return this.in.read();
        }

        public int hashCode() {
            return this.in.hashCode();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.in.read(b);
        }

        public boolean equals(Object obj) {
            return this.in.equals(obj);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.in.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.in.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.in.available();
        }

        public String toString() {
            return this.in.toString();
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        @Override
        public void mark(int readlimit) {
            this.in.mark(readlimit);
        }

        @Override
        public void reset() throws IOException {
            this.in.reset();
        }

        @Override
        public boolean markSupported() {
            return this.in.markSupported();
        }
    }
}

