/*
 * Decompiled with CFR 0.152.
 */
package jp.thisnor.dre.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipFile;
import jp.thisnor.dre.app.ImageUtils;
import jp.thisnor.dre.core.FileEntry;
import jp.thisnor.dre.core.ZippedFileEntry;

public class NormalFileEntry
implements FileEntry {
    private final File file;
    private int width = -1;
    private int height = -1;
    private FileEntry[] subEntries;
    private FileEntry parent;

    public NormalFileEntry(File file) {
        this.file = file;
    }

    @Override
    public String getPath() {
        return this.file.getPath();
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public long getSize() {
        return this.file.length();
    }

    @Override
    public long getLastModified() {
        return this.file.lastModified();
    }

    @Override
    public int getWidth() {
        if (this.width == -1) {
            ImageUtils.ImageSize size = ImageUtils.getImageSize((FileEntry)this);
            if (size != null) {
                this.width = size.width;
                this.height = size.height;
            } else {
                this.width = Integer.MIN_VALUE;
                this.height = Integer.MIN_VALUE;
            }
        }
        return this.width;
    }

    @Override
    public int getHeight() {
        if (this.height == -1) {
            ImageUtils.ImageSize size = ImageUtils.getImageSize((FileEntry)this);
            if (size != null) {
                this.width = size.width;
                this.height = size.height;
            } else {
                this.width = Integer.MIN_VALUE;
                this.height = Integer.MIN_VALUE;
            }
        }
        return this.height;
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public FileEntry[] subEntries() {
        if (this.subEntries == null) {
            if (this.isZip()) {
                this.subEntries = new ZippedFileEntry(this.file, "").subEntries();
            } else {
                File[] files = this.file.listFiles();
                if (files != null) {
                    this.subEntries = new FileEntry[files.length];
                    int i = 0;
                    while (i < files.length) {
                        this.subEntries[i] = new NormalFileEntry(files[i]);
                        ++i;
                    }
                } else {
                    this.subEntries = new FileEntry[0];
                }
            }
        }
        return this.subEntries;
    }

    /*
     * Loose catch block
     */
    public boolean isZip() {
        if (!this.file.getName().toLowerCase().endsWith("zip")) {
            return false;
        }
        ZipFile zipFile = null;
        zipFile = new ZipFile(this.file);
        try {
            if (zipFile != null) {
                zipFile.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
        catch (IOException e) {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
            catch (Throwable throwable) {
                try {
                    if (zipFile != null) {
                        zipFile.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    @Override
    public FileEntry getParent() {
        if (this.parent != null) {
            this.parent = new NormalFileEntry(this.file.getParentFile());
        }
        return this.parent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NormalFileEntry)) {
            return false;
        }
        NormalFileEntry e = (NormalFileEntry)o;
        return e.file.equals(this.file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public String toString() {
        return this.getPath();
    }

    @Override
    public InputStream open() throws IOException {
        return new FileInputStream(this.file);
    }
}

