/*
 * Decompiled with CFR 0.152.
 */
package jp.thisnor.dre.bindup;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import jp.thisnor.dre.core.FileEntry;
import jp.thisnor.dre.core.MeasureOptionEntry;
import jp.thisnor.dre.core.Measurer;

public class BinDupMeasurer
implements Measurer {
    @Override
    public void init(Map<String, MeasureOptionEntry> optionMap) {
        MeasureOptionEntry thresholdOption = new MeasureOptionEntry("threshold");
        thresholdOption.setValue("0");
        optionMap.put("threshold", thresholdOption);
    }

    @Override
    public Object convert(FileEntry entry) throws Exception {
        return entry;
    }

    @Override
    public int measure(Object data1, Object data2, int threshold) {
        FileEntry entry1 = (FileEntry)data1;
        FileEntry entry2 = (FileEntry)data2;
        if (entry1.equals(entry2)) {
            return 0;
        }
        int dSize = Math.abs((int)(entry2.getSize() - entry1.getSize()));
        if (dSize == 0) {
            BufferedInputStream in1 = null;
            InputStream in2 = null;
            try {
                int read2;
                int read1;
                in1 = new BufferedInputStream(entry1.open());
                in2 = new BufferedInputStream(entry2.open());
                while ((read1 = ((InputStream)in1).read()) == (read2 = in2.read()) && read1 != -1) {
                }
                if (read1 == -1) {
                    return 0;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (in1 != null) {
                        ((InputStream)in1).close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (in2 != null) {
                        in2.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return dSize + 1;
    }

    @Override
    public void dispose() {
    }
}

